C
      SUBROUTINE SETBC
C---------------------------------------------------
C     Overwrites the N-momentum Jacobian
C     entries for J stagnation lines and far-field
C     with appropriate boundary conditions.
C---------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
C**** Store element surface sensitivities ***********
C
      DO 4 IS=1, 2*NBL
        NB = (IS+1)/2
        J = JS1(NB)
        IF (MOD(IS,2).EQ.0) J = JS2(NB)
        DO 3 I=1, II
          V1S(IS,I) = V1(J,I)
          V2S(IS,I) = V2(J,I)
          V3S(IS,I) = V3(J,I)
          V4S(IS,I) = V4(J,I)
          V5S(IS,I) = V5(J,I)
          Z1S(IS,I) = Z1(J,I)
          Z2S(IS,I) = Z2(J,I)
          Z3S(IS,I) = Z3(J,I)
          Z4S(IS,I) = Z4(J,I)
          Z5S(IS,I) = Z5(J,I)
          A1S(IS,I) = A1(J,I)
          A2S(IS,I) = A2(J,I)
          A3S(IS,I) = A3(J,I)
          A4S(IS,I) = A4(J,I)
          A5S(IS,I) = A5(J,I)
          B1S(IS,I) = B1(J,I)
          B2S(IS,I) = B2(J,I)
          B3S(IS,I) = B3(J,I)
          B4S(IS,I) = B4(J,I)
          B5S(IS,I) = B5(J,I)
          C1S(IS,I) = C1(J,I)
          C2S(IS,I) = C2(J,I)
          C3S(IS,I) = C3(J,I)
          DRS(IS,1,I) = 0.0
          DO 2 L = 2, NRHS
            DRS(IS,L,I) = DR(J,L,I)
    2     CONTINUE
    3   CONTINUE
    4 CONTINUE
C
C
C=======================================================================
C----For each element
C      The element is represented by gridlines  J1 - top    surface
C                                               J2 - bottom surface
C      The streamtube between lines J1 and J2 is J2 (S-mom eqn. cleared)
C
      DO 100 NB = 1, NBL
C
       ILE = ILEB(NB)
       ITE = ITEB(NB)
       J1 = JS1(NB)
       J2 = JS2(NB)
       I1 = IS1(NB)
       I2 = IS2(NB)
C
C---- Set dummy S-momentum equations for element streamtubes
       DO 6 I=1, II
         A8(J2,I) = -1.0
   6   CONTINUE
C
C
C**** Set boundary conditions at each streamwise station ***************
C
C---- inlet streamline: periodic pressure and geometry, no Dstar effects
       CALL PERSTR(NB, 2, ILE-1, .FALSE. )
C
C---- outlet streamline: periodic pressure and geometry, + Dstar if viscous
ccc       CALL PERSTR(NB, ITE+1,  II-1,  LVISC  )
       CALL PERSTR(NB, ITE+1,  II-1,  .true.  )
C
       IF(LMIXI .AND. NB.EQ.NMIX) THEN
C------ Mixed-Inverse setup
        CALL DIRWAL(NB, ILE ,  IX0-1 )
        CALL DIRWAL(NB, IX1+1 ,ITE )
        CALL INVWAL(NB)
C
       ELSE
C------ Direct and/or modal-inverse setup
        CALL DIRWAL(NB, ILE , ITE )
C
      ENDIF
C
  100 CONTINUE
C
C---- set airfoil far field boundary conditions
      IF(IFFBC.EQ.1) CALL FFBC1(.FALSE.)
      IF(IFFBC.EQ.2) CALL FFBC2(.FALSE.)
      IF(IFFBC.EQ.3) CALL FFBC3
      IF(IFFBC.EQ.4) CALL FFBC4
      IF(IFFBC.EQ.5) CALL FFBC4
C
      IF(IFFBC.EQ.6) CALL FFBC1(.TRUE.)
      IF(IFFBC.EQ.7) CALL FFBC2(.TRUE.)
C
      RETURN
      END ! SETBC


      SUBROUTINE PERSTR(N,IND1,IND2,LVBC)
C-----------------------------------------------------------
C     Imposes pressure continuity and geometric continuity
C     across element N streamline over i = IND1..IND2.
C     If LVBC = .TRUE., then delta* gap is imposed.
C
C     This version imposes a curvature correction to 
C     the pressure continuity.
C-----------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      LOGICAL LVBC
      DIMENSION DP1_M1(NBX), DP1_NG(NBX), DP1_NP(NPOSX),
     &          DP2_M1(NBX), DP2_NG(NBX), DP2_NP(NPOSX)
C
      J1 = JS1(N)
      J2 = JS2(N)
      I1 = IS1(N)
      I2 = IS2(N)
C
C---- set pressure continuity (add j=1,J block lines into j=1 line)
      DO 2 I=IND1, IND2
        V1(J1,I) = V1(J2,I)
        VT(I1,I) = V2(J2,I)
        V4(J1,I) = V4(J2,I)
        Z1(J1,I) = Z1(J2,I)
        ZT(I1,I) = Z2(J2,I)
        Z4(J1,I) = Z4(J2,I)
        B1(J1,I) = B1(J2,I)
        BT(I1,I) = B2(J2,I)
        B4(J1,I) = B4(J2,I)
        A1(J1,I) = A1(J2,I)
        AT(I1,I) = A2(J2,I)
        A4(J1,I) = A4(J2,I)
        C1(J1,I) = C1(J2,I)
        CT(I1,I) = C2(J2,I)
        DO 21 L=1, NRHS
          DR(J1,L,I) = DR(J1,L,I) + DR(J2,L,I)
 21     CONTINUE
C
C==========================================================
C------ add Theta,Dstar contributions to delta(p) across wake gap
C
C       net Residual = 2 [ Pi  - Pi  ]
C                            2     1
C
C                           dp                dp
C                    + 2 [  -- (Th + Ds)   -  -- (Th + Ds)  ]
C                           dn          2     dn          1
C
C   ( )  =  upper-side quantity    ( )  =  lower-side quantity
C      1                              2
C
C    dp/dn is positive away from wake centerline
C
C
C------ set dp/dn on each wake side
        CALL DPDN(I,I1,DP1,
     &              DP1_R1 , DP1_R2 ,
     &              DP1_N1M, DP1_N2M, DP1_N3M,
     &              DP1_N1P, DP1_N2P, DP1_N3P,
     &              DP1_MS , DP1_AL , DP1_M1 , DP1_NG, DP1_NP)
        CALL DPDN(I,I2,DP2,
     &              DP2_R1 , DP2_R2 ,
     &              DP2_N1M, DP2_N2M, DP2_N3M,
     &              DP2_N1P, DP2_N2P, DP2_N3P,
     &              DP2_MS , DP2_AL , DP2_M1 , DP2_NG, DP2_NP)
C
C
C------ set contribution to residual
        DREZ  =  2.0*DP2*(WXPT*THET(I,I2) + WXPD*DSTR(I,I2))
     &        -  2.0*DP1*(WXPT*THET(I,I1) + WXPD*DSTR(I,I1))
C
        Z_DP1 = -2.0*(WXPT*THET(I,I1) + WXPD*DSTR(I,I1))
        Z_DP2 =  2.0*(WXPT*THET(I,I2) + WXPD*DSTR(I,I2))
        Z_TH1 = -2.0*DP1*WXPT
        Z_TH2 =  2.0*DP2*WXPT
        Z_DS1 = -2.0*DP1*WXPD
        Z_DS2 =  2.0*DP2*WXPD
C
C
C
c        IF(I.GT.ITEB(N)) THEN
c        DPCON = 0.0
c        DPS = DPCON
c     &          * ( DSTR(I,I1)/DSTR(I,I2)
c     &            - DSTR(I,I2)/DSTR(I,I1) ) * RHOINF*QINF**2
c        DPS_MSQ = DPS/RHOINF   * RI_MSQ
c     &          + DPS/QINF*2.0 * QI_MSQ
c        DPS_DS1 = DPCON
c     &          * (        1.0/DSTR(I,I2)
c     &            + DSTR(I,I2)/DSTR(I,I1)**2 ) * RHOINF*QINF**2
c        DPS_DS2 = DPCON
c     &          * ( -      1.0/DSTR(I,I1)
c     &            - DSTR(I,I1)/DSTR(I,I2)**2 ) * RHOINF*QINF**2
cC
c        DREZ = DREZ + DPS
c        Z_DS1 = Z_DS1 + DPS_DS1
c        Z_DS2 = Z_DS2 + DPS_DS2
c        ENDIF
C

C------ first rhs column holds -Residual
        DR(J1,1,I) = DR(J1,1,I) - DREZ
C
C------ add contributions to Jacobian and global-variable rhs columns
        AI(I1,2,I) = Z_TH1
        AI(I1,3,I) = Z_DS1
        AI(I1,5,I) = Z_TH2
        AI(I1,6,I) = Z_DS2
C
        B2(J1,I) = B2(J1,I) + Z_DP1*DP1_N1M
        A2(J1,I) = A2(J1,I) + Z_DP1*DP1_N2M
        C2(J1,I) = C2(J1,I) + Z_DP1*DP1_N3M
        B3(J1,I) = B3(J1,I) + Z_DP1*DP1_N1P
        A3(J1,I) = A3(J1,I) + Z_DP1*DP1_N2P
        C3(J1,I) = C3(J1,I) + Z_DP1*DP1_N3P
        B5(J1,I) = B5(J1,I) + Z_DP1*DP1_R1
        A5(J1,I) = A5(J1,I) + Z_DP1*DP1_R2
C
        B1(J1,I) = B1(J1,I) + Z_DP2*DP2_N1M
        A1(J1,I) = A1(J1,I) + Z_DP2*DP2_N2M
        C1(J1,I) = C1(J1,I) + Z_DP2*DP2_N3M
        BT(I1,I) = BT(I1,I) + Z_DP2*DP2_N1P
        AT(I1,I) = AT(I1,I) + Z_DP2*DP2_N2P
        CT(I1,I) = CT(I1,I) + Z_DP2*DP2_N3P
        B4(J1,I) = B4(J1,I) + Z_DP2*DP2_R1
        A4(J1,I) = A4(J1,I) + Z_DP2*DP2_R2
C
        DR(J1,LMASS,I) = DR(J1,LMASS,I) + Z_DP1*DP1_MS + Z_DP2*DP2_MS
        DR(J1,LALFA,I) = DR(J1,LALFA,I) + Z_DP1*DP1_AL + Z_DP2*DP2_AL
        DO 23 NN=1, NBL
          L = LSBLE(NN)
          DR(J1,L,I) = DR(J1,L,I) + Z_DP1*DP1_NG(NN) + Z_DP2*DP2_NG(NN)
          L = LMAS1(NN)
          DR(J1,L,I) = DR(J1,L,I) + Z_DP1*DP1_M1(NN) + Z_DP2*DP2_M1(NN)
 23     CONTINUE
        DO 24 NN=1, NPOSN
          K = KPOSN(NN)
          L = LPOSN(K)
          DR(J1,L,I) = DR(J1,L,I) + Z_DP1*DP1_NP(K) + Z_DP2*DP2_NP(K)
 24     CONTINUE
C==========================================================
C
 2    CONTINUE
C
C
C---- clear j=J block rows for BC below
      DO 3 I=IND1, IND2
        CALL CLROW(I,J2)
 3    CONTINUE
C
      IF(LVBC) THEN
C----- set grid gap = Dstar
       DO 41 I=IND1, IND2
        DOTP1 = NX(I,J1)*BNX(I,I1) + NY(I,J1)*BNY(I,I1)
        DOTP2 = NX(I,J2)*BNX(I,I2) + NY(I,J2)*BNY(I,I2)
        AT(I2,I) = DOTP1
        A2(J2,I) = DOTP2
        AI(I2,6,I) = -1.0
        AI(I2,3,I) = -1.0
        DR(J2,1,I) = (DSTR(I,I1)+DSTR(I,I2)) - (DISP(I,I1)+DISP(I,I2))
 41    CONTINUE
      ELSE
C----- set grid gap change = 0
       DO 42 I=IND1, IND2 
         A2(J2,I) = -1.0
         AT(I2,I) =  1.0
 42    CONTINUE
      ENDIF
C
ccc      return
      IF(.NOT.LVISC) RETURN
C
C===== Add weighted dn = d* wall BC equation to  dH*/dx =...  BL equation, 
C=     which gives the latter a larger diagonal element.  This is typically 
C=     needed at separation, where the diagonal element for dH*/dx = ...  
C=     goes through zero [ H*(Hk) is stationary at separation ].
C
      DO 54 I=IND1, IND2
C------ weight dn = d* equation so as to eliminate the dn entry in BL equation
        AITMP = ANH(I1,1,I)/AT(I2,I)
        ANH(I1,1,I) = 0.0
CCC                 = ANH(I1,1,I) - AITMP*AT(I2,I)
        ANH(I1,4,I) = ANH(I1,4,I) - AITMP*A2(J2,I)
C
        AVH(I1,1,I) = AVH(I1,1,I) - AITMP*AI(I2,1,I)
        AVH(I1,2,I) = AVH(I1,2,I) - AITMP*AI(I2,2,I)
        AVH(I1,3,I) = AVH(I1,3,I) - AITMP*AI(I2,3,I)
        AVH(I1,4,I) = AVH(I1,4,I) - AITMP*AI(I2,4,I)
        AVH(I1,5,I) = AVH(I1,5,I) - AITMP*AI(I2,5,I)
        AVH(I1,6,I) = AVH(I1,6,I) - AITMP*AI(I2,6,I)
        JD = 2*JJ-1 + 3*I1
        DO 542 L=1, NRHS
          DR(JD,L,I) = DR(JD,L,I) - AITMP*DR(J2,L,I)
 542    CONTINUE
C
 54   CONTINUE
C
      RETURN
      END ! PERSTR


      SUBROUTINE DPDN(I,IS,DP,
     &                  DP_R1,DP_R2,
     &                  DP_N1M,DP_N2M,DP_N3M,
     &                  DP_N1P,DP_N2P,DP_N3P,
     &                  DP_MS,DP_AL,DP_M1,DP_NG,DP_NP)
C--------------------------------------------------------------
C     Sets normal pressure gradient at BL station I, side IS.
C     Gradient is positive from wake centerline to outer flow
C      (positive for wake side curving away from outer flow).
C
C     This DPDN version uses displacement streamline curvature.
C--------------------------------------------------------------
C
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      DIMENSION DP_M1(NBX), DP_NG(NBX), DP_NP(NPOSX)
C
      N = (IS+1)/2
      IF(MOD(IS,2).EQ.0) THEN
       J = JS2(N)
       SGN = 1.0
      ELSE
       J = JS1(N)
       SGN = -1.0
      ENDIF
C
      X1 = X(I-1,J)
      X2 = X(I  ,J)
      X3 = X(I+1,J)
      Y1 = Y(I-1,J)
      Y2 = Y(I  ,J)
      Y3 = Y(I+1,J)
C
      SX1 = X2 - X1
      SY1 = Y2 - Y1
      SX2 = X3 - X2
      SY2 = Y3 - Y2
      S1 = SQRT(SX1*SX1 + SY1*SY1)
      S2 = SQRT(SX2*SX2 + SY2*SY2)
      S1INV = 1.0/S1
      S2INV = 1.0/S2
C
      S1_X1 = -SX1*S1INV
      S1_X2 =  SX1*S1INV
      S1_Y1 = -SY1*S1INV
      S1_Y2 =  SY1*S1INV
C
      S2_X2 = -SX2*S2INV
      S2_X3 =  SX2*S2INV
      S2_Y2 = -SY2*S2INV
      S2_Y3 =  SY2*S2INV
C
C---- set displacement-surface curvature
      CV     = SGN*2.0*(SX1*SY2-SY1*SX2)*S1INV*S2INV/(S1+S2)
      CV_SXS = SGN*2.0                  *S1INV*S2INV/(S1+S2)
      CV_S1  = -CV*S1INV - CV/(S1+S2)
      CV_S2  = -CV*S2INV - CV/(S1+S2)
C
      CV_SX1 =  CV_SXS*SY2
      CV_SY1 = -CV_SXS*SX2
      CV_SX2 = -CV_SXS*SY1
      CV_SY2 =  CV_SXS*SX1
C
      CV_X1 = CV_S1*S1_X1 - CV_SX1
      CV_Y1 = CV_S1*S1_Y1 - CV_SY1
      CV_X2 = CV_S1*S1_X2 + CV_SX1
     &      + CV_S2*S2_X2 - CV_SX2
      CV_Y2 = CV_S1*S1_Y2 + CV_SY1
     &      + CV_S2*S2_Y2 - CV_SY2
      CV_X3 = CV_S2*S2_X3 + CV_SX2
      CV_Y3 = CV_S2*S2_Y3 + CV_SY2
C
      IF(MOD(IS,2).EQ.0) THEN
       CV_N1M = 0.
       CV_N2M = 0.
       CV_N3M = 0.
       CV_N1P = CV_X1*NX(I-1,J) + CV_Y1*NY(I-1,J)
       CV_N2P = CV_X2*NX(I  ,J) + CV_Y2*NY(I  ,J)
       CV_N3P = CV_X3*NX(I+1,J) + CV_Y3*NY(I+1,J)
      ELSE
       CV_N1M = CV_X1*NX(I-1,J) + CV_Y1*NY(I-1,J)
       CV_N2M = CV_X2*NX(I  ,J) + CV_Y2*NY(I  ,J)
       CV_N3M = CV_X3*NX(I+1,J) + CV_Y3*NY(I+1,J)
       CV_N1P = 0.
       CV_N2P = 0.
       CV_N3P = 0.
      ENDIF
C
      CV_AL = CV_X1*NXA(I-1,J) + CV_Y1*NYA(I-1,J)
     &      + CV_X2*NXA(I  ,J) + CV_Y2*NYA(I  ,J)
     &      + CV_X3*NXA(I+1,J) + CV_Y3*NYA(I+1,J)
C
C
C
      DP    = RHOI(I,IS)*UINV(I,IS)**2 * CV
      DP_RH =            UINV(I,IS)**2 * CV
      DP_UI = RHOI(I,IS)*UINV(I,IS)*2.0* CV
      DP_CV = RHOI(I,IS)*UINV(I,IS)**2
C
      DP_R1  = DP_RH*DRHDR1(I,IS) + DP_UI*DUIDR1(I,IS)   
      DP_R2  = DP_RH*DRHDR2(I,IS) + DP_UI*DUIDR2(I,IS)   
      DP_N1M = DP_RH*DRHN1M(I,IS) + DP_UI*DUIN1M(I,IS) + DP_CV*CV_N1M
      DP_N1P = DP_RH*DRHN1P(I,IS) + DP_UI*DUIN1P(I,IS) + DP_CV*CV_N1P
      DP_N2M = DP_RH*DRHN2M(I,IS) + DP_UI*DUIN2M(I,IS) + DP_CV*CV_N2M
      DP_N2P = DP_RH*DRHN2P(I,IS) + DP_UI*DUIN2P(I,IS) + DP_CV*CV_N2P
      DP_N3M = DP_RH*DRHN3M(I,IS) + DP_UI*DUIN3M(I,IS) + DP_CV*CV_N3M
      DP_N3P = DP_RH*DRHN3P(I,IS) + DP_UI*DUIN3P(I,IS) + DP_CV*CV_N3P
C
      DP_MS  = DP_RH*DRHDMS(I,IS) + DP_UI*DUIDMS(I,IS)
      DP_AL  = DP_RH*DRHDAL(I,IS) + DP_UI*DUIDAL(I,IS) + DP_CV*CV_AL
C
      DO 74 NN = 1, NBL
        CV_NG = CV_X1*NXG(I-1,J,NN) + CV_Y1*NYG(I-1,J,NN)
     &        + CV_X2*NXG(I  ,J,NN) + CV_Y2*NYG(I  ,J,NN)
     &        + CV_X3*NXG(I+1,J,NN) + CV_Y3*NYG(I+1,J,NN)
C
C------ BUG  16 Feb 96   DP_M1(N)) = ...
        DP_M1(NN) = DP_RH*DRHDM1(I,IS,NN) + DP_UI*DUIDM1(I,IS,NN)
        DP_NG(NN) = DP_RH*DRHDNG(I,IS,NN) + DP_UI*DUIDNG(I,IS,NN)
     &                                                 + DP_CV*CV_NG
  74  CONTINUE
C
      DO 75 NN = 1, NPOSN
        K = KPOSN(NN)
        CV_NP = CV_X1*NXP(I-1,J,K) + CV_Y1*NYP(I-1,J,K)
     &        + CV_X2*NXP(I  ,J,K) + CV_Y2*NYP(I  ,J,K)
     &        + CV_X3*NXP(I+1,J,K) + CV_Y3*NYP(I+1,J,K)
        DP_NP(K) = DP_RH*DRHDNP(I,IS,K) + DP_UI*DUIDNP(I,IS,K)
     &                                                + DP_CV*CV_NP
  75  CONTINUE
C
      RETURN
      END ! DPDN


      SUBROUTINE DIRWAL(N,IND1,IND2)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      J1 = JS1(N)
      J2 = JS2(N)
      I1 = IS1(N)
      I2 = IS2(N)
C
C---- clear j=1,J block rows for wall BC's below
      DO 10 I=IND1, IND2
        CALL CLROW(I,J1)
        CALL CLROW(I,J2)
 10   CONTINUE
C
cc      IF(LVISC) THEN
C----- set dn = d* conditions
       DO 22 I=IND1, IND2
         DOTP = NX(I,J1)*BNX(I,I1) + NY(I,J1)*BNY(I,I1)
         A2(J1,I) = DOTP
         AI(I1,3,I) =-1.0
         DR(J1,1,I) = DSTR(I,I1) - DISP(I,I1)
C
         DOTP = NX(I,J2)*BNX(I,I2) + NY(I,J2)*BNY(I,I2)
         A2(J2,I) = DOTP
         AI(I2,6,I) = -1.0
         DR(J2,1,I) = DSTR(I,I2) - DISP(I,I2)
   22  CONTINUE
C
cc      ELSE
ccC
ccC----- set dn = 0 conditions
cc       DO 23 I=IND1, IND2
cc         A2(J1,I) = 1.0
cc         A2(J2,I) = 1.0
cc   23  CONTINUE
C
cc      ENDIF
C
      IF(LMODI .OR. LMINV) THEN
C
C----- add on modal perturbation terms to righthand sides
       DO 31 I=IND1, IND2
         IG = I - ILEB(N) + 1
C
         SB1 = SBLE(N) + (SB(1     ,N) - SBLE(N))*SG(IG,I1)
         SB2 = SBLE(N) + (SB(IIB(N),N) - SBLE(N))*SG(IG,I2)
C
         XN1 =  DEVAL(SB1,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
         YN1 = -DEVAL(SB1,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
         SN1 = SQRT(XN1**2 + YN1**2)
         XN1 = XN1/SN1
         YN1 = YN1/SN1
C
         XN2 =  DEVAL(SB2,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
         YN2 = -DEVAL(SB2,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
         SN2 = SQRT(XN2**2 + YN2**2)
         XN2 = XN2/SN2
         YN2 = YN2/SN2
C
         DOTP1 = XN1*BNX(I,I1) + YN1*BNY(I,I1)
         DOTP2 = XN2*BNX(I,I2) + YN2*BNY(I,I2)
C
         DO 315 NN=1, NMODN
           K = KMODN(NN)
           DR(J1,LMODN(K),I) = -GN(K,IG,I1)*DOTP1
           DR(J2,LMODN(K),I) = -GN(K,IG,I2)*DOTP2
  315    CONTINUE
   31  CONTINUE
C
      ENDIF
C
ccc      return
      IF(.NOT.LVISC) RETURN
C
C===== Add weighted dn = d* wall BC equation to  dH*/dx =...  BL equation, 
C=     which gives the latter a larger diagonal element.  This is typically 
C=     needed at separation, where the diagonal element for dH*/dx = ...  
C=     goes through zero [ H*(Hk) is stationary at separation ].
C
      DO 54 I=IND1, IND2
C------ weight dn = d* equation so as to eliminate the dn entry in BL equation
        AITMP = ANH(I1,1,I)/A2(J1,I)
        ANH(I1,1,I) = 0.0
CCC                 = ANH(I1,1,I) - AITMP*A2(J1,I)
        AVH(I1,3,I) = AVH(I1,3,I) - AITMP*AI(I1,3,I)
        JD = 2*JJ-1 + 3*I1
        DO 542 L=1, NRHS
          DR(JD,L,I) = DR(JD,L,I) - AITMP*DR(J1,L,I)
  542   CONTINUE
C
        AITMP = ANH(I2,4,I)/A2(J2,I)
        ANH(I2,4,I) = 0.0
CCC                 = ANH(I2,4,I) - AITMP*A2(J2,I)
        AVH(I2,6,I) = AVH(I2,6,I) - AITMP*AI(I2,6,I)
        JD = 2*JJ-1 + 3*I2
        DO 544 L=1, NRHS
          DR(JD,L,I) = DR(JD,L,I) - AITMP*DR(J2,L,I)
  544   CONTINUE
   54 CONTINUE
C
      RETURN
      END ! DIRWAL


      SUBROUTINE INVWAL(N)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      J1 = JS1(N)
      J2 = JS2(N)
      I1 = IS1(N)
      I2 = IS2(N)
      ILE = ILEB(N)
      ITE = ITEB(N)
C
      IF(ISPRES.EQ.0) THEN
C----- Specified delta(p)
C
       DO 61 I=IX0, IX1
C
        IG = I - ILE + 1
C
        V1(J1,I) = V1(J2,I)
        VT(I1,I) = V2(J2,I)
        V4(J1,I) = V4(J2,I)
        Z1(J1,I) = Z1(J2,I)
        ZT(I1,I) = Z2(J2,I)
        Z4(J1,I) = Z4(J2,I)
        B1(J1,I) = B1(J2,I)
        BT(I1,I) = B2(J2,I)
        B4(J1,I) = B4(J2,I)
        A1(J1,I) = A1(J2,I)
        AT(I1,I) = A2(J2,I)
        A4(J1,I) = A4(J2,I)
        C1(J1,I) = C1(J2,I)
        CT(I1,I) = C2(J2,I)
        DR(J1,1,I) = DR(J1,1,I) + DR(J2,1,I)
     &             - 2.0*( PSPEC(IG,I1) - PSPEC(IG,I2)
     &                   + PDX0*FX0(I) + PDX1*FX1(I) 
     &                   + PDD0*FD0(I) + PDD1*FD1(I) )
        DR(J1,LPDX0,I) = 2.0*FX0(I)
        DR(J1,LPDX1,I) = 2.0*FX1(I)
        DR(J1,LPDD0,I) = 2.0*FD0(I)
        DR(J1,LPDD1,I) = 2.0*FD1(I)
        DO 11 L=2, NRHS
          DR(J1,L,I) = DR(J1,L,I) + DR(J2,L,I)
  11    CONTINUE
C
   61 CONTINUE
C
      ELSE IF(ISPRES.EQ.1) THEN
C----- specified pressure on side 1
C
       DO 71 I=IX0, IX1
         IG = I - ILE + 1
         DR(J1,1,I) = DR(J1,1,I)
     &             - 2.0*( PSPEC(IG,I1)
     &                   + PDX0*FX0(I) + PDX1*FX1(I) 
     &                   + PDD0*FD0(I) + PDD1*FD1(I) )
         DR(J1,LPDX0,I) = 2.0*FX0(I)
         DR(J1,LPDX1,I) = 2.0*FX1(I)
         DR(J1,LPDD0,I) = 2.0*FD0(I)
         DR(J1,LPDD1,I) = 2.0*FD1(I)
   71  CONTINUE
C
      ELSE IF(ISPRES.EQ.2) THEN
C----- specified pressure on side 2
C
       DO 81 I=IX0, IX1
         IG = I - ILE + 1
         DR(J2,1,I) = DR(J2,1,I)
     &              + 2.0*( PSPEC(IG,I2)
     &                    + PDX0*FX0(I) + PDX1*FX1(I) 
     &                    + PDD0*FD0(I) + PDD1*FD1(I) )
         DR(J2,LPDX0,I) = -2.0*FX0(I)
         DR(J2,LPDX1,I) = -2.0*FX1(I)
         DR(J2,LPDD0,I) = -2.0*FD0(I)
         DR(J2,LPDD1,I) = -2.0*FD1(I)
   81  CONTINUE
C
      ELSE
       STOP 'INVWAL:  Illegal ISPRES trigger'
      ENDIF
C
C
      IF(ISMOVE.EQ.-1) THEN

C----- set sum(n+Dstar) = 0 condition (camber preserved)
       DO 40 I=IX0, IX1
         CALL CLROW(I,J2)
   40  CONTINUE
C
       IF(LVISC) THEN
        DO 42 I=IX0, IX1
          DOTP1 = NX(I,J1)*BNX(I,I1) + NY(I,J1)*BNY(I,I1)
          DOTP2 = NX(I,J2)*BNX(I,I2) + NY(I,J2)*BNY(I,I2)
          AT(I2,I) =  DOTP1
          A2(J2,I) = -DOTP2
          AI(I2,3,I) = -1.0
          AI(I2,6,I) =  1.0
          DR(J2,1,I) = DSTR(I,I1)-DSTR(I,I2) - (DISP(I,I1)-DISP(I,I2))
   42   CONTINUE
       ELSE
        DO 44 I=IX0, IX1
          A2(J2,I) = 1.0
          AT(I2,I) = 1.0
   44   CONTINUE
       ENDIF
C
      ELSE IF(ISMOVE.EQ.0) THEN
C
C----- set delta(n+Dstar) = 0 condition (thickness preserved)
       DO 50 I=IX0, IX1
         CALL CLROW(I,J2)
   50  CONTINUE
C
       IF(LVISC) THEN
        DO 52 I=IX0, IX1
          DOTP1 = NX(I,J1)*BNX(I,I1) + NY(I,J1)*BNY(I,I1)
          DOTP2 = NX(I,J2)*BNX(I,I2) + NY(I,J2)*BNY(I,I2)
          AT(I2,I) = DOTP1
          A2(J2,I) = DOTP2
          AI(I2,3,I) = -1.0
          AI(I2,6,I) = -1.0
          DR(JJ,1,I) = DSTR(I,I1)+DSTR(I,I2) - (DISP(I,I1)+DISP(I,I2))
   52   CONTINUE
       ELSE
        DO 54 I=IX0, IX1
          A2(J2,I) = -1.0
          AT(I2,I) =  1.0
   54   CONTINUE
       ENDIF
C
      ELSE IF(ISMOVE.EQ.1) THEN
C
C----- grid offset = Dstar  on side 2
       DO 72 I=IX0, IX1
         CALL CLROW(I,J2)
   72  CONTINUE
C
       DO 73 I=IX0, IX1
         DOTP = NX(I,J2)*BNX(I,I2) + NY(I,J2)*BNY(I,I2)
         A2(J2,I) = DOTP
         AI(I2,6,I) = -1.0
         DR(J2,1,I) = DSTR(I,I2) - DISP(I,I2)
   73  CONTINUE
C
      ELSE IF(ISMOVE.EQ.2) THEN
C
C----- grid offset = Dstar  on side 1
       DO 82 I=IX0, IX1
         CALL CLROW(I,J1)
   82  CONTINUE
C
       DO 83 I=IX0, IX1
         DOTP = NX(I,J1)*BNX(I,I1) + NY(I,J1)*BNY(I,I1)
         A2(J1,I) = DOTP
         AI(I1,3,I) = -1.0
         DR(J1,1,I) = DSTR(I,I1) - DISP(I,I1)
   83  CONTINUE
C
      ELSE
       STOP 'INVWAL:  Illegal ISMOVE trigger'
      ENDIF
C
      RETURN
      END ! INVWAL


 
      SUBROUTINE CLROW(I,J)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      V1(J,I) = 0.
      V2(J,I) = 0.
      V3(J,I) = 0.
      V4(J,I) = 0.
      V5(J,I) = 0.
      Z1(J,I) = 0.
      Z2(J,I) = 0.
      Z3(J,I) = 0.
      Z4(J,I) = 0.
      Z5(J,I) = 0.
      B1(J,I) = 0.
      B2(J,I) = 0.
      B3(J,I) = 0.
      B4(J,I) = 0.
      B5(J,I) = 0.
      A1(J,I) = 0.
      A2(J,I) = 0.
      A3(J,I) = 0.
      A4(J,I) = 0.
      A5(J,I) = 0.
      C1(J,I) = 0.
      C2(J,I) = 0.
      C3(J,I) = 0.
      DO 10 L=1, NGLX
        DR(J,L,I) = 0.
   10 CONTINUE
C
      IF(JSTAG(J).NE.0) THEN
       IS = ABS(JSTAG(J))
C
       VT(IS,I) = 0.
       ZT(IS,I) = 0.
       BT(IS,I) = 0. 
       AT(IS,I) = 0.
       CT(IS,I) = 0.
       DO 20 K=1, 6
         AI(IS,K,I) = 0.
         BI(IS,K,I) = 0.
   20  CONTINUE
      ENDIF
C
      RETURN
      END ! CLROW
 


      SUBROUTINE SKUTTA
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
C----For each element
      DO 50 NB = 1, NBL
C
       ILE = ILEB(NB)
       ITE = ITEB(NB)
       J1 = JS1(NB)
       J2 = JS2(NB)
       I1 = IS1(NB)
       I2 = IS2(NB)
C
C---- add each dn-d* wake relation to the same condition downstream
       DO 20 I=II, ITE+2, -1
         IM = I-1
         BT(I2,I) = AT(I2,IM)
         B2(J2,I) = A2(J2,IM)
         BI(I2,3,I) = AI(I2,3,IM)
         BI(I2,6,I) = AI(I2,6,IM)
         DR(J2,1,I) = DR(J2,1,I) + DR(J2,1,IM)
         DO 10 N = 1, NBL
           DR(J2,LSBLE(N),I) = DR(J2,LSBLE(N),I) + DR(J2,LSBLE(N),IM)
   10    CONTINUE
   20  CONTINUE
C
       I = ITE+1
       IM = I-1
C
       BT(I2,I) = -AT(I2,IM)
       B2(J2,I) =  A2(J2,IM)
       BI(I2,6,I) = AI(I2,6,IM)
       DR(J2,1,I) = DR(J2,1,I)
     &            + DSTR(IM,I2) + DISP(IM,I1) - DISP(IM,I2)
C
   50 CONTINUE
C
      RETURN
      END ! SKUTTA



