
      SUBROUTINE SETBL
C-------------------------------------------------
C     Sets up the BL Newton system coefficients
C     for the current BL variables and the edge
C     velocities received from SETUP. The local
C     BL system coefficients are then
C     incorporated into the global Newton system.  
C-------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'MBL.INC'
      DIMENSION XTRLOC(ISX)
      DIMENSION AMPL(ISX)
C
      IF(NBX.NE.NEX) 
     &  STOP '**  Must have NBX=NEX between STATE.INC and MBL.INC  ** '
C
      PSTBL = PSTOUT
      RSTBL = RSTOUT
      HSTBL = HINF
      REYBL = REYN
C
      IF(LREYN.EQ.0) THEN
C----- linearize Reynolds number wrt mass flow
CCC    REYN = REYNIN/(RHOINF*QINF/MUINF)
       RE_MASS = REYN*(MU_MSQ/MUINF - RI_MSQ/RHOINF - QI_MSQ/QINF)
     &       / MS_MSQ
       RE_REYN = 1.0
      ELSE
C----- Reynolds number is a global DOF: no explicit dependence on mass flow
       RE_MASS = 0.0
       RE_REYN = 1.0
      ENDIF
C
      GAMBL = GAM
      GM1BL = GM1
C
      HVISBL = HVIS
      AMCRIT = ACRIT
C
C---- calculate BL arc length arrays
      CALL XICALC
C
C---- set forced transition locations
      CALL XIFSET
C
C---- set current edge density
      DO 2 IS=1, 2*NBL
        N = (IS+1)/2
        DO 21 I=ILEB(N), II-1
          CALL RHF(RHOI(I,IS), UINV(I,IS), DUDN(I,IS),
     &                         THET(I,IS), DSTR(I,IS),
     &           WXUT, WXUD, HSTBL, GAMBL,
     &           RHOE(I,IS), RH_RI2, RH_UI2, RH_UN2, RH_TH2, RH_DS2)
 21     CONTINUE
 2    CONTINUE
C
      IF(INITBL.EQ.0) THEN
C
       WRITE(*,*)
       WRITE(*,*) 'Initializing BL ...'
C
C----- save inviscid edge velocity, since UEDG will be changed by MRCHUE/DU
       DO 5 N=1, NBL
         ILE = ILEB(N)
         I1 = IS1(N)
         I2 = IS2(N)
         DO 4 I=ILE, II
           UEDG(I,I1) = UINV(I,I1)
           UEDG(I,I2) = UINV(I,I2)
    4    CONTINUE
C
         IF(NBL.GT.1) THEN
C-------- for multielement cases, smooth Ue slightly for MRCHUE initialization
          DSLE = SBLE(N)*0.5*(SG(2,I1)-SG(1,I1) + SG(2,I2)-SG(1,I2))
CCC       SMOOL = 8.0*DSLE
          SMOOL = 1.0*DSLE
          CALL UEMOD(I1,SMOOL)         
          CALL UEMOD(I2,SMOOL)
         ENDIF
    5  CONTINUE
C
C----- initialize BL by marching with Ue (fudge at separation)
       CALL BUSET
       CALL MRCHUE
       INITBL = 1
C
      ELSE
C
C----- save inviscid edge velocity, since UEDG will be changed by MRCHUE/DU
       DO 8 N=1, NBL
         ILE = ILEB(N)
         ITE = ITEB(N)
         I1 = IS1(N)
         I2 = IS2(N)
         DO 7 I=ILE, II
C--------- nudge UEDG towards UINV -- Newton step may not do it fast enough
           CALL UEF(UINV(I,I1), DUDN(I,I1), THET(I,I1), DSTR(I,I1),
     &              WXUT, WXUD,
     &              UE1, UE_UI1, UE_UN1, UE_TH1, UE_DS1)
           CALL UEF(UINV(I,I2), DUDN(I,I2), THET(I,I2), DSTR(I,I2),
     &              WXUT, WXUD,
     &              UE2, UE_UI2, UE_UN2, UE_TH2, UE_DS2)
           UEDG(I,I1) = 0.25*UE1 + 0.75*UEDG(I,I1)
           UEDG(I,I2) = 0.25*UE2 + 0.75*UEDG(I,I2)
cc@@@
c        CALL RHF(RHOI(I ,I1), UINV(I,I1), DUDN(I,I1),
c     &                        THET(I,I1), DSTR(I,I1),
c     &              WXUT, WXUD, HSTBL, GAMBL,
c     &              RH1, RH_RI1, RH_UI1, RH_UN1, RH_TH1, RH_DS1)
c        CALL RHF(RHOI(I ,I2), UINV(I,I2), DUDN(I,I2),
c     &                        THET(I,I2), DSTR(I,I2),
c     &              WXUT, WXUD, HSTBL, GAMBL,
c     &              RH2, RH_RI2, RH_UI2, RH_UN2, RH_TH2, RH_DS2)
c           UEDG(I,I1) = UE1
c           UEDG(I,I2) = UE2
c           RHOE(I,I1) = RH1
c           RHOE(I,I2) = RH2
cc@@@
    7    CONTINUE
    8  CONTINUE
C
C----- march BL's with current Ue and Ds to establish transition
      CALL BUSET
      CALL MRCHDU
C
      ENDIF
C
      DO 10 IS=1, 2*NBL
        N = (IS+1)/2
C
C------ initialize transition and turbulent flags
        TRAN(IS) = .FALSE.
        TURB(IS) = .FALSE.
C
C------ save TE thicknesses
        DWTE(IS) = 0.5*WGAP(ITEB(N),N)
C
   10 CONTINUE
C
C
C---- find minimum LE index
      ILEMIN = ILEB(1)
      DO 14 N=1, NBL
        ILEMIN = MIN0( ILEMIN , ILEB(N) )
   14 CONTINUE
C
C
C**** Sweep downstream setting up BL equation linearizations
      DO 1000 I=ILEMIN+1, II-1
C
      IM = I-1
C
C**** Go over each deck, setting up variables and various flags
      DO 20 IS=1, 2*NBL
        N = (IS+1)/2
C
        ILE = ILEB(N)
        ITE = ITEB(N)
C
C------ keep going if we're still upstream of LE on this deck
        UPLE(IS) = I.LE.ILE
        IF(UPLE(IS)) GO TO 20
C
        SIMI(IS) = I.EQ.ILE+1
        WAKE(IS) = I.GT.ITE
        TRAN(IS) = I.EQ.ITRAN(IS)
        TURB(IS) = I.GT.ITRAN(IS)
C
        IF(I.LT.ITRAN(IS)) AMPL(IS) = CTAU(I,IS)
C
        DSWAKI = 0.0
        IF(WAKE(IS)) DSWAKI = 0.5*WGAP(I,N)
C
C------ set primary variables for current station
        XSI = XI(I,IS)  
c%%%        AMI = CTAU(I,IS)
        AMI = AMPL(  IS)
        CTI = CTAU(I,IS)
        UEI = UEDG(I,IS)
        THI = THET(I,IS)
        DSI = DSTR(I,IS) - DSWAKI
        RHI = RHOE(I,IS)
        UNI = DUDN(I,IS)
C
C------ set all secondary "2" variables in COMMON/VAR2/
        CALL SETKIN(XSI,AMI,CTI,UEI,THI,DSI,DSWAKI,UNI,RHI)
C
C------ check for transition and set TRAN, XT, etc. if found
        IF(TRAN(IS)) THEN
C
C------- set secondary variables for TRCHEK
         DO 205 NC=1, NCOM
           V2SAV(NC,IS) = COM2(NC)
 205     CONTINUE
C
         CALL TRCHEK(I,IS,AMI)
         IF(.NOT.TRAN(IS)) THEN
          WRITE(*,*) 
     &  '? Xtr err -- i is n1 n2:',I,IS,CTAU(I-1,IS),CTAU(I,IS)
C
C-------- set original amplification variable (TRCHEK clobbered it)
          AMI = CTAU(I,IS)
          AMPL2 = AMI
         ENDIF
        ENDIF
C
C------ save secondary variables
        DO 210 NC=1, NCOM
          V2SAV(NC,IS) = COM2(NC)
  210   CONTINUE
C
   20 CONTINUE ! with next side
C
C
C**** set profile parameters for all decks at station I
ccc      CALL DECPAR(GAPS,2*NBL)
C
C
      DO 30 IS=1, 2*NBL
        N = (IS+1)/2
C
C------ keep going if we're still upstream of LE on this layer
        IF(UPLE(IS)) GO TO 30
C
C------ set all tertiary "1" (LE only), "2", and "A" variables and save
        CALL SETVAR(IS)
C
C------ save wall shear for plotting output
        TAU(I,IS) = TAUWI
        TAU_RH(I,IS) = TAU_RHI
        TAU_UE(I,IS) = TAU_UEI
        TAU_TH(I,IS) = TAU_THI
        TAU_DS(I,IS) = TAU_DSI
        TAU_RE(I,IS) = TAU_REY
C
        VCEN(I,IS) = VCENI
C
   30 CONTINUE ! with next side
C
C
C---- unset convergence flags to force BLSYS to set up equation system
      DO 35 N=1, NBL
        CONVB(N) = .FALSE.
   35 CONTINUE
C
C
C**** Set overall BL equation system for all layers at current i interval
      CALL BLSYS(NBL)
C
C
C**** Stuff BL equation system coefficients into main Jacobian matrix
      DO 40 IS=1, 2*NBL
        IF(UPLE(IS)) GO TO 40
C
        N = (IS+1)/2
C
C------ IS0 = 1 (upper), or 2 (lower) side
        IS0 = MOD(IS+1,2) + 1
C
        ILE = ILEB(N)
        ITE = ITEB(N)
C
cc        if(i.gt.ite) then
cc         write(*,6661) i, 0.001*tyysav(n), 0.001*uyysav(n), 
cc     &              cesav(n), 1.0-ussav(n), dussav(n)
cc 6661    format(1x,i3, 5f13.4)
cc        endif
cc
C------ set main Jacobian matrix BL equation row indices for layer IS
        KC = 2*JJ + 3*(IS-1)       ! amplification/shear-lag equation
        KT = 2*JJ + 3*(IS-1) + 1   ! momentum equation
        KH = 2*JJ + 3*(IS-1) + 2   ! shape parameter equation
C
C------ set residuals, Re entries, and clear other entries for layer IS
        K0 = 4*(IS0-1)
C
        DR(KC,1,I) = VVREZ(K0+1,N)
        DR(KT,1,I) = VVREZ(K0+2,N)
        DR(KH,1,I) = VVREZ(K0+3,N)
C
        DR(KC,LREYN,I) = VVR(K0+1,N) * RE_REYN
        DR(KT,LREYN,I) = VVR(K0+2,N) * RE_REYN
        DR(KH,LREYN,I) = VVR(K0+3,N) * RE_REYN
C
        DR(KC,LMASS,I) = VVR(K0+1,N) * RE_MASS
        DR(KT,LMASS,I) = VVR(K0+2,N) * RE_MASS
        DR(KH,LMASS,I) = VVR(K0+3,N) * RE_MASS
C
        DO 390 L=1, NBL
          DR(KC,LMAS1(L),I) = 0.
          DR(KT,LMAS1(L),I) = 0.
          DR(KH,LMAS1(L),I) = 0.
C
          DR(KC,LSBLE(L),I) = 0.
          DR(KT,LSBLE(L),I) = 0.
          DR(KH,LSBLE(L),I) = 0.
  390   CONTINUE
C
C------ set XI sensitivities wrt LE movement of this element
        IF(MOD(IS,2).EQ.1) THEN
         J = JS1(N)
         SGN = 1.0
        ELSE
         J = JS2(N)
         SGN = -1.0
        ENDIF
C
        XL_SBLE =  SGN*SQRT(NXG(ILE,J,N)**2 + NYG(ILE,J,N)**2)
        X1_SBLE = -SGN*SQRT(NXG(I-1,J,N)**2 + NYG(I-1,J,N)**2) + XL_SBLE
        X2_SBLE = -SGN*SQRT(NXG(I  ,J,N)**2 + NYG(I  ,J,N)**2) + XL_SBLE
C
C------ sensitivity of forced-transition location
        IF(XTR1(IS).GT.0.0) THEN
          XF_SBLE = XL_SBLE
        ELSE
          XF_SBLE = XL_SBLE * ABS(XTR1(IS))
        ENDIF
C
C****** go over all variables in all layers which might influence layer IS
C
C------ go over the two layers of the element which contains side IS
        DO 400 KS=1, 2
C
        JS = 2*(N-1) + KS
C
C------ column indices in overall BL system storage arrays
        LN1 = 2*(KS-1) + 1
        LN2 = 2*(KS-1) + 2
        LR = KS
C
C------ column indices for Ct, Th, etc.,  in local BL system arrays
        LC = 4*(KS-1) + 1
        LT = 4*(KS-1) + 2
        LD = 4*(KS-1) + 3
        LU = 4*(KS-1) + 4
        LX = KS
C
        LVC = 3*(KS-1) + 1
        LVT = 3*(KS-1) + 2
        LVD = 3*(KS-1) + 3
C
C------ set current Ue implied by current Ui, Un, Th, Ds
        CALL UEF(UINV(IM,JS), DUDN(IM,JS), THET(IM,JS), DSTR(IM,JS),
     &              WXUT, WXUD,
     &              UE1, UE_UI1, UE_UN1, UE_TH1, UE_DS1)
        CALL UEF(UINV(I ,JS), DUDN(I ,JS), THET(I ,JS), DSTR(I ,JS),
     &              WXUT, WXUD,
     &              UE2, UE_UI2, UE_UN2, UE_TH2, UE_DS2)
C
C------ set current Rhoe implied by current Ri, Ui, Un, Th, Ds
        CALL RHF(RHOI(IM,JS), UINV(IM,JS), DUDN(IM,JS), 
     &                        THET(IM,JS), DSTR(IM,JS),
     &              WXUT, WXUD, HSTBL, GAMBL,
     &              RH1, RH_RI1, RH_UI1, RH_UN1, RH_TH1, RH_DS1)
        CALL RHF(RHOI(I ,JS), UINV(I ,JS), DUDN(I ,JS),
     &                        THET(I ,JS), DSTR(I ,JS),
     &              WXUT, WXUD, HSTBL, GAMBL,
     &              RH2, RH_RI2, RH_UI2, RH_UN2, RH_TH2, RH_DS2)
C
C----------------------------------------------
C------ fill lag equation
        K = 4*(IS0-1) + 1
        Z_UE1 = VV1(K,LU,N)
        Z_UE2 = VV2(K,LU,N)
        Z_RH1 = VVR1(K,LX,N)
        Z_RH2 = VVR2(K,LX,N)
C
        Z_UN1 = VVN1(K,LX,N) + Z_UE1*UE_UN1 + Z_RH1*RH_UN1
        Z_UN2 = VVN2(K,LX,N) + Z_UE2*UE_UN2 + Z_RH2*RH_UN2
        Z_X1  = VVX1(K,LX,N)
        Z_X2  = VVX2(K,LX,N)
        Z_XF  = VVXF(K,LX,N)
ccc     Z_RE  = VVR(K,N)
C
        Z_UI1 = Z_UE1*UE_UI1 + Z_RH1*RH_UI1
        Z_UI2 = Z_UE2*UE_UI2 + Z_RH2*RH_UI2
        Z_RI1 =                Z_RH1*RH_RI1
        Z_RI2 =                Z_RH2*RH_RI2
C
        ZNC(IS,LN1,I) = Z_UI1*DUIN1M(IM,JS)
     &                + Z_RI1*DRHN1M(IM,JS)
     &                + Z_UN1*DUNN1M(IM,JS)
        BNC(IS,LN1,I) = Z_UI1*DUIN2M(IM,JS) + Z_UI2*DUIN1M(I,JS)
     &                + Z_RI1*DRHN2M(IM,JS) + Z_RI2*DRHN1M(I,JS)
     &                + Z_UN1*DUNN2M(IM,JS) + Z_UN2*DUNN1M(I,JS)
        ANC(IS,LN1,I) = Z_UI1*DUIN3M(IM,JS) + Z_UI2*DUIN2M(I,JS)
     &                + Z_RI1*DRHN3M(IM,JS) + Z_RI2*DRHN2M(I,JS)
     &                + Z_UN1*DUNN3M(IM,JS) + Z_UN2*DUNN2M(I,JS)
        CNC(IS,LN1,I) =                       Z_UI2*DUIN3M(I,JS)
     &                                      + Z_RI2*DRHN3M(I,JS)
     &                                      + Z_UN2*DUNN3M(I,JS)
C
        ZNC(IS,LN2,I) = Z_UI1*DUIN1P(IM,JS)
     &                + Z_RI1*DRHN1P(IM,JS)
     &                + Z_UN1*DUNN1P(IM,JS)
        BNC(IS,LN2,I) = Z_UI1*DUIN2P(IM,JS) + Z_UI2*DUIN1P(I,JS)
     &                + Z_RI1*DRHN2P(IM,JS) + Z_RI2*DRHN1P(I,JS)
     &                + Z_UN1*DUNN2P(IM,JS) + Z_UN2*DUNN1P(I,JS)
        ANC(IS,LN2,I) = Z_UI1*DUIN3P(IM,JS) + Z_UI2*DUIN2P(I,JS)
     &                + Z_RI1*DRHN3P(IM,JS) + Z_RI2*DRHN2P(I,JS)
     &                + Z_UN1*DUNN3P(IM,JS) + Z_UN2*DUNN2P(I,JS)
        CNC(IS,LN2,I) =                       Z_UI2*DUIN3P(I,JS)
     &                                      + Z_RI2*DRHN3P(I,JS)
     &                                      + Z_UN2*DUNN3P(I,JS)
C
        ZRC(IS,LR ,I) = Z_UI1*DUIDR1(IM,JS)
     &                + Z_RI1*DRHDR1(IM,JS)
     &                + Z_UN1*DUNDR1(IM,JS)
        BRC(IS,LR ,I) = Z_UI1*DUIDR2(IM,JS) + Z_UI2*DUIDR1(I,JS)
     &                + Z_RI1*DRHDR2(IM,JS) + Z_RI2*DRHDR1(I,JS)
     &                + Z_UN1*DUNDR2(IM,JS) + Z_UN2*DUNDR1(I,JS)
        ARC(IS,LR ,I) =                       Z_UI2*DUIDR2(I,JS)
     &                                      + Z_RI2*DRHDR2(I,JS)
     &                                      + Z_UN2*DUNDR2(I,JS)
C
        BVC(IS,LVC,I) = VV1(K,LC,N)
        AVC(IS,LVC,I) = VV2(K,LC,N)
        BVC(IS,LVT,I) = VV1(K,LT,N) + Z_UE1*UE_TH1 + Z_RH1*RH_TH1
        AVC(IS,LVT,I) = VV2(K,LT,N) + Z_UE2*UE_TH2 + Z_RH2*RH_TH2
        BVC(IS,LVD,I) = VV1(K,LD,N) + Z_UE1*UE_DS1 + Z_RH1*RH_DS1
        AVC(IS,LVD,I) = VV2(K,LD,N) + Z_UE2*UE_DS2 + Z_RH2*RH_DS2
C
        DR(KC,1,I) = DR(KC,1,I) + Z_UE1*(UEDG(IM,JS)-UE1)
     &                          + Z_UE2*(UEDG(I ,JS)-UE2)
     &                          + Z_RH1*(RHOE(IM,JS)-RH1)
     &                          + Z_RH2*(RHOE(I ,JS)-RH2)
        DR(KC,LMASS,I) = DR(KC,LMASS,I) 
     &                 + Z_UI1*DUIDMS(IM,JS) + Z_UI2*DUIDMS(I ,JS)
     &                 + Z_RI1*DRHDMS(IM,JS) + Z_RI2*DRHDMS(I ,JS)
     &                 + Z_UN1*DUNDMS(IM,JS) + Z_UN2*DUNDMS(I ,JS)
        DO 4010 L=1, NBL
          DR(KC,LMAS1(L),I) = DR(KC,LMAS1(L),I)
     &                + Z_UI1*DUIDM1(IM,JS,L) + Z_UI2*DUIDM1(I ,JS,L)
     &                + Z_RI1*DRHDM1(IM,JS,L) + Z_RI2*DRHDM1(I ,JS,L)
     &                + Z_UN1*DUNDM1(IM,JS,L) + Z_UN2*DUNDM1(I ,JS,L)
          DR(KC,LSBLE(L),I) = DR(KC,LSBLE(L),I)
     &                + Z_UI1*DUIDNG(IM,JS,L) + Z_UI2*DUIDNG(I ,JS,L)
     &                + Z_RI1*DRHDNG(IM,JS,L) + Z_RI2*DRHDNG(I ,JS,L)
     &                + Z_UN1*DUNDNG(IM,JS,L) + Z_UN2*DUNDNG(I ,JS,L)
 4010   CONTINUE
        DO 4012 L=1, NPOSN
          KK = KPOSN(L)
          DR(KC,LPOSN(KK),I) = DR(KC,LPOSN(KK),I)
     &                + Z_UI1*DUIDNP(IM,JS,KK) + Z_UI2*DUIDNP(I ,JS,KK)
     &                + Z_RI1*DRHDNP(IM,JS,KK) + Z_RI2*DRHDNP(I ,JS,KK)
     &                + Z_UN1*DUNDNP(IM,JS,KK) + Z_UN2*DUNDNP(I ,JS,KK)
     &                + Z_X1 *DXIDNP(IM,JS,KK) + Z_X2 *DXIDNP(I ,JS,KK)
 4012   CONTINUE
        DR(KC,LALFA,I) = DR(KC,LALFA,I)
     &                + Z_UI1*DUIDAL(IM,JS) + Z_UI2*DUIDAL(I ,JS)
     &                + Z_RI1*DRHDAL(IM,JS) + Z_RI2*DRHDAL(I ,JS)
     &                + Z_UN1*DUNDAL(IM,JS) + Z_UN2*DUNDAL(I ,JS)
C
        DR(KC,LSBLE(N),I) = DR(KC,LSBLE(N),I)
     &                + Z_X1*X1_SBLE + Z_X2*X2_SBLE + Z_XF*XF_SBLE
C
C
C----------------------------------------------
C------ fill momentum equation
        K = 4*(IS0-1) + 2
        Z_UE1 = VV1(K,LU,N)
        Z_UE2 = VV2(K,LU,N)
        Z_RH1 = VVR1(K,LX,N)
        Z_RH2 = VVR2(K,LX,N)
C
        Z_UN1 = VVN1(K,LX,N) + Z_UE1*UE_UN1 + Z_RH1*RH_UN1
        Z_UN2 = VVN2(K,LX,N) + Z_UE2*UE_UN2 + Z_RH2*RH_UN2
        Z_X1  = VVX1(K,LX,N)
        Z_X2  = VVX2(K,LX,N)
        Z_XF  = VVXF(K,LX,N)
ccc     Z_RE  = VVR(K,N)
C
        Z_UI1 = Z_UE1*UE_UI1 + Z_RH1*RH_UI1
        Z_UI2 = Z_UE2*UE_UI2 + Z_RH2*RH_UI2
        Z_RI1 =                Z_RH1*RH_RI1
        Z_RI2 =                Z_RH2*RH_RI2
C
        ZNT(IS,LN1,I) = Z_UI1*DUIN1M(IM,JS)
     &                + Z_RI1*DRHN1M(IM,JS)
     &                + Z_UN1*DUNN1M(IM,JS)
        BNT(IS,LN1,I) = Z_UI1*DUIN2M(IM,JS) + Z_UI2*DUIN1M(I,JS)
     &                + Z_RI1*DRHN2M(IM,JS) + Z_RI2*DRHN1M(I,JS)
     &                + Z_UN1*DUNN2M(IM,JS) + Z_UN2*DUNN1M(I,JS)
        ANT(IS,LN1,I) = Z_UI1*DUIN3M(IM,JS) + Z_UI2*DUIN2M(I,JS)
     &                + Z_RI1*DRHN3M(IM,JS) + Z_RI2*DRHN2M(I,JS)
     &                + Z_UN1*DUNN3M(IM,JS) + Z_UN2*DUNN2M(I,JS)
        CNT(IS,LN1,I) =                       Z_UI2*DUIN3M(I,JS)
     &                                      + Z_RI2*DRHN3M(I,JS)
     &                                      + Z_UN2*DUNN3M(I,JS)
C
        ZNT(IS,LN2,I) = Z_UI1*DUIN1P(IM,JS)
     &                + Z_RI1*DRHN1P(IM,JS)
     &                + Z_UN1*DUNN1P(IM,JS)
        BNT(IS,LN2,I) = Z_UI1*DUIN2P(IM,JS) + Z_UI2*DUIN1P(I,JS)
     &                + Z_RI1*DRHN2P(IM,JS) + Z_RI2*DRHN1P(I,JS)
     &                + Z_UN1*DUNN2P(IM,JS) + Z_UN2*DUNN1P(I,JS)
        ANT(IS,LN2,I) = Z_UI1*DUIN3P(IM,JS) + Z_UI2*DUIN2P(I,JS)
     &                + Z_RI1*DRHN3P(IM,JS) + Z_RI2*DRHN2P(I,JS)
     &                + Z_UN1*DUNN3P(IM,JS) + Z_UN2*DUNN2P(I,JS)
        CNT(IS,LN2,I) =                       Z_UI2*DUIN3P(I,JS)
     &                                      + Z_RI2*DRHN3P(I,JS)
     &                                      + Z_UN2*DUNN3P(I,JS)
C
        ZRT(IS,LR ,I) = Z_UI1*DUIDR1(IM,JS)
     &                + Z_RI1*DRHDR1(IM,JS)
     &                + Z_UN1*DUNDR1(IM,JS)
        BRT(IS,LR ,I) = Z_UI1*DUIDR2(IM,JS) + Z_UI2*DUIDR1(I,JS)
     &                + Z_RI1*DRHDR2(IM,JS) + Z_RI2*DRHDR1(I,JS)
     &                + Z_UN1*DUNDR2(IM,JS) + Z_UN2*DUNDR1(I,JS)
        ART(IS,LR ,I) =                       Z_UI2*DUIDR2(I,JS)
     &                                      + Z_RI2*DRHDR2(I,JS)
     &                                      + Z_UN2*DUNDR2(I,JS)
C
        BVT(IS,LVC,I) = VV1(K,LC,N)
        AVT(IS,LVC,I) = VV2(K,LC,N)
        BVT(IS,LVT,I) = VV1(K,LT,N) + Z_UE1*UE_TH1 + Z_RH1*RH_TH1
        AVT(IS,LVT,I) = VV2(K,LT,N) + Z_UE2*UE_TH2 + Z_RH2*RH_TH2
        BVT(IS,LVD,I) = VV1(K,LD,N) + Z_UE1*UE_DS1 + Z_RH1*RH_DS1
        AVT(IS,LVD,I) = VV2(K,LD,N) + Z_UE2*UE_DS2 + Z_RH2*RH_DS2
C
        DR(KT,1,I) = DR(KT,1,I) + Z_UE1*(UEDG(IM,JS)-UE1)
     &                          + Z_UE2*(UEDG(I ,JS)-UE2)
     &                          + Z_RH1*(RHOE(IM,JS)-RH1)
     &                          + Z_RH2*(RHOE(I ,JS)-RH2)
        DR(KT,LMASS,I) = DR(KT,LMASS,I) 
     &                 + Z_UI1*DUIDMS(IM,JS) + Z_UI2*DUIDMS(I ,JS)
     &                 + Z_RI1*DRHDMS(IM,JS) + Z_RI2*DRHDMS(I ,JS)
     &                 + Z_UN1*DUNDMS(IM,JS) + Z_UN2*DUNDMS(I ,JS)
        DO 4020 L=1, NBL
          DR(KT,LMAS1(L),I) = DR(KT,LMAS1(L),I)
     &                + Z_UI1*DUIDM1(IM,JS,L) + Z_UI2*DUIDM1(I ,JS,L)
     &                + Z_RI1*DRHDM1(IM,JS,L) + Z_RI2*DRHDM1(I ,JS,L)
     &                + Z_UN1*DUNDM1(IM,JS,L) + Z_UN2*DUNDM1(I ,JS,L)
          DR(KT,LSBLE(L),I) = DR(KT,LSBLE(L),I)
     &                + Z_UI1*DUIDNG(IM,JS,L) + Z_UI2*DUIDNG(I ,JS,L)
     &                + Z_RI1*DRHDNG(IM,JS,L) + Z_RI2*DRHDNG(I ,JS,L)
     &                + Z_UN1*DUNDNG(IM,JS,L) + Z_UN2*DUNDNG(I ,JS,L)
 4020   CONTINUE
        DO 4022 L=1, NPOSN
          KK = KPOSN(L)
          DR(KT,LPOSN(KK),I) = DR(KT,LPOSN(KK),I)
     &                + Z_UI1*DUIDNP(IM,JS,KK) + Z_UI2*DUIDNP(I ,JS,KK)
     &                + Z_RI1*DRHDNP(IM,JS,KK) + Z_RI2*DRHDNP(I ,JS,KK)
     &                + Z_UN1*DUNDNP(IM,JS,KK) + Z_UN2*DUNDNP(I ,JS,KK)
     &                + Z_X1 *DXIDNP(IM,JS,KK) + Z_X2 *DXIDNP(I ,JS,KK)
 4022   CONTINUE
        DR(KT,LALFA,I) = DR(KT,LALFA,I)
     &                + Z_UI1*DUIDAL(IM,JS) + Z_UI2*DUIDAL(I ,JS)
     &                + Z_RI1*DRHDAL(IM,JS) + Z_RI2*DRHDAL(I ,JS)
     &                + Z_UN1*DUNDAL(IM,JS) + Z_UN2*DUNDAL(I ,JS)
C
        DR(KT,LSBLE(N),I) = DR(KT,LSBLE(N),I)
     &                + Z_X1*X1_SBLE + Z_X2*X2_SBLE + Z_XF*XF_SBLE
C
C
C----------------------------------------------
C------ fill shape parameter equation
        K = 4*(IS0-1) + 3
        Z_UE1 = VV1(K,LU,N)
        Z_UE2 = VV2(K,LU,N)
        Z_RH1 = VVR1(K,LX,N)
        Z_RH2 = VVR2(K,LX,N)
C
        Z_UN1 = VVN1(K,LX,N) + Z_UE1*UE_UN1 + Z_RH1*RH_UN1
        Z_UN2 = VVN2(K,LX,N) + Z_UE2*UE_UN2 + Z_RH2*RH_UN2
        Z_X1  = VVX1(K,LX,N)
        Z_X2  = VVX2(K,LX,N)
        Z_XF  = VVXF(K,LX,N)
ccc     Z_RE  = VVR(K,N)
C
        Z_UI1 = Z_UE1*UE_UI1 + Z_RH1*RH_UI1
        Z_UI2 = Z_UE2*UE_UI2 + Z_RH2*RH_UI2
        Z_RI1 =                Z_RH1*RH_RI1
        Z_RI2 =                Z_RH2*RH_RI2
C
        ZNH(IS,LN1,I) = Z_UI1*DUIN1M(IM,JS)
     &                + Z_RI1*DRHN1M(IM,JS)
     &                + Z_UN1*DUNN1M(IM,JS)
        BNH(IS,LN1,I) = Z_UI1*DUIN2M(IM,JS) + Z_UI2*DUIN1M(I,JS)
     &                + Z_RI1*DRHN2M(IM,JS) + Z_RI2*DRHN1M(I,JS)
     &                + Z_UN1*DUNN2M(IM,JS) + Z_UN2*DUNN1M(I,JS)
        ANH(IS,LN1,I) = Z_UI1*DUIN3M(IM,JS) + Z_UI2*DUIN2M(I,JS)
     &                + Z_RI1*DRHN3M(IM,JS) + Z_RI2*DRHN2M(I,JS)
     &                + Z_UN1*DUNN3M(IM,JS) + Z_UN2*DUNN2M(I,JS)
        CNH(IS,LN1,I) =                       Z_UI2*DUIN3M(I,JS)
     &                                      + Z_RI2*DRHN3M(I,JS)
     &                                      + Z_UN2*DUNN3M(I,JS)
C
        ZNH(IS,LN2,I) = Z_UI1*DUIN1P(IM,JS)
     &                + Z_RI1*DRHN1P(IM,JS)
     &                + Z_UN1*DUNN1P(IM,JS)
        BNH(IS,LN2,I) = Z_UI1*DUIN2P(IM,JS) + Z_UI2*DUIN1P(I,JS)
     &                + Z_RI1*DRHN2P(IM,JS) + Z_RI2*DRHN1P(I,JS)
     &                + Z_UN1*DUNN2P(IM,JS) + Z_UN2*DUNN1P(I,JS)
        ANH(IS,LN2,I) = Z_UI1*DUIN3P(IM,JS) + Z_UI2*DUIN2P(I,JS)
     &                + Z_RI1*DRHN3P(IM,JS) + Z_RI2*DRHN2P(I,JS)
     &                + Z_UN1*DUNN3P(IM,JS) + Z_UN2*DUNN2P(I,JS)
        CNH(IS,LN2,I) =                       Z_UI2*DUIN3P(I,JS)
     &                                      + Z_RI2*DRHN3P(I,JS)
     &                                      + Z_UN2*DUNN3P(I,JS)
C
        ZRH(IS,LR ,I) = Z_UI1*DUIDR1(IM,JS)
     &                + Z_RI1*DRHDR1(IM,JS)
     &                + Z_UN1*DUNDR1(IM,JS)
        BRH(IS,LR ,I) = Z_UI1*DUIDR2(IM,JS) + Z_UI2*DUIDR1(I,JS)
     &                + Z_RI1*DRHDR2(IM,JS) + Z_RI2*DRHDR1(I,JS)
     &                + Z_UN1*DUNDR2(IM,JS) + Z_UN2*DUNDR1(I,JS)
        ARH(IS,LR ,I) =                       Z_UI2*DUIDR2(I,JS)
     &                                      + Z_RI2*DRHDR2(I,JS)
     &                                      + Z_UN2*DUNDR2(I,JS)
C
        BVH(IS,LVC,I) = VV1(K,LC,N)
        AVH(IS,LVC,I) = VV2(K,LC,N)
        BVH(IS,LVT,I) = VV1(K,LT,N) + Z_UE1*UE_TH1 + Z_RH1*RH_TH1
        AVH(IS,LVT,I) = VV2(K,LT,N) + Z_UE2*UE_TH2 + Z_RH2*RH_TH2
        BVH(IS,LVD,I) = VV1(K,LD,N) + Z_UE1*UE_DS1 + Z_RH1*RH_DS1
        AVH(IS,LVD,I) = VV2(K,LD,N) + Z_UE2*UE_DS2 + Z_RH2*RH_DS2
C
        DR(KH,1,I) = DR(KH,1,I) + Z_UE1*(UEDG(IM,JS)-UE1)
     &                          + Z_UE2*(UEDG(I ,JS)-UE2)
     &                          + Z_RH1*(RHOE(IM,JS)-RH1)
     &                          + Z_RH2*(RHOE(I ,JS)-RH2)
        DR(KH,LMASS,I) = DR(KH,LMASS,I) 
     &                 + Z_UI1*DUIDMS(IM,JS) + Z_UI2*DUIDMS(I ,JS)
     &                 + Z_RI1*DRHDMS(IM,JS) + Z_RI2*DRHDMS(I ,JS)
     &                 + Z_UN1*DUNDMS(IM,JS) + Z_UN2*DUNDMS(I ,JS)
        DO 4030 L=1, NBL
          DR(KH,LMAS1(L),I) = DR(KH,LMAS1(L),I)
     &                + Z_UI1*DUIDM1(IM,JS,L) + Z_UI2*DUIDM1(I ,JS,L)
     &                + Z_RI1*DRHDM1(IM,JS,L) + Z_RI2*DRHDM1(I ,JS,L)
     &                + Z_UN1*DUNDM1(IM,JS,L) + Z_UN2*DUNDM1(I ,JS,L)
          DR(KH,LSBLE(L),I) = DR(KH,LSBLE(L),I)
     &                + Z_UI1*DUIDNG(IM,JS,L) + Z_UI2*DUIDNG(I ,JS,L)
     &                + Z_RI1*DRHDNG(IM,JS,L) + Z_RI2*DRHDNG(I ,JS,L)
     &                + Z_UN1*DUNDNG(IM,JS,L) + Z_UN2*DUNDNG(I ,JS,L)
 4030   CONTINUE
        DO 4032 L=1, NPOSN
          KK = KPOSN(L)
          DR(KH,LPOSN(KK),I) = DR(KH,LPOSN(KK),I)
     &                + Z_UI1*DUIDNP(IM,JS,KK) + Z_UI2*DUIDNP(I ,JS,KK)
     &                + Z_RI1*DRHDNP(IM,JS,KK) + Z_RI2*DRHDNP(I ,JS,KK)
     &                + Z_UN1*DUNDNP(IM,JS,KK) + Z_UN2*DUNDNP(I ,JS,KK)
     &                + Z_X1 *DXIDNP(IM,JS,KK) + Z_X2 *DXIDNP(I ,JS,KK)
 4032   CONTINUE
        DR(KH,LALFA,I) = DR(KH,LALFA,I)
     &                + Z_UI1*DUIDAL(IM,JS) + Z_UI2*DUIDAL(I ,JS)
     &                + Z_RI1*DRHDAL(IM,JS) + Z_RI2*DRHDAL(I ,JS)
     &                + Z_UN1*DUNDAL(IM,JS) + Z_UN2*DUNDAL(I ,JS)
C
        DR(KH,LSBLE(N),I) = DR(KH,LSBLE(N),I)
     &                + Z_X1*X1_SBLE + Z_X2*X2_SBLE + Z_XF*XF_SBLE
C
  400 CONTINUE ! with next setup side
C
C
   40 CONTINUE   ! with next airfoil side
C
C
C---- set all "2" variables to "1" variables for next station
      DO 60 IS=1, 2*NBL
C
C------ keep going if we're still upstream of LE on this layer
        IF(UPLE(IS)) GO TO 60
C
        N = (IS+1)/2
C
        ILE = ILEB(N)
        ITE = ITEB(N)
C
C------ turbulent intervals will follow if currently at transition interval
        IF(TRAN(IS)) TURB(IS) = .TRUE.
        TRAN(IS) = .FALSE.
C
        IF(I.EQ.ITE) THEN
C------- set "2" variables at TE to wake correlations for next station
         DO 602 NC=1, NCOM
           COM2(NC) = V2SAV(NC,IS)
  602    CONTINUE
C
         DW2 = 0.5*WGAP(I,N)
         TURB(IS) = .TRUE.
         WAKE(IS) = .TRUE.
         ISIDE = IS
C
         CALL DSTSET
         CALL BLVAR(3)
C
         DO 604 NC=1, NCOM
           V2SAV(NC,IS) = COM2(NC)
  604    CONTINUE
        ENDIF
C
C------ set "1" variables to "2" variables for next i interval
        DO 606 NC=1, NCOM
          V1SAV(NC,IS) = V2SAV(NC,IS)
  606   CONTINUE
C
   60 CONTINUE
C
 1000 CONTINUE   ! with next streamwise station
C
C
C---- set transition info
      DO 70 IS=1, 2*NBL
        N = (IS+1)/2
C
C------ set transition point arc length, and get x,y from splined airfoil
        IF(MOD(IS,2).EQ.1) THEN
         SBT = SBLE(N) - XITRAN(IS)
        ELSE
         SBT = SBLE(N) + XITRAN(IS)
        ENDIF
        XTR(IS) = SEVAL(SBT,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
        YTR     = SEVAL(SBT,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
C------ set chord line vector components
        XBC = XBTAIL(N) - XBNOSE(N)
        YBC = YBTAIL(N) - YBNOSE(N)
        SBC = SQRT(XBC**2 + YBC**2)
C
C------ set Xtr/c on local chord line
        XTRLOC(IS) = (  (XTR(IS)-XBNOSE(N))*XBC 
     &                + (YTR    -YBNOSE(N))*YBC )/SBC**2
C
   70 CONTINUE
C
C---- display transition info
      WRITE(*,*) ' '
      DO 80 IS=1, 2*NBL
        IF(TFORCE(IS)) THEN
         WRITE(*,9100) IS,XTR(IS),XTRLOC(IS),ITRAN(IS)
 9100    FORMAT(1X,'Side',I2,' forced transition at  X (x/c) i = ',
     &            F9.4,' (',F6.4,')',I5)
        ELSE
         WRITE(*,9200) IS,XTR(IS),XTRLOC(IS),ITRAN(IS)
 9200    FORMAT(1X,'Side',I2,'  free  transition at  X (x/c) i = ',
     &            F9.4,' (',F6.4,')',I5)
        ENDIF
   80 CONTINUE
C
      RETURN
      END ! SETBL


      SUBROUTINE UEF(UI,    UN,    TH,    DS,  WT, WD,
     &        UE, UE_UI, UE_UN, UE_TH, UE_DS)
C--------------------------------------------
C     Defines BL edge velocity UE.
C
C      UI  inviscid velocity at y = delta*
C      UN  inviscid du/dy (flow curvature)
C      TH  momentum thickness
C      DS  displacement thickness
C--------------------------------------------
C
      UE = UI + UN*(WT*TH + WD*DS)
C
      UE_UI = 1.0
      UE_UN = WT*TH + WD*DS
      UE_TH = UN*WT
      UE_DS = UN*WD
C
      RETURN
      END


      SUBROUTINE RHF(RI,    UI,    UN,    TH,    DS,  WT, WD, HST, GAM,
     &        RH, RH_RI, RH_UI, RH_UN, RH_TH, RH_DS )
C--------------------------------------------
C     Defines BL edge density RH.
C
C      RI  inviscid density  at y = delta*
C      RI  inviscid velocity at y = delta*
C      UN  inviscid du/dy (flow curvature)
C      TH  momentum thickness
C      DS  displacement thickness
C--------------------------------------------
      IMPLICIT REAL (M)
      GM1 = GAM - 1.0
C
      MSQU    = UI/(GM1*(HST - 0.5*UI*UI))
      MSQU_UI = (1.0/GM1 + MSQU*UI)/(HST - 0.5*UI*UI)
C
      DUI    = UN*(WT*TH + WD*DS)
      DUI_UN =     WT*TH + WD*DS
      DUI_TH = UN* WT
      DUI_DS = UN*         WD
C
      RH    = RI*(1.0 - MSQU*DUI   )
      RH_RI =     1.0 - MSQU*DUI   
      RH_UI = RI*(    - MSQU_UI*DUI)
      RH_UN = RI*(    - MSQU*DUI_UN)
      RH_TH = RI*(    - MSQU*DUI_TH)
      RH_DS = RI*(    - MSQU*DUI_DS)
C
      RETURN
      END



      SUBROUTINE BUSET
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'MBL.INC'
C
      DO 10 IS=1, 2*NBL
        N = (IS+1)/2
        I = ILEB(N)+1
C
        XSI = XI(I,IS)
        UEI = UEDG(I,IS)
        BULE(IS) = LOG(UEDG(I+1,IS)/UEI) / LOG(XI(I+1,IS)/XSI)
ccc        BULE(IS) = 0.6
        BULE(IS) = MAX( -.05 , BULE(IS) )
   10 CONTINUE
C
      RETURN
      END ! BUSET



      SUBROUTINE XICALC
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'MBL.INC'
C-----------------------------------------------
C     Sets BL arc length arrays and derivatives
C     wrt to element position DOFs.
C-----------------------------------------------
C
      DO 100 N=1, NBL
C
        ILE = ILEB(N)
        ITE = ITEB(N)
C
        SMAX = SB(IIB(N),N)
        SBLD1 = SBLE(N)
        SBLD2 = SMAX - SBLE(N)
C
        DO 10 I=ILE, ITE
          IG = I-ILE+1
          XI(I,IS1(N)) = SG(IG,IS1(N))*SBLD1
          XI(I,IS2(N)) = SG(IG,IS2(N))*SBLD2
          DO 105 NN=1, NPOSN
            K = KPOSN(NN)
            DXIDNP(I,IS1(N),K) = SGSRFP(IG,IS1(N),K)*SBLD1
            DXIDNP(I,IS2(N),K) = SGSRFP(IG,IS2(N),K)*SBLD2
 105      CONTINUE
 10     CONTINUE
C
        XITE(IS1(N)) = XI(ITE,IS1(N))
        XITE(IS2(N)) = XI(ITE,IS2(N))
C
        DO 20 I=ITE+1, II
          IG = I-ITE+1
          XI(I,IS1(N)) = SBLD1 + SGOUT(IG,N)*SWAK(N)
          XI(I,IS2(N)) = SBLD2 + SGOUT(IG,N)*SWAK(N)
          DO 205 NN=1, NPOSN
            K = KPOSN(NN)
            DXIDNP(I,IS1(N),K) = SGOUTP(IG,N,K)*SBLD1
            DXIDNP(I,IS2(N),K) = SGOUTP(IG,N,K)*SBLD2
 205      CONTINUE
 20     CONTINUE
C
 100  CONTINUE
C
      RETURN
      END ! XICALC



      SUBROUTINE UEMOD(IS,SMOOL)
C-------------------------------------------------
C     Smooths UEDG array for side IS by smearing
C     it over a smoothing-length distance SMOOL.
C-------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
C---- overlay work storage arrays to save space
ccc      COMMON/WORK/ W1(IX),W2(IX),W3(IX),W4(IX),W5(IX)
      DIMENSION W1(IX),W2(IX),W3(IX),W4(IX),W5(IX)
C
      N = (IS+1)/2
      ILE = ILEB(N)
      ITE = ITEB(N)
C
C---- set up tri-diagonal system
      K = 0
      DO 10 I=ILE+1, II-1
        K = K+1
        W4(K) = UEDG(I,IS)
        W5(K) =   XI(I,IS)
   10 CONTINUE
      KK = K
      KTE = ITE-ILE
C
      W2(1) = 1.0
      W3(1) = 0.0
      DO 15 K=2, KK-1
        DSM = W5(K) - W5(K-1)
        DSO = 0.5*(W5(K+1) - W5(K-1))
        DSP = W5(K+1) - W5(K)
C
        SMOOSQ = SMOOL**2
C
        W1(K) =  SMOOSQ*(         - 1.0/DSM)/DSO
        W2(K) =  SMOOSQ*( 1.0/DSP + 1.0/DSM)/DSO  +  1.0
        W3(K) =  SMOOSQ*(-1.0/DSP          )/DSO
   15 CONTINUE
C
      W1(KK) = 0.0
      W2(KK) = 1.0
C
      CALL TRISOL(W2,W1,W3,W4,KK)
C
      K = 0
      DO 30 I=ILE+1, II-1
        K = K+1
        UEDG(I,IS) = W4(K)
   30 CONTINUE
C
      RETURN
      END


