C
      SUBROUTINE SETUP
C.........................................................
C     SUBCRITICAL ISENTROPIC SETUP ROUTINE
C
C     Sets up the Jacobian matrix blocks for all internal
C     discrete isentropic Euler equations.  By assuming
C     constant stagnation conditions all along each
C     streamtube, and assuming the flow is subsonic,
C     all the flow variables are related to only the
C     grid geometry node displacements.  The density is
C     no longer a primary variable, and the S-momentum
C     equation slots contain dummy equations.
C.........................................................
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      LOGICAL LLEREG, LLEM, LLEP
C
      DATA DREPS / 1.0E-5 /
cccc      DATA DREPS / 1.0D-12 /
C
C---- Hook into ABC and CTH common blocks in MSES.INC
      DIMENSION ABC(NABC), CTH(NCTH)
      EQUIVALENCE (V1(1,1),ABC(1)), (ZNC(1,1,1),CTH(1))
C
C---- Zero out ABC common block ( S & N-momentum eqn. Jacobian entries )
      DO 10 K=1, NABC
        ABC(K) = 0.
   10 CONTINUE
C
C---- Zero out CTH common block ( BL  & coupling eqn. Jacobian entries )
      DO 11 K=1, NCTH
        CTH(K) = 0.
   11 CONTINUE
C
      DO 13 I=1, II
C
C------ Zero out righthand sides
        DO 131 J=1, 2*JJ-1+6*NBL
          DO 1311 L=1, NRHS
            DR(J,L,I) = 0.
 1311     CONTINUE
  131   CONTINUE
C
C------ Dummy S-momentum equation coefficients
        DO 132 J=1, JJ-1
          A8(J,I) = 1.0
  132  CONTINUE
C
   13 CONTINUE
C
      DO 27 NBIT=1, NBITX
        DO 26 I=1, II
          ISBITS(NBIT,I) = 0
 26     CONTINUE
 27   CONTINUE
C
C---- Set up dummy BL equations
      DO 32 N=1, NBL
        I1 = IS1(N)
        I2 = IS2(N)
        DO 30 I=1, II
          AVC(I1,1,I) = 1.0
          AVT(I1,2,I) = 1.0
          AVH(I1,3,I) = 1.0
          AVC(I2,4,I) = 1.0
          AVT(I2,5,I) = 1.0
          AVH(I2,6,I) = 1.0
   30   CONTINUE
   32 CONTINUE
C
C---- set sonic static/total density ratio
      RBSTAR = (1.0 + 0.5*GM1)**(-1.0/GM1)
C
C---- Loop over all streamtubes
      DO 200 JO = 1, JJ-1
C
C------ skip dummy far-field streamtube
        IF(JSTAG(JO).GT.0) GOTO 200
C
        JP = JO + 1
        JZ = JO + JJ
C
        IO = 1
        IP = 2
C
        SX1M = X(IP,JO) - X(IO,JO)
        SX1P = X(IP,JP) - X(IO,JP)
        SY1M = Y(IP,JO) - Y(IO,JO)
        SY1P = Y(IP,JP) - Y(IO,JP)
        SX1 = 0.5*(SX1M + SX1P)
        SY1 = 0.5*(SY1M + SY1P)
        S1 = SQRT(SX1*SX1 + SY1*SY1)
        S1INV = 1.0 / S1
        AX1 = 0.5*(X(IP,JP)+X(IO,JP) - X(IP,JO)-X(IO,JO))
        AY1 = 0.5*(Y(IP,JP)+Y(IO,JP) - Y(IP,JO)-Y(IO,JO))
        AN1 = (SX1*AY1 - SY1*AX1)*S1INV
C
        STMP = 0.5*S1INV
C
        S1_X1M = -SX1 * STMP
        S1_Y1M = -SY1 * STMP
        S1_X1P = -SX1 * STMP
        S1_Y1P = -SY1 * STMP
        S1_X2M =  SX1 * STMP
        S1_Y2M =  SY1 * STMP
        S1_X2P =  SX1 * STMP
        S1_Y2P =  SY1 * STMP
C
        AN1_S1 = -AN1*S1INV
C
        AN1_X1M = ( SY1-AY1 ) * STMP  +  AN1_S1*S1_X1M
        AN1_Y1M = (-SX1+AX1 ) * STMP  +  AN1_S1*S1_Y1M
        AN1_X1P = (-SY1-AY1 ) * STMP  +  AN1_S1*S1_X1P
        AN1_Y1P = ( SX1+AX1 ) * STMP  +  AN1_S1*S1_Y1P
        AN1_X2M = ( SY1+AY1 ) * STMP  +  AN1_S1*S1_X2M
        AN1_Y2M = (-SX1-AX1 ) * STMP  +  AN1_S1*S1_Y2M
        AN1_X2P = (-SY1+AY1 ) * STMP  +  AN1_S1*S1_X2P
        AN1_Y2P = ( SX1-AX1 ) * STMP  +  AN1_S1*S1_Y2P
C
        HCON = 2.0*HINF*RSTOUT**2
C
        RB1 = R(IO,JO)/RSTOUT
        IF(RB1 .LT. 1.01*RBSTAR) THEN
         WRITE(*,*) 'SETIS: Density below sonic value at', IO, JO
         RB1 = 1.01*RBSTAR
        ENDIF
C
C------ Newton loop for subsonic rho/rho(stag) assuming isentropic flow
        MOA = (M(JO)/AN1)**2
        DO 45 IDUM=1, 20
          RG = RB1**GAM
          RES = HCON*RB1*(RB1 - RG) - MOA
          DELR = -RES / (HCON*(2.0*RB1 - GP1*RG))
          RB1 = RB1 + DELR
          IF(ABS(DELR) .LT. DREPS) GO TO 46
 45     CONTINUE
        WRITE(*,*) 'SETIS: Rho iteration failed.  dR  i j : ',DELR,IO,JO
C
 46     CONTINUE
        IF(RB1 .LT. 1.01*RBSTAR) RB1 = 1.01*RBSTAR
C
        R1 = RB1*RSTOUT
C
C------ calculate remaining flow variables
        Q1 = M(JO)/(AN1*R1)
        P1 = GCON * R1 * (HINF - 0.5*Q1*Q1)
        MSQ1 = Q1*Q1 / (GM1*(HINF - 0.5*Q1*Q1))
        RST1 = RSTOUT
C
        R(IO,JO) = R1
        Q(IO,JO) = Q1
C
        MSQ1_Q1 = MSQ1*(2.0 + GM1*MSQ1)/Q1
C
C------ calculate R, Q, and P sensitivities
        R1_AN1 = R1/AN1 *     MSQ1/(1.0-MSQ1)
        Q1_AN1 =-Q1/AN1 *     1.0 /(1.0-MSQ1)
CCC        P1_AN1 = P1/AN1 * GAM*MSQ1/(1.0-MSQ1)
        P1_AN1 = R1/AN1 *    Q1*Q1/(1.0-MSQ1)
C
        R1_MJ  =-R1/M(JO)  *     MSQ1/(1.0-MSQ1)
        Q1_MJ  = Q1/M(JO)  *     1.0 /(1.0-MSQ1)
CCC        P1_MJ  =-P1/M(JO)  * GAM*MSQ1/(1.0-MSQ1)
        P1_MJ  =-R1/M(JO)  *    Q1*Q1/(1.0-MSQ1)
C
C
C------ pressure variable is actually the pressure defect from stagnation
        P1 = P1 - PSTOUT
C
C------ for low Mach numbers...
        IF(MSQ1 .LT. 0.05) THEN
C-------- use fifth-order Taylor series to get more accurate pressure defect
C
          QSOH = Q1**2 / (GM1*HINF)
C
          P1 = 0.5*RSTOUT*Q1*Q1
     &       * (-1.0 + 0.25*QSOH - (2.0-GAM)/24.0 * QSOH**2)
        ENDIF
C
C
C------ Sweep along streamtube setting inviscid Jacobian entries
C
        DO 100 IO = 2, II-1
C
          IL = IO-2
          IM = IO-1
          IP = IO+1
          IL = MAX0(IL,1)
C
C-------- is location 2 in LE cell?
          LLEM = .FALSE.
          LLEP = .FALSE.
          DO N=1, NBL
            IF( JO.EQ.JBLD(N)   .AND. IO.GE.NINL(N)-1
     &                          .AND. IO.LE.NINL(N)  ) LLEM = .TRUE.
            IF( JP.EQ.JBLD(N)-1 .AND. IO.GE.NINL(N)-1
     &                          .AND. IO.LE.NINL(N)  ) LLEP = .TRUE.
cc           IF( JO.EQ.JBLD(N)  ) LLEM = .TRUE.
cc           IF( JP.EQ.JBLD(N)-1) LLEP = .TRUE.
          ENDDO
C
C-------- set random shorthand junk
C
          IF    (LLEM) THEN
            SWTP = 0.7
            SWTM = 0.3
          ELSEIF(LLEP) THEN
            SWTP = 0.3
            SWTM = 0.7
          ELSE
            SWTP = 0.5
            SWTM = 0.5
          ENDIF
C
          SX2M = X(IP,JO) - X(IO,JO)
          SX2P = X(IP,JP) - X(IO,JP)
          SY2M = Y(IP,JO) - Y(IO,JO)
          SY2P = Y(IP,JP) - Y(IO,JP)
          SX2 = SWTM*SX2M + SWTP*SX2P
          SY2 = SWTM*SY2M + SWTP*SY2P
          S2 = SQRT(SX2*SX2 + SY2*SY2)
          S2INV = 1.0 / S2
          AX2 = 0.5*(X(IP,JP)+X(IO,JP) - X(IP,JO)-X(IO,JO))
          AY2 = 0.5*(Y(IP,JP)+Y(IO,JP) - Y(IP,JO)-Y(IO,JO))
          AN2 = (SX2*AY2 - SY2*AX2)*S2INV
C
          STMPM = SWTM*S2INV
          STMPP = SWTP*S2INV
C
          S2_X2M = -SX2 * STMPM
          S2_Y2M = -SY2 * STMPM
          S2_X2P = -SX2 * STMPP
          S2_Y2P = -SY2 * STMPP
          S2_X3M =  SX2 * STMPM
          S2_Y3M =  SY2 * STMPM
          S2_X3P =  SX2 * STMPP
          S2_Y3P =  SY2 * STMPP
C
          AN2_S2 = -AN2*S2INV
C
          AN2_X2M = ( SY2-AY2 ) * STMPM  +  AN2_S2*S2_X2M
          AN2_Y2M = (-SX2+AX2 ) * STMPM  +  AN2_S2*S2_Y2M
          AN2_X2P = (-SY2-AY2 ) * STMPP  +  AN2_S2*S2_X2P
          AN2_Y2P = ( SX2+AX2 ) * STMPP  +  AN2_S2*S2_Y2P
          AN2_X3M = ( SY2+AY2 ) * STMPM  +  AN2_S2*S2_X3M
          AN2_Y3M = (-SX2-AX2 ) * STMPM  +  AN2_S2*S2_Y3M
          AN2_X3P = (-SY2+AY2 ) * STMPP  +  AN2_S2*S2_X3P
          AN2_Y3P = ( SX2-AX2 ) * STMPP  +  AN2_S2*S2_Y3P
C
          BXM = 0.5*(X(IP,JO)-X(IM,JO))
          BXP = 0.5*(X(IP,JP)-X(IM,JP))
          BYM = 0.5*(Y(IP,JO)-Y(IM,JO))
          BYP = 0.5*(Y(IP,JP)-Y(IM,JP))
          AXA = AX1*AY2 - AX2*AY1
          BXB = BXM*BYP - BXP*BYM
          SXSM = (SX1M*SY2M - SY1M*SX2M)
          SXSP = (SX1P*SY2P - SY1P*SX2P)
C
          XS = 0.5*(BXM+BXP)
          YS = 0.5*(BYM+BYP)
          XN = 0.5*(AX1+AX2)
          YN = 0.5*(AY1+AY2)
          SXN = XS*YN - YS*XN
          SXNINV = 1.0 / SXN
C
          SXN_X1M = ( YS-YN ) * 0.25
          SXN_Y1M = (-XS+XN ) * 0.25
          SXN_X1P = (-YS-YN ) * 0.25
          SXN_Y1P = ( XS+XN ) * 0.25
          SXN_X2M = ( YS    ) * 0.5
          SXN_Y2M = (-XS    ) * 0.5
          SXN_X2P = (-YS    ) * 0.5
          SXN_Y2P = ( XS    ) * 0.5
          SXN_X3M = ( YS+YN ) * 0.25
          SXN_Y3M = (-XS-XN ) * 0.25
          SXN_X3P = (-YS+YN ) * 0.25
          SXN_Y3P = ( XS-XN ) * 0.25
C
C-------- Newton loop for subsonic rho/rho(stag) assuming isentropic flow
          RB2 = R(IO,JO)/RSTOUT
          IF(RB2 .LT. 1.01*RBSTAR) THEN
           WRITE(*,*) 'SETIS: Density below sonic value at', IO, JO
           RB2 = 1.01*RBSTAR
          ENDIF
C
          MOA = (M(JO)/AN2)**2
          DO 48 IDUM=1, 20
            RG = RB2**GAM
            RES = HCON*RB2*(RB2 - RG) - MOA
            DELR = -RES / (HCON*(2.0*RB2 - GP1*RG))
            RB2 = RB2 + DELR
ccc         amach = sqrt(2.0/gm1*(rb2**(-gm1) - 1.0))
            IF(ABS(DELR).LT.DREPS) GO TO 49
 48       CONTINUE
        WRITE(*,*) 'SETIS: Rho iteration failed.  dR  i j : ',DELR,IO,JO
C
 49       CONTINUE
          IF(RB2 .LT. 1.01*RBSTAR) RB2 = 1.01*RBSTAR
C
          R2 = RB2*RSTOUT
C
C-------- calculate remaining flow variables
          Q2 = M(JO)/(AN2*R2)
          P2 = GCON * R2 * (HINF - 0.5*Q2*Q2)
          MSQ2 = Q2*Q2 / (GM1*(HINF - 0.5*Q2*Q2))
          RST2 = RSTOUT
C
          R(IO,JO) = R2
          Q(IO,JO) = Q2
C
          MSQ2_Q2 = MSQ2*(2.0 + GM1*MSQ2)/Q2
C
C-------- Calculate R(A;m), Q(A;m), and P(A;m) sensitivities
          R2_AN2 = R2/AN2 *     MSQ2/(1.0-MSQ2)
          Q2_AN2 =-Q2/AN2 *     1.0 /(1.0-MSQ2)
          P2_AN2 = R2/AN2 *    Q2*Q2/(1.0-MSQ2)
C
          R2_MJ  =-R2/M(JO)  *     MSQ2/(1.0-MSQ2)
          Q2_MJ  = Q2/M(JO)  *     1.0 /(1.0-MSQ2)
          P2_MJ  =-R2/M(JO)  *    Q2*Q2/(1.0-MSQ2)
C
C
C-------- pressure variable is actually the pressure defect from stagnation
          P2 = P2 - PSTOUT
C
C-------- for low Mach numbers...
          IF(MSQ2 .LT. 0.05) THEN
C---------- use fifth-order Taylor series to get more accurate pressure defect
C
            QSOH = Q2**2 / (GM1*HINF)
C
            P2 = 0.5*RSTOUT*Q2*Q2
     &         * (-1.0 + 0.25*QSOH - (2.0-GAM)/24.0 * QSOH**2)
          ENDIF
C
C
C-------- calculate dP/dA correction  PCORR
          PTMP   = 0.0625*PCWT
C
C-------- PC ( R(A m) Q(A m) SXS S )
          PCORR  = PTMP*(R1+R2)*(Q1+Q2)**2*(SXSM-SXSP)*S1INV*S2INV
          PC_R1  = PTMP        *(Q1+Q2)**2*(SXSM-SXSP)*S1INV*S2INV
          PC_R2  = PTMP        *(Q1+Q2)**2*(SXSM-SXSP)*S1INV*S2INV
          PC_Q1  = PTMP*(R1+R2)*(Q1+Q2)*2.*(SXSM-SXSP)*S1INV*S2INV
          PC_Q2  = PTMP*(R1+R2)*(Q1+Q2)*2.*(SXSM-SXSP)*S1INV*S2INV
          PC_SXS = PTMP*(R1+R2)*(Q1+Q2)**2            *S1INV*S2INV
          PC_S1  =-PTMP*(R1+R2)*(Q1+Q2)**2*(SXSM-SXSP)*S1INV*S2INV/S1
          PC_S2  =-PTMP*(R1+R2)*(Q1+Q2)**2*(SXSM-SXSP)*S1INV*S2INV/S2
C
C-------- PC( A(x y)  m  SXS(x y)  S(x y) )
          PC_AN1 = PC_R1*R1_AN1 + PC_Q1*Q1_AN1
          PC_AN2 = PC_R2*R2_AN2 + PC_Q2*Q2_AN2
          PC_MJ  = PC_R1*R1_MJ  + PC_Q1*Q1_MJ
     &           + PC_R2*R2_MJ  + PC_Q2*Q2_MJ
C
C-------- PC( R x y  m )
          PC_X1M = PC_S1*S1_X1M + PC_AN1*AN1_X1M + PC_SXS*(-SY2M)
          PC_Y1M = PC_S1*S1_Y1M + PC_AN1*AN1_Y1M + PC_SXS*( SX2M)
          PC_X1P = PC_S1*S1_X1P + PC_AN1*AN1_X1P + PC_SXS*( SY2P)
          PC_Y1P = PC_S1*S1_Y1P + PC_AN1*AN1_Y1P + PC_SXS*(-SX2P)
C
          PC_X2M = PC_S1*S1_X2M + PC_AN1*AN1_X2M + PC_SXS*( SY2M)
     &           + PC_S2*S2_X2M + PC_AN2*AN2_X2M + PC_SXS*( SY1M)
          PC_Y2M = PC_S1*S1_Y2M + PC_AN1*AN1_Y2M + PC_SXS*(-SX2M)
     &           + PC_S2*S2_Y2M + PC_AN2*AN2_Y2M + PC_SXS*(-SX1M)
          PC_X2P = PC_S1*S1_X2P + PC_AN1*AN1_X2P + PC_SXS*(-SY2P)
     &           + PC_S2*S2_X2P + PC_AN2*AN2_X2P + PC_SXS*(-SY1P)
          PC_Y2P = PC_S1*S1_Y2P + PC_AN1*AN1_Y2P + PC_SXS*( SX2P)
     &           + PC_S2*S2_Y2P + PC_AN2*AN2_Y2P + PC_SXS*( SX1P)
C
          PC_X3M = PC_S2*S2_X3M + PC_AN2*AN2_X3M + PC_SXS*(-SY1M)
          PC_Y3M = PC_S2*S2_Y3M + PC_AN2*AN2_Y3M + PC_SXS*( SX1M)
          PC_X3P = PC_S2*S2_X3P + PC_AN2*AN2_X3P + PC_SXS*( SY1P)
          PC_Y3P = PC_S2*S2_Y3P + PC_AN2*AN2_Y3P + PC_SXS*(-SX1P)
C
C
C*******  N Momentum  *****************************
C
          G1 = (SX1*XN+SY1*YN)*S1INV*SXNINV
          G2 = (SX2*XN+SY2*YN)*S2INV*SXNINV
C
          PIDIF = M(JO)*Q1*G1 - M(JO)*Q2*G2   + PCORR*AXA*SXNINV
          PISUM = P1 + P2 + 2.0*PCORR
          PIP = 0.5*(PISUM + PIDIF)
          PIM = 0.5*(PISUM - PIDIF)
C
C         REZ = M(JO)*Q1*G1 - M(JO)*Q2*G2 + PCORR*AXA*SXNINV  <- part 1
C
C             +/- (P1 + P2 + 2.0*PCORR)                       <- part 2
C
C                      +              -
C             =  2.0*Pi    /   -2.0*Pi
C
C
C=======  N Momentum,  part 1  ====================
C
          Z_PC  =  AXA*SXNINV
          Z_SXN = -M(JO)*Q1*G1*SXNINV    + M(JO)*Q2*G2*SXNINV
     &          -  PCORR*AXA*SXNINV**2
          Z_AXA =  PCORR*SXNINV
C
          Z_Q1 =  M(JO)*G1
          Z_Q2 = -M(JO)*G2
C
          Z_DP1 =  M(JO)*Q1*S1INV*SXNINV
          Z_DP2 =                         - M(JO)*Q2*S2INV*SXNINV
          Z_S1  = -M(JO)*Q1*G1*S1INV
          Z_S2  =                         + M(JO)*Q2*G2*S2INV
          Z_AN1 = Z_Q1*Q1_AN1
          Z_AN2 = Z_Q2*Q2_AN2
C
          Z_MJ = Q1*G1 - Q2*G2 + Z_PC*PC_MJ + Z_Q1*Q1_MJ + Z_Q2*Q2_MJ
C
          Z_X1M = Z_PC*PC_X1M + Z_SXN*SXN_X1M
     &          + Z_S1*S1_X1M + Z_AN1*AN1_X1M
     &          + Z_DP1*(-.25*SX1 - SWTM*XN)
     &          + Z_DP2*(-.25*SX2          )
     &          + Z_AXA*(-0.5*AY2)
          Z_Y1M = Z_PC*PC_Y1M + Z_SXN*SXN_Y1M
     &          + Z_S1*S1_Y1M + Z_AN1*AN1_Y1M
     &          + Z_DP1*(-.25*SY1 - SWTM*YN)
     &          + Z_DP2*(-.25*SY2          )
     &          + Z_AXA*( 0.5*AX2)
C
          Z_X1P = Z_PC*PC_X1P + Z_SXN*SXN_X1P
     &          + Z_S1*S1_X1P + Z_AN1*AN1_X1P
     &          + Z_DP1*( .25*SX1 - SWTP*XN)
     &          + Z_DP2*( .25*SX2          )
     &          + Z_AXA*( 0.5*AY2)
          Z_Y1P = Z_PC*PC_Y1P + Z_SXN*SXN_Y1P
     &          + Z_S1*S1_Y1P + Z_AN1*AN1_Y1P
     &          + Z_DP1*( .25*SY1 - SWTP*YN)
     &          + Z_DP2*( .25*SY2          )
     &          + Z_AXA*(-0.5*AX2)
C
          Z_X2M = Z_PC*PC_X2M + Z_SXN*SXN_X2M
     &          + Z_S1*S1_X2M + Z_AN1*AN1_X2M
     &          + Z_S2*S2_X2M + Z_AN2*AN2_X2M
     &          + Z_DP1*(-.50*SX1 + SWTM*XN)
     &          + Z_DP2*(-.50*SX2 - SWTM*XN)
     &          + Z_AXA*(-0.5*AY2 + 0.5*AY1)
          Z_Y2M = Z_PC*PC_Y2M + Z_SXN*SXN_Y2M
     &          + Z_S1*S1_Y2M + Z_AN1*AN1_Y2M
     &          + Z_S2*S2_Y2M + Z_AN2*AN2_Y2M
     &          + Z_DP1*(-.50*SY1 + SWTM*YN)
     &          + Z_DP2*(-.50*SY2 - SWTM*YN)
     &          + Z_AXA*( 0.5*AX2 - 0.5*AX1)
C
          Z_X2P = Z_PC*PC_X2P + Z_SXN*SXN_X2P
     &          + Z_S1*S1_X2P + Z_AN1*AN1_X2P
     &          + Z_S2*S2_X2P + Z_AN2*AN2_X2P
     &          + Z_DP1*( .50*SX1 + SWTP*XN)
     &          + Z_DP2*( .50*SX2 - SWTP*XN)
     &          + Z_AXA*( 0.5*AY2 - 0.5*AY1)
          Z_Y2P = Z_PC*PC_Y2P + Z_SXN*SXN_Y2P
     &          + Z_S1*S1_Y2P + Z_AN1*AN1_Y2P
     &          + Z_S2*S2_Y2P + Z_AN2*AN2_Y2P
     &          + Z_DP1*( .50*SY1 + SWTP*YN)
     &          + Z_DP2*( .50*SY2 - SWTP*YN)
     &          + Z_AXA*(-0.5*AX2 + 0.5*AX1)
C
          Z_X3M = Z_PC*PC_X3M + Z_SXN*SXN_X3M
     &          + Z_S2*S2_X3M + Z_AN2*AN2_X3M
     &          + Z_DP1*(-.25*SX1          )
     &          + Z_DP2*(-.25*SX2 + SWTM*XN)
     &          + Z_AXA*( 0.5*AY1)
          Z_Y3M = Z_PC*PC_Y3M + Z_SXN*SXN_Y3M
     &          + Z_S2*S2_Y3M + Z_AN2*AN2_Y3M
     &          + Z_DP1*(-.25*SY1          )
     &          + Z_DP2*(-.25*SY2 + SWTM*YN)
     &          + Z_AXA*(-0.5*AX1)
C
          Z_X3P = Z_PC*PC_X3P + Z_SXN*SXN_X3P
     &          + Z_S2*S2_X3P + Z_AN2*AN2_X3P
     &          + Z_DP1*( .25*SX1          )
     &          + Z_DP2*( .25*SX2 + SWTP*XN)
     &          + Z_AXA*(-0.5*AY1)
          Z_Y3P = Z_PC*PC_Y3P + Z_SXN*SXN_Y3P
     &          + Z_S2*S2_Y3P + Z_AN2*AN2_Y3P
     &          + Z_DP1*( .25*SY1          )
     &          + Z_DP2*( .25*SY2 + SWTP*YN)
     &          + Z_AXA*( 0.5*AX1)
C
          B2(JO,IO) = B2(JO,IO) + Z_X1M*NX(IM,JO) + Z_Y1M*NY(IM,JO)
          B1(JP,IO) = B1(JP,IO) + Z_X1M*NX(IM,JO) + Z_Y1M*NY(IM,JO)
C
          B3(JO,IO) = B3(JO,IO) + Z_X1P*NX(IM,JP) + Z_Y1P*NY(IM,JP)
          B2(JP,IO) = B2(JP,IO) + Z_X1P*NX(IM,JP) + Z_Y1P*NY(IM,JP)
C
          A2(JO,IO) = A2(JO,IO) + Z_X2M*NX(IO,JO) + Z_Y2M*NY(IO,JO)
          A1(JP,IO) = A1(JP,IO) + Z_X2M*NX(IO,JO) + Z_Y2M*NY(IO,JO)
C
          A3(JO,IO) = A3(JO,IO) + Z_X2P*NX(IO,JP) + Z_Y2P*NY(IO,JP)
          A2(JP,IO) = A2(JP,IO) + Z_X2P*NX(IO,JP) + Z_Y2P*NY(IO,JP)
C
          C2(JO,IO) = C2(JO,IO) + Z_X3M*NX(IP,JO) + Z_Y3M*NY(IP,JO)
          C1(JP,IO) = C1(JP,IO) + Z_X3M*NX(IP,JO) + Z_Y3M*NY(IP,JO)
C
          C3(JO,IO) = C3(JO,IO) + Z_X3P*NX(IP,JP) + Z_Y3P*NY(IP,JP)
          C2(JP,IO) = C2(JP,IO) + Z_X3P*NX(IP,JP) + Z_Y3P*NY(IP,JP)
C
          DR(JO,LMASS,IO) = DR(JO,LMASS,IO) + MF0(JO)*Z_MJ
          DR(JP,LMASS,IO) = DR(JP,LMASS,IO) + MF0(JO)*Z_MJ
C
          DO 50 N = 1, NBL
            DR(JO,LMAS1(N),IO) = DR(JO,LMAS1(N),IO) + MF1(JO,N)*Z_MJ
            DR(JP,LMAS1(N),IO) = DR(JP,LMAS1(N),IO) + MF1(JO,N)*Z_MJ
C
            Z_NG = Z_X1M*NXG(IM,JO,N) + Z_Y1M*NYG(IM,JO,N)
     &           + Z_X1P*NXG(IM,JP,N) + Z_Y1P*NYG(IM,JP,N)
     &           + Z_X2M*NXG(IO,JO,N) + Z_Y2M*NYG(IO,JO,N)
     &           + Z_X2P*NXG(IO,JP,N) + Z_Y2P*NYG(IO,JP,N)
     &           + Z_X3M*NXG(IP,JO,N) + Z_Y3M*NYG(IP,JO,N)
     &           + Z_X3P*NXG(IP,JP,N) + Z_Y3P*NYG(IP,JP,N)
            DR(JO,LSBLE(N),IO) = DR(JO,LSBLE(N),IO) + Z_NG
            DR(JP,LSBLE(N),IO) = DR(JP,LSBLE(N),IO) + Z_NG
  50      CONTINUE
C
          DO 51 NN = 1, NPOSN
            K = KPOSN(NN)
            Z_NP = Z_X1M*NXP(IM,JO,K) + Z_Y1M*NYP(IM,JO,K)
     &           + Z_X1P*NXP(IM,JP,K) + Z_Y1P*NYP(IM,JP,K)
     &           + Z_X2M*NXP(IO,JO,K) + Z_Y2M*NYP(IO,JO,K)
     &           + Z_X2P*NXP(IO,JP,K) + Z_Y2P*NYP(IO,JP,K)
     &           + Z_X3M*NXP(IP,JO,K) + Z_Y3M*NYP(IP,JO,K)
     &           + Z_X3P*NXP(IP,JP,K) + Z_Y3P*NYP(IP,JP,K)
            DR(JO,LPOSN(K),IO) = DR(JO,LPOSN(K),IO) + Z_NP
            DR(JP,LPOSN(K),IO) = DR(JP,LPOSN(K),IO) + Z_NP
  51      CONTINUE
          Z_AL   = Z_X1M*NXA(IM,JO) + Z_Y1M*NYA(IM,JO)
     &           + Z_X1P*NXA(IM,JP) + Z_Y1P*NYA(IM,JP)
     &           + Z_X2M*NXA(IO,JO) + Z_Y2M*NYA(IO,JO)
     &           + Z_X2P*NXA(IO,JP) + Z_Y2P*NYA(IO,JP)
     &           + Z_X3M*NXA(IP,JO) + Z_Y3M*NYA(IP,JO)
     &           + Z_X3P*NXA(IP,JP) + Z_Y3P*NYA(IP,JP)
          DR(JO,LALFA,IO) = DR(JO,LALFA,IO) + Z_AL
          DR(JP,LALFA,IO) = DR(JP,LALFA,IO) + Z_AL
C
C
C=======  N Momentum, part 2  ====================
C
          Z_AN1 = P1_AN1
          Z_AN2 = P2_AN2
C
          Z_MJ  = P1_MJ + P2_MJ + 2.0*PC_MJ
C
C
          Z_X1M = Z_AN1*AN1_X1M                  + 2.0*PC_X1M
          Z_Y1M = Z_AN1*AN1_Y1M                  + 2.0*PC_Y1M
C
          Z_X1P = Z_AN1*AN1_X1P                  + 2.0*PC_X1P
          Z_Y1P = Z_AN1*AN1_Y1P                  + 2.0*PC_Y1P
C
          Z_X2M = Z_AN1*AN1_X2M + Z_AN2*AN2_X2M  + 2.0*PC_X2M
          Z_Y2M = Z_AN1*AN1_Y2M + Z_AN2*AN2_Y2M  + 2.0*PC_Y2M
C
          Z_X2P = Z_AN1*AN1_X2P + Z_AN2*AN2_X2P  + 2.0*PC_X2P
          Z_Y2P = Z_AN1*AN1_Y2P + Z_AN2*AN2_Y2P  + 2.0*PC_Y2P
C
          Z_X3M =                 Z_AN2*AN2_X3M  + 2.0*PC_X3M
          Z_Y3M =                 Z_AN2*AN2_Y3M  + 2.0*PC_Y3M
C
          Z_X3P =                 Z_AN2*AN2_X3P  + 2.0*PC_X3P
          Z_Y3P =                 Z_AN2*AN2_Y3P  + 2.0*PC_Y3P
C
C
          B2(JO,IO) = B2(JO,IO) - (Z_X1M*NX(IM,JO) + Z_Y1M*NY(IM,JO))
          B1(JP,IO) = B1(JP,IO) + (Z_X1M*NX(IM,JO) + Z_Y1M*NY(IM,JO))
C
          B3(JO,IO) = B3(JO,IO) - (Z_X1P*NX(IM,JP) + Z_Y1P*NY(IM,JP))
          B2(JP,IO) = B2(JP,IO) + (Z_X1P*NX(IM,JP) + Z_Y1P*NY(IM,JP))
C
          A2(JO,IO) = A2(JO,IO) - (Z_X2M*NX(IO,JO) + Z_Y2M*NY(IO,JO))
          A1(JP,IO) = A1(JP,IO) + (Z_X2M*NX(IO,JO) + Z_Y2M*NY(IO,JO))
C
          A3(JO,IO) = A3(JO,IO) - (Z_X2P*NX(IO,JP) + Z_Y2P*NY(IO,JP))
          A2(JP,IO) = A2(JP,IO) + (Z_X2P*NX(IO,JP) + Z_Y2P*NY(IO,JP))
C
          C2(JO,IO) = C2(JO,IO) - (Z_X3M*NX(IP,JO) + Z_Y3M*NY(IP,JO))
          C1(JP,IO) = C1(JP,IO) + (Z_X3M*NX(IP,JO) + Z_Y3M*NY(IP,JO))
C
          C3(JO,IO) = C3(JO,IO) - (Z_X3P*NX(IP,JP) + Z_Y3P*NY(IP,JP))
          C2(JP,IO) = C2(JP,IO) + (Z_X3P*NX(IP,JP) + Z_Y3P*NY(IP,JP))
C
          DR(JO,LMASS,IO) = DR(JO,LMASS,IO) - MF0(JO)*Z_MJ
          DR(JP,LMASS,IO) = DR(JP,LMASS,IO) + MF0(JO)*Z_MJ
C
          DO 52 N = 1, NBL
            DR(JO,LMAS1(N),IO) = DR(JO,LMAS1(N),IO) - MF1(JO,N)*Z_MJ
            DR(JP,LMAS1(N),IO) = DR(JP,LMAS1(N),IO) + MF1(JO,N)*Z_MJ
C
            Z_NG = Z_X1M*NXG(IM,JO,N) + Z_Y1M*NYG(IM,JO,N)
     &           + Z_X1P*NXG(IM,JP,N) + Z_Y1P*NYG(IM,JP,N)
     &           + Z_X2M*NXG(IO,JO,N) + Z_Y2M*NYG(IO,JO,N)
     &           + Z_X2P*NXG(IO,JP,N) + Z_Y2P*NYG(IO,JP,N)
     &           + Z_X3M*NXG(IP,JO,N) + Z_Y3M*NYG(IP,JO,N)
     &           + Z_X3P*NXG(IP,JP,N) + Z_Y3P*NYG(IP,JP,N)
            DR(JO,LSBLE(N),IO) = DR(JO,LSBLE(N),IO) - Z_NG
            DR(JP,LSBLE(N),IO) = DR(JP,LSBLE(N),IO) + Z_NG
  52      CONTINUE
C
          DO 53 NN = 1, NPOSN
            K = KPOSN(NN)
            Z_NP = Z_X1M*NXP(IM,JO,K) + Z_Y1M*NYP(IM,JO,K)
     &           + Z_X1P*NXP(IM,JP,K) + Z_Y1P*NYP(IM,JP,K)
     &           + Z_X2M*NXP(IO,JO,K) + Z_Y2M*NYP(IO,JO,K)
     &           + Z_X2P*NXP(IO,JP,K) + Z_Y2P*NYP(IO,JP,K)
     &           + Z_X3M*NXP(IP,JO,K) + Z_Y3M*NYP(IP,JO,K)
     &           + Z_X3P*NXP(IP,JP,K) + Z_Y3P*NYP(IP,JP,K)
            DR(JO,LPOSN(K),IO) = DR(JO,LPOSN(K),IO) - Z_NP
            DR(JP,LPOSN(K),IO) = DR(JP,LPOSN(K),IO) + Z_NP
  53      CONTINUE
          Z_AL   = Z_X1M*NXA(IM,JO) + Z_Y1M*NYA(IM,JO)
     &           + Z_X1P*NXA(IM,JP) + Z_Y1P*NYA(IM,JP)
     &           + Z_X2M*NXA(IO,JO) + Z_Y2M*NYA(IO,JO)
     &           + Z_X2P*NXA(IO,JP) + Z_Y2P*NYA(IO,JP)
     &           + Z_X3M*NXA(IP,JO) + Z_Y3M*NYA(IP,JO)
     &           + Z_X3P*NXA(IP,JP) + Z_Y3P*NYA(IP,JP)
          DR(JO,LALFA,IO) = DR(JO,LALFA,IO) - Z_AL
          DR(JP,LALFA,IO) = DR(JP,LALFA,IO) + Z_AL
C
          DR(JO,1,IO) = DR(JO,1,IO) + 2.0*PIM
          DR(JP,1,IO) = DR(JP,1,IO) - 2.0*PIP
C
C
C-------- set isentropic-cell bit 
          NBIT = 1 + (JO-1)/30
          JBIT = JO - (NBIT-1)*30 - 1
          ISBITS(NBIT,IO) = ISBITS(NBIT,IO) + 2**JBIT
C
C
C----Are we on either side of a stagnation streamtube (element streamlines)
C
          IF(JSTAG(JO).LT.0 .OR. JSTAG(JO+1).GT.0) THEN
C
           IF (JSTAG(JO).LT.0) THEN
             IS = ABS(JSTAG(JO))
             SGN = 1.0
            ELSE
             IS = ABS(JSTAG(JO+1))
             SGN = -1.0
           ENDIF
           N = (IS+1)/2
C
C
C--------- calculate dU/dA correction UCORR
           UTMP = -.25*PCWT
C
cC--------- old UCORR
c           UCORR  =  UTMP*(Q1+Q2)*(SXSM-SXSP)*SXNINV
c           UC_QQ  =  UTMP        *(SXSM-SXSP)*SXNINV
c           UC_SXS =  UTMP*(Q1+Q2)            *SXNINV
c           UC_SXN = -UCORR*SXNINV
cC
c           UC_Q1 = UC_QQ
c           UC_Q2 = UC_QQ
cC
c           UC_AN1 = UC_Q1*Q1_AN1
c           UC_AN2 = UC_Q2*Q2_AN2
c           UC_MJ  = UC_Q1*Q1_MJ + UC_Q2*Q2_MJ
cC
cC--------- assemble  UC(x,y;m)  sensitivities
c           UC_X1M = UC_SXN*SXN_X1M + UC_AN1*AN1_X1M + UC_SXS*(-SY2M)
c           UC_Y1M = UC_SXN*SXN_Y1M + UC_AN1*AN1_Y1M + UC_SXS*( SX2M)
c           UC_X1P = UC_SXN*SXN_X1P + UC_AN1*AN1_X1P + UC_SXS*( SY2P)
c           UC_Y1P = UC_SXN*SXN_Y1P + UC_AN1*AN1_Y1P + UC_SXS*(-SX2P)
c           UC_X2M = UC_SXN*SXN_X2M + UC_AN1*AN1_X2M + UC_SXS*( SY2M)
c     &                             + UC_AN2*AN2_X2M + UC_SXS*( SY1M)
c           UC_Y2M = UC_SXN*SXN_Y2M + UC_AN1*AN1_Y2M + UC_SXS*(-SX2M)
c     &                             + UC_AN2*AN2_Y2M + UC_SXS*(-SX1M)
c           UC_X2P = UC_SXN*SXN_X2P + UC_AN1*AN1_X2P + UC_SXS*(-SY2P)
c     &                             + UC_AN2*AN2_X2P + UC_SXS*(-SY1P)
c           UC_Y2P = UC_SXN*SXN_Y2P + UC_AN1*AN1_Y2P + UC_SXS*( SX2P)
c     &                             + UC_AN2*AN2_Y2P + UC_SXS*( SX1P)
c           UC_X3M = UC_SXN*SXN_X3M + UC_AN2*AN2_X3M + UC_SXS*(-SY1M)
c           UC_Y3M = UC_SXN*SXN_Y3M + UC_AN2*AN2_Y3M + UC_SXS*( SX1M)
c           UC_X3P = UC_SXN*SXN_X3P + UC_AN2*AN2_X3P + UC_SXS*( SY1P)
c           UC_Y3P = UC_SXN*SXN_Y3P + UC_AN2*AN2_Y3P + UC_SXS*(-SX1P)
cC
C
C--------- new UCORR  10 May 94
           UCORR  =  UTMP*(Q1+Q2)*(SXSM-SXSP)*S1INV*S2INV
           UC_QQ  =  UTMP        *(SXSM-SXSP)*S1INV*S2INV
           UC_SXS =  UTMP*(Q1+Q2)            *S1INV*S2INV
           UC_S1  = -UCORR*S1INV
           UC_S2  = -UCORR*S2INV
C
C
           UC_Q1 = UC_QQ
           UC_Q2 = UC_QQ
C
           UC_AN1 = UC_Q1*Q1_AN1
           UC_AN2 = UC_Q2*Q2_AN2
           UC_MJ  = UC_Q1*Q1_MJ + UC_Q2*Q2_MJ
C
C--------- assemble  UC(x,y;m)  sensitivities
           UC_X1M = UC_S1*S1_X1M + UC_AN1*AN1_X1M + UC_SXS*(-SY2M)
           UC_Y1M = UC_S1*S1_Y1M + UC_AN1*AN1_Y1M + UC_SXS*( SX2M)
           UC_X1P = UC_S1*S1_X1P + UC_AN1*AN1_X1P + UC_SXS*( SY2P)
           UC_Y1P = UC_S1*S1_Y1P + UC_AN1*AN1_Y1P + UC_SXS*(-SX2P)
           UC_X2M = UC_S1*S1_X2M + UC_AN1*AN1_X2M + UC_SXS*( SY2M)
     &            + UC_S2*S2_X2M + UC_AN2*AN2_X2M + UC_SXS*( SY1M)
           UC_Y2M = UC_S1*S1_Y2M + UC_AN1*AN1_Y2M + UC_SXS*(-SX2M)
     &            + UC_S2*S2_Y2M + UC_AN2*AN2_Y2M + UC_SXS*(-SX1M)
           UC_X2P = UC_S1*S1_X2P + UC_AN1*AN1_X2P + UC_SXS*(-SY2P)
     &            + UC_S2*S2_X2P + UC_AN2*AN2_X2P + UC_SXS*(-SY1P)
           UC_Y2P = UC_S1*S1_Y2P + UC_AN1*AN1_Y2P + UC_SXS*( SX2P)
     &            + UC_S2*S2_Y2P + UC_AN2*AN2_Y2P + UC_SXS*( SX1P)
           UC_X3M = UC_S2*S2_X3M + UC_AN2*AN2_X3M + UC_SXS*(-SY1M)
           UC_Y3M = UC_S2*S2_Y3M + UC_AN2*AN2_Y3M + UC_SXS*( SX1M)
           UC_X3P = UC_S2*S2_X3P + UC_AN2*AN2_X3P + UC_SXS*( SY1P)
           UC_Y3P = UC_S2*S2_Y3P + UC_AN2*AN2_Y3P + UC_SXS*(-SX1P)
C
C--------- calculate dU/dn
C
CCC          SX1 = 0.5*(X2M - X1M + X2P - X1P)
CCC          SY1 = 0.5*(Y2M - Y1M + Y2P - Y1P)
CCC
CCC          SX2 = 0.5*(X3M - X2M + X3P - X2P)
CCC          SY2 = 0.5*(Y3M - Y2M + Y3P - Y2P)
C
           UDN    = SGN*(Q1+Q2)*(SX1*SY2-SY1*SX2)*S1INV*S2INV/(S1+S2)
           UD_QQ  = SGN        *(SX1*SY2-SY1*SX2)*S1INV*S2INV/(S1+S2)
           UD_SXS = SGN*(Q1+Q2)                  *S1INV*S2INV/(S1+S2)
           UD_S1  = -UDN*S1INV - UDN/(S1+S2)
           UD_S2  = -UDN*S2INV - UDN/(S1+S2)
C
           UD_AN1 = UD_QQ*Q1_AN1
           UD_AN2 = UD_QQ*Q2_AN2
C
           UD_SX1 =  UD_SXS*SY2
           UD_SY1 = -UD_SXS*SX2
           UD_SX2 = -UD_SXS*SY1
           UD_SY2 =  UD_SXS*SX1
C
           UD_X1M = UD_S1*S1_X1M + UD_AN1*AN1_X1M + UD_SX1*(-SWTM)
           UD_Y1M = UD_S1*S1_Y1M + UD_AN1*AN1_Y1M + UD_SY1*(-SWTM)
           UD_X1P = UD_S1*S1_X1P + UD_AN1*AN1_X1P + UD_SX1*(-SWTP)
           UD_Y1P = UD_S1*S1_Y1P + UD_AN1*AN1_Y1P + UD_SY1*(-SWTP)
           UD_X2M = UD_S1*S1_X2M + UD_AN1*AN1_X2M + UD_SX1*(+SWTM)
     &            + UD_S2*S2_X2M + UD_AN2*AN2_X2M + UD_SX2*(-SWTM)
           UD_Y2M = UD_S1*S1_Y2M + UD_AN1*AN1_Y2M + UD_SY1*(+SWTM)
     &            + UD_S2*S2_Y2M + UD_AN2*AN2_Y2M + UD_SY2*(-SWTM)
           UD_X2P = UD_S1*S1_X2P + UD_AN1*AN1_X2P + UD_SX1*(+SWTP)
     &            + UD_S2*S2_X2P + UD_AN2*AN2_X2P + UD_SX2*(-SWTP)
           UD_Y2P = UD_S1*S1_Y2P + UD_AN1*AN1_Y2P + UD_SY1*(+SWTP)
     &            + UD_S2*S2_Y2P + UD_AN2*AN2_Y2P + UD_SY2*(-SWTP)
           UD_X3M = UD_S2*S2_X3M + UD_AN2*AN2_X3M + UD_SX2*(+SWTM)
           UD_Y3M = UD_S2*S2_Y3M + UD_AN2*AN2_Y3M + UD_SY2*(+SWTM)
           UD_X3P = UD_S2*S2_X3P + UD_AN2*AN2_X3P + UD_SX2*(+SWTP)
           UD_Y3P = UD_S2*S2_Y3P + UD_AN2*AN2_Y3P + UD_SY2*(+SWTP)
C
           UD_MJ  = UD_QQ*(Q1_MJ + Q2_MJ)
C
C--------- calculate  Ue(n)  and assemble its sensitivities
           WT1 = 0.5
           WT2 = 0.5
           UINV(IO,IS) = WT1*Q1 + WT2*Q2 + UCORR
     &       - 0.5*(WT1*AN1 + WT2*AN2)*UDN
C
           UI_AN1 = WT1*Q1_AN1 - 0.5*WT1*UDN
           UI_AN2 = WT2*Q2_AN2 - 0.5*WT2*UDN
           UI_UD  = -0.5*(WT1*AN1 + WT2*AN2)
           UI_MJ  = WT1*Q1_MJ
     &            + WT2*Q2_MJ
ccc        UI_UC  = 1.0
C
CCC HHY Bug fix for grid doubling problem (where UEDG(ILENEW+1,IS) went 
CCC     negative and blew up the LE BL initialization).  
CCC     Fix is clamp UINV and derivs to zero, put out warning to user
CCC     A clamped UINV at the LE or on the blade will blow in the BL routines!
C
           IF(UINV(IO,IS).LT.0.0) THEN
             IF(IO.GT.ILEB(N))
     &         WRITE(*,*) 'UINV<0 at I,IS,UINV ',IO,IS,UINV(IO,IS)
ccc             write(*,*) 'Q1,Q2,UCORR,UDN ',Q1,Q2,UCORR,UDN
             UINV(IO,IS) = 0.0
             UI_AN1 = 0.0
             UI_AN2 = 0.0
             UI_UD  = 0.0
             UI_MJ  = 0.0
ccc          UI_UC  = 0.0
           ENDIF
C
           UI_X1M = UC_X1M + UI_AN1*AN1_X1M + UI_UD*UD_X1M
           UI_Y1M = UC_Y1M + UI_AN1*AN1_Y1M + UI_UD*UD_Y1M
           UI_X1P = UC_X1P + UI_AN1*AN1_X1P + UI_UD*UD_X1P
           UI_Y1P = UC_Y1P + UI_AN1*AN1_Y1P + UI_UD*UD_Y1P
           UI_X2M = UC_X2M + UI_AN1*AN1_X2M
     &                     + UI_AN2*AN2_X2M + UI_UD*UD_X2M
           UI_Y2M = UC_Y2M + UI_AN1*AN1_Y2M
     &                     + UI_AN2*AN2_Y2M + UI_UD*UD_Y2M
           UI_X2P = UC_X2P + UI_AN1*AN1_X2P
     &                     + UI_AN2*AN2_X2P + UI_UD*UD_X2P
           UI_Y2P = UC_Y2P + UI_AN1*AN1_Y2P
     &                     + UI_AN2*AN2_Y2P + UI_UD*UD_Y2P
           UI_X3M = UC_X3M + UI_AN2*AN2_X3M + UI_UD*UD_X3M
           UI_Y3M = UC_Y3M + UI_AN2*AN2_Y3M + UI_UD*UD_Y3M
           UI_X3P = UC_X3P + UI_AN2*AN2_X3P + UI_UD*UD_X3P
           UI_Y3P = UC_Y3P + UI_AN2*AN2_Y3P + UI_UD*UD_Y3P
C
C
           DUIDR1(IO,IS) = 0.
           DUIDR2(IO,IS) = 0.
C
           DUIN1M(IO,IS) = UI_X1M*NX(IM,JO) + UI_Y1M*NY(IM,JO)
           DUIN1P(IO,IS) = UI_X1P*NX(IM,JP) + UI_Y1P*NY(IM,JP)
           DUIN2M(IO,IS) = UI_X2M*NX(IO,JO) + UI_Y2M*NY(IO,JO)
           DUIN2P(IO,IS) = UI_X2P*NX(IO,JP) + UI_Y2P*NY(IO,JP)
           DUIN3M(IO,IS) = UI_X3M*NX(IP,JO) + UI_Y3M*NY(IP,JO)
           DUIN3P(IO,IS) = UI_X3P*NX(IP,JP) + UI_Y3P*NY(IP,JP)
C
           DUIDMS(IO,IS) = MF0(JO)*(UI_MJ + UC_MJ + UI_UD*UD_MJ)
           DO 64 N = 1, NBL
            DUIDM1(IO,IS,N) = MF1(JO,N)*(UI_MJ + UC_MJ + UI_UD*UD_MJ)
            DUIDNG(IO,IS,N) = UI_X1M*NXG(IM,JO,N) + UI_Y1M*NYG(IM,JO,N)
     &                      + UI_X1P*NXG(IM,JP,N) + UI_Y1P*NYG(IM,JP,N)
     &                      + UI_X2M*NXG(IO,JO,N) + UI_Y2M*NYG(IO,JO,N)
     &                      + UI_X2P*NXG(IO,JP,N) + UI_Y2P*NYG(IO,JP,N)
     &                      + UI_X3M*NXG(IP,JO,N) + UI_Y3M*NYG(IP,JO,N)
     &                      + UI_X3P*NXG(IP,JP,N) + UI_Y3P*NYG(IP,JP,N)
  64       CONTINUE
C
           DO 65 NN = 1, NPOSN
            K = KPOSN(NN)
            DUIDNP(IO,IS,K) = UI_X1M*NXP(IM,JO,K) + UI_Y1M*NYP(IM,JO,K)
     &                      + UI_X1P*NXP(IM,JP,K) + UI_Y1P*NYP(IM,JP,K)
     &                      + UI_X2M*NXP(IO,JO,K) + UI_Y2M*NYP(IO,JO,K)
     &                      + UI_X2P*NXP(IO,JP,K) + UI_Y2P*NYP(IO,JP,K)
     &                      + UI_X3M*NXP(IP,JO,K) + UI_Y3M*NYP(IP,JO,K)
     &                      + UI_X3P*NXP(IP,JP,K) + UI_Y3P*NYP(IP,JP,K)
  65       CONTINUE
           DUIDAL(IO,IS) = UI_X1M*NXA(IM,JO) + UI_Y1M*NYA(IM,JO)
     &                   + UI_X1P*NXA(IM,JP) + UI_Y1P*NYA(IM,JP)
     &                   + UI_X2M*NXA(IO,JO) + UI_Y2M*NYA(IO,JO)
     &                   + UI_X2P*NXA(IO,JP) + UI_Y2P*NYA(IO,JP)
     &                   + UI_X3M*NXA(IP,JO) + UI_Y3M*NYA(IP,JO)
     &                   + UI_X3P*NXA(IP,JP) + UI_Y3P*NYA(IP,JP)
C
           TEMPR = 1.0 - 0.5*UINV(IO,IS)**2/HINF
           RHOI(IO,IS) = RSTOUT*TEMPR**(1.0/GM1)
           RH_UI = -UINV(IO,IS)*RHOI(IO,IS)/(GM1*HINF*TEMPR)
C
           DRHDR1(IO,IS) = RH_UI*DUIDR1(IO,IS)
           DRHDR2(IO,IS) = RH_UI*DUIDR2(IO,IS)
C
           DRHN1M(IO,IS) = RH_UI*DUIN1M(IO,IS)
           DRHN1P(IO,IS) = RH_UI*DUIN1P(IO,IS)
           DRHN2M(IO,IS) = RH_UI*DUIN2M(IO,IS)
           DRHN2P(IO,IS) = RH_UI*DUIN2P(IO,IS)
           DRHN3M(IO,IS) = RH_UI*DUIN3M(IO,IS)
           DRHN3P(IO,IS) = RH_UI*DUIN3P(IO,IS)
C
           DRHDMS(IO,IS) = RH_UI*DUIDMS(IO,IS)
           DO 74 N = 1, NBL
             DRHDM1(IO,IS,N) = RH_UI*DUIDM1(IO,IS,N)
             DRHDNG(IO,IS,N) = RH_UI*DUIDNG(IO,IS,N)
  74       CONTINUE
C
           DO 75 NN = 1, NPOSN
             K = KPOSN(NN)
             DRHDNP(IO,IS,K) = RH_UI*DUIDNP(IO,IS,K)
  75       CONTINUE
           DRHDAL(IO,IS) = RH_UI*DUIDAL(IO,IS)
C
C
           DUDN(IO,IS) = UDN
           DUNDR1(IO,IS) = 0.
           DUNDR2(IO,IS) = 0.
C
           DUNN1M(IO,IS) = UD_X1M*NX(IM,JO) + UD_Y1M*NY(IM,JO)
           DUNN1P(IO,IS) = UD_X1P*NX(IM,JP) + UD_Y1P*NY(IM,JP)
           DUNN2M(IO,IS) = UD_X2M*NX(IO,JO) + UD_Y2M*NY(IO,JO)
           DUNN2P(IO,IS) = UD_X2P*NX(IO,JP) + UD_Y2P*NY(IO,JP)
           DUNN3M(IO,IS) = UD_X3M*NX(IP,JO) + UD_Y3M*NY(IP,JO)
           DUNN3P(IO,IS) = UD_X3P*NX(IP,JP) + UD_Y3P*NY(IP,JP)
C
           DUNDMS(IO,IS) = MF0(JO)*UD_MJ
           DO 86 N = 1, NBL
            DUNDM1(IO,IS,N) = MF1(JO,N)*UD_MJ
            DUNDNG(IO,IS,N) = UD_X1M*NXG(IM,JO,N) + UD_Y1M*NYG(IM,JO,N)
     &                      + UD_X1P*NXG(IM,JP,N) + UD_Y1P*NYG(IM,JP,N)
     &                      + UD_X2M*NXG(IO,JO,N) + UD_Y2M*NYG(IO,JO,N)
     &                      + UD_X2P*NXG(IO,JP,N) + UD_Y2P*NYG(IO,JP,N)
     &                      + UD_X3M*NXG(IP,JO,N) + UD_Y3M*NYG(IP,JO,N)
     &                      + UD_X3P*NXG(IP,JP,N) + UD_Y3P*NYG(IP,JP,N)
   86      CONTINUE
C
           DO 87 NN = 1, NPOSN
            K = KPOSN(NN)
            DUNDNP(IO,IS,K) = UD_X1M*NXP(IM,JO,K) + UD_Y1M*NYP(IM,JO,K)
     &                      + UD_X1P*NXP(IM,JP,K) + UD_Y1P*NYP(IM,JP,K)
     &                      + UD_X2M*NXP(IO,JO,K) + UD_Y2M*NYP(IO,JO,K)
     &                      + UD_X2P*NXP(IO,JP,K) + UD_Y2P*NYP(IO,JP,K)
     &                      + UD_X3M*NXP(IP,JO,K) + UD_Y3M*NYP(IP,JO,K)
     &                      + UD_X3P*NXP(IP,JP,K) + UD_Y3P*NYP(IP,JP,K)
  87       CONTINUE
           DUNDAL(IO,IS) = UD_X1M*NXA(IM,JO) + UD_Y1M*NYA(IM,JO)
     &                   + UD_X1P*NXA(IM,JP) + UD_Y1P*NYA(IM,JP)
     &                   + UD_X2M*NXA(IO,JO) + UD_Y2M*NYA(IO,JO)
     &                   + UD_X2P*NXA(IO,JP) + UD_Y2P*NYA(IO,JP)
     &                   + UD_X3M*NXA(IP,JO) + UD_Y3M*NYA(IP,JO)
     &                   + UD_X3P*NXA(IP,JP) + UD_Y3P*NYA(IP,JP)
C
          ENDIF
C
          PI(IO,JO) = PIM
          PI(IO,JP) = PIP
C
C-------- set shorthand for next streamtube station
          SX1M = SX2M
          SX1P = SX2P
          SY1M = SY2M
          SY1P = SY2P
          SX1 = SX2
          SY1 = SY2
          AX1 = AX2
          AY1 = AY2
          AN1 = AN2
          S1 = S2
          S1INV = S2INV
C
          S1_X1M = S2_X2M
          S1_Y1M = S2_Y2M
          S1_X1P = S2_X2P
          S1_Y1P = S2_Y2P
          S1_X2M = S2_X3M
          S1_Y2M = S2_Y3M
          S1_X2P = S2_X3P
          S1_Y2P = S2_Y3P
C
          AN1_X1M = AN2_X2M
          AN1_Y1M = AN2_Y2M
          AN1_X1P = AN2_X2P
          AN1_Y1P = AN2_Y2P
          AN1_X2M = AN2_X3M
          AN1_Y2M = AN2_Y3M
          AN1_X2P = AN2_X3P
          AN1_Y2P = AN2_Y3P
C
          Q1 = Q2
          R1 = R2
          P1 = P2
          MSQ1 = MSQ2
          RST1 = RST2
C
          Q1_AN1 = Q2_AN2
          R1_AN1 = R2_AN2
          P1_AN1 = P2_AN2
C
          Q1_MJ = Q2_MJ
          R1_MJ = R2_MJ
          P1_MJ = P2_MJ
C
          MSQ1_Q1 = MSQ2_Q2
C
 100    CONTINUE
C
 200  CONTINUE
C
C
C---- set flag indicating that the isentropic SETUP has been used
      ISSET = 2
C
      RETURN
      END ! SETUP


