C
      SUBROUTINE SETUP
C==========================================================
C     Sets up the Jacobian matrix blocks for all internal
C     discrete Euler equations.  The nonzero entries of
C     each A(i) block are stored in the eight arrays
C     A1 -> A8.  Likewise for the B and Z blocks.  The
C     C blocks are the same except that the C4, C5, C8
C     arrays are always zero and are not stored.
C     The BL equation block entries are stored in the
C     AVC,AVT,AVH, and BVC,BVT,BVH arrays.
C==========================================================
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
C---- Hook into ABC and CTH common blocks in MSES.INC
      DIMENSION ABC(NABC), CTH(NCTH)
      EQUIVALENCE (V1(1,1),ABC(1)), (ZNC(1,1,1),CTH(1))
C
      LOGICAL LLEREG, LLEPNT, LLEM, LLEP
C
      LOGICAL LISEN
      DIMENSION LISEN(IX,JX)
ccc      COMMON/WORK/ LISEN(IX,JX)
C---------------------------------------------------------------------
C     Set isentropic-region indices for ISMOM=3.
C
C      ISEN   number of isentropic cells downstream of LE
C      JSEN   number of isentropic streamtubes above,below each airfoil
C
C                |
C                |____________________
C j = JBLD+JSEN  |                    |
C                |              ___________________
C     JBLD       |             C___________________
C                |                    |
C     JBLD-JSEN  |____________________
C                |             .      .
C                .             .      .
C
C            i = 1            ILE   ILE+ISEN
C      
      DATA ISEN, JSEN / 20 , 5 /
ccc      DATA ISEN, JSEN / 32 , 12 /
C---------------------------------------------------------------------
C
C---- S-momentum trigger thresholds for ISMOM=4.
C-    (fractional total pressure change, Mach number change over cell)
      DPTEPS = 0.00005
      DQTEPS = 0.001
cc      DPTEPS = 0.00001
cc      DQTEPS = 0.0002
C
C---------------------------------------------------------------------
C
C
C---- Zero out ABC common block ( S & N-momentum eqn. Jacobian entries )
      DO 10 K=1, NABC
        ABC(K) = 0.
 10   CONTINUE
C
C---- Zero out CTH common block ( BL  & coupling eqn. Jacobian entries )
      DO 12 K=1, NCTH
        CTH(K) = 0.
 12   CONTINUE
C
C---- Zero out righthand sides
      DO 14 I=1, II
        DO 141 J=1, 2*JJ-1+6*NBL
          DO 1411 L=1, NRHS
            DR(J,L,I) = 0.
 1411     CONTINUE
 141    CONTINUE
 14   CONTINUE
C
C---- Set current-isentropy cell array
      DO 16 I=1, II-1
        DO 161 J=1, JJ-1
          NBIT = 1 + (J-1)/30
          JBIT = J - (NBIT-1)*30 - 1
C
          ISHIFT = ISBITS(NBIT,I) / 2**JBIT
          LISEN(I,J) = ISHIFT .GT. 2*(ISHIFT/2)
 161    CONTINUE
 16   CONTINUE
C
C---- Zero out isentropic-cell bits
      DO 18 I=1, II
        DO 181 NBIT=1, NBITX
          ISBITS(NBIT,I) = 0
 181    CONTINUE
 18   CONTINUE
C
C
C---- Set up dummy BL equations
      DO 20 N=1, NBL
        I1 = IS1(N)
        I2 = IS2(N)
        DO 204 I=1, II
          AVC(I1,1,I) = 1.0
          AVT(I1,2,I) = 1.0
          AVH(I1,3,I) = 1.0
          AVC(I2,4,I) = 1.0
          AVT(I2,5,I) = 1.0
          AVH(I2,6,I) = 1.0
 204    CONTINUE
 20   CONTINUE
C
C
C---- zero out accumulator for grid-exit pressure
      PEXSUM = 0.
C
C---- set scaling factors for 1st,2nd order dissipation from max d(Rho)
C     (use high 1st-order and weaker 2nd-order dissipation 
C         if max dRho was large at previous iteration)
C
      IF(ICOUNT.EQ.1) THEN
        DRF = 0.05
      ELSE
        DRF = DRMAX
      ENDIF
C
c###
C---- setting DRF = 0 here disables dissipation augmentation
      DRF = 0.0
C
C---- set weighting factor FMU for augmenting dissipation
      DRFEPS = 0.15
      DRF1 = DRF**3 / (DRF**2 + (0.25*DRFEPS)**2)
      ARG = (DRF1/DRFEPS)**2
      ARG = MIN(25.0 , ARG)
      FMU = EXP(-ARG)
C
C---- maintain extra dissipation for coarsened grid
c###
ccc      IF(NHALF.LT.0) FMU = 0.5
C
C---- use lowered Mcrit to speed up shocks
ccc      MCMIN = MAX( MINF + 0.05*(1.0-MINF) , 0.75 )
      MCMIN = 0.75
C
      MCMIN = MIN( MCMIN , MCRIT )
      MCMAX = MCRIT
      MCRX = MCMIN + (MCMAX-MCMIN) * FMU
C
      AMU = 1.0 - MCRX
C
C---- set weights for 1st, 2nd-order dissipation coefficients
      MUBFAC = 1.0
      MUCFAC = FMU
C
C
C---- Loop over all streamtubes
      JSCT = -12345
      JPRS = JS2(NBL)
      ILES = II
      ILEP = ILEB(NBL)
C
      DO 200 JO = 1, JJ-1
        IF(JSTAG(JO).GT.0) GOTO 200
C
C------ Find the stagnation streamlines that bound this bunch of streamlines
        IF (JSTAG(JO).LT.0) THEN
          JSCT = JO
          N = (1-JSTAG(JSCT))/2
          ILES = ILEB(N)
          DO 41 JT = JO, JJ-1
            IF (JSTAG(JT).GT.0) THEN
              JPRS = JT
              N = (1+JSTAG(JPRS))/2
              ILEP = ILEB(N)
              GO TO 43
            ENDIF
   41     CONTINUE
          JPRS = 12345
          ILEP = II
        ENDIF
C
C
   43   JP = JO + 1
        JZ = JO + JJ
C
        IO = 1
        IP = 2
C
        QSTAR = SQRT(2.0*HINF/(2.0/GM1 + 1.0))
C
        S9     = 0.
        S9_X9M = 0.
        S9_Y9M = 0.
        S9_X9P = 0.
        S9_Y9P = 0.
        S9_X0M = 0.
        S9_Y0M = 0.
        S9_X0P = 0.
        S9_Y0P = 0.
C
        S0     = 0.
        S0_X0M = 0.
        S0_Y0M = 0.
        S0_X0P = 0.
        S0_Y0P = 0.
        S0_X1M = 0.
        S0_Y1M = 0.
        S0_X1P = 0.
        S0_Y1P = 0.
C
        AN9     = 0.
        AN9_X9M = 0.
        AN9_Y9M = 0.
        AN9_X9P = 0.
        AN9_Y9P = 0.
        AN9_X0M = 0.
        AN9_Y0M = 0.
        AN9_X0P = 0.
        AN9_Y0P = 0.
C
        AN0     = 0.
        AN0_X0M = 0.
        AN0_Y0M = 0.
        AN0_X0P = 0.
        AN0_Y0P = 0.
        AN0_X1M = 0.
        AN0_Y1M = 0.
        AN0_X1P = 0.
        AN0_Y1P = 0.
C

        SX1M = X(IP,JO) - X(IO,JO)
        SX1P = X(IP,JP) - X(IO,JP)
        SY1M = Y(IP,JO) - Y(IO,JO)
        SY1P = Y(IP,JP) - Y(IO,JP)
        SX1 = 0.5*(SX1M + SX1P)
        SY1 = 0.5*(SY1M + SY1P)
        S1 = SQRT(SX1*SX1 + SY1*SY1)
        S1INV = 1.0 / S1
        AX1 = 0.5*(X(IP,JP)+X(IO,JP) - X(IP,JO)-X(IO,JO))
        AY1 = 0.5*(Y(IP,JP)+Y(IO,JP) - Y(IP,JO)-Y(IO,JO))
        AN1 = (SX1*AY1 - SY1*AX1)*S1INV
C
        STMP = 0.5*S1INV
C
        S1_X1M = -SX1 * STMP
        S1_Y1M = -SY1 * STMP
        S1_X1P = -SX1 * STMP
        S1_Y1P = -SY1 * STMP
        S1_X2M =  SX1 * STMP
        S1_Y2M =  SY1 * STMP
        S1_X2P =  SX1 * STMP
        S1_Y2P =  SY1 * STMP
C
        AN1_S1 = -AN1*S1INV
C
        AN1_X1M = ( SY1-AY1 ) * STMP  +  AN1_S1*S1_X1M
        AN1_Y1M = (-SX1+AX1 ) * STMP  +  AN1_S1*S1_Y1M
        AN1_X1P = (-SY1-AY1 ) * STMP  +  AN1_S1*S1_X1P
        AN1_Y1P = ( SX1+AX1 ) * STMP  +  AN1_S1*S1_Y1P
        AN1_X2M = ( SY1+AY1 ) * STMP  +  AN1_S1*S1_X2M
        AN1_Y2M = (-SX1-AX1 ) * STMP  +  AN1_S1*S1_Y2M
        AN1_X2P = (-SY1+AY1 ) * STMP  +  AN1_S1*S1_X2P
        AN1_Y2P = ( SX1-AX1 ) * STMP  +  AN1_S1*S1_Y2P
C
        R1 = R(IO,JO)
C
C------ Calculate Q(R,A;m)  and  P(R,A;m)
        Q1 = M(JO)/(AN1*R1)
        Q1_R1  = -Q1/R1
        Q1_AN1 = -Q1/AN1
        Q1_MJ  =  Q1/M(JO)

        P1    =  GCON * R1 * (HINF - 0.5*Q1*Q1)
        P1_Q1 = -GCON * R1 *  Q1
C
        P1_R1  =  P1/R1 + P1_Q1*Q1_R1
        P1_AN1 =          P1_Q1*Q1_AN1
        P1_MJ  =          P1_Q1*Q1_MJ

        MSQ1 = Q1*Q1 / (GM1*(HINF - 0.5*Q1*Q1))
        MSQ1_Q1 = MSQ1*(2.0 + GM1*MSQ1)/Q1
C
        Q(IO,JO) = Q1
C
C------ set dummy-cell speeds upstream of inflow plane
        Q9     = QINF
        Q9_R9  = 0.
        Q9_AN9 = 0.
        Q9_MJ  = 0.
        Q9_MS  = QI_MSQ/MS_MSQ
C
        Q0     = QINF
        Q0_R0  = 0.
        Q0_AN0 = 0.
        Q0_MJ  = 0.
        Q0_MS  = QI_MSQ/MS_MSQ
C
        IF(MSQ1.GT.1.0) THEN
C------- supersonic inflow -- upwind from freestream speed QINF
         MU      = ABS(MUCON)/GAM * (1.0-1.0/MSQ1)
         MU_MSQ1 = ABS(MUCON)/GAM           /MSQ1**2
C
         MU_Q0  = 0.
         MU_Q1  = MU_MSQ1*MSQ1_Q1
C
         QS1    = Q1     - (Q1-Q0)*MU
         QS1_Q9 = 0.
         QS1_Q0 =     MU - (Q1-Q0)*MU_Q0
         QS1_Q1 = 1.0-MU - (Q1-Q0)*MU_Q1
        ELSE
C------- subsonic inflow -- no upwinding
         MU     = 0.
         MU_Q0  = 0.
         MU_Q1  = 0.
         QS1    = Q1
         QS1_Q9 = 0.
         QS1_Q0 = 0.
         QS1_Q1 = 1.0
        ENDIF
        QS1_S9 = 0.
        QS1_S0 = 0.
        QS1_S1 = 0.
C
        IF(QS1*QS1 .GT. 2.0*HINF) THEN
         WRITE(*,*) 'Neg. temp., q qs i j =', Q1,QS1,IO,JO
         QS1 = 0.95*SQRT(2.0*HINF)
         QS1_Q9 = 0.0
         QS1_Q0 = 0.0
         QS1_Q1 = 0.0
        ENDIF
C
C
C------ total pressure based on upwinded speed
        PST1     = P1 * (1.0 - 0.5*QS1*QS1/HINF)**(-GAM/GM1)
        PST1_P1  = PST1 / P1
        PST1_Q1  = 0.
        PST1_QS1 = PST1 * QS1*GAM/(GM1*(HINF - 0.5*QS1*QS1))
C
C------- usual total pressure
c        PST1     = P1 * (1.0 - 0.5*Q1*Q1/HINF)**(-GAM/GM1)
c        PST1_P1  = PST1 / P1
c        PST1_Q1  = PST1 * Q1*GAM/(GM1*(HINF - 0.5*Q1*Q1))
c        PST1_QS1 = 0.
C
C
C
C*****  Inlet stagnation pressure  **************************
C
        REZ = PST1 - RSTOUT*GCON*HINF
C
        Z_QS1 = PST1_QS1
        Z_Q1 = Z_QS1*QS1_Q1  +  PST1_Q1
        Z_Q0 = Z_QS1*QS1_Q0
        Z_Q9 = Z_QS1*QS1_Q9
C
        Z_R1  = Z_Q1*Q1_R1   +  PST1_P1*P1_R1
        Z_AN1 = Z_Q1*Q1_AN1  +  PST1_P1*P1_AN1
        Z_MJ  = Z_Q1*Q1_MJ   +  PST1_P1*P1_MJ
        Z_MS  = Z_Q0*Q0_MS
     &        + Z_Q9*Q9_MS
C
        V8(JO,IO) = 0.
        Z8(JO,IO) = 0.
        B8(JO,IO) = 0.
        A8(JO,IO) = Z_R1
C
        Z_X1M = Z_AN1*AN1_X1M
        Z_Y1M = Z_AN1*AN1_Y1M
        Z_X1P = Z_AN1*AN1_X1P
        Z_Y1P = Z_AN1*AN1_Y1P
        Z_X2M = Z_AN1*AN1_X2M
        Z_Y2M = Z_AN1*AN1_Y2M
        Z_X2P = Z_AN1*AN1_X2P
        Z_Y2P = Z_AN1*AN1_Y2P
C
        A6(JO,IO) = Z_X1M*NX(IO,JO) + Z_Y1M*NY(IO,JO)
        A7(JO,IO) = Z_X1P*NX(IO,JP) + Z_Y1P*NY(IO,JP)
        C6(JO,IO) = Z_X2M*NX(IP,JO) + Z_Y2M*NY(IP,JO)
        C7(JO,IO) = Z_X2P*NX(IP,JP) + Z_Y2P*NY(IP,JP)
C
        DR(JZ,LMASS,IO) = MF0(JO)*Z_MJ + Z_MS
        DO 44 N = 1, NBL
          DR(JZ,LMAS1(N),IO) = MF1(JO,N)*Z_MJ
          DR(JZ,LSBLE(N),IO) = Z_X1M*NXG(IO,JO,N) + Z_Y1M*NYG(IO,JO,N)
     &                       + Z_X1P*NXG(IO,JP,N) + Z_Y1P*NYG(IO,JP,N)
     &                       + Z_X2M*NXG(IP,JO,N) + Z_Y2M*NYG(IP,JO,N)
     &                       + Z_X2P*NXG(IP,JP,N) + Z_Y2P*NYG(IP,JP,N)
 44     CONTINUE
C
        DO 45 NN = 1, NPOSN
          K = KPOSN(NN)
          DR(JZ,LPOSN(K),IO) = Z_X1M*NXP(IO,JO,K) + Z_Y1M*NYP(IO,JO,K)
     &                       + Z_X1P*NXP(IO,JP,K) + Z_Y1P*NYP(IO,JP,K)
     &                       + Z_X2M*NXP(IP,JO,K) + Z_Y2M*NYP(IP,JO,K)
     &                       + Z_X2P*NXP(IP,JP,K) + Z_Y2P*NYP(IP,JP,K)
 45     CONTINUE
        DR(JZ,LALFA,IO) = Z_X1M*NXA(IO,JO) + Z_Y1M*NYA(IO,JO)
     &                  + Z_X1P*NXA(IO,JP) + Z_Y1P*NYA(IO,JP)
     &                  + Z_X2M*NXA(IP,JO) + Z_Y2M*NYA(IP,JO)
     &                  + Z_X2P*NXA(IP,JP) + Z_Y2P*NYA(IP,JP)
C
        DR(JZ,1,IO) = -REZ
C
C
C------ save PST residual sensitivities for choked-solver inlet condition
        A8P(JO) = A8(JO,IO)
C     
        A6P(JO) = A6(JO,IO)
        A7P(JO) = A7(JO,IO)
        C6P(JO) = C6(JO,IO)
        C7P(JO) = C7(JO,IO)
C     
        DO 46 L=1, NRHS
          DRP(JO,L) = DR(JZ,L,IO)
 46     CONTINUE
C
C
C====== Sweep along streamtube setting inviscid Jacobian entries
        DO 100 IO = 2, II-1
C
          IP = IO+1
          IM = IO-1
          IL = IO-2
          IK = IO-3
C
          IL = MAX(IL,1)
          IK = MAX(IK,1)
C
C-------- is location 2 in LE cell?
          LLEM = .FALSE.
          LLEP = .FALSE.
          DO N=1, NBL
            IF( JO.EQ.JBLD(N)   .AND. IO.GE.NINL(N)-1
     &                          .AND. IO.LE.NINL(N)  ) LLEM = .TRUE.
            IF( JP.EQ.JBLD(N)-1 .AND. IO.GE.NINL(N)-1
     &                          .AND. IO.LE.NINL(N)  ) LLEP = .TRUE.
          ENDDO
C
          IF    (LLEM) THEN
            SWTP = 0.7
            SWTM = 0.3
          ELSEIF(LLEP) THEN
            SWTP = 0.3
            SWTM = 0.7
          ELSE
            SWTP = 0.5
            SWTM = 0.5
          ENDIF
C
C-------- set random shorthand junk
          SX2M = X(IP,JO) - X(IO,JO)
          SX2P = X(IP,JP) - X(IO,JP)
          SY2M = Y(IP,JO) - Y(IO,JO)
          SY2P = Y(IP,JP) - Y(IO,JP)
c         SX2 = 0.5*(SX2M + SX2P)
c         SY2 = 0.5*(SY2M + SY2P)
          SX2 = SWTM*SX2M + SWTP*SX2P
          SY2 = SWTM*SY2M + SWTP*SY2P
          S2 = SQRT(SX2*SX2 + SY2*SY2)
          S2INV = 1.0 / S2
          AX2 = 0.5*(X(IP,JP)+X(IO,JP) - X(IP,JO)-X(IO,JO))
          AY2 = 0.5*(Y(IP,JP)+Y(IO,JP) - Y(IP,JO)-Y(IO,JO))
          AN2 = (SX2*AY2 - SY2*AX2)*S2INV
C
c          STMP = 0.5*S2INV
cC
c          S2_X2M = -SX2 * STMP
c          S2_Y2M = -SY2 * STMP
c          S2_X2P = -SX2 * STMP
c          S2_Y2P = -SY2 * STMP
c          S2_X3M =  SX2 * STMP
c          S2_Y3M =  SY2 * STMP
c          S2_X3P =  SX2 * STMP
c          S2_Y3P =  SY2 * STMP
cC
cC-------- assemble  A(x,y)  sensitivities
c          AN2_S2 = -AN2*S2INV
cC
c          AN2_X2M = ( SY2-AY2 ) * STMP  +  AN2_S2*S2_X2M
c          AN2_Y2M = (-SX2+AX2 ) * STMP  +  AN2_S2*S2_Y2M
c          AN2_X2P = (-SY2-AY2 ) * STMP  +  AN2_S2*S2_X2P
c          AN2_Y2P = ( SX2+AX2 ) * STMP  +  AN2_S2*S2_Y2P
c          AN2_X3M = ( SY2+AY2 ) * STMP  +  AN2_S2*S2_X3M
c          AN2_Y3M = (-SX2-AX2 ) * STMP  +  AN2_S2*S2_Y3M
c          AN2_X3P = (-SY2+AY2 ) * STMP  +  AN2_S2*S2_X3P
c          AN2_Y3P = ( SX2-AX2 ) * STMP  +  AN2_S2*S2_Y3P
C
C
          STMPM = SWTM*S2INV
          STMPP = SWTP*S2INV
C
          S2_X2M = -SX2 * STMPM
          S2_Y2M = -SY2 * STMPM
          S2_X2P = -SX2 * STMPP
          S2_Y2P = -SY2 * STMPP
          S2_X3M =  SX2 * STMPM
          S2_Y3M =  SY2 * STMPM
          S2_X3P =  SX2 * STMPP
          S2_Y3P =  SY2 * STMPP
C
C-------- assemble  A(x,y)  sensitivities
          AN2_S2 = -AN2*S2INV
C
          AN2_X2M = ( SY2-AY2 ) * STMPM  +  AN2_S2*S2_X2M
          AN2_Y2M = (-SX2+AX2 ) * STMPM  +  AN2_S2*S2_Y2M
          AN2_X2P = (-SY2-AY2 ) * STMPP  +  AN2_S2*S2_X2P
          AN2_Y2P = ( SX2+AX2 ) * STMPP  +  AN2_S2*S2_Y2P
          AN2_X3M = ( SY2+AY2 ) * STMPM  +  AN2_S2*S2_X3M
          AN2_Y3M = (-SX2-AX2 ) * STMPM  +  AN2_S2*S2_Y3M
          AN2_X3P = (-SY2+AY2 ) * STMPP  +  AN2_S2*S2_X3P
          AN2_Y3P = ( SX2-AX2 ) * STMPP  +  AN2_S2*S2_Y3P
C
          BXM = 0.5*(X(IP,JO)-X(IM,JO))
          BXP = 0.5*(X(IP,JP)-X(IM,JP))
          BYM = 0.5*(Y(IP,JO)-Y(IM,JO))
          BYP = 0.5*(Y(IP,JP)-Y(IM,JP))
          AXA = AX1*AY2 - AX2*AY1
          BXB = BXM*BYP - BXP*BYM
          SXSM = (SX1M*SY2M - SY1M*SX2M)
          SXSP = (SX1P*SY2P - SY1P*SX2P)
C
          XS = 0.5*(BXM+BXP)
          YS = 0.5*(BYM+BYP)
          XN = 0.5*(AX1+AX2)
          YN = 0.5*(AY1+AY2)
          SXN = XS*YN - YS*XN
          SXNINV = 1.0 / SXN
C
C-------- assemble  SXN(x,y)  sensitivities
          SXN_X1M = ( YS-YN ) * 0.25
          SXN_Y1M = (-XS+XN ) * 0.25
          SXN_X1P = (-YS-YN ) * 0.25
          SXN_Y1P = ( XS+XN ) * 0.25
          SXN_X2M = ( YS    ) * 0.5
          SXN_Y2M = (-XS    ) * 0.5
          SXN_X2P = (-YS    ) * 0.5
          SXN_Y2P = ( XS    ) * 0.5
          SXN_X3M = ( YS+YN ) * 0.25
          SXN_Y3M = (-XS-XN ) * 0.25
          SXN_X3P = (-YS+YN ) * 0.25
          SXN_Y3P = ( XS-XN ) * 0.25
C
C-------- calculate flow variables ...
C
          R2 = R(IO,JO)
C
C-------- assemble  Q(R,A;m)  and  P(R,A;m)  sensitivities
          Q2     = M(JO) / (AN2*R2)
          Q2_R2  = -Q2/R2
          Q2_AN2 = -Q2/AN2
          Q2_MJ  =  Q2/M(JO)
C
          P2    = GCON * R2 * (HINF - 0.5*Q2*Q2)
          P2_Q2 = -GCON*R2*Q2
C
          P2_R2  = P2/R2 + P2_Q2*Q2_R2
          P2_AN2 =         P2_Q2*Q2_AN2
          P2_MJ  =         P2_Q2*Q2_MJ
C
C-------- set  MSQ(Q)
          MSQ2 = Q2*Q2 / (GM1*(HINF - 0.5*Q2*Q2))
          MSQ2_Q2 = MSQ2*(2.0 + GM1*MSQ2)/Q2
C
          Q(IO,JO) = Q2
C
C-------- set weighting factor MCF for 2nd order dissipation
          IF(MUCON .LT. 0.0) THEN
C
C---------- use first-order dissipation only
            MCF = 0.
            MCF_Q1 = 0.
            MCF_Q2 = 0.
C
          ELSE
C
C---------- dot product measuring grid skew
ccc            SNDOT = (SX2*AX2 + SY2*AY2)*S2INV**2
            SNDOT = 0.
c            SND_S2 = -2.0*SNDOT*S2INV
cC
c            STMP = 0.5*S2INV**2
c            SND_X2M = (-SX2-AX2 ) * STMP  +  SND_S2*S2_X2M
c            SND_Y2M = (-SY2-AY2 ) * STMP  +  SND_S2*S2_Y2M
c            SND_X2P = ( SX2-AX2 ) * STMP  +  SND_S2*S2_X2P
c            SND_Y2P = ( SY2-AY2 ) * STMP  +  SND_S2*S2_Y2P
c            SND_X3M = (-SX2+AX2 ) * STMP  +  SND_S2*S2_X3M
c            SND_Y3M = (-SY2+AY2 ) * STMP  +  SND_S2*S2_Y3M
c            SND_X3P = ( SX2+AX2 ) * STMP  +  SND_S2*S2_X3P
c            SND_Y3P = ( SY2+AY2 ) * STMP  +  SND_S2*S2_Y3P
C


ccC---------- assume weak 2nd-order dissipation, and weaken more in high skew
cc            FQWT = 5.0*(1.0 + ABS(SNDOT))
cc            FQWT_SND = 5.0*  SIGN(1.0,SNDOT)
ccC
ccC---------- use full 2nd-order dissipation only if flow is accelerating
c            IF(Q2.GE.Q1 .AND. Q1.GE.Q0 .AND. Q0.GE.Q9) FQWT = 1.0
C
            FQWT = 0.0
C
C---------- use full 2nd-order dissipation only if speed gradient is small
            FQ    =  FQWT*(Q2-Q1)/QSTAR
            FQ_Q1 = -FQWT        /QSTAR
            FQ_Q2 =  FQWT        /QSTAR
C
            ARG = FQ**2
            ARG = MIN( 25.0 , ARG )
C
            MCF = EXP(-ARG)
            MCF_FQ = -2.0*FQ*MCF
C
            MCF_Q1 = MCF_FQ*FQ_Q1
            MCF_Q2 = MCF_FQ*FQ_Q2
C
C
            MCF    = 1.0
            MCF_Q1 = 0.
            MCF_Q2 = 0.
C
          ENDIF
C

C-------- set basic dissipation
          MSQA = 0.5*(MSQ1 + MSQ2)
C
          ARG = (1.0-1.0/MSQA)/AMU
          IF( ARG .LT. -10.0) THEN
            MU      = 0.
            MU_MSQA = 0.
          ELSEIF (ARG .GT. 10.0) THEN
            MU      = ABS(MUCON)/GAM * (1.0-1.0/MSQA)
            MU_MSQA = ABS(MUCON)/GAM           /MSQA**2
          ELSE
            EMU     = EXP(ARG)
            MU      = ABS(MUCON)/GAM * AMU*LOG(1.0 + EMU)
            MU_MSQA = ABS(MUCON)/GAM        / (1.0 + EMU) * EMU/MSQA**2
          ENDIF
C
          MU_Q1  = MU_MSQA*0.5*MSQ1_Q1
          MU_Q2  = MU_MSQA*0.5*MSQ2_Q2
C
C
C-------- modify 1st,2nd order dissipation based on previous-cycle max dRho
          MUB     = MUBFAC*MU
          MUB_Q1  = MUBFAC*MU_Q1
          MUB_Q2  = MUBFAC*MU_Q2
C
          MUC     = MUCFAC*MU   *MCF
          MUC_Q1  = MUCFAC*MU_Q1*MCF + MUCFAC*MU*MCF_Q1
          MUC_Q2  = MUCFAC*MU_Q2*MCF + MUCFAC*MU*MCF_Q2
C
C
C-------- limit 2nd-order dissipation in subsonic flow to avoid 
C-         oscillatory post-shock behavior (prevent complex-pair root)
c          IF( MSQ .GT. MSFX .AND. MSQ .LT. 1.0 .AND. MUCON.GT.0.0) THEN
c            SQM     = SQRT(1.0 + MUB*GAM/(1.0/MSQ-1.0))
c            SQM_MUB = (0.5/SQM)     *GAM/(1.0/MSQ-1.0)
c            SQM_MSQ = (0.5/SQM)* MUB*GAM/(1.0-MSQ)**2
cC
c            MUC     = MUB - (1.0/MSQ - 1.0)*(SQM - 1.0) * 2.0/GAM
c            MUC_MUB = 1.0 - (1.0/MSQ - 1.0)*(SQM_MUB  ) * 2.0/GAM
c            MUC_MSQ =     - (1.0/MSQ - 1.0)*(SQM_MSQ  ) * 2.0/GAM
c     &                    + (1.0/MSQ**2   )*(SQM - 1.0) * 2.0/GAM
cC
c            MUC_Q1 = MUC_MUB*MUB_Q1 + MUC_MSQ*MSQ_Q1
c            MUC_Q2 = MUC_MUB*MUB_Q2 + MUC_MSQ*MSQ_Q2
cC
cc            write(*,8844) msq, mub, muc
cc 8844       format(1x,5f12.5)
c          ENDIF
C
C-------- factor to correct dissipation for nonuniform grid
          SRAT    = (S2+S1)/(S1+S0)
          SRAT_S0 =   -SRAT/(S1+S0)
          SRAT_S1 =   -SRAT/(S1+S0) + 1.0/(S1+S0)
          SRAT_S2 =                   1.0/(S1+S0)
C
C-------- calculate upwinded speed and assemble  QS(Q)  sensitivities
C-        Qs( Q{R An(x y) m}  Mu(Q) )
          QS2    = Q2  - (Q2-Q1)*MUB    + (Q1-Q0)*MUC   *SRAT
          QS2_Q0 =                           -    MUC   *SRAT
          QS2_Q1 =               MUB    +         MUC   *SRAT
     &                 - (Q2-Q1)*MUB_Q1 + (Q1-Q0)*MUC_Q1*SRAT
          QS2_Q2 = 1.0 -         MUB
     &                 - (Q2-Q1)*MUB_Q2 + (Q1-Q0)*MUC_Q2*SRAT
          QS2_S0 =                        (Q1-Q0)*MUC   *SRAT_S0
          QS2_S1 =                        (Q1-Q0)*MUC   *SRAT_S1
          QS2_S2 =                        (Q1-Q0)*MUC   *SRAT_S2
C
          IF(QS2*QS2 .GT. 2.0*HINF) THEN
           WRITE(*,*) 'Neg. temp., q qs i j =', Q2,QS2,IO,JO
           QS2 = 0.95*SQRT(2.0*HINF)
           QS2_Q0 = 0.
           QS2_Q1 = 0.
           QS2_Q2 = 0.
           QS2_S0 = 0.
           QS2_S1 = 0.
           QS2_S2 = 0.
          ENDIF
C
C
C-------- total pressure based on upwinded speed
          PST2     = P2 * (1.0 - 0.5*QS2*QS2/HINF)**(-GAM/GM1)
          PST2_P2  = PST2 / P2
          PST2_Q2  = 0.
          PST2_QS2 = PST2 * QS2*GAM/(GM1*(HINF - 0.5*QS2*QS2))
C
cC-------- usual total pressure
c          PST2     = P2 * (1.0 - 0.5*Q2*Q2/HINF)**(-GAM/GM1)
c          PST2_P2  = PST2 / P2
c          PST2_Q2  = PST2 * Q2*GAM/(GM1*(HINF - 0.5*Q2*Q2))
c          PST2_QS2 = 0.
C
C
C-------- calculate dP/dA correction  PCORR
          PTMP   = 0.0625*PCWT
C
C-------- PC ( R Q(R A m) SXS S DPC(R A S m) )
          PCORR  = PTMP*(R1+R2)*(Q1+Q2)**2*(SXSM-SXSP)*S1INV*S2INV
          PC_R1  = PTMP        *(Q1+Q2)**2*(SXSM-SXSP)*S1INV*S2INV
          PC_R2  = PTMP        *(Q1+Q2)**2*(SXSM-SXSP)*S1INV*S2INV
          PC_Q1  = PTMP*(R1+R2)*(Q1+Q2)*2.*(SXSM-SXSP)*S1INV*S2INV
          PC_Q2  = PTMP*(R1+R2)*(Q1+Q2)*2.*(SXSM-SXSP)*S1INV*S2INV
          PC_SXS = PTMP*(R1+R2)*(Q1+Q2)**2            *S1INV*S2INV
          PC_S1  =-PTMP*(R1+R2)*(Q1+Q2)**2*(SXSM-SXSP)*S1INV*S2INV/S1
          PC_S2  =-PTMP*(R1+R2)*(Q1+Q2)**2*(SXSM-SXSP)*S1INV*S2INV/S2
C
C-------- PC( R  A(x y)  m  SXS(x y)  S(x y) )
          PC_R9  = 0.
          PC_R0  = 0.
          PC_R1  = PC_Q1*Q1_R1  + PC_R1
          PC_R2  = PC_Q2*Q2_R2  + PC_R2
          PC_AN9 = 0.
          PC_AN0 = 0.
          PC_AN1 = PC_Q1*Q1_AN1
          PC_AN2 = PC_Q2*Q2_AN2
          PC_S9  = 0.
          PC_S0  = 0.
          PC_S1  = PC_S1
          PC_S2  = PC_S2
          PC_MJ  = PC_Q1*Q1_MJ
     &           + PC_Q2*Q2_MJ 
C
C-------- PC( R x y  m )
          PC_X9M = PC_S9*S9_X9M + PC_AN9*AN9_X9M
          PC_Y9M = PC_S9*S9_Y9M + PC_AN9*AN9_Y9M
          PC_X9P = PC_S9*S9_X9P + PC_AN9*AN9_X9P
          PC_Y9P = PC_S9*S9_Y9P + PC_AN9*AN9_Y9P
C
          PC_X0M = PC_S9*S9_X0M + PC_AN9*AN9_X0M
     &           + PC_S0*S0_X0M + PC_AN0*AN0_X0M
          PC_Y0M = PC_S9*S9_Y0M + PC_AN9*AN9_Y0M
     &           + PC_S0*S0_Y0M + PC_AN0*AN0_Y0M
          PC_X0P = PC_S9*S9_X0P + PC_AN9*AN9_X0P
     &           + PC_S0*S0_X0P + PC_AN0*AN0_X0P
          PC_Y0P = PC_S9*S9_Y0P + PC_AN9*AN9_Y0P
     &           + PC_S0*S0_Y0P + PC_AN0*AN0_Y0P
C
          PC_X1M = PC_S0*S0_X1M + PC_AN0*AN0_X1M
     &           + PC_S1*S1_X1M + PC_AN1*AN1_X1M + PC_SXS*(-SY2M)
          PC_Y1M = PC_S0*S0_Y1M + PC_AN0*AN0_Y1M
     &           + PC_S1*S1_Y1M + PC_AN1*AN1_Y1M + PC_SXS*( SX2M)
          PC_X1P = PC_S0*S0_X1P + PC_AN0*AN0_X1P
     &           + PC_S1*S1_X1P + PC_AN1*AN1_X1P + PC_SXS*( SY2P)
          PC_Y1P = PC_S0*S0_Y1P + PC_AN0*AN0_Y1P
     &           + PC_S1*S1_Y1P + PC_AN1*AN1_Y1P + PC_SXS*(-SX2P)
C
          PC_X2M = PC_S1*S1_X2M + PC_AN1*AN1_X2M + PC_SXS*( SY2M)
     &           + PC_S2*S2_X2M + PC_AN2*AN2_X2M + PC_SXS*( SY1M)
          PC_Y2M = PC_S1*S1_Y2M + PC_AN1*AN1_Y2M + PC_SXS*(-SX2M)
     &           + PC_S2*S2_Y2M + PC_AN2*AN2_Y2M + PC_SXS*(-SX1M)
          PC_X2P = PC_S1*S1_X2P + PC_AN1*AN1_X2P + PC_SXS*(-SY2P)
     &           + PC_S2*S2_X2P + PC_AN2*AN2_X2P + PC_SXS*(-SY1P)
          PC_Y2P = PC_S1*S1_Y2P + PC_AN1*AN1_Y2P + PC_SXS*( SX2P)
     &           + PC_S2*S2_Y2P + PC_AN2*AN2_Y2P + PC_SXS*( SX1P)
C
          PC_X3M = PC_S2*S2_X3M + PC_AN2*AN2_X3M + PC_SXS*(-SY1M)
          PC_Y3M = PC_S2*S2_Y3M + PC_AN2*AN2_Y3M + PC_SXS*( SX1M)
          PC_X3P = PC_S2*S2_X3P + PC_AN2*AN2_X3P + PC_SXS*( SY1P)
          PC_Y3P = PC_S2*S2_Y3P + PC_AN2*AN2_Y3P + PC_SXS*(-SX1P)
C
C
C
C*******  S Momentum equation  *************************
C
          F1 = (SX1*XS+SY1*YS)*S1INV*SXNINV
          F2 = (SX2*XS+SY2*YS)*S2INV*SXNINV
C
          REZS = (P1 - P2) + M(JO)*(QS1*F1 - QS2*F2) + PCORR*BXB*SXNINV
C
C-------- ZS( PC SXN BXB DP QS(Q S) P S m )
          ZS_PC  =  BXB*SXNINV
          ZS_SXN = -M(JO)*QS1*F1*SXNINV    + M(JO)*QS2*F2*SXNINV
     &           -  PCORR*BXB*SXNINV**2
          ZS_BXB =  PCORR*SXNINV
          ZS_DP1 =  M(JO)*QS1*S1INV*SXNINV
          ZS_DP2 =                         - M(JO)*QS2*S2INV*SXNINV
          ZS_QS1 =  M(JO)*F1
          ZS_QS2 = -M(JO)*F2
          ZS_P1  =  1.0
          ZS_P2  = -1.0
          ZS_S1  = -M(JO)*QS1*F1*S1INV
          ZS_S2  =  M(JO)*QS2*F2*S2INV
          ZS_MJ  = QS1*F1 - QS2*F2
C
C-------- ZS( PC(R x y m)  SXN  BXB  DP  Q(R A m)  P(R A m)  S  m )
          ZS_S9 = ZS_QS1*QS1_S9
          ZS_S0 = ZS_QS1*QS1_S0 + ZS_QS2*QS2_S0
          ZS_S1 = ZS_QS1*QS1_S1 + ZS_QS2*QS2_S1 + ZS_S1
          ZS_S2 =                 ZS_QS2*QS2_S2 + ZS_S2
C
          ZS_Q9 = ZS_QS1*QS1_Q9
          ZS_Q0 = ZS_QS1*QS1_Q0 + ZS_QS2*QS2_Q0
          ZS_Q1 = ZS_QS1*QS1_Q1 + ZS_QS2*QS2_Q1
          ZS_Q2 =                 ZS_QS2*QS2_Q2
C
C-------- ZS( PC(x y) SXN(x y) BXB(x y) DP(x y) R A(x y) S(x y) m )
          ZS_R9  = ZS_Q9*Q9_R9                 +  ZS_PC*PC_R9
          ZS_R0  = ZS_Q0*Q0_R0                 +  ZS_PC*PC_R0
          ZS_R1  = ZS_Q1*Q1_R1  + ZS_P1*P1_R1  +  ZS_PC*PC_R1
          ZS_R2  = ZS_Q2*Q2_R2  + ZS_P2*P2_R2  +  ZS_PC*PC_R2
C
          ZS_AN9 = ZS_Q9*Q9_AN9
          ZS_AN0 = ZS_Q0*Q0_AN0
          ZS_AN1 = ZS_Q1*Q1_AN1 + ZS_P1*P1_AN1
          ZS_AN2 = ZS_Q2*Q2_AN2 + ZS_P2*P2_AN2
C
          ZS_MJ  = ZS_Q9*Q9_MJ 
     &           + ZS_Q0*Q0_MJ
     &           + ZS_Q1*Q1_MJ  + ZS_P1*P1_MJ   + ZS_PC*PC_MJ
     &           + ZS_Q2*Q2_MJ  + ZS_P2*P2_MJ
     &           + ZS_MJ
C
C-------- ZS( R x y m )
          ZS_X9M = ZS_PC*PC_X9M
     &           + ZS_S9*S9_X9M + ZS_AN9*AN9_X9M
          ZS_Y9M = ZS_PC*PC_Y9M
     &           + ZS_S9*S9_Y9M + ZS_AN9*AN9_Y9M
C
          ZS_X9P = ZS_PC*PC_X9P
     &           + ZS_S9*S9_X9P + ZS_AN9*AN9_X9P
          ZS_Y9P = ZS_PC*PC_Y9P
     &           + ZS_S9*S9_Y9P + ZS_AN9*AN9_Y9P
C
          ZS_X0M = ZS_PC*PC_X0M
     &           + ZS_S9*S9_X0M + ZS_AN9*AN9_X0M
     &           + ZS_S0*S0_X0M + ZS_AN0*AN0_X0M
          ZS_Y0M = ZS_PC*PC_Y0M
     &           + ZS_S9*S9_Y0M + ZS_AN9*AN9_Y0M
     &           + ZS_S0*S0_Y0M + ZS_AN0*AN0_Y0M
C
          ZS_X0P = ZS_PC*PC_X0P
     &           + ZS_S9*S9_X0P + ZS_AN9*AN9_X0P
     &           + ZS_S0*S0_X0P + ZS_AN0*AN0_X0P
          ZS_Y0P = ZS_PC*PC_Y0P
     &           + ZS_S9*S9_Y0P + ZS_AN9*AN9_Y0P
     &           + ZS_S0*S0_Y0P + ZS_AN0*AN0_Y0P
C
          ZS_X1M = ZS_PC*PC_X1M + ZS_SXN*SXN_X1M
     &           + ZS_S0*S0_X1M + ZS_AN0*AN0_X1M
     &           + ZS_S1*S1_X1M + ZS_AN1*AN1_X1M
     &    + ZS_DP1*(-.25*SX1 - SWTM*XS) + ZS_BXB*(-0.5*BYP)
     &    + ZS_DP2*(-.25*SX2          )
          ZS_Y1M = ZS_PC*PC_Y1M + ZS_SXN*SXN_Y1M
     &           + ZS_S0*S0_Y1M + ZS_AN0*AN0_Y1M
     &           + ZS_S1*S1_Y1M + ZS_AN1*AN1_Y1M
     &    + ZS_DP1*(-.25*SY1 - SWTM*YS) + ZS_BXB*( 0.5*BXP)
     &    + ZS_DP2*(-.25*SY2          )
C
          ZS_X1P = ZS_PC*PC_X1P + ZS_SXN*SXN_X1P
     &           + ZS_S0*S0_X1P + ZS_AN0*AN0_X1P
     &           + ZS_S1*S1_X1P + ZS_AN1*AN1_X1P
     &    + ZS_DP1*(-.25*SX1 - SWTP*XS) + ZS_BXB*( 0.5*BYM)
     &    + ZS_DP2*(-.25*SX2          )
          ZS_Y1P = ZS_PC*PC_Y1P + ZS_SXN*SXN_Y1P
     &           + ZS_S0*S0_Y1P + ZS_AN0*AN0_Y1P
     &           + ZS_S1*S1_Y1P + ZS_AN1*AN1_Y1P
     &    + ZS_DP1*(-.25*SY1 - SWTP*YS) + ZS_BXB*(-0.5*BXM)
     &    + ZS_DP2*(-.25*SY2          )
C
          ZS_X2M = ZS_PC*PC_X2M + ZS_SXN*SXN_X2M
     &           + ZS_S1*S1_X2M + ZS_AN1*AN1_X2M
     &           + ZS_S2*S2_X2M + ZS_AN2*AN2_X2M
     &    + ZS_DP1*(         + SWTM*XS)
     &    + ZS_DP2*(         - SWTM*XS)
          ZS_Y2M = ZS_PC*PC_Y2M + ZS_SXN*SXN_Y2M
     &           + ZS_S1*S1_Y2M + ZS_AN1*AN1_Y2M
     &           + ZS_S2*S2_Y2M + ZS_AN2*AN2_Y2M
     &    + ZS_DP1*(         + SWTM*YS)
     &    + ZS_DP2*(         - SWTM*YS)
C
          ZS_X2P = ZS_PC*PC_X2P + ZS_SXN*SXN_X2P
     &           + ZS_S1*S1_X2P + ZS_AN1*AN1_X2P
     &           + ZS_S2*S2_X2P + ZS_AN2*AN2_X2P
     &    + ZS_DP1*(         + SWTP*XS)
     &    + ZS_DP2*(         - SWTP*XS)
          ZS_Y2P = ZS_PC*PC_Y2P + ZS_SXN*SXN_Y2P
     &           + ZS_S1*S1_Y2P + ZS_AN1*AN1_Y2P
     &           + ZS_S2*S2_Y2P + ZS_AN2*AN2_Y2P
     &    + ZS_DP1*(         + SWTP*YS)
     &    + ZS_DP2*(         - SWTP*YS)
C
          ZS_X3M = ZS_PC*PC_X3M + ZS_SXN*SXN_X3M
     &           + ZS_S2*S2_X3M + ZS_AN2*AN2_X3M
     &    + ZS_DP1*( .25*SX1          ) + ZS_BXB*( 0.5*BYP)
     &    + ZS_DP2*( .25*SX2 + SWTM*XS)
          ZS_Y3M = ZS_PC*PC_Y3M + ZS_SXN*SXN_Y3M
     &           + ZS_S2*S2_Y3M + ZS_AN2*AN2_Y3M
     &    + ZS_DP1*( .25*SY1          ) + ZS_BXB*(-0.5*BXP)
     &    + ZS_DP2*( .25*SY2 + SWTM*YS)
C
          ZS_X3P = ZS_PC*PC_X3P + ZS_SXN*SXN_X3P
     &           + ZS_S2*S2_X3P + ZS_AN2*AN2_X3P
     &    + ZS_DP1*( .25*SX1          ) + ZS_BXB*(-0.5*BYM)
     &    + ZS_DP2*( .25*SX2 + SWTP*XS)
          ZS_Y3P = ZS_PC*PC_Y3P + ZS_SXN*SXN_Y3P
     &           + ZS_S2*S2_Y3P + ZS_AN2*AN2_Y3P
     &    + ZS_DP1*( .25*SY1          ) + ZS_BXB*( 0.5*BXM)
     &    + ZS_DP2*( .25*SY2 + SWTP*YS)
C
C
C
C=======  Isentropy (total pressure) equation residual and Jacobian
C-        (scaled to same form as S-momentum residual)
C
C-------- ZI( PST(QS Q P) P )
          REZI    = LOG(PST1/PST2)*0.5*(P1+P2)
          ZI_PST1 =    ( 1.0/PST1)*0.5*(P1+P2)
          ZI_PST2 =    (-1.0/PST2)*0.5*(P1+P2)
          ZI_P1   = LOG(PST1/PST2)*0.5
          ZI_P2   = LOG(PST1/PST2)*0.5
C
C-------- ZI( QS(Q S) Q P )
          ZI_QS1 = ZI_PST1*PST1_QS1
          ZI_QS2 = ZI_PST2*PST2_QS2
C
          ZI_Q1  = ZI_PST1*PST1_Q1
          ZI_Q2  = ZI_PST2*PST2_Q2
C
          ZI_P1  = ZI_PST1*PST1_P1  + ZI_P1
          ZI_P2  = ZI_PST2*PST2_P2  + ZI_P2
C
C
C
C-------- Set S-momentum/isentropy trigger
          FS_QS1 = 0.
          FS_QS2 = 0.
          FS_Q9  = 0.
          FS_Q0  = 0.
          FS_Q1  = 0.
          FS_Q2  = 0.
          FS_R1  = 0.
          FS_R2  = 0.
          FS_P1  = 0.
          FS_P2  = 0.
          FS_ZS  = 0.
          FS_ZI  = 0.
C
          IF     (ISMOM.EQ.1) THEN
C
            FS = 1.0
C
          ELSE IF(ISMOM.EQ.2) THEN
C
            FS = 0.0
C
          ELSE IF(ISMOM.EQ.3) THEN
C
C---------- are we in LE region ?
            LLEREG = (JO.LT.JSCT+JSEN .AND. IO.LE.ILES+ISEN)
     &          .OR. (JO.GE.JPRS-JSEN .AND. IO.LE.ILEP+ISEN)
C
C---------- constant entropy in LE region, S-momentum elsewhere
            IF(LLEREG) THEN
              FS = 0.0
            ELSE
              FS = 1.0
            ENDIF
C
          ELSE IF(ISMOM.EQ.4) THEN
C
C--------- set trigger EXQ based on velocity change over cells i, i-1, i-2
           IF(Q0 .LT. Q9) THEN
             DQTL = (Q0 - Q9)/QSTAR
             DQTL_Q9 =   -1.0/QSTAR
             DQTL_Q0 =    1.0/QSTAR
           ELSE
             DQTL    = 0.
             DQTL_Q9 = 0.
             DQTL_Q0 = 0.
           ENDIF
C
           IF(Q1 .LT. Q0) THEN
             DQTM = (Q1 - Q0)/QSTAR
             DQTM_Q0 =   -1.0/QSTAR
             DQTM_Q1 =    1.0/QSTAR
           ELSE
             DQTM    = 0.
             DQTM_Q0 = 0.
             DQTM_Q1 = 0.
           ENDIF
C
           IF(Q2 .LT. Q1) THEN
             DQTO = (Q2 - Q1)/QSTAR
             DQTO_Q1 =   -1.0/QSTAR
             DQTO_Q2 =    1.0/QSTAR
           ELSE
             DQTO    = 0.
             DQTO_Q1 = 0.
             DQTO_Q2 = 0.
           ENDIF
C
           ARG = (DQTL/DQTEPS)**2 + (DQTM/DQTEPS)**2 + (DQTO/DQTEPS)**2
           ARG = MIN(25.0 , ARG)
           EXQ = EXP(-ARG)
           EXQ_DQTL = -EXQ * 2.0*DQTL/DQTEPS**2
           EXQ_DQTM = -EXQ * 2.0*DQTM/DQTEPS**2
           EXQ_DQTO = -EXQ * 2.0*DQTO/DQTEPS**2
C
           EXQ_Q9 =                                     EXQ_DQTL*DQTL_Q9
           EXQ_Q0 =                   EXQ_DQTM*DQTM_Q0+ EXQ_DQTL*DQTL_Q0
           EXQ_Q1 = EXQ_DQTO*DQTO_Q1+ EXQ_DQTM*DQTM_Q1
           EXQ_Q2 = EXQ_DQTO*DQTO_Q2
C
C--------- set trigger EXT based on upwinded total pressure change over cell i
           DQ1 = QS1 - Q1
           DQ2 = QS2 - Q2
           DDQ     =  0.5*(DQ1+DQ2)*(R2*Q2/P2 - R1*Q1/P1)
C
           IF(DDQ .GT. 0.0) THEN
             DDQ     = 0.
             DDQ_Q1  = 0.
             DDQ_Q2  = 0.
             DDQ_QS1 = 0.
             DDQ_QS2 = 0.
             DDQ_R1  = 0.
             DDQ_R2  = 0.
             DDQ_P1  = 0.
             DDQ_P2  = 0.
           ELSE
CCC          DDQ     =  0.5*(DQ1+DQ2)*(R2*Q2/P2 - R1*Q1/P1)
             DDQ_Q1  = -0.5          *(R2*Q2/P2 - R1*Q1/P1)
     &               +  0.5*(DQ1+DQ2)*(         - R1   /P1)
             DDQ_Q2  = -0.5          *(R2*Q2/P2 - R1*Q1/P1)
     &               +  0.5*(DQ1+DQ2)*(R2   /P2           )
             DDQ_QS1 =  0.5          *(R2*Q2/P2 - R1*Q1/P1)
             DDQ_QS2 =  0.5          *(R2*Q2/P2 - R1*Q1/P1)
             DDQ_R1  =  0.5*(DQ1+DQ2)*(         -    Q1/P1)
             DDQ_R2  =  0.5*(DQ1+DQ2)*(   Q2/P2           )
             DDQ_P1  = -0.5*(DQ1+DQ2)*(         - R1*Q1/P1)/P1
             DDQ_P2  = -0.5*(DQ1+DQ2)*(R2*Q2/P2           )/P2
           ENDIF
C
           ARG = (DDQ/DPTEPS)**2
           ARG = MIN(25.0 , ARG)
           EXT = EXP(-ARG)
           EXT_DDQ = -EXT * 2.0*DDQ / DPTEPS**2
C
           FSMOM   = (1.0 - EXT)*(1.0 - EXQ)
           FSM_EXT = (    - 1.0)*(1.0 - EXQ)
           FSM_EXQ = (1.0 - EXT)*(    - 1.0)
C
           FSM_QS1 = FSM_EXT*EXT_DDQ*DDQ_QS1
           FSM_QS2 = FSM_EXT*EXT_DDQ*DDQ_QS2
           FSM_Q9  =                           FSM_EXQ*EXQ_Q9
           FSM_Q0  =                           FSM_EXQ*EXQ_Q0
           FSM_Q1  = FSM_EXT*EXT_DDQ*DDQ_Q1  + FSM_EXQ*EXQ_Q1
           FSM_Q2  = FSM_EXT*EXT_DDQ*DDQ_Q2  + FSM_EXQ*EXQ_Q2
           FSM_R1  = FSM_EXT*EXT_DDQ*DDQ_R1
           FSM_R2  = FSM_EXT*EXT_DDQ*DDQ_R2
           FSM_P1  = FSM_EXT*EXT_DDQ*DDQ_P1
           FSM_P2  = FSM_EXT*EXT_DDQ*DDQ_P2
C
C
C--------- increase FSMOM closer to 1.0 if current total residual is not small
           REZT   = REZS*FSMOM + REZI*(1.0-FSMOM)
           ZT_ZS  =      FSMOM
           ZT_ZI  =                    1.0-FSMOM
           ZT_FSM = REZS       - REZI
C
           RTWT = 0.0
           ARG = ( RTWT * REZT*2.0/(P1+P2) )**2
           ARG = MIN(25.0 , ARG)
           EXR = EXP(-ARG)
           EXR_PP  = -EXR * 2.0*(-ARG/(P1+P2))
           EXR_FSM = -EXR * 2.0*REZT * (RTWT*2.0/(P1+P2) )**2 * ZT_FSM
           EXR_ZS  = -EXR * 2.0*REZT * (RTWT*2.0/(P1+P2) )**2 * ZT_ZS
           EXR_ZI  = -EXR * 2.0*REZT * (RTWT*2.0/(P1+P2) )**2 * ZT_ZI
C
C--------- FS( FSM P ZS ZI )
           FS     = FSMOM + (1.0 - FSMOM)*(1.0 - EXR    )
           FS_FSM = 1.0          -        (1.0 - EXR    )
     &                    + (1.0 - FSMOM)*(    - EXR_FSM)
           FS_PP  =         (1.0 - FSMOM)*(    - EXR_PP )
C
           FS_ZS  =         (1.0 - FSMOM)*(    - EXR_ZS )
           FS_ZI  =         (1.0 - FSMOM)*(    - EXR_ZI )
C
C--------- FS(QS(Q S) Q R P ZS ZI)
           FS_QS1 = FS_FSM*FSM_QS1
           FS_QS2 = FS_FSM*FSM_QS2
           FS_Q9  = FS_FSM*FSM_Q9 
           FS_Q0  = FS_FSM*FSM_Q0 
           FS_Q1  = FS_FSM*FSM_Q1 
           FS_Q2  = FS_FSM*FSM_Q2 
           FS_R1  = FS_FSM*FSM_R1 
           FS_R2  = FS_FSM*FSM_R2 
           FS_P1  = FS_FSM*FSM_P1  + FS_PP
           FS_P2  = FS_FSM*FSM_P2  + FS_PP
C
c           if(abs(fs-fsmom) .gt. 0.1) then
c             write(*,4589) io,jo,sqrt(msq2),rezs,rezi, fs, fsmom
c 4589        format(1x,2i4,f8.4,2f12.6,2f9.3)
c           endif

          ELSE
C
            STOP 'SETUP:  Illegal ISMOM trigger.'
C
          ENDIF
C
C
C-------- are we adjacent to LE point?
          LLEPNT = .FALSE.
          DO N=1, NBL
            IF( (JO.EQ.JS1(N) .AND. IO.GE.ILEB(N)-1
     &                        .AND. IO.LE.ILEB(N)+1)
     &      .OR.(JP.EQ.JS2(N) .AND. IO.GE.ILEB(N)-1
     &                        .AND. IO.LE.ILEB(N)+1) ) LLEPNT = .TRUE.
          ENDDO
C
C-------- make cells adjacent to LE point always isentropic
          IF(LLEPNT) THEN
           FS     = 0.0
           FS_QS1 = 0.
           FS_QS2 = 0.
           FS_Q9  = 0.
           FS_Q0  = 0.
           FS_Q1  = 0.
           FS_Q2  = 0.
           FS_R1  = 0.
           FS_R2  = 0.
           FS_P1  = 0.
           FS_P2  = 0.
           FS_ZS  = 0.
           FS_ZI  = 0.
          ENDIF
C
C
C======== set total weighted S-momentum + Stagnation density equation
C
C-------- Res( ZS(R x y m) , ZI(QS(Q S) Q P) , FS(QS(Q S) Q R P ZS ZI) )
          REZ  = REZS*FS + REZI*(1.0-FS)
          Z_ZS =      FS
          Z_ZI =                 1.0-FS
          Z_FS = REZS    - REZI
C
C-------- Res( ZS(R x y m) , ZI(QS(Q S) Q P) , FS(QS(Q S) Q R P) )
          Z_ZS = Z_FS*FS_ZS   + Z_ZS
          Z_ZI = Z_FS*FS_ZI   + Z_ZI
C
C-------- Res( ZS(R x y m) , ZI(Q P) , FS(Q R P) , QS(Q S) )
          Z_QS1 = Z_ZI*ZI_QS1 + Z_FS*FS_QS1
          Z_QS2 = Z_ZI*ZI_QS2 + Z_FS*FS_QS2
C
C-------- Res( ZS(R x y m) , Q(R A m) , R , P(R A m) , S(x y) )
          Z_Q9 = Z_QS1*QS1_Q9                             + Z_FS*FS_Q9
          Z_Q0 = Z_QS1*QS1_Q0 + Z_QS2*QS2_Q0              + Z_FS*FS_Q0
          Z_Q1 = Z_QS1*QS1_Q1 + Z_QS2*QS2_Q1 + Z_ZI*ZI_Q1 + Z_FS*FS_Q1
          Z_Q2 =                Z_QS2*QS2_Q2 + Z_ZI*ZI_Q2 + Z_FS*FS_Q2
C
          Z_R1 =                                            Z_FS*FS_R1
          Z_R2 =                                            Z_FS*FS_R2
C
          Z_P1 =                               Z_ZI*ZI_P1 + Z_FS*FS_P1
          Z_P2 =                               Z_ZI*ZI_P2 + Z_FS*FS_P2
C
          Z_S9 = Z_QS1*QS1_S9
          Z_S0 = Z_QS1*QS1_S0 + Z_QS2*QS2_S0
          Z_S1 = Z_QS1*QS1_S1 + Z_QS2*QS2_S1
          Z_S2 =                Z_QS2*QS2_S2
C
C-------- Res( ZS(R x y m) , R , A(x y) , m , S(x y) )
          Z_R9  = Z_Q9*Q9_R9
          Z_R0  = Z_Q0*Q0_R0
          Z_R1  = Z_Q1*Q1_R1 + Z_P1*P1_R1 + Z_R1
          Z_R2  = Z_Q2*Q2_R2 + Z_P2*P2_R2 + Z_R2
C
          Z_AN9 = Z_Q9*Q9_AN9
          Z_AN0 = Z_Q0*Q0_AN0
          Z_AN1 = Z_Q1*Q1_AN1 + Z_P1*P1_AN1
          Z_AN2 = Z_Q2*Q2_AN2 + Z_P2*P2_AN2
C
          Z_MJ = Z_Q9*Q9_MJ + Z_Q0*Q0_MJ + Z_Q1*Q1_MJ + Z_Q2*Q2_MJ
     &                                   + Z_P1*P1_MJ + Z_P2*P2_MJ
C
C-------- Res( R , x(N) , y(N) , m )
          Z_X9M = Z_AN9*AN9_X9M + Z_S9*S9_X9M  + Z_ZS*ZS_X9M
          Z_Y9M = Z_AN9*AN9_Y9M + Z_S9*S9_Y9M  + Z_ZS*ZS_Y9M
          Z_X9P = Z_AN9*AN9_X9P + Z_S9*S9_X9P  + Z_ZS*ZS_X9P
          Z_Y9P = Z_AN9*AN9_Y9P + Z_S9*S9_Y9P  + Z_ZS*ZS_Y9P
C
          Z_X0M = Z_AN9*AN9_X0M + Z_S9*S9_X0M  + Z_ZS*ZS_X0M
     &          + Z_AN0*AN0_X0M + Z_S0*S0_X0M
          Z_Y0M = Z_AN9*AN9_Y0M + Z_S9*S9_Y0M  + Z_ZS*ZS_Y0M
     &          + Z_AN0*AN0_Y0M + Z_S0*S0_Y0M
          Z_X0P = Z_AN9*AN9_X0P + Z_S9*S9_X0P  + Z_ZS*ZS_X0P
     &          + Z_AN0*AN0_X0P + Z_S0*S0_X0P
          Z_Y0P = Z_AN9*AN9_Y0P + Z_S9*S9_Y0P  + Z_ZS*ZS_Y0P
     &          + Z_AN0*AN0_Y0P + Z_S0*S0_Y0P
C
          Z_X1M = Z_AN0*AN0_X1M + Z_S0*S0_X1M  + Z_ZS*ZS_X1M
     &          + Z_AN1*AN1_X1M + Z_S1*S1_X1M
          Z_Y1M = Z_AN0*AN0_Y1M + Z_S0*S0_Y1M  + Z_ZS*ZS_Y1M
     &          + Z_AN1*AN1_Y1M + Z_S1*S1_Y1M
          Z_X1P = Z_AN0*AN0_X1P + Z_S0*S0_X1P  + Z_ZS*ZS_X1P
     &          + Z_AN1*AN1_X1P + Z_S1*S1_X1P
          Z_Y1P = Z_AN0*AN0_Y1P + Z_S0*S0_Y1P  + Z_ZS*ZS_Y1P
     &          + Z_AN1*AN1_Y1P + Z_S1*S1_Y1P
C
          Z_X2M = Z_AN1*AN1_X2M + Z_S1*S1_X2M  + Z_ZS*ZS_X2M
     &          + Z_AN2*AN2_X2M + Z_S2*S2_X2M
          Z_Y2M = Z_AN1*AN1_Y2M + Z_S1*S1_Y2M  + Z_ZS*ZS_Y2M
     &          + Z_AN2*AN2_Y2M + Z_S2*S2_Y2M
          Z_X2P = Z_AN1*AN1_X2P + Z_S1*S1_X2P  + Z_ZS*ZS_X2P
     &          + Z_AN2*AN2_X2P + Z_S2*S2_X2P
          Z_Y2P = Z_AN1*AN1_Y2P + Z_S1*S1_Y2P  + Z_ZS*ZS_Y2P
     &          + Z_AN2*AN2_Y2P + Z_S2*S2_Y2P
C
          Z_X3M = Z_AN2*AN2_X3M + Z_S2*S2_X3M  + Z_ZS*ZS_X3M
          Z_Y3M = Z_AN2*AN2_Y3M + Z_S2*S2_Y3M  + Z_ZS*ZS_Y3M
          Z_X3P = Z_AN2*AN2_X3P + Z_S2*S2_X3P  + Z_ZS*ZS_X3P
          Z_Y3P = Z_AN2*AN2_Y3P + Z_S2*S2_Y3P  + Z_ZS*ZS_Y3P
C
          Z_R9 = Z_R9 + Z_ZS*ZS_R9
          Z_R0 = Z_R0 + Z_ZS*ZS_R0
          Z_R1 = Z_R1 + Z_ZS*ZS_R1
          Z_R2 = Z_R2 + Z_ZS*ZS_R2
C
          Z_MJ = Z_MJ + Z_ZS*ZS_MJ
C
C
C-------- Res( R N m )
          V8(JO,IO) = Z_R9
          Z8(JO,IO) = Z_R0
          B8(JO,IO) = Z_R1
          A8(JO,IO) = Z_R2
C
          V6(JO,IO) = Z_X9M*NX(IK,JO) + Z_Y9M*NY(IK,JO)
          V7(JO,IO) = Z_X9P*NX(IK,JP) + Z_Y9P*NY(IK,JP)
          Z6(JO,IO) = Z_X0M*NX(IL,JO) + Z_Y0M*NY(IL,JO)
          Z7(JO,IO) = Z_X0P*NX(IL,JP) + Z_Y0P*NY(IL,JP)
          B6(JO,IO) = Z_X1M*NX(IM,JO) + Z_Y1M*NY(IM,JO)
          B7(JO,IO) = Z_X1P*NX(IM,JP) + Z_Y1P*NY(IM,JP)
          A6(JO,IO) = Z_X2M*NX(IO,JO) + Z_Y2M*NY(IO,JO)
          A7(JO,IO) = Z_X2P*NX(IO,JP) + Z_Y2P*NY(IO,JP)
          C6(JO,IO) = Z_X3M*NX(IP,JO) + Z_Y3M*NY(IP,JO)
          C7(JO,IO) = Z_X3P*NX(IP,JP) + Z_Y3P*NY(IP,JP)
C
          DR(JZ,LMASS,IO) = MF0(JO)*Z_MJ
          DO 48 N = 1, NBL
           DR(JZ,LMAS1(N),IO) = MF1(JO,N)*Z_MJ
           DR(JZ,LSBLE(N),IO) = Z_X9M*NXG(IK,JO,N) + Z_Y9M*NYG(IK,JO,N)
     &                        + Z_X9P*NXG(IK,JP,N) + Z_Y9P*NYG(IK,JP,N)
     &                        + Z_X0M*NXG(IL,JO,N) + Z_Y0M*NYG(IL,JO,N)
     &                        + Z_X0P*NXG(IL,JP,N) + Z_Y0P*NYG(IL,JP,N)
     &                        + Z_X1M*NXG(IM,JO,N) + Z_Y1M*NYG(IM,JO,N)
     &                        + Z_X1P*NXG(IM,JP,N) + Z_Y1P*NYG(IM,JP,N)
     &                        + Z_X2M*NXG(IO,JO,N) + Z_Y2M*NYG(IO,JO,N)
     &                        + Z_X2P*NXG(IO,JP,N) + Z_Y2P*NYG(IO,JP,N)
     &                        + Z_X3M*NXG(IP,JO,N) + Z_Y3M*NYG(IP,JO,N)
     &                        + Z_X3P*NXG(IP,JP,N) + Z_Y3P*NYG(IP,JP,N)
  48      CONTINUE
C
          DO 49 NN = 1, NPOSN
           K = KPOSN(NN)
           DR(JZ,LPOSN(K),IO) = Z_X9M*NXP(IK,JO,K) + Z_Y9M*NYP(IK,JO,K)
     &                        + Z_X9P*NXP(IK,JP,K) + Z_Y9P*NYP(IK,JP,K)
     &                        + Z_X0M*NXP(IL,JO,K) + Z_Y0M*NYP(IL,JO,K)
     &                        + Z_X0P*NXP(IL,JP,K) + Z_Y0P*NYP(IL,JP,K)
     &                        + Z_X1M*NXP(IM,JO,K) + Z_Y1M*NYP(IM,JO,K)
     &                        + Z_X1P*NXP(IM,JP,K) + Z_Y1P*NYP(IM,JP,K)
     &                        + Z_X2M*NXP(IO,JO,K) + Z_Y2M*NYP(IO,JO,K)
     &                        + Z_X2P*NXP(IO,JP,K) + Z_Y2P*NYP(IO,JP,K)
     &                        + Z_X3M*NXP(IP,JO,K) + Z_Y3M*NYP(IP,JO,K)
     &                        + Z_X3P*NXP(IP,JP,K) + Z_Y3P*NYP(IP,JP,K)
  49      CONTINUE
          DR(JZ,LALFA,IO) = Z_X9M*NXA(IK,JO) + Z_Y9M*NYA(IK,JO)
     &                    + Z_X9P*NXA(IK,JP) + Z_Y9P*NYA(IK,JP)
     &                    + Z_X0M*NXA(IL,JO) + Z_Y0M*NYA(IL,JO)
     &                    + Z_X0P*NXA(IL,JP) + Z_Y0P*NYA(IL,JP)
     &                    + Z_X1M*NXA(IM,JO) + Z_Y1M*NYA(IM,JO)
     &                    + Z_X1P*NXA(IM,JP) + Z_Y1P*NYA(IM,JP)
     &                    + Z_X2M*NXA(IO,JO) + Z_Y2M*NYA(IO,JO)
     &                    + Z_X2P*NXA(IO,JP) + Z_Y2P*NYA(IO,JP)
     &                    + Z_X3M*NXA(IP,JO) + Z_Y3M*NYA(IP,JO)
     &                    + Z_X3P*NXA(IP,JP) + Z_Y3P*NYA(IP,JP)
C
          DR(JZ,1,IO) = -REZ
C
ccc         ENDIF
C

cC------- list cell with any significant S-momentum/isentropy blending
c         if(fsmom.gt.0.01 .and. fsmom.lt.0.99) then
c           write(*,*) io, jo, sqrt(msq2), ddq, fsmom
c         endif

C
         IF(FS .LT. 0.5) THEN
C-------- set isentropic-cell bit
          NBIT = 1 + (JO-1)/30
          JBIT = JO - (NBIT-1)*30 - 1
          ISBITS(NBIT,IO) = ISBITS(NBIT,IO) + 2**JBIT
         ENDIF
C
C
C********************************************
C*******  N Momentum equation  **************
C
          G1 = (SX1*XN+SY1*YN)*S1INV*SXNINV
          G2 = (SX2*XN+SY2*YN)*S2INV*SXNINV
C
          PIDIF = M(JO)*QS1*G1 - M(JO)*QS2*G2   + PCORR*AXA*SXNINV
          PISUM = (P1 + P2 - 2.0*PSTOUT) + 2.0*PCORR
          PIP = 0.5*(PISUM + PIDIF)
          PIM = 0.5*(PISUM - PIDIF)
C
C         REZ = M(JO)*QS1*G1 - M(JO)*QS2*G2 + PCORR*AXA*SXNINV  <- part 1
C
C             +/- (P1 + P2 + 2.0*PCORR)                         <- part 2
C
C                      +              -
C             =  2.0*Pi    /   -2.0*Pi
C
C
C=======  N Momentum,  part 1  ====================
C
          Z_PC  =  AXA*SXNINV
          Z_SXN = -M(JO)*QS1*G1*SXNINV    + M(JO)*QS2*G2*SXNINV
     &          -  PCORR*AXA*SXNINV**2
          Z_AXA =  PCORR*SXNINV
          Z_DP1 =  M(JO)*QS1*S1INV*SXNINV
          Z_DP2 =                         - M(JO)*QS2*S2INV*SXNINV
          Z_QS1 =  M(JO)*G1
          Z_QS2 = -M(JO)*G2
C
          Z_S9 = Z_QS1*QS1_S9
          Z_S0 = Z_QS1*QS1_S0 + Z_QS2*QS2_S0
          Z_S1 = Z_QS1*QS1_S1 + Z_QS2*QS2_S1 - M(JO)*QS1*G1*S1INV
          Z_S2 =                Z_QS2*QS2_S2 + M(JO)*QS2*G2*S2INV
C
          Z_Q9 = Z_QS1*QS1_Q9
          Z_Q0 = Z_QS1*QS1_Q0 + Z_QS2*QS2_Q0
          Z_Q1 = Z_QS1*QS1_Q1 + Z_QS2*QS2_Q1
          Z_Q2 =                Z_QS2*QS2_Q2
C
          Z_AN9 = Z_Q9*Q9_AN9
          Z_AN0 = Z_Q0*Q0_AN0
          Z_AN1 = Z_Q1*Q1_AN1
          Z_AN2 = Z_Q2*Q2_AN2
C
          Z_MJ = QS1*G1 - QS2*G2 + Z_PC*PC_MJ
     &         + Z_Q9*Q9_MJ + Z_Q0*Q0_MJ + Z_Q1*Q1_MJ + Z_Q2*Q2_MJ
C
          V5(JO,IO) = V5(JO,IO) + Z_Q9*Q9_R9  +  Z_PC*PC_R9
          V4(JP,IO) = V4(JP,IO) + Z_Q9*Q9_R9  +  Z_PC*PC_R9
          Z5(JO,IO) = Z5(JO,IO) + Z_Q0*Q0_R0  +  Z_PC*PC_R0
          Z4(JP,IO) = Z4(JP,IO) + Z_Q0*Q0_R0  +  Z_PC*PC_R0
          B5(JO,IO) = B5(JO,IO) + Z_Q1*Q1_R1  +  Z_PC*PC_R1
          B4(JP,IO) = B4(JP,IO) + Z_Q1*Q1_R1  +  Z_PC*PC_R1
          A5(JO,IO) = A5(JO,IO) + Z_Q2*Q2_R2  +  Z_PC*PC_R2
          A4(JP,IO) = A4(JP,IO) + Z_Q2*Q2_R2  +  Z_PC*PC_R2
C
          Z_X9M = Z_PC*PC_X9M
     &          + Z_S9*S9_X9M + Z_AN9*AN9_X9M
          Z_Y9M = Z_PC*PC_Y9M
     &          + Z_S9*S9_Y9M + Z_AN9*AN9_Y9M
C
          Z_X9P = Z_PC*PC_X9P
     &          + Z_S9*S9_X9P + Z_AN9*AN9_X9P
          Z_Y9P = Z_PC*PC_Y9P
     &          + Z_S9*S9_Y9P + Z_AN9*AN9_Y9P
C
          Z_X0M = Z_PC*PC_X0M
     &          + Z_S9*S9_X0M + Z_AN9*AN9_X0M
     &          + Z_S0*S0_X0M + Z_AN0*AN0_X0M
          Z_Y0M = Z_PC*PC_Y0M
     &          + Z_S9*S9_Y0M + Z_AN9*AN9_Y0M
     &          + Z_S0*S0_Y0M + Z_AN0*AN0_Y0M
C
          Z_X0P = Z_PC*PC_X0P
     &          + Z_S9*S9_X0P + Z_AN9*AN9_X0P
     &          + Z_S0*S0_X0P + Z_AN0*AN0_X0P
          Z_Y0P = Z_PC*PC_Y0P
     &          + Z_S9*S9_Y0P + Z_AN9*AN9_Y0P
     &          + Z_S0*S0_Y0P + Z_AN0*AN0_Y0P
C
          Z_X1M = Z_PC*PC_X1M + Z_SXN*SXN_X1M
     &          + Z_S0*S0_X1M + Z_AN0*AN0_X1M
     &          + Z_S1*S1_X1M + Z_AN1*AN1_X1M
     &          + Z_DP1*(-.25*SX1 - SWTM*XN)
     &          + Z_DP2*(-.25*SX2          )
     &          + Z_AXA*(-0.5*AY2)
          Z_Y1M = Z_PC*PC_Y1M + Z_SXN*SXN_Y1M
     &          + Z_S0*S0_Y1M + Z_AN0*AN0_Y1M
     &          + Z_S1*S1_Y1M + Z_AN1*AN1_Y1M
     &          + Z_DP1*(-.25*SY1 - SWTM*YN)
     &          + Z_DP2*(-.25*SY2          )
     &          + Z_AXA*( 0.5*AX2)
C
          Z_X1P = Z_PC*PC_X1P + Z_SXN*SXN_X1P
     &          + Z_S0*S0_X1P + Z_AN0*AN0_X1P
     &          + Z_S1*S1_X1P + Z_AN1*AN1_X1P
     &          + Z_DP1*( .25*SX1 - SWTP*XN)
     &          + Z_DP2*( .25*SX2          )
     &          + Z_AXA*( 0.5*AY2)
          Z_Y1P = Z_PC*PC_Y1P + Z_SXN*SXN_Y1P
     &          + Z_S0*S0_Y1P + Z_AN0*AN0_Y1P
     &          + Z_S1*S1_Y1P + Z_AN1*AN1_Y1P
     &          + Z_DP1*( .25*SY1 - SWTP*YN)
     &          + Z_DP2*( .25*SY2          )
     &          + Z_AXA*(-0.5*AX2)
C
          Z_X2M = Z_PC*PC_X2M + Z_SXN*SXN_X2M
     &          + Z_S1*S1_X2M + Z_AN1*AN1_X2M
     &          + Z_S2*S2_X2M + Z_AN2*AN2_X2M
     &          + Z_DP1*(-.50*SX1 + SWTM*XN)
     &          + Z_DP2*(-.50*SX2 - SWTM*XN)
     &          + Z_AXA*(-0.5*AY2 + 0.5*AY1)
          Z_Y2M = Z_PC*PC_Y2M + Z_SXN*SXN_Y2M
     &          + Z_S1*S1_Y2M + Z_AN1*AN1_Y2M
     &          + Z_S2*S2_Y2M + Z_AN2*AN2_Y2M
     &          + Z_DP1*(-.50*SY1 + SWTM*YN)
     &          + Z_DP2*(-.50*SY2 - SWTM*YN)
     &          + Z_AXA*( 0.5*AX2 - 0.5*AX1)
C
          Z_X2P = Z_PC*PC_X2P + Z_SXN*SXN_X2P
     &          + Z_S1*S1_X2P + Z_AN1*AN1_X2P
     &          + Z_S2*S2_X2P + Z_AN2*AN2_X2P
     &          + Z_DP1*( .50*SX1 + SWTP*XN)
     &          + Z_DP2*( .50*SX2 - SWTP*XN)
     &          + Z_AXA*( 0.5*AY2 - 0.5*AY1)
          Z_Y2P = Z_PC*PC_Y2P + Z_SXN*SXN_Y2P
     &          + Z_S1*S1_Y2P + Z_AN1*AN1_Y2P
     &          + Z_S2*S2_Y2P + Z_AN2*AN2_Y2P
     &          + Z_DP1*( .50*SY1 + SWTP*YN)
     &          + Z_DP2*( .50*SY2 - SWTP*YN)
     &          + Z_AXA*(-0.5*AX2 + 0.5*AX1)
C
          Z_X3M = Z_PC*PC_X3M + Z_SXN*SXN_X3M
     &          + Z_S2*S2_X3M + Z_AN2*AN2_X3M
     &          + Z_DP1*(-.25*SX1          )
     &          + Z_DP2*(-.25*SX2 + SWTM*XN)
     &          + Z_AXA*( 0.5*AY1)
          Z_Y3M = Z_PC*PC_Y3M + Z_SXN*SXN_Y3M
     &          + Z_S2*S2_Y3M + Z_AN2*AN2_Y3M
     &          + Z_DP1*(-.25*SY1          )
     &          + Z_DP2*(-.25*SY2 + SWTM*YN)
     &          + Z_AXA*(-0.5*AX1)
C
          Z_X3P = Z_PC*PC_X3P + Z_SXN*SXN_X3P
     &          + Z_S2*S2_X3P + Z_AN2*AN2_X3P
     &          + Z_DP1*( .25*SX1          )
     &          + Z_DP2*( .25*SX2 + SWTP*XN)
     &          + Z_AXA*(-0.5*AY1)
          Z_Y3P = Z_PC*PC_Y3P + Z_SXN*SXN_Y3P
     &          + Z_S2*S2_Y3P + Z_AN2*AN2_Y3P
     &          + Z_DP1*( .25*SY1          )
     &          + Z_DP2*( .25*SY2 + SWTP*YN)
     &          + Z_AXA*( 0.5*AX1)
C
          V2(JO,IO) = V2(JO,IO) + Z_X9M*NX(IK,JO) + Z_Y9M*NY(IK,JO)
          V1(JP,IO) = V1(JP,IO) + Z_X9M*NX(IK,JO) + Z_Y9M*NY(IK,JO)
C
          V3(JO,IO) = V3(JO,IO) + Z_X9P*NX(IK,JP) + Z_Y9P*NY(IK,JP)
          V2(JP,IO) = V2(JP,IO) + Z_X9P*NX(IK,JP) + Z_Y9P*NY(IK,JP)
C
          Z2(JO,IO) = Z2(JO,IO) + Z_X0M*NX(IL,JO) + Z_Y0M*NY(IL,JO)
          Z1(JP,IO) = Z1(JP,IO) + Z_X0M*NX(IL,JO) + Z_Y0M*NY(IL,JO)
C
          Z3(JO,IO) = Z3(JO,IO) + Z_X0P*NX(IL,JP) + Z_Y0P*NY(IL,JP)
          Z2(JP,IO) = Z2(JP,IO) + Z_X0P*NX(IL,JP) + Z_Y0P*NY(IL,JP)
C
          B2(JO,IO) = B2(JO,IO) + Z_X1M*NX(IM,JO) + Z_Y1M*NY(IM,JO)
          B1(JP,IO) = B1(JP,IO) + Z_X1M*NX(IM,JO) + Z_Y1M*NY(IM,JO)
C
          B3(JO,IO) = B3(JO,IO) + Z_X1P*NX(IM,JP) + Z_Y1P*NY(IM,JP)
          B2(JP,IO) = B2(JP,IO) + Z_X1P*NX(IM,JP) + Z_Y1P*NY(IM,JP)
C
          A2(JO,IO) = A2(JO,IO) + Z_X2M*NX(IO,JO) + Z_Y2M*NY(IO,JO)
          A1(JP,IO) = A1(JP,IO) + Z_X2M*NX(IO,JO) + Z_Y2M*NY(IO,JO)
C
          A3(JO,IO) = A3(JO,IO) + Z_X2P*NX(IO,JP) + Z_Y2P*NY(IO,JP)
          A2(JP,IO) = A2(JP,IO) + Z_X2P*NX(IO,JP) + Z_Y2P*NY(IO,JP)
C
          C2(JO,IO) = C2(JO,IO) + Z_X3M*NX(IP,JO) + Z_Y3M*NY(IP,JO)
          C1(JP,IO) = C1(JP,IO) + Z_X3M*NX(IP,JO) + Z_Y3M*NY(IP,JO)
C
          C3(JO,IO) = C3(JO,IO) + Z_X3P*NX(IP,JP) + Z_Y3P*NY(IP,JP)
          C2(JP,IO) = C2(JP,IO) + Z_X3P*NX(IP,JP) + Z_Y3P*NY(IP,JP)
C
          DR(JO,LMASS,IO) = DR(JO,LMASS,IO) + MF0(JO)*Z_MJ
          DR(JP,LMASS,IO) = DR(JP,LMASS,IO) + MF0(JO)*Z_MJ
C
          DO 50 N = 1, NBL
            DR(JO,LMAS1(N),IO) = DR(JO,LMAS1(N),IO) + MF1(JO,N)*Z_MJ
            DR(JP,LMAS1(N),IO) = DR(JP,LMAS1(N),IO) + MF1(JO,N)*Z_MJ
C
            Z_NG = Z_X9M*NXG(IK,JO,N) + Z_Y9M*NYG(IK,JO,N)
     &           + Z_X9P*NXG(IK,JP,N) + Z_Y9P*NYG(IK,JP,N)
     &           + Z_X0M*NXG(IL,JO,N) + Z_Y0M*NYG(IL,JO,N)
     &           + Z_X0P*NXG(IL,JP,N) + Z_Y0P*NYG(IL,JP,N)
     &           + Z_X1M*NXG(IM,JO,N) + Z_Y1M*NYG(IM,JO,N)
     &           + Z_X1P*NXG(IM,JP,N) + Z_Y1P*NYG(IM,JP,N)
     &           + Z_X2M*NXG(IO,JO,N) + Z_Y2M*NYG(IO,JO,N)
     &           + Z_X2P*NXG(IO,JP,N) + Z_Y2P*NYG(IO,JP,N)
     &           + Z_X3M*NXG(IP,JO,N) + Z_Y3M*NYG(IP,JO,N)
     &           + Z_X3P*NXG(IP,JP,N) + Z_Y3P*NYG(IP,JP,N)
            DR(JO,LSBLE(N),IO) = DR(JO,LSBLE(N),IO) + Z_NG
            DR(JP,LSBLE(N),IO) = DR(JP,LSBLE(N),IO) + Z_NG
  50      CONTINUE
C
          DO 51 NN = 1, NPOSN
            K = KPOSN(NN)
            Z_NP = Z_X9M*NXP(IK,JO,K) + Z_Y9M*NYP(IK,JO,K)
     &           + Z_X9P*NXP(IK,JP,K) + Z_Y9P*NYP(IK,JP,K)
     &           + Z_X0M*NXP(IL,JO,K) + Z_Y0M*NYP(IL,JO,K)
     &           + Z_X0P*NXP(IL,JP,K) + Z_Y0P*NYP(IL,JP,K)
     &           + Z_X1M*NXP(IM,JO,K) + Z_Y1M*NYP(IM,JO,K)
     &           + Z_X1P*NXP(IM,JP,K) + Z_Y1P*NYP(IM,JP,K)
     &           + Z_X2M*NXP(IO,JO,K) + Z_Y2M*NYP(IO,JO,K)
     &           + Z_X2P*NXP(IO,JP,K) + Z_Y2P*NYP(IO,JP,K)
     &           + Z_X3M*NXP(IP,JO,K) + Z_Y3M*NYP(IP,JO,K)
     &           + Z_X3P*NXP(IP,JP,K) + Z_Y3P*NYP(IP,JP,K)
            DR(JO,LPOSN(K),IO) = DR(JO,LPOSN(K),IO) + Z_NP
            DR(JP,LPOSN(K),IO) = DR(JP,LPOSN(K),IO) + Z_NP
  51      CONTINUE
          Z_AL = Z_X9M*NXA(IK,JO) + Z_Y9M*NYA(IK,JO)
     &         + Z_X9P*NXA(IK,JP) + Z_Y9P*NYA(IK,JP)
     &         + Z_X0M*NXA(IL,JO) + Z_Y0M*NYA(IL,JO)
     &         + Z_X0P*NXA(IL,JP) + Z_Y0P*NYA(IL,JP)
     &         + Z_X1M*NXA(IM,JO) + Z_Y1M*NYA(IM,JO)
     &         + Z_X1P*NXA(IM,JP) + Z_Y1P*NYA(IM,JP)
     &         + Z_X2M*NXA(IO,JO) + Z_Y2M*NYA(IO,JO)
     &         + Z_X2P*NXA(IO,JP) + Z_Y2P*NYA(IO,JP)
     &         + Z_X3M*NXA(IP,JO) + Z_Y3M*NYA(IP,JO)
     &         + Z_X3P*NXA(IP,JP) + Z_Y3P*NYA(IP,JP)
          DR(JO,LALFA,IO) = DR(JO,LALFA,IO) + Z_AL
          DR(JP,LALFA,IO) = DR(JP,LALFA,IO) + Z_AL
C
C=======  N Momentum, part 2  ====================
C
          Z_R9  =          2.0*PC_R9
          Z_R0  =          2.0*PC_R0
          Z_R1  = P1_R1  + 2.0*PC_R1
          Z_R2  = P2_R2  + 2.0*PC_R2
          Z_AN1 = P1_AN1
          Z_AN2 = P2_AN2
C
          Z_MJ = P1_MJ + P2_MJ + 2.0*PC_MJ
C
          Z_X9M =                                  2.0*PC_X9M
          Z_Y9M =                                  2.0*PC_Y9M
C                 
          Z_X9P =                                  2.0*PC_X9P
          Z_Y9P =                                  2.0*PC_Y9P
C                 
          Z_X0M =                                  2.0*PC_X0M
          Z_Y0M =                                  2.0*PC_Y0M
C                 
          Z_X0P =                                  2.0*PC_X0P
          Z_Y0P =                                  2.0*PC_Y0P
C
          Z_X1M = Z_AN1*AN1_X1M                  + 2.0*PC_X1M
          Z_Y1M = Z_AN1*AN1_Y1M                  + 2.0*PC_Y1M
C
          Z_X1P = Z_AN1*AN1_X1P                  + 2.0*PC_X1P
          Z_Y1P = Z_AN1*AN1_Y1P                  + 2.0*PC_Y1P
C
          Z_X2M = Z_AN1*AN1_X2M + Z_AN2*AN2_X2M  + 2.0*PC_X2M
          Z_Y2M = Z_AN1*AN1_Y2M + Z_AN2*AN2_Y2M  + 2.0*PC_Y2M
C
          Z_X2P = Z_AN1*AN1_X2P + Z_AN2*AN2_X2P  + 2.0*PC_X2P
          Z_Y2P = Z_AN1*AN1_Y2P + Z_AN2*AN2_Y2P  + 2.0*PC_Y2P
C
          Z_X3M =                 Z_AN2*AN2_X3M  + 2.0*PC_X3M
          Z_Y3M =                 Z_AN2*AN2_Y3M  + 2.0*PC_Y3M
C
          Z_X3P =                 Z_AN2*AN2_X3P  + 2.0*PC_X3P
          Z_Y3P =                 Z_AN2*AN2_Y3P  + 2.0*PC_Y3P
C
          V5(JO,IO) = V5(JO,IO) - Z_R9
          V4(JP,IO) = V4(JP,IO) + Z_R9
          Z5(JO,IO) = Z5(JO,IO) - Z_R0
          Z4(JP,IO) = Z4(JP,IO) + Z_R0
          B5(JO,IO) = B5(JO,IO) - Z_R1
          B4(JP,IO) = B4(JP,IO) + Z_R1
          A5(JO,IO) = A5(JO,IO) - Z_R2
          A4(JP,IO) = A4(JP,IO) + Z_R2
C
          V2(JO,IO) = V2(JO,IO) - (Z_X9M*NX(IK,JO) + Z_Y9M*NY(IK,JO))
          V1(JP,IO) = V1(JP,IO) + (Z_X9M*NX(IK,JO) + Z_Y9M*NY(IK,JO))
C
          V3(JO,IO) = V3(JO,IO) - (Z_X9P*NX(IK,JP) + Z_Y9P*NY(IK,JP))
          V2(JP,IO) = V2(JP,IO) + (Z_X9P*NX(IK,JP) + Z_Y9P*NY(IK,JP))
C
          Z2(JO,IO) = Z2(JO,IO) - (Z_X0M*NX(IL,JO) + Z_Y0M*NY(IL,JO))
          Z1(JP,IO) = Z1(JP,IO) + (Z_X0M*NX(IL,JO) + Z_Y0M*NY(IL,JO))
C
          Z3(JO,IO) = Z3(JO,IO) - (Z_X0P*NX(IL,JP) + Z_Y0P*NY(IL,JP))
          Z2(JP,IO) = Z2(JP,IO) + (Z_X0P*NX(IL,JP) + Z_Y0P*NY(IL,JP))
C
          B2(JO,IO) = B2(JO,IO) - (Z_X1M*NX(IM,JO) + Z_Y1M*NY(IM,JO))
          B1(JP,IO) = B1(JP,IO) + (Z_X1M*NX(IM,JO) + Z_Y1M*NY(IM,JO))
C
          B3(JO,IO) = B3(JO,IO) - (Z_X1P*NX(IM,JP) + Z_Y1P*NY(IM,JP))
          B2(JP,IO) = B2(JP,IO) + (Z_X1P*NX(IM,JP) + Z_Y1P*NY(IM,JP))
C
          A2(JO,IO) = A2(JO,IO) - (Z_X2M*NX(IO,JO) + Z_Y2M*NY(IO,JO))
          A1(JP,IO) = A1(JP,IO) + (Z_X2M*NX(IO,JO) + Z_Y2M*NY(IO,JO))
C
          A3(JO,IO) = A3(JO,IO) - (Z_X2P*NX(IO,JP) + Z_Y2P*NY(IO,JP))
          A2(JP,IO) = A2(JP,IO) + (Z_X2P*NX(IO,JP) + Z_Y2P*NY(IO,JP))
C
          C2(JO,IO) = C2(JO,IO) - (Z_X3M*NX(IP,JO) + Z_Y3M*NY(IP,JO))
          C1(JP,IO) = C1(JP,IO) + (Z_X3M*NX(IP,JO) + Z_Y3M*NY(IP,JO))
C
          C3(JO,IO) = C3(JO,IO) - (Z_X3P*NX(IP,JP) + Z_Y3P*NY(IP,JP))
          C2(JP,IO) = C2(JP,IO) + (Z_X3P*NX(IP,JP) + Z_Y3P*NY(IP,JP))
C
          DR(JO,LMASS,IO) = DR(JO,LMASS,IO) - MF0(JO)*Z_MJ
          DR(JP,LMASS,IO) = DR(JP,LMASS,IO) + MF0(JO)*Z_MJ
C
          DO 52 N = 1, NBL
            DR(JO,LMAS1(N),IO) = DR(JO,LMAS1(N),IO) - MF1(JO,N)*Z_MJ
            DR(JP,LMAS1(N),IO) = DR(JP,LMAS1(N),IO) + MF1(JO,N)*Z_MJ
C
            Z_NG = Z_X9M*NXG(IK,JO,N) + Z_Y9M*NYG(IK,JO,N)
     &           + Z_X9P*NXG(IK,JP,N) + Z_Y9P*NYG(IK,JP,N)
     &           + Z_X0M*NXG(IL,JO,N) + Z_Y0M*NYG(IL,JO,N)
     &           + Z_X0P*NXG(IL,JP,N) + Z_Y0P*NYG(IL,JP,N)
     &           + Z_X1M*NXG(IM,JO,N) + Z_Y1M*NYG(IM,JO,N)
     &           + Z_X1P*NXG(IM,JP,N) + Z_Y1P*NYG(IM,JP,N)
     &           + Z_X2M*NXG(IO,JO,N) + Z_Y2M*NYG(IO,JO,N)
     &           + Z_X2P*NXG(IO,JP,N) + Z_Y2P*NYG(IO,JP,N)
     &           + Z_X3M*NXG(IP,JO,N) + Z_Y3M*NYG(IP,JO,N)
     &           + Z_X3P*NXG(IP,JP,N) + Z_Y3P*NYG(IP,JP,N)
            DR(JO,LSBLE(N),IO) = DR(JO,LSBLE(N),IO) - Z_NG
            DR(JP,LSBLE(N),IO) = DR(JP,LSBLE(N),IO) + Z_NG
  52      CONTINUE
C
          DO 53 NN = 1, NPOSN
            K = KPOSN(NN)
            Z_NP = Z_X9M*NXP(IK,JO,N) + Z_Y9M*NYP(IK,JO,N)
     &           + Z_X9P*NXP(IK,JP,N) + Z_Y9P*NYP(IK,JP,N)
     &           + Z_X0M*NXP(IL,JO,N) + Z_Y0M*NYP(IL,JO,N)
     &           + Z_X0P*NXP(IL,JP,N) + Z_Y0P*NYP(IL,JP,N)
     &           + Z_X1M*NXP(IM,JO,N) + Z_Y1M*NYP(IM,JO,N)
     &           + Z_X1P*NXP(IM,JP,N) + Z_Y1P*NYP(IM,JP,N)
     &           + Z_X2M*NXP(IO,JO,N) + Z_Y2M*NYP(IO,JO,N)
     &           + Z_X2P*NXP(IO,JP,N) + Z_Y2P*NYP(IO,JP,N)
     &           + Z_X3M*NXP(IP,JO,N) + Z_Y3M*NYP(IP,JO,N)
     &           + Z_X3P*NXP(IP,JP,N) + Z_Y3P*NYP(IP,JP,N)
            DR(JO,LPOSN(K),IO) = DR(JO,LPOSN(K),IO) - Z_NP
            DR(JP,LPOSN(K),IO) = DR(JP,LPOSN(K),IO) + Z_NP
  53      CONTINUE
          Z_AL = Z_X9M*NXA(IK,JO) + Z_Y9M*NYA(IK,JO)
     &         + Z_X9P*NXA(IK,JP) + Z_Y9P*NYA(IK,JP)
     &         + Z_X0M*NXA(IL,JO) + Z_Y0M*NYA(IL,JO)
     &         + Z_X0P*NXA(IL,JP) + Z_Y0P*NYA(IL,JP)
     &         + Z_X1M*NXA(IM,JO) + Z_Y1M*NYA(IM,JO)
     &         + Z_X1P*NXA(IM,JP) + Z_Y1P*NYA(IM,JP)
     &         + Z_X2M*NXA(IO,JO) + Z_Y2M*NYA(IO,JO)
     &         + Z_X2P*NXA(IO,JP) + Z_Y2P*NYA(IO,JP)
     &         + Z_X3M*NXA(IP,JO) + Z_Y3M*NYA(IP,JO)
     &         + Z_X3P*NXA(IP,JP) + Z_Y3P*NYA(IP,JP)
          DR(JO,LALFA,IO) = DR(JO,LALFA,IO) - Z_AL
          DR(JP,LALFA,IO) = DR(JP,LALFA,IO) + Z_AL
C
          DR(JO,1,IO) = DR(JO,1,IO) + 2.0*PIM
          DR(JP,1,IO) = DR(JP,1,IO) - 2.0*PIP
C
C
C---- Are we on either side of a stagnation streamtube (element streamlines)?
C
          IF(JSTAG(JO).LT.0 .OR. JSTAG(JO+1).GT.0) THEN
C
           IF (JSTAG(JO).LT.0) THEN
             IS = ABS(JSTAG(JO))
             SGN = 1.0
            ELSE
             IS = ABS(JSTAG(JO+1))
             SGN = -1.0
           ENDIF
           N = (IS+1)/2
C
C
C--------- calculate dU/dA correction UCORR
           UTMP = -.25*PCWT
C
           UCORR  =  UTMP*(Q1+Q2)*(SXSM-SXSP)*S1INV*S2INV
           UC_QQ  =  UTMP        *(SXSM-SXSP)*S1INV*S2INV
           UC_SXS =  UTMP*(Q1+Q2)            *S1INV*S2INV
           UC_S1  = -UCORR*S1INV
           UC_S2  = -UCORR*S2INV
C
           UC_Q1 = UC_QQ
           UC_Q2 = UC_QQ
C
           UC_AN1 = UC_Q1*Q1_AN1
           UC_AN2 = UC_Q2*Q2_AN2
C
C--------- assemble  UC(R,x,y;m)  sensitivities
           UC_R1  = UC_Q1*Q1_R1
           UC_R2  = UC_Q2*Q2_R2
C
           UC_X1M = UC_S1*S1_X1M + UC_AN1*AN1_X1M + UC_SXS*(-SY2M)
           UC_Y1M = UC_S1*S1_Y1M + UC_AN1*AN1_Y1M + UC_SXS*( SX2M)
           UC_X1P = UC_S1*S1_X1P + UC_AN1*AN1_X1P + UC_SXS*( SY2P)
           UC_Y1P = UC_S1*S1_Y1P + UC_AN1*AN1_Y1P + UC_SXS*(-SX2P)
           UC_X2M = UC_S1*S1_X2M + UC_AN1*AN1_X2M + UC_SXS*( SY2M)
     &            + UC_S2*S2_X2M + UC_AN2*AN2_X2M + UC_SXS*( SY1M)
           UC_Y2M = UC_S1*S1_Y2M + UC_AN1*AN1_Y2M + UC_SXS*(-SX2M)
     &            + UC_S2*S2_Y2M + UC_AN2*AN2_Y2M + UC_SXS*(-SX1M)
           UC_X2P = UC_S1*S1_X2P + UC_AN1*AN1_X2P + UC_SXS*(-SY2P)
     &            + UC_S2*S2_X2P + UC_AN2*AN2_X2P + UC_SXS*(-SY1P)
           UC_Y2P = UC_S1*S1_Y2P + UC_AN1*AN1_Y2P + UC_SXS*( SX2P)
     &            + UC_S2*S2_Y2P + UC_AN2*AN2_Y2P + UC_SXS*( SX1P)
           UC_X3M = UC_S2*S2_X3M + UC_AN2*AN2_X3M + UC_SXS*(-SY1M)
           UC_Y3M = UC_S2*S2_Y3M + UC_AN2*AN2_Y3M + UC_SXS*( SX1M)
           UC_X3P = UC_S2*S2_X3P + UC_AN2*AN2_X3P + UC_SXS*( SY1P)
           UC_Y3P = UC_S2*S2_Y3P + UC_AN2*AN2_Y3P + UC_SXS*(-SX1P)
C
           UC_MJ = UC_Q1*Q1_MJ + UC_Q2*Q2_MJ
C
C
C--------- calculate dU/dn
C
CCC          SX1 = 0.5*(X2M - X1M + X2P - X1P)
CCC          SY1 = 0.5*(Y2M - Y1M + Y2P - Y1P)
CCC
CCC          SX2 = 0.5*(X3M - X2M + X3P - X2P)
CCC          SY2 = 0.5*(Y3M - Y2M + Y3P - Y2P)
C
           UDN    = SGN*(Q1+Q2)*(SX1*SY2-SY1*SX2)*S1INV*S2INV/(S1+S2)
           UD_QQ  = SGN        *(SX1*SY2-SY1*SX2)*S1INV*S2INV/(S1+S2)
           UD_SXS = SGN*(Q1+Q2)                  *S1INV*S2INV/(S1+S2)
           UD_S1  = -UDN*S1INV - UDN/(S1+S2)
           UD_S2  = -UDN*S2INV - UDN/(S1+S2)
C
           UD_AN1 = UD_QQ*Q1_AN1
           UD_AN2 = UD_QQ*Q2_AN2
C
           UD_SX1 =  UD_SXS*SY2
           UD_SY1 = -UD_SXS*SX2
           UD_SX2 = -UD_SXS*SY1
           UD_SY2 =  UD_SXS*SX1
C
           UD_X1M = UD_S1*S1_X1M + UD_AN1*AN1_X1M + UD_SX1*(-SWTM)
           UD_Y1M = UD_S1*S1_Y1M + UD_AN1*AN1_Y1M + UD_SY1*(-SWTM)
           UD_X1P = UD_S1*S1_X1P + UD_AN1*AN1_X1P + UD_SX1*(-SWTP)
           UD_Y1P = UD_S1*S1_Y1P + UD_AN1*AN1_Y1P + UD_SY1*(-SWTP)
           UD_X2M = UD_S1*S1_X2M + UD_AN1*AN1_X2M + UD_SX1*(+SWTM)
     &            + UD_S2*S2_X2M + UD_AN2*AN2_X2M + UD_SX2*(-SWTM)
           UD_Y2M = UD_S1*S1_Y2M + UD_AN1*AN1_Y2M + UD_SY1*(+SWTM)
     &            + UD_S2*S2_Y2M + UD_AN2*AN2_Y2M + UD_SY2*(-SWTM)
           UD_X2P = UD_S1*S1_X2P + UD_AN1*AN1_X2P + UD_SX1*(+SWTP)
     &            + UD_S2*S2_X2P + UD_AN2*AN2_X2P + UD_SX2*(-SWTP)
           UD_Y2P = UD_S1*S1_Y2P + UD_AN1*AN1_Y2P + UD_SY1*(+SWTP)
     &            + UD_S2*S2_Y2P + UD_AN2*AN2_Y2P + UD_SY2*(-SWTP)
           UD_X3M = UD_S2*S2_X3M + UD_AN2*AN2_X3M + UD_SX2*(+SWTM)
           UD_Y3M = UD_S2*S2_Y3M + UD_AN2*AN2_Y3M + UD_SY2*(+SWTM)
           UD_X3P = UD_S2*S2_X3P + UD_AN2*AN2_X3P + UD_SX2*(+SWTP)
           UD_Y3P = UD_S2*S2_Y3P + UD_AN2*AN2_Y3P + UD_SY2*(+SWTP)
C
           UD_R1  = UD_QQ* Q1_R1
           UD_R2  = UD_QQ* Q2_R2
           UD_MJ  = UD_QQ*(Q1_MJ + Q2_MJ)
C
C--------- calculate  Ui(R,n)  and assemble its sensitivities
           WT1 = 0.5
           WT2 = 0.5
           UINV(IO,IS) = WT1*Q1 + WT2*Q2 + UCORR
     &       - 0.5*(WT1*AN1 + WT2*AN2)*UDN
C
           UI_R1  = WT1*Q1_R1
           UI_R2  = WT2*Q2_R2
           UI_AN1 = WT1*Q1_AN1 - 0.5*WT1*UDN
           UI_AN2 = WT2*Q2_AN2 - 0.5*WT2*UDN
           UI_UD  = -0.5*(WT1*AN1 + WT2*AN2)
           UI_MJ  = WT1*Q1_MJ
     &            + WT2*Q2_MJ
ccc        UI_UC  = 1.0
C
CCC HHY Bug fix for grid doubling problem (where UEDG(ILENEW+1,IS) went 
CCC     negative and blew up the LE BL initialization).  
CCC     Fix is clamp UINV and derivs to zero, put out warning to user
CCC     A clamped UINV at the LE or on the blade will blow in the BL routines!
C
           IF(UINV(IO,IS).LT.0.0) THEN
             IF(IO.GT.ILEB(N))
     &         WRITE(*,*) 'UINV<0 at I,IS,UINV ',IO,IS,UINV(IO,IS)
ccc             write(*,*) 'Q1,Q2,UCORR,UDN ',Q1,Q2,UCORR,UDN
             UINV(IO,IS) = 0.0
             UI_R1  = 0.0
             UI_R2  = 0.0
             UI_AN1 = 0.0
             UI_AN2 = 0.0
             UI_UD  = 0.0
             UI_MJ  = 0.0
ccc          UI_UC  = 0.0
           ENDIF
C
           UI_X1M = UC_X1M + UI_AN1*AN1_X1M + UI_UD*UD_X1M
           UI_Y1M = UC_Y1M + UI_AN1*AN1_Y1M + UI_UD*UD_Y1M
           UI_X1P = UC_X1P + UI_AN1*AN1_X1P + UI_UD*UD_X1P
           UI_Y1P = UC_Y1P + UI_AN1*AN1_Y1P + UI_UD*UD_Y1P
           UI_X2M = UC_X2M + UI_AN1*AN1_X2M
     &                     + UI_AN2*AN2_X2M + UI_UD*UD_X2M
           UI_Y2M = UC_Y2M + UI_AN1*AN1_Y2M
     &                     + UI_AN2*AN2_Y2M + UI_UD*UD_Y2M
           UI_X2P = UC_X2P + UI_AN1*AN1_X2P
     &                     + UI_AN2*AN2_X2P + UI_UD*UD_X2P
           UI_Y2P = UC_Y2P + UI_AN1*AN1_Y2P
     &                     + UI_AN2*AN2_Y2P + UI_UD*UD_Y2P
           UI_X3M = UC_X3M + UI_AN2*AN2_X3M + UI_UD*UD_X3M
           UI_Y3M = UC_Y3M + UI_AN2*AN2_Y3M + UI_UD*UD_Y3M
           UI_X3P = UC_X3P + UI_AN2*AN2_X3P + UI_UD*UD_X3P
           UI_Y3P = UC_Y3P + UI_AN2*AN2_Y3P + UI_UD*UD_Y3P
C
C
           DUIDR1(IO,IS) = UI_R1 + UC_R1 + UI_UD*UD_R1
           DUIDR2(IO,IS) = UI_R2 + UC_R2 + UI_UD*UD_R2
C
           DUIN1M(IO,IS) = UI_X1M*NX(IM,JO) + UI_Y1M*NY(IM,JO)
           DUIN1P(IO,IS) = UI_X1P*NX(IM,JP) + UI_Y1P*NY(IM,JP)
           DUIN2M(IO,IS) = UI_X2M*NX(IO,JO) + UI_Y2M*NY(IO,JO)
           DUIN2P(IO,IS) = UI_X2P*NX(IO,JP) + UI_Y2P*NY(IO,JP)
           DUIN3M(IO,IS) = UI_X3M*NX(IP,JO) + UI_Y3M*NY(IP,JO)
           DUIN3P(IO,IS) = UI_X3P*NX(IP,JP) + UI_Y3P*NY(IP,JP)
C
           DUIDMS(IO,IS) = MF0(JO)*(UI_MJ + UC_MJ + UI_UD*UD_MJ)
           DO 64 N = 1, NBL
            DUIDM1(IO,IS,N) = MF1(JO,N)*(UI_MJ + UC_MJ + UI_UD*UD_MJ)
            DUIDNG(IO,IS,N) = UI_X1M*NXG(IM,JO,N) + UI_Y1M*NYG(IM,JO,N)
     &                      + UI_X1P*NXG(IM,JP,N) + UI_Y1P*NYG(IM,JP,N)
     &                      + UI_X2M*NXG(IO,JO,N) + UI_Y2M*NYG(IO,JO,N)
     &                      + UI_X2P*NXG(IO,JP,N) + UI_Y2P*NYG(IO,JP,N)
     &                      + UI_X3M*NXG(IP,JO,N) + UI_Y3M*NYG(IP,JO,N)
     &                      + UI_X3P*NXG(IP,JP,N) + UI_Y3P*NYG(IP,JP,N)
  64       CONTINUE
C
           DO 65 NN = 1, NPOSN
            K = KPOSN(NN)
            DUIDNP(IO,IS,K) = UI_X1M*NXP(IM,JO,K) + UI_Y1M*NYP(IM,JO,K)
     &                      + UI_X1P*NXP(IM,JP,K) + UI_Y1P*NYP(IM,JP,K)
     &                      + UI_X2M*NXP(IO,JO,K) + UI_Y2M*NYP(IO,JO,K)
     &                      + UI_X2P*NXP(IO,JP,K) + UI_Y2P*NYP(IO,JP,K)
     &                      + UI_X3M*NXP(IP,JO,K) + UI_Y3M*NYP(IP,JO,K)
     &                      + UI_X3P*NXP(IP,JP,K) + UI_Y3P*NYP(IP,JP,K)
  65       CONTINUE
           DUIDAL(IO,IS) = UI_X1M*NXA(IM,JO) + UI_Y1M*NYA(IM,JO)
     &                   + UI_X1P*NXA(IM,JP) + UI_Y1P*NYA(IM,JP)
     &                   + UI_X2M*NXA(IO,JO) + UI_Y2M*NYA(IO,JO)
     &                   + UI_X2P*NXA(IO,JP) + UI_Y2P*NYA(IO,JP)
     &                   + UI_X3M*NXA(IP,JO) + UI_Y3M*NYA(IP,JO)
     &                   + UI_X3P*NXA(IP,JP) + UI_Y3P*NYA(IP,JP)
C
C
C--------- set stagnation density
           RST1     = R1 * (1.0 - 0.5*Q1*Q1/HINF)**(-1.0/GM1)
           RST1_R1  = RST1 / R1
           RST1_Q1  = RST1 * Q1 / (GM1*(HINF - 0.5*Q1*Q1))
C
           RST2     = R2 * (1.0 - 0.5*Q2*Q2/HINF)**(-1.0/GM1)
           RST2_R2  = RST2 / R2
           RST2_Q2  = RST2 * Q2 / (GM1*(HINF - 0.5*Q2*Q2))
C
C--------- RSTA( R  Q(R An m) )
           RSTA     = WT1*RST1    + WT2*RST2
           RSTA_R1  = WT1*RST1_R1
           RSTA_Q1  = WT1*RST1_Q1
           RSTA_R2  =               WT2*RST2_R2
           RSTA_Q2  =               WT2*RST2_Q2
C
C--------- RSTA( R An(x y) m )
           RSTA_R1  = RSTA_Q1*Q1_R1  +  RSTA_R1
           RSTA_R2  = RSTA_Q2*Q2_R2  +  RSTA_R2
C
           RSTA_AN1 = RSTA_Q1*Q1_AN1
           RSTA_AN2 = RSTA_Q2*Q2_AN2
C
           RSTA_MJ  = RSTA_Q1*Q1_MJ
     &              + RSTA_Q2*Q2_MJ
C
           UI = UINV(IO,IS)
C
C--------- RHOI( RSTA(R An m) UI(R An UD m UC) )
           RHOI(IO,IS) = RSTA*(1.0 - 0.5*UI*UI/HINF)**(1.0/GM1)
           RH_RSTA     = RHOI(IO,IS) / RSTA
           RH_UI       = RHOI(IO,IS) * (-UI/(GM1*(HINF - 0.5*UI*UI)))
C
C--------- RHOI( R An(x y) UD(R x y m) m UC(R x y m) )
           RH_R1  = RH_UI*UI_R1  + RH_RSTA*RSTA_R1
           RH_R2  = RH_UI*UI_R2  + RH_RSTA*RSTA_R2
           RH_AN1 = RH_UI*UI_AN1 + RH_RSTA*RSTA_AN1
           RH_AN2 = RH_UI*UI_AN2 + RH_RSTA*RSTA_AN2
           RH_UD  = RH_UI*UI_UD
           RH_MJ  = RH_UI*UI_MJ  + RH_RSTA*RSTA_MJ
           RH_UC  = RH_UI
C
           RH_X1M = RH_AN1*AN1_X1M + RH_UC*UC_X1M + RH_UD*UD_X1M
           RH_Y1M = RH_AN1*AN1_Y1M + RH_UC*UC_Y1M + RH_UD*UD_Y1M
           RH_X1P = RH_AN1*AN1_X1P + RH_UC*UC_X1P + RH_UD*UD_X1P
           RH_Y1P = RH_AN1*AN1_Y1P + RH_UC*UC_Y1P + RH_UD*UD_Y1P
           RH_X2M = RH_AN1*AN1_X2M + RH_UC*UC_X2M + RH_UD*UD_X2M
     &            + RH_AN2*AN2_X2M
           RH_Y2M = RH_AN1*AN1_Y2M + RH_UC*UC_Y2M + RH_UD*UD_Y2M
     &            + RH_AN2*AN2_Y2M
           RH_X2P = RH_AN1*AN1_X2P + RH_UC*UC_X2P + RH_UD*UD_X2P
     &            + RH_AN2*AN2_X2P
           RH_Y2P = RH_AN1*AN1_Y2P + RH_UC*UC_Y2P + RH_UD*UD_Y2P
     &            + RH_AN2*AN2_Y2P
           RH_X3M = RH_AN2*AN2_X3M + RH_UC*UC_X3M + RH_UD*UD_X3M
           RH_Y3M = RH_AN2*AN2_Y3M + RH_UC*UC_Y3M + RH_UD*UD_Y3M
           RH_X3P = RH_AN2*AN2_X3P + RH_UC*UC_X3P + RH_UD*UD_X3P
           RH_Y3P = RH_AN2*AN2_Y3P + RH_UC*UC_Y3P + RH_UD*UD_Y3P
C
C
           DRHDR1(IO,IS) = RH_R1 + RH_UC*UC_R1 + RH_UD*UD_R1
           DRHDR2(IO,IS) = RH_R2 + RH_UC*UC_R2 + RH_UD*UD_R2
C
           DRHN1M(IO,IS) = RH_X1M*NX(IM,JO) + RH_Y1M*NY(IM,JO)
           DRHN1P(IO,IS) = RH_X1P*NX(IM,JP) + RH_Y1P*NY(IM,JP)
           DRHN2M(IO,IS) = RH_X2M*NX(IO,JO) + RH_Y2M*NY(IO,JO)
           DRHN2P(IO,IS) = RH_X2P*NX(IO,JP) + RH_Y2P*NY(IO,JP)
           DRHN3M(IO,IS) = RH_X3M*NX(IP,JO) + RH_Y3M*NY(IP,JO)
           DRHN3P(IO,IS) = RH_X3P*NX(IP,JP) + RH_Y3P*NY(IP,JP)
C
           DRHDMS(IO,IS) = MF0(JO)*(RH_MJ + RH_UC*UC_MJ + RH_UD*UD_MJ)
           DO 74 N = 1, NBL
            DRHDM1(IO,IS,N) =
     &                   MF1(JO,N)*(UI_MJ + RH_UC*UC_MJ + UI_UD*UD_MJ)
            DRHDNG(IO,IS,N) = RH_X1M*NXG(IM,JO,N) + RH_Y1M*NYG(IM,JO,N)
     &                      + RH_X1P*NXG(IM,JP,N) + RH_Y1P*NYG(IM,JP,N)
     &                      + RH_X2M*NXG(IO,JO,N) + RH_Y2M*NYG(IO,JO,N)
     &                      + RH_X2P*NXG(IO,JP,N) + RH_Y2P*NYG(IO,JP,N)
     &                      + RH_X3M*NXG(IP,JO,N) + RH_Y3M*NYG(IP,JO,N)
     &                      + RH_X3P*NXG(IP,JP,N) + RH_Y3P*NYG(IP,JP,N)
  74       CONTINUE
C
           DO 75 NN = 1, NPOSN
            K = KPOSN(NN)
            DRHDNP(IO,IS,K) = RH_X1M*NXP(IM,JO,K) + RH_Y1M*NYP(IM,JO,K)
     &                      + RH_X1P*NXP(IM,JP,K) + RH_Y1P*NYP(IM,JP,K)
     &                      + RH_X2M*NXP(IO,JO,K) + RH_Y2M*NYP(IO,JO,K)
     &                      + RH_X2P*NXP(IO,JP,K) + RH_Y2P*NYP(IO,JP,K)
     &                      + RH_X3M*NXP(IP,JO,K) + RH_Y3M*NYP(IP,JO,K)
     &                      + RH_X3P*NXP(IP,JP,K) + RH_Y3P*NYP(IP,JP,K)
  75       CONTINUE
           DRHDAL(IO,IS) = RH_X1M*NXA(IM,JO) + RH_Y1M*NYA(IM,JO)
     &                   + RH_X1P*NXA(IM,JP) + RH_Y1P*NYA(IM,JP)
     &                   + RH_X2M*NXA(IO,JO) + RH_Y2M*NYA(IO,JO)
     &                   + RH_X2P*NXA(IO,JP) + RH_Y2P*NYA(IO,JP)
     &                   + RH_X3M*NXA(IP,JO) + RH_Y3M*NYA(IP,JO)
     &                   + RH_X3P*NXA(IP,JP) + RH_Y3P*NYA(IP,JP)
C
C
           DUDN(IO,IS) = UDN
           DUNDR1(IO,IS) = UD_R1
           DUNDR2(IO,IS) = UD_R2
C
           DUNN1M(IO,IS) = UD_X1M*NX(IM,JO) + UD_Y1M*NY(IM,JO)
           DUNN1P(IO,IS) = UD_X1P*NX(IM,JP) + UD_Y1P*NY(IM,JP)
           DUNN2M(IO,IS) = UD_X2M*NX(IO,JO) + UD_Y2M*NY(IO,JO)
           DUNN2P(IO,IS) = UD_X2P*NX(IO,JP) + UD_Y2P*NY(IO,JP)
           DUNN3M(IO,IS) = UD_X3M*NX(IP,JO) + UD_Y3M*NY(IP,JO)
           DUNN3P(IO,IS) = UD_X3P*NX(IP,JP) + UD_Y3P*NY(IP,JP)
C
           DUNDMS(IO,IS) = MF0(JO)*UD_MJ
           DO 86 N = 1, NBL
            DUNDM1(IO,IS,N) = MF1(JO,N)*UD_MJ
            DUNDNG(IO,IS,N) = UD_X1M*NXG(IM,JO,N) + UD_Y1M*NYG(IM,JO,N)
     &                      + UD_X1P*NXG(IM,JP,N) + UD_Y1P*NYG(IM,JP,N)
     &                      + UD_X2M*NXG(IO,JO,N) + UD_Y2M*NYG(IO,JO,N)
     &                      + UD_X2P*NXG(IO,JP,N) + UD_Y2P*NYG(IO,JP,N)
     &                      + UD_X3M*NXG(IP,JO,N) + UD_Y3M*NYG(IP,JO,N)
     &                      + UD_X3P*NXG(IP,JP,N) + UD_Y3P*NYG(IP,JP,N)
   86      CONTINUE
C
           DO 87 NN = 1, NPOSN
            K = KPOSN(NN)
            DUNDNP(IO,IS,K) = UD_X1M*NXP(IM,JO,K) + UD_Y1M*NYP(IM,JO,K)
     &                      + UD_X1P*NXP(IM,JP,K) + UD_Y1P*NYP(IM,JP,K)
     &                      + UD_X2M*NXP(IO,JO,K) + UD_Y2M*NYP(IO,JO,K)
     &                      + UD_X2P*NXP(IO,JP,K) + UD_Y2P*NYP(IO,JP,K)
     &                      + UD_X3M*NXP(IP,JO,K) + UD_Y3M*NYP(IP,JO,K)
     &                      + UD_X3P*NXP(IP,JP,K) + UD_Y3P*NYP(IP,JP,K)
  87       CONTINUE
           DUNDAL(IO,IS) = UD_X1M*NXA(IM,JO) + UD_Y1M*NYA(IM,JO)
     &                   + UD_X1P*NXA(IM,JP) + UD_Y1P*NYA(IM,JP)
     &                   + UD_X2M*NXA(IO,JO) + UD_Y2M*NYA(IO,JO)
     &                   + UD_X2P*NXA(IO,JP) + UD_Y2P*NYA(IO,JP)
     &                   + UD_X3M*NXA(IP,JO) + UD_Y3M*NYA(IP,JO)
     &                   + UD_X3P*NXA(IP,JP) + UD_Y3P*NYA(IP,JP)
C
          ENDIF
C
          PI(IO,JO) = PIM
          PI(IO,JP) = PIP
C
          IF(IO.EQ.II-1) GO TO 100
C
C-------- set shorthand for next streamtube station
          SX1M = SX2M
          SX1P = SX2P
          SY1M = SY2M
          SY1P = SY2P
          SX1 = SX2
          SY1 = SY2
          AX1 = AX2
          AY1 = AY2
C
          S9     = S0
          S9_X9M = S0_X0M
          S9_Y9M = S0_Y0M
          S9_X9P = S0_X0P
          S9_Y9P = S0_Y0P
          S9_X0M = S0_X1M
          S9_Y0M = S0_Y1M
          S9_X0P = S0_X1P
          S9_Y0P = S0_Y1P
C
          S0     = S1
          S0_X0M = S1_X1M
          S0_Y0M = S1_Y1M
          S0_X0P = S1_X1P
          S0_Y0P = S1_Y1P
          S0_X1M = S1_X2M
          S0_Y1M = S1_Y2M
          S0_X1P = S1_X2P
          S0_Y1P = S1_Y2P
C
          S1     = S2
          S1INV  = S2INV
          S1_X1M = S2_X2M
          S1_Y1M = S2_Y2M
          S1_X1P = S2_X2P
          S1_Y1P = S2_Y2P
          S1_X2M = S2_X3M
          S1_Y2M = S2_Y3M
          S1_X2P = S2_X3P
          S1_Y2P = S2_Y3P
C
          AN9     = AN0
          AN9_X9M = AN0_X0M
          AN9_Y9M = AN0_Y0M
          AN9_X9P = AN0_X0P
          AN9_Y9P = AN0_Y0P
          AN9_X0M = AN0_X1M
          AN9_Y0M = AN0_Y1M
          AN9_X0P = AN0_X1P
          AN9_Y0P = AN0_Y1P
C
          AN0     = AN1
          AN0_X0M = AN1_X1M
          AN0_Y0M = AN1_Y1M
          AN0_X0P = AN1_X1P
          AN0_Y0P = AN1_Y1P
          AN0_X1M = AN1_X2M
          AN0_Y1M = AN1_Y2M
          AN0_X1P = AN1_X2P
          AN0_Y1P = AN1_Y2P
C
          AN1     = AN2
          AN1_X1M = AN2_X2M
          AN1_Y1M = AN2_Y2M
          AN1_X1P = AN2_X2P
          AN1_Y1P = AN2_Y2P
          AN1_X2M = AN2_X3M
          AN1_Y2M = AN2_Y3M
          AN1_X2P = AN2_X3P
          AN1_Y2P = AN2_Y3P
C
          R1 = R2
C
          QS1    = QS2
          QS1_Q9 = QS2_Q0
          QS1_Q0 = QS2_Q1
          QS1_Q1 = QS2_Q2
          QS1_S9 = QS2_S0
          QS1_S0 = QS2_S1
          QS1_S1 = QS2_S2
C
          Q9     = Q0
          Q9_R9  = Q0_R0
          Q9_AN9 = Q0_AN0
          Q9_MJ  = Q0_MJ
C
          Q0     = Q1
          Q0_R0  = Q1_R1
          Q0_AN0 = Q1_AN1
          Q0_MJ  = Q1_MJ
C
          Q1     = Q2
          Q1_R1  = Q2_R2
          Q1_AN1 = Q2_AN2
          Q1_MJ  = Q2_MJ
C
          P0     = P1
          P0_R0  = P1_R1
          P0_AN0 = P1_AN1
          P0_MJ  = P1_MJ
C
          P1     = P2
          P1_R1  = P2_R2
          P1_AN1 = P2_AN2
          P1_MJ  = P2_MJ
C
          MSQ1    = MSQ2
          MSQ1_Q1 = MSQ2_Q2
C
          PST1     = PST2
          PST1_P1  = PST2_P2
          PST1_Q1  = PST2_Q2
          PST1_QS1 = PST2_QS2
C
  100   CONTINUE
C
        IK = II-3
        IL = II-2
        IM = II-1
C
        MFRJ = MFRACT(JO)
        PEXSUM = PEXSUM + MFRJ*P2
C
C------ set exit pressure (used by choked solver only)
        REZ = P2
        Z_R0  = 0.
        Z_AN0 = 0.
        Z_R1  = 0.
        Z_AN1 = 0.
        Z_R2  = P2_R2
        Z_AN2 = P2_AN2
        Z_MJ  = P2_MJ
C
C------ extrapolate exit pressure (used by supersonic solver only)
        IF(IFFBC.GE.4) THEN
         REZ = P2 - 2.0*P1 + P0
         Z_R0  =  P0_R0
         Z_AN0 =  P0_AN0
         Z_R1  = -2.0*P1_R1
         Z_AN1 = -2.0*P1_AN1
         Z_R2  =  P2_R2
         Z_AN2 =  P2_AN2
         Z_MJ  = P2_MJ - 2.0*P1_MJ + P0_MJ
        ENDIF
C
C------ put pressure condition in convenient dummy S-momentum equation slot
        Z_X0M = Z_AN0*AN0_X0M
        Z_Y0M = Z_AN0*AN0_Y0M
        Z_X0P = Z_AN0*AN0_X0P
        Z_Y0P = Z_AN0*AN0_Y0P
        Z_X1M = Z_AN1*AN1_X1M + Z_AN0*AN0_X1M
        Z_Y1M = Z_AN1*AN1_Y1M + Z_AN0*AN0_Y1M
        Z_X1P = Z_AN1*AN1_X1P + Z_AN0*AN0_X1P
        Z_Y1P = Z_AN1*AN1_Y1P + Z_AN0*AN0_Y1P
        Z_X2M = Z_AN2*AN2_X2M + Z_AN1*AN1_X2M
        Z_Y2M = Z_AN2*AN2_Y2M + Z_AN1*AN1_Y2M
        Z_X2P = Z_AN2*AN2_X2P + Z_AN1*AN1_X2P
        Z_Y2P = Z_AN2*AN2_Y2P + Z_AN1*AN1_Y2P
        Z_X3M =                 Z_AN2*AN2_X3M
        Z_Y3M =                 Z_AN2*AN2_Y3M
        Z_X3P =                 Z_AN2*AN2_X3P
        Z_Y3P =                 Z_AN2*AN2_Y3P
C
        V8(JO,II) = MFRJ*Z_R0
        Z8(JO,II) = MFRJ*Z_R1
        B8(JO,II) = MFRJ*Z_R2
C
        V6(JO,II) = MFRJ*(Z_X0M*NX(IK,JO) + Z_Y0M*NY(IK,JO))
        V7(JO,II) = MFRJ*(Z_X0P*NX(IK,JP) + Z_Y0P*NY(IK,JP))
        Z6(JO,II) = MFRJ*(Z_X1M*NX(IL,JO) + Z_Y1M*NY(IL,JO))
        Z7(JO,II) = MFRJ*(Z_X1P*NX(IL,JP) + Z_Y1P*NY(IL,JP))
        B6(JO,II) = MFRJ*(Z_X2M*NX(IM,JO) + Z_Y2M*NY(IM,JO))
        B7(JO,II) = MFRJ*(Z_X2P*NX(IM,JP) + Z_Y2P*NY(IM,JP))
        A6(JO,II) = MFRJ*(Z_X3M*NX(II,JO) + Z_Y3M*NY(II,JO))
        A7(JO,II) = MFRJ*(Z_X3P*NX(II,JP) + Z_Y3P*NY(II,JP))
C
        DR(JZ,LMASS,II) = MFRJ*(MF0(JO)*Z_MJ)
C
        DO 102 N = 1, NBL
          DR(JZ,LMAS1(N),II) = MFRJ*(MF1(JO,N)*Z_MJ)
          DR(JZ,LSBLE(N),II) = MFRJ*
     &                    ( Z_X0M*NXG(IK,JO,N) + Z_Y0M*NYG(IK,JO,N)
     &                    + Z_X0P*NXG(IK,JP,N) + Z_Y0P*NYG(IK,JP,N)
     &                    + Z_X1M*NXG(IL,JO,N) + Z_Y1M*NYG(IL,JO,N)
     &                    + Z_X1P*NXG(IL,JP,N) + Z_Y1P*NYG(IL,JP,N)
     &                    + Z_X2M*NXG(IM,JO,N) + Z_Y2M*NYG(IM,JO,N)
     &                    + Z_X2P*NXG(IM,JP,N) + Z_Y2P*NYG(IM,JP,N)
     &                    + Z_X3M*NXG(II,JO,N) + Z_Y3M*NYG(II,JO,N)
     &                    + Z_X3P*NXG(II,JP,N) + Z_Y3P*NYG(II,JP,N) )
  102   CONTINUE
C
        DO 103 NN = 1, NPOSN
          K = KPOSN(NN)
          DR(JZ,LPOSN(K),II) = MFRJ*
     &                    ( Z_X0M*NXP(IK,JO,K) + Z_Y0M*NYP(IK,JO,K)
     &                    + Z_X0P*NXP(IK,JP,K) + Z_Y0P*NYP(IK,JP,K)
     &                    + Z_X1M*NXP(IL,JO,K) + Z_Y1M*NYP(IL,JO,K)
     &                    + Z_X1P*NXP(IL,JP,K) + Z_Y1P*NYP(IL,JP,K)
     &                    + Z_X2M*NXP(IM,JO,K) + Z_Y2M*NYP(IM,JO,K)
     &                    + Z_X2P*NXP(IM,JP,K) + Z_Y2P*NYP(IM,JP,K)
     &                    + Z_X3M*NXP(II,JO,K) + Z_Y3M*NYP(II,JO,K)
     &                    + Z_X3P*NXP(II,JP,K) + Z_Y3P*NYP(II,JP,K) )
  103   CONTINUE
        DR(JZ,LALFA,II) = MFRJ*
     &          ( Z_X0M*NXA(IK,JO) + Z_Y0M*NYA(IK,JO)
     &          + Z_X0P*NXA(IK,JP) + Z_Y0P*NYA(IK,JP)
     &          + Z_X1M*NXA(IL,JO) + Z_Y1M*NYA(IL,JO)
     &          + Z_X1P*NXA(IL,JP) + Z_Y1P*NYA(IL,JP)
     &          + Z_X2M*NXA(IM,JO) + Z_Y2M*NYA(IM,JO)
     &          + Z_X2P*NXA(IM,JP) + Z_Y2P*NYA(IM,JP)
     &          + Z_X3M*NXA(II,JO) + Z_Y3M*NYA(II,JO)
     &          + Z_X3P*NXA(II,JP) + Z_Y3P*NYA(II,JP) )
C
        DR(JZ,1,II) = MFRJ*(-REZ)
C
C
C------ entry for i=II dummy density variable past streamtube exit
        A8(JO,II) = -1.0
C
  200 CONTINUE
C
C
C---- since PREX is a passive Newton variable, 
C     just set it to the current exit pressure and add it to the Residual
      PREX = PEXSUM
C
      DO 300 JO=1, JJ-1
        IF(JSTAG(JO).GT.0)  GOTO 300
C
        JZ = JO + JJ
        DR(JZ,    1,II) = DR(JZ,    1,II) + MFRACT(JO)*PREX
        DR(JZ,LPREX,II) = DR(JZ,LPREX,II) - MFRACT(JO)
 300  CONTINUE
C
C
C---- set flag indicating that the regular SETUP has been used
      ISSET = 1
C
      RETURN
      END ! SETUP
