

      SUBROUTINE SGCURV(PLOTP,XSIZ,YSIZ,
     &                  IIB,XB,XPB,YB,YPB,SB,
     &                  SBLE,IBLE,SG,IX,NBLD,CVLEWT,FSLE,FSTE,
     &                  XSREF1,XSREF2,XPREF1,XPREF2,CRRATS,CRRATP)
      IMPLICIT REAL (A-H,M,O-Z)
      LOGICAL PLOTP
      DIMENSION XB(IIB),XPB(IIB), YB(IIB),YPB(IIB), SB(IIB),
     &          SG(IX,2)
C=================================================================
C     Sets spacing array SG for airfoil element passed in via the 
C     spline arrays XB,YB,XPB,YPB,SB.  
C=================================================================
C
      PARAMETER (IBX=480)
      DIMENSION CV(IBX), CVS(IBX), SNEW(IBX)
      DIMENSION AA(IBX), BB(IBX), CC(IBX)
C
      DIMENSION SBT(IBX), CST(IBX), CSTP(IBX)
      DIMENSION DLE(2), DTE(2), DSMAX(2), DSMIN(2)
      DIMENSION VAR(10)
      LOGICAL PLOTP1, ERROR,LFUDGE,UFUDGE
      CHARACTER*1 ANS
C
      IF(IIB.GT.IBX) STOP 'SGCURV: Array overflow.  Increase IBX.'
C
      PLOTP1 = PLOTP
C
C
C**** Set surface panel node distribution based on curvature ***
C
 100  CONTINUE
C
      SBTOT = SB(IIB) - SB(1)
      DSAVG = 0.5*SBTOT / FLOAT(NBLD-1)
C
      DSLE = FSLE * DSAVG
      DSTE = FSTE * DSAVG
C
C---- set up curvature array (nondimensionalized with airfoil perimeter)
      CMAX = 0.0
      DO 110 IB=1, IIB
        IF(IBLE.NE.0 .AND. (IB.EQ.IBLE .OR. IB.EQ.IBLE+1)) THEN
         CV(IB) = 0.
        ELSE
         CV(IB) = CURV(SB(IB),XB,XPB,YB,YPB,SB,IIB) * SBTOT
        ENDIF
        CV(IB) = ABS(CV(IB))
 110  CONTINUE
C
C---- reset curvature at corner nodes from adjacent nodes
      DO 114 IB=2, IIB-2
        IF(SB(IB) .EQ. SB(IB+1)) THEN
         CV(IB) = 0.5*(CV(IB-1) + CV(IB+2))
         CV(IB+1) = CV(IB)
        ENDIF
 114  CONTINUE
C
C---- set max curvature
      CMAX = CV(1)
      DO 116 IB=2, IIB
        CMAX = MAX( CMAX , CV(IB) )
 116  CONTINUE
C
C---- set LE curvature
      CVLE = ABS( CURV(SBLE,XB,XPB,YB,YPB,SB,IIB) ) * SBTOT
ccc      write(*,*) 'CVLE =', CVLE
C
C---- LE curvature should be at least  2 pi / perimeter
      CVLE = MAX( CVLE , 6.3 )
C
C---- sharp LE case
      IF(IBLE.NE.0) THEN
       CV(IBLE) = CVLE
       CV(IBLE+1) = CVLE
      ENDIF
C
C---- set artificial curvature at TE to get approximate ds/c there
      ALDS = LOG(DSLE/DSTE) / SQRT(CVLEWT)
      ALDS = MIN( ALDS ,  12.0 )
      ALDS = MAX( ALDS , -12.0 )
      CVTE = CVLE * EXP(ALDS)
      CV(1)   = CVTE
      CV(IIB) = CVTE
C
C---- set curvature smoothing length
ccc      CURVL = 0.5*SBTOT/CMAX
      CURVL = 0.005*SBTOT
C
C---- set up implicit system for smoothed curvature array CV
      CURVK = CURVL**2
      AA(1) = 1.0
      CC(1) = 0.
      DO 120 IB=2, IIB-1
        IF(IB.EQ.IBLE .OR. IB.EQ.IBLE+1) GO TO 120
        DSM = SB(IB) - SB(IB-1)
        DSP = SB(IB+1) - SB(IB)
        DSA = 0.5*(DSM+DSP)
        IF(DSM.EQ.0.0 .OR. DSP.EQ.0.0) THEN
         BB(IB) = 0.0
         AA(IB) = 1.0
         CC(IB) = 0.0
        ELSE
         BB(IB) = - CURVK/(DSM*DSA)
         AA(IB) =   CURVK/(DSM*DSA) + CURVK/(DSP*DSA)  +  1.0
         CC(IB) =                   - CURVK/(DSP*DSA)
        ENDIF
 120  CONTINUE
      AA(IIB) = 1.0
      BB(IIB) = 0.
C
C---- fix curvature at LE point by modifying equations adjacent to LE
      DO 130 IB=2, IIB-1
        IF(SB(IB).EQ.SBLE) THEN
C------- if node falls right on LE point, fix curvature there
         BB(IB) = 0.
         AA(IB) = 1.0
         CC(IB) = 0.
         CV(IB) = CVLE
         GO TO 131
        ELSE IF(SB(IB-1).LT.SBLE .AND. SB(IB).GT.SBLE) THEN
C------- modify equation at node just before LE point
         DSM = SB(IB-1) - SB(IB-2)
         DSP = SBLE     - SB(IB-1)
         DSO = 0.5*(SBLE - SB(IB-2))
C
         BB(IB-1) = CURVK * (         - 1.0/DSM) / DSO
         AA(IB-1) = CURVK * ( 1.0/DSP + 1.0/DSM) / DSO  +  1.0
         CC(IB-1) = 0.
         CV(IB-1) = CV(IB-1) + CURVK*CVLE/(DSP*DSO)
C
C------- modify equation at node just after LE point
         DSM = SB(IB) - SBLE
         DSP = SB(IB+1) - SB(IB)
         DSO = 0.5*(SB(IB+1) - SBLE)
         BB(IB) = 0.
         AA(IB) = CURVK * ( 1.0/DSP + 1.0/DSM) / DSO  +  1.0
         CC(IB) = CURVK * (-1.0/DSP          ) / DSO
         CV(IB) = CV(IB) + CURVK*CVLE/(DSM*DSO)
C
         GO TO 131
        ENDIF
 130  CONTINUE
 131  CONTINUE
C
C---- set artificial curvature at the bunching points
      CVRS = 0.0
      IF(CRRATS .GT. 0.0) THEN
       ALRS = LOG(CRRATS) / SQRT(CVLEWT)
       ALRS = MIN( ALRS ,  12.0 )
       ALRS = MAX( ALRS , -12.0 )
cc       CVRS = CMAX * EXP(ALRS)
       CVRS = CVLE * EXP(ALRS)
      ENDIF
C
      CVRP = 0.0
      IF(CRRATP .GT. 0.0) THEN
       ALRP = LOG(CRRATP) / SQRT(CVLEWT)
       ALRP = MIN( ALRP ,  12.0 )
       ALRP = MAX( ALRP , -12.0 )
cc       CVRP = CMAX * EXP(ALRP)
       CVRP = CVLE * EXP(ALRP)
      ENDIF
C
      SBSIDS = SB(1)   - SBLE
      SBSIDP = SB(IIB) - SBLE
      DO 140 IB=2, IIB-1
        IF(SB(IB).LT.SBLE .AND. CRRATS.GT.0.0) THEN
C------- check if top side point is in refinement area
         SGI = (SB(IB)-SBLE)/SBSIDS
         IF(SGI.GT.XSREF1 .AND. SGI.LT.XSREF2) THEN
cc          BB(IB) = 0.
cc          AA(IB) = 1.0
cc          CC(IB) = 0.
          CV(IB) = CVRS
         ENDIF
        ELSE IF(SB(IB).GT.SBLE .AND. CRRATP.GT.0.0) THEN
C------- check if bottom side point is in refinement area
         SGI = (SB(IB)-SBLE)/SBSIDP
         IF(SGI.GT.XPREF1 .AND. SGI.LT.XPREF2) THEN
cc          BB(IB) = 0.
cc          AA(IB) = 1.0
cc          CC(IB) = 0.
          CV(IB) = CVRP
         ENDIF
        ENDIF
 140  CONTINUE
C
C---- calculate smoothed curvature array
      CALL TRISOL(AA,BB,CC,CV,IIB)
C
C---- spline curvature array
      CALL SEGSPL(CV,CVS,SB,IIB)
C
C
C---- Integrate exponentiated curvature with arc length
C-    CVS array is no longer needed and is used for storage
      CVS(1) = 0.
      DO I = 2, IIB
C------ raise curvature to power sq(CVLEWT), limiting to prevent overflows
        ALGO = MIN( SQRT(CVLEWT)*LOG(CV(I)  ) , 12.0 )
        ALGM = MIN( SQRT(CVLEWT)*LOG(CV(I-1)) , 12.0 )
        CVO = EXP(ALGO)
        CVM = EXP(ALGM)
        CVS(I) = CVS(I-1) + 0.5*(CVO+CVM)*(SB(I)-SB(I-1))
      END DO
C
      DO I = 1, IIB
        CVS(I) = CVS(I)/CVS(IIB)
      END DO
C
C---- spline integrated curvature array
      CALL SPLINA(CVS,CSTP,SB,IIB)
      CVSLE = SEVAL(SBLE,CVS,CSTP,SB,IIB)
C
C---- plot curvature, and spacing parameter function
CCC      CALL PLTCRV(SBLE,SB,CV,CVS,IIB,XSIZ,YSIZ)
C
C---- Calculate normalized surface spacing distribution arrays
C
C---- Upper surface
      IT = 1
      SBT(IT) = 0.0
      CST(IT) = 0.0
      DO IB = IIB, 1, -1
       IF(SB(IB).LT.SBLE) THEN
        IT = IT + 1
        SBT(IT) = SBLE - SB(IB)
        CST(IT) = CVSLE - CVS(IB)
       ENDIF
      END DO
C
      CALL SETCRV(SNEW,NBLD,SBT,CST,CSTP,IT,DSLE,UFUDGE)
      DO IG=1, NBLD
        SG(IG,1) = (SNEW(IG)-SNEW(1))/(SNEW(NBLD)-SNEW(1))
      END DO
C---- calculate actual obtained grid spacings
      DLE(1) = ABS( SNEW(2)    - SNEW(1)      )
      DTE(1) = ABS( SNEW(NBLD) - SNEW(NBLD-1) )
      DSMIN(1) = DLE(1)
      DSMAX(1) = 0.0
      DO IG=2, NBLD
        DSMIN(1) = MIN( DSMIN(1) , ABS(SNEW(IG)-SNEW(IG-1)) )
        DSMAX(1) = MAX( DSMAX(1) , ABS(SNEW(IG)-SNEW(IG-1)) )
      END DO
C
C---- Lower surface
      IT = 1
      SBT(IT) = 0.0
      CST(IT) = 0.0
      DO IB = 1, IIB
       IF(SB(IB).GT.SBLE) THEN
        IT = IT + 1
        SBT(IT) = SB(IB) - SBLE
        CST(IT) = CVS(IB) - CVSLE
       ENDIF
      END DO
C
      CALL SETCRV(SNEW,NBLD,SBT,CST,CSTP,IT,DSLE,LFUDGE)
      DO IG=1, NBLD
        SG(IG,2) = (SNEW(IG)-SNEW(1))/(SNEW(NBLD)-SNEW(1))
      END DO
C---- calculate actual obtained grid spacings
      DLE(2) = ABS( SNEW(2)    - SNEW(1)      )
      DTE(2) = ABS( SNEW(NBLD) - SNEW(NBLD-1) )
      DSMIN(2) = DLE(2)
      DSMAX(2) = 0.0
      DO IG=2, NBLD
        DSMIN(2) = MIN( DSMIN(2) , ABS(SNEW(IG)-SNEW(IG-1)) )
        DSMAX(2) = MAX( DSMAX(2) , ABS(SNEW(IG)-SNEW(IG-1)) )
      END DO
C
      IF(PLOTP1) THEN
       CALL PLNODE(IIB,XB,XPB,YB,YPB,SB,SBLE,IBLE,SG,IX,NBLD,
     &             XSIZ,YSIZ,XSREF1,XSREF2,XPREF1,XPREF2)
      ENDIF
C
C
      WRITE(*,3020) FSLE, FSTE, CVLEWT
      IF (CRRATS .NE. 0.0) WRITE(*,3040) 'U',XSREF1,XSREF2,CRRATS
      IF (CRRATP .NE. 0.0) WRITE(*,3040) 'L',XPREF1,XPREF2,CRRATP
 3020 FORMAT(/1X,'  Prescribed grid node spacing parameters ...'
     &       /1X,'    dsLE/dsAvg =',F7.4, '   dsTE/dsAvg =',F7.4
     &          ,'    curvature exponent =',F9.4)
 3040 FORMAT(2X,A1,': refinement between s/smax =',2F8.4,
     &             '     dsLoc/dsAvg =',F8.3)
C
      IF(UFUDGE .OR. LFUDGE) WRITE(*,*)
      IF(UFUDGE) WRITE(*,3080) 'U'
      IF(LFUDGE) WRITE(*,3080) 'L'
 3080 FORMAT(2X,A1,': LE curvature too small to enforce spacing ... ',
     &             'increased locally.')
C
      WRITE(*,3100)
      WRITE(*,3110) 'U',  DLE(1)/DSAVG,   DTE(1)/DSAVG, 
     &                  DSMIN(1)/DSAVG, DSMAX(1)/DSAVG
      WRITE(*,3110) 'L',  DLE(2)/DSAVG,   DTE(2)/DSAVG, 
     &                  DSMIN(2)/DSAVG, DSMAX(2)/DSAVG
 3100 FORMAT(/' Actual resulting surface spacings ...')
 3110 FORMAT( 2X,A1,': dsLE/dsAvg =',F7.3,'   dsTE/dsAvg =',F7.3,
     &        2X,'| ds/dsAvg  min max:',2F7.3 )
C
C==============================================
C
 18   WRITE(*,2010)
 2010 FORMAT(
     &   ' __________________________________________'
     & //'  D sLE/dsAvg, dsTE/dsAvg  spacing ratios  '
     &  /'  C urvature exponent                      '
     &  /'  U pper side spacing refinement           |   B lowup plot'
     &  /'  L ower side spacing refinement           |   R eset plot ')
 20   WRITE(*,2015)
 2015 FORMAT(/1X,'Change what? (<Return> if spacing OK):  ',$)
      READ(*,1000,ERR=18) ANS
 1000 FORMAT(A)
C
C---------------------------------------------
      IF (ANS.EQ.' ') THEN
        CALL CLRZOOM
        RETURN
      ENDIF
      IF (INDEX('Dd',ANS).NE.0) GO TO 30
      IF (INDEX('Cc',ANS).NE.0) GO TO 40
      IF (INDEX('Uu',ANS).NE.0) GO TO 51
      IF (INDEX('Ll',ANS).NE.0) GO TO 52
      IF (INDEX('Bb',ANS).NE.0) THEN
        CALL USETZOOM(.TRUE.,.TRUE.)
        CALL REPLOT(IDEV)
      ENDIF
      IF (INDEX('Rr',ANS).NE.0) THEN
        CALL CLRZOOM
        CALL REPLOT(IDEV)
      ENDIF
      GO TO 18
C
C---------------------------------------------
 30   VAR(1) = FSLE
      VAR(2) = FSTE
      WRITE(*,2030) VAR(1), VAR(2)
 2030 FORMAT(' Enter new  dsLE/dsAvg, dsTE/dsAvg ',2F9.4)
      CALL READR(2,VAR,ERROR)
      IF(ERROR) GO TO 30
      IF(VAR(1).LE.0.0 .OR. VAR(2).LE.0.0) GO TO 30
      FSLE   = VAR(1)
      FSTE   = VAR(2)
      GO TO 100
C
C---------------------------------------------
 40   VAR(1) = CVLEWT
      WRITE(*,2040) VAR(1)
 2040 FORMAT(' Enter new curvature exponent (0 to ~5)',F9.4)
      CALL READR(1,VAR,ERROR)
      IF(ERROR) GO TO 40
      CVLEWT = VAR(1)
      IF(CVLEWT .LT. 0.0) GO TO 40
      CVLEWT = MAX(CVLEWT , 0.0001)
      GO TO 100
C
C---------------------------------------------
 51   VAR(1) = XSREF1
      VAR(2) = XSREF2
      VAR(3) = CRRATS
      WRITE(*,2051) VAR(1), VAR(2), VAR(3)
 2051 FORMAT(' Enter new upper',
     &  ' s/smax limits, local/avg spacing ratio', 2F8.4,F8.3)
      CALL READR(3,VAR,ERROR)
      IF(ERROR) GO TO 52
      XSREF1 = VAR(1)
      XSREF2 = VAR(2)
      CRRATS = VAR(3)
      IF(XSREF1.GT.XSREF2) THEN
       XSREF1 = VAR(2)
       XSREF2 = VAR(1)
      ENDIF
      GO TO 100
C
C---------------------------------------------
 52   VAR(1) = XPREF1
      VAR(2) = XPREF2
      VAR(3) = CRRATP
      WRITE(*,2052) VAR(1), VAR(2), VAR(3)
 2052 FORMAT(' Enter new lower',
     &  ' s/smax limits, local/avg spacing ratio', 2F8.4,F8.3)
      CALL READR(3,VAR,ERROR)
      IF(ERROR) GO TO 52
      XPREF1 = VAR(1)
      XPREF2 = VAR(2)
      CRRATP = VAR(3)
      IF(XPREF1.GT.XPREF2) THEN
       XPREF1 = VAR(2)
       XPREF2 = VAR(1)
      ENDIF
      GO TO 100
C
      END ! SGCURV



      SUBROUTINE SETCRV(SNEW,NBLD,SB,CS,CSP,N,DSLE,LEFUDG)
      IMPLICIT REAL (A-H,O-Z)
      DIMENSION SNEW(NBLD), SB(N), CS(N), CSP(N)
      LOGICAL LEFUDG
C
      PARAMETER (NMAX=360)
      DIMENSION H(NMAX), HF(NMAX), SBP(NMAX)
C
C---- LE curvature fudge extends ~TCON*DSLE from LE point
      DATA TCON /2.0/
C
      IF(NBLD.GT.NMAX) STOP 'SETCRV: array overflow'
C
      RN = FLOAT(NBLD-1)
C
      CALL SPLINA(CS,CSP,SB,N)
      DCLE = SEVAL(DSLE,CS,CSP,SB,N)
C
C---- set LE spacing for strongest-possible curvature attraction
      DO I=1, N
        H(I) = CS(I)
      END DO
      CALL SPLINA(SB,SBP,H,N)
      DHC = H(N)/RN
      DSC = SEVAL(DHC,SB,SBP,H,N)
C
C
C---- Determine coefficient of curvature weighting term
C     in node distribution - driven by matching DSLE
      IF(DSC .LT. DSLE) THEN
C
C----- normal case --- LE curvature has sufficient authority
       F = 0.0
       CWT = SB(N) - DSLE*RN
       SWT = CS(N) - DCLE*RN
       LEFUDG = .FALSE.
C
      ELSE
C
C----- put in additional 1/cosh(s)^2 contribution to curvature at LE
C-     to allow DSLE requirement to be met
       DTLE = TCON*DSLE*TANH(1.0  / TCON      )
       TMAX = TCON*DSLE*TANH(SB(N)/(TCON*DSLE))
       F = -(RN*DCLE - CS(N))
     &     /(RN*DTLE - TMAX )

       CWT = 1.0
       SWT = 0.0
       LEFUDG = .TRUE.
C
      ENDIF
C
C---- Setup spacing array
      H(1) = 0.0
      DO I=2, N
        TANHDS = TANH( SB(I)/(TCON*DSLE) )
        H(I) = -SWT* SB(I)
     &        + CWT*(CS(I) + F*TCON*DSLE*TANHDS)
      END DO
C
C
C---- spline spacing parameter
ccc   CALL SPLINA(SB,SBP,H,N)
      CALL SPLINA(H,SBP,SB,N)
      DO I=1, N
        SBP(I) = 1.0/SBP(I)
      ENDDO
C
      DH = H(N)/RN
ccc      WRITE(*,*) 'swt, cwt, f, dh:', -SWT, CWT, f, dsc
C
      SNEW(1) = 0.0
      DO 110 I=2, NBLD-1
        HH = FLOAT(I-1)*DH
        SNEW(I) = SEVAL(HH,SB,SBP,H,N)
  110 CONTINUE
      SNEW(NBLD) = SB(N)
C
      RETURN
      END ! SETCRV




      SUBROUTINE SGCOPY(S1,S2,N)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION S1(N), S2(N)
C
      DO 10 I=1, N
        S1(I) = S2(I)
   10 CONTINUE
C
      RETURN
      END


      SUBROUTINE SGCOPF(S1,S2,N,SOFF1,SWT1,SOFF2,SWT2, FOFF,
     &                  F1,FX1,X1,N1, F2,FX2,X2,N2)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION S1(N), S2(N)
      DIMENSION F1(N1),FX1(N1),X1(N1)
      DIMENSION F2(N2),FX2(N2),X2(N2)
C
C---- reset array S1 so that  f1(s1) = f2(s2) + foff ,
C-    with  s1 = S1*SWT1 + SOFF1  and  s2 = S2*SWT2 + SOFF2
C
      DELS1 = S1(N) - S1(1)
      DO 20 I=2, N-1
        FEV2 = SEVAL((S2(I)*SWT2+SOFF2),F2,FX2,X2,N2) + FOFF
C
        DO 200 ITER=1, 10
          FEV1 = SEVAL((S1(I)*SWT1+SOFF1),F1,FX1,X1,N1)
          DEV1 = DEVAL((S1(I)*SWT1+SOFF1),F1,FX1,X1,N1)
          RES = FEV1 - FEV2
          RES_S1 = DEV1 * SWT1
          DS1 = -RES/RES_S1
          S1(I) = S1(I) + DS1
          IF(ABS(DS1/DELS1) .LT. 1.0E-5) GO TO 20
  200   CONTINUE
        WRITE(*,*) 'SGCOPF: Convergence failed.  dS/Smax =', DS1/DELS1
C
   20 CONTINUE
C
      RETURN
      END


      SUBROUTINE SGAVG(S1,S2,N,C1)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION S1(N), S2(N)
C
C---- average arrays S1 S2,
C-    preserving S1 spacing at right point and S2 spacing at left endpoint
      DO 10 I=1, N
        F1 = FLOAT(I-1) * C1
        F2 = FLOAT(N-I)
        S1(I) = (S1(I)*F1 + S2(I)*F2) / (F1 + F2)
        S2(I) = S1(I)
   10 CONTINUE
C
      RETURN
      END


      SUBROUTINE SGAVG1(S1,S2,N)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION S1(N), S2(N)
C
C---- impose spacing of array S1 on S2 at right endpoint
      DO 10 I=1, N
        F1 = FLOAT(I-1)
        F2 = FLOAT(N-I)
        S2(I) = (S1(I)*F1 + S2(I)*F2) / (F1 + F2)
   10 CONTINUE
C
      RETURN
      END


      SUBROUTINE SGAVG2(S1,S2,N)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION S1(N), S2(N)
C
C---- impose spacing of array S2 on S1 at left endpoint
      DO 10 I=1, N
        F1 = FLOAT(I-1)
        F2 = FLOAT(N-I)
        S1(I) = (S1(I)*F1 + S2(I)*F2) / (F1 + F2)
   10 CONTINUE
C
      RETURN
      END



      SUBROUTINE NEWNUM(S,N1,N2)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION S(2000)
C----------------------------------------------------------------------
C     Interpolates input array S(1:N1) into new number of points 1:N2.
C     The interpolation is a spline in the array index.
C     The first and last elements in S will remain the same.
C----------------------------------------------------------------------
      PARAMETER (NMAX=2000)
      DIMENSION X(NMAX), XI(NMAX), C(NMAX)
C
      IF(N1.GT.NMAX) STOP 'NEWNUM:  Array overflow'
C
C---- save old input array
      DO 10 I=1, N1
        X(I) = S(I)
   10 CONTINUE
C
C---- spline X(i)  (set up and solve tridiagonal system on the fly)
      C(1) = 0.5
      XI(1) = 1.5*(X(2)-X(1))
      DO 20 I=2, N1-1
        C(I) = 1.0 / (4.0 - C(I-1))
        XI(I) = (3.0*(X(I+1) - X(I-1)) - XI(I-1)) * C(I)
   20 CONTINUE
      I = N1
      XI(I) = (3.0*(X(I)-X(I-1)) - XI(I-1)) / (2.0 - C(I-1))
C
      DO 30 I=N1-1, 1, -1
        XI(I) = XI(I) - C(I)*XI(I+1)
   30 CONTINUE
C
C---- evaluate s(i) spline at new points
      DO 40 J=1, N2
        FRAC = FLOAT(J-1)/FLOAT(N2-1)
        RI = 1.0 + FRAC*FLOAT(N1-1)
        I  = MIN( INT(RI) , N1-1 )
C
        T = RI - FLOAT(I)
        CX1 = XI(I)   - X(I+1) + X(I)
        CX2 = XI(I+1) - X(I+1) + X(I)
        S(J) = T*X(I+1) + (1.0-T)*X(I) + (T-T*T)*((1.0-T)*CX1 - T*CX2)
   40 CONTINUE
C
C---- make sure new endpoints are exactly the same as old ones
      S(1)  = X(1)
      S(N2) = X(N1)
C
      RETURN
      END ! NEWNUM







