C    
      PROGRAM SHRINK
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C-------------------------------------------------
C     Strips off outermost cell layer(s) from
C     specified xxx data set.  Current mdat.xxx
C     is overwritten with reduced grid version.
C     This is useful in checking sensitivity
C     to grid outer boundary location.
C
C     Usage:    % shrink xxx
C
C-------------------------------------------------
C
      CALL INPUT
      CALL INDINI
C
C---- get number of cells to be removed from inlet,outlet planes
      WRITE(*,*) 'Enter dIinl dIout: '
      READ (*,*) ID1, ID2
C
C---- get number of streamtubes to be removed from bottom, top
      WRITE(*,*) 'Enter dJbot dJtop: '
      READ (*,*) JD1, JD2
C
      DMF1 = 0.
      DO J=1, JD1
        DMF1 = DMF1 + MFRACT(J)
      ENDDO
      DMF2 = 0.
      DO J=JJ-JD2, JJ-1
        DMF2 = DMF2 + MFRACT(J)
      ENDDO
C
C---- report fractional mass flow removed from bottom & top,
C      and the total new/old mass flow ratio
      WRITE(*,*)
      WRITE(*,*) 'Top d(m)/m =', DMF1
      WRITE(*,*) 'Bot d(m)/m =', DMF2
      WRITE(*,*) 'm_new / m_old =', 1.0-dmf1-dmf2
C
C
      YBBOT = YBBOT + DMF1*AINF
      YBTOP = YBTOP - DMF2*AINF
C
      MASS = MASS*(1.0 - DMF1 - DMF2)
      AINF = AINF*(1.0 - DMF1 - DMF2)
C
      DO J=1, JJ-JD1-JD2
        MFRACT(J) = MFRACT(J+JD1) / (1.0 - DMF1 - DMF2)
        DO I=1, II-ID1-ID2
          X(I,J) = X(I+ID1,J+JD1)
          Y(I,J) = Y(I+ID1,J+JD1)
          R(I,J) = R(I+ID1,J+JD1)
        ENDDO
      ENDDO
C
      DO N=1, NBL
        DO IG=1, NINL(N)-ID1
          SGINL(IG,N) = SGINL(IG+ID1,N)
        ENDDO
C
        SG1 = SGINL(          1,N)
        SGN = SGINL(NINL(N)-ID1,N)
        DO IG=1, NINL(N)-ID1
          SGINL(IG,N) = (SGINL(IG,N)-SG1)/(SGN-SG1)
        ENDDO
C
        SG1 = SGOUT(          1,N)
        SGN = SGOUT(NOUT(N)-ID2,N)
        DO IG=1, NOUT(N)-ID2
          SGOUT(IG,N) = (SGOUT(IG,N)-SG1)/(SGN-SG1)
        ENDDO
        SWAK(N) = SWAK(N) * (SGN-SG1)
      ENDDO
C
      DO IS=1, 2*NBL
        DO I=1, II-ID1-ID2
          DISP(I,IS) = DISP(I+ID1,IS)
          THET(I,IS) = THET(I+ID1,IS)
          DSTR(I,IS) = DSTR(I+ID1,IS)
          UEDG(I,IS) = UEDG(I+ID1,IS)
          CTAU(I,IS) = CTAU(I+ID1,IS)
           TAU(I,IS) =  TAU(I+ID1,IS)
        ENDDO
        ITRAN(IS) = ITRAN(IS) - ID1
      ENDDO
C
      DO N=1, NBL
        JBLD(N) = JBLD(N) - JD1
        NINL(N) = NINL(N) - ID1
        NOUT(N) = NOUT(N) - ID2
      ENDDO
C
      IX0 = IX0 - ID1
      IX1 = IX1 - ID1
C
      II = II - ID1 - ID2
      JJ = JJ - JD1 - JD2
C
C---- verify that new MFRACT adds up to 1
      mfsum = 0.
      do j=1, jj-1
        mfsum = mfsum + mfract(j)
      enddo
      write(*,*) mfsum
C
C---- give new inlet,outlet x,  and bottom,top y
      write(*,*) 
      write(*,*) x(1,jbld(1)), x(ii,jbld(1)), ybbot, ybtop
C
      CALL OUTPUT
      STOP
      END



      SUBROUTINE INDINI
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
C----Initialize indices and pointers for element(s)
      DO 10 J = 1, JJ
        JSTAG(J) = 0
   10 CONTINUE
C
C----IS arrays give side indices for element
C       IS1 - suction  side (odd) 
C       IS2 - pressure side (even) 
C    JS arrays give J line corresponding to element side
C       JS1 - suction  side 
C       JS2 - pressure side
C    JSTAG links the J lines and the element sides
C                 0 for J line not corresponding to element side
C                -IS1 for suction  side on element
C                +IS2 for pressure side on element
C Note: JSTAG(J)>0 indicates a dummy streamtube J (between the element grids)
C
      DO 20 N = 1, NBL
C
        ILE = NINL(N)
        ITE = II-NOUT(N)+1
        ILEB(N) = ILE
        ITEB(N) = ITE
C
        IS1(N) = 2*N - 1
        IS2(N) = 2*N
C
        JS1(N) = JBLD(N)
        JS2(N) = JBLD(N) - 1
        IF (JS2(N).LT.1) JS2(N) = JJ
C
        JSTAG(JS1(N)) = -IS1(N)
        JSTAG(JS2(N)) =  IS2(N)
   20 CONTINUE
C
      RETURN
      END ! INDINI



