C
      SUBROUTINE SMOVE(ITMAX,CIRREF,RHOLIM)
      INCLUDE 'STATE.INC'
C
      DIMENSION XPS(IX,JX), YPS(JX), JFIX(JX)
C
      IF(CIRC .GT. 0.0) THEN
        XPFAC = 1.0 - EXP(-CIRC/CIRREF)
        XPEXT = XPEX - (      XPEX)*XPFAC
        XPEXB = XPEX + (1.0 - XPEX)*XPFAC
      ELSE
        XPFAC = 1.0 - EXP( CIRC/CIRREF)
        XPEXB = XPEX - (      XPEX)*XPFAC
        XPEXT = XPEX + (1.0 - XPEX)*XPFAC
      ENDIF
C
c      IF(CIRC .GT. 0.0) THEN
c        XPFAC = 1.0 - EXP(-CIRC/CIRREF)
c        XPEXT = XPEX + (0.5 - XPEX)*XPFAC
c        XPEXB = XPEX + (1.0 - XPEX)*XPFAC
c      ELSE
c        XPFAC = 1.0 - EXP( CIRC/CIRREF)
c        XPEXB = XPEX + (0.5 - XPEX)*XPFAC
c        XPEXT = XPEX + (1.0 - XPEX)*XPFAC
c      ENDIF
C
      XPEXM = 1.0 - 0.5*(1.0-XPEX)
C
C
C---- set YPOS array for current grid by summing current mass fractions
      YPS(1) = 0.0
      DO J=1, JJ-1
        YPS(J+1) = YPS(J) + MFRACT(J)
      ENDDO
C
C
      DO J=1, JJ
        JFIX(J) = 0
      ENDDO
      DO N=1, NBL
        JFIX(JBLD(N)  ) = +1
        JFIX(JBLD(N)-1) = -1
      ENDDO
C
C
C---- go over each block of streamlines
      J1 = 1
      DO 100 IBLOCK=1, NBL+1
C
        IF(IBLOCK.LE.NBL) THEN
C-------- find next bottom airfoil side up from j=J1 streamline
          N = NBL - IBLOCK + 1
          DO 10 J2=J1+1, JJ
            IF(J2 .EQ. JBLD(N)-1) GO TO 11
   10     CONTINUE
          J2 = JJ
   11     CONTINUE
        ELSE
          J2 = JJ
        ENDIF
C
C------ set spacing array for this block of streamlines
        IF(J1.EQ.1) THEN
C------- bottom stream channel
         XPEXJ = XPEXB
         WT2 = 1.0
         WT1 = 0.0
C
        ELSE IF(J2.EQ.JJ) THEN
C------- top stream channel
         XPEXJ = XPEXT
         WT2 = 0.0
         WT1 = 1.0
C
        ELSE
C------- inter-element stream channels
         XPEXJ = XPEXM
         WT2 = 0.5
         WT1 = 0.5
        ENDIF
C
        XPS(1,J1) = 0.0
        DO I=2, II
          DSQ1 = SQRT((X(I,J1)-X(I-1,J1))**2 + (Y(I,J1)-Y(I-1,J1))**2)
          DSQ2 = SQRT((X(I,J2)-X(I-1,J2))**2 + (Y(I,J2)-Y(I-1,J2))**2)
          XPS(I,J1) = XPS(I-1,J1) + ( WT1*DSQ1 + WT2*DSQ2 )**XPEXJ
        ENDDO
C
C------ filter xi(i) distribution
        SMLEN = 3.0
        CALL FILTER(XPS(1,J1),SMLEN,II)
C
C------ set XPS for remaining streamlines in this block
        DO J = J1+1, J2
          DO I=1, II
             XPS(I,J) = XPS(I,J1)
          ENDDO
        ENDDO
C
C------ set low streamline of next block
        J1 = J2 + 1
 100  CONTINUE
C
      CALL ELLIP(IX,JX,II,JJ,JFIX,X,Y,XPS,YPS,R,RHOLIM,ITMAX)
C
      RETURN
      END ! SMOVE


