C***********************************************************************
C  MACH SWEEP PLOTTING FACILITY FOR ISES
C
C    INPUT:
C     * Sweep file(s) generated by ISES
C     * Reference data files in the format:
C
C         MACH(1)  CD(1)
C         MACH(2)  CD(2)
C          .      .
C          .      .
C         999.0  999.0
C         
C     * SPLOT.DEF plot parameter file (optional)
C
C***********************************************************************
C
      PROGRAM SPLOT
      INCLUDE 'PINDEX.INC'
      INCLUDE 'SPLOT.INC'
C
      DIMENSION ISORT(NAX)
      DIMENSION CSORT(NAX)
C
      LPLOT = .FALSE.
      CALL PLINITIALIZE
C
C---- get default settings
      CALL GETDEF
C
    1 WRITE(*,1000)
      IF(NPOL.GT.0) WRITE(*,1010)
      WRITE(*,1050)
C
 1000 FORMAT(//' 1  Read sweep(s)        (-1 to append)'
     &        /' 2  Read reference data  (-2 to append)'
     &        /' 3  Plot'
     &        /' 4  Hardcopy current plot'
     &        /' 5  Change settings for plot'
     &        /' 6  Zoom'
     &        /' 7  Unzoom'
     &        /' 8  Annotation menu')
 1010 FORMAT( ' 11  Re-read current sweeps'
     &       /' 12  Re-read current reference data')
 1050 FORMAT(/'   Select option (0=quit): ', $)
C
      READ(*,*,ERR=1) IOPTS
      IOPT = ABS(IOPTS)
C
      GO TO (900, 10, 20, 30, 40, 50, 60, 70, 80,900,900,
     &            10, 20                                   ), IOPT+1
      GO TO 1
C
C=============================================
C---- read sweeps and assign colors
 10   IREAD = -1
      IF(IOPTS.LT.0 ) IREAD = +1
      IF(IOPTS.EQ.11) IREAD = 0
      CALL GETSWP(IREAD, FNPOL,
     &            NAX,NPX,NPOL,NA,CPOL, NAME,
     &            ISX,NBL,XTR,
     &            TITLE,CODE,VERSION )
      DO 101, IP=1, NPOL
        CALL GETTYP(NAX,NA(IP),CPOL(1,1,IP),IMATYP(IP),IRETYP(IP))
        CALL STRIP(NAME(IP),NNAME)
 101  CONTINUE
      DO 105 IP=1, NPOL
        ICOL(IP) = 2 + IP
 105  CONTINUE
CCC   CALL MINMAX(NAX,NPOL,NA,CPOL,CPOLPLF)
      GO TO 1
C
C=============================================
C---- read reference data and assign colors
 20   IREAD = -1
      IF(IOPTS.LT.0 ) IREAD = +1
      IF(IOPTS.EQ.12) IREAD = 0
      CALL GETREF(IREAD, FNREF,
     &            NFX,NDX,NDAT,NF,XYREF,LABREF )
      DO 201, ID=1, NDAT
        CALL STRIP(LABREF(ID),NLAB)
 201  CONTINUE
      DO 205 ID=1, NDAT
ccc     IFCOL(ID) = NCOLOR - ID + 1
        IFCOL(ID) = 2 + ID
 205  CONTINUE
      GO TO 1
C
C=============================================
C---- Make the Plot
 30   IF (NPOL.EQ.0 .AND. NDAT.EQ.0) GO TO 1
C
C---- sort each polar by increasing Mach
      DO 302 IP=1, NPOL
        CALL SORT(NA(IP),CPOL(1,IMA,IP),ISORT)
C
        DO K=1, IPTOT
          DO IA=1, NA(IP)
            CSORT(IA) = CPOL(ISORT(IA),K,IP)
          ENDDO
          DO IA=1, NA(IP)
            CPOL(IA,K,IP) = CSORT(IA)
          ENDDO
        ENDDO
C
        DO IS=1, 2*NBL(IP)
          DO IA=1, NA(IP)
            CSORT(IA) = XTR(ISORT(IA),IS,IP)
          ENDDO
          DO IA=1, NA(IP)
            XTR(IA,IS,IP) = CSORT(IA)
          ENDDO
        ENDDO
C
 302  CONTINUE
C
      IF (LPLOT) CALL PLEND
      CALL PLOPEN(SCRNFR,IPSLU,IDEV)
      LPLOT = .TRUE.
C
C---- set 0.5" left,bottom margins
      CALL PLOTABS(0.5,0.5,-3)
C
      CALL NEWFACTOR(SIZE)
C
      CALL PLOT(6.0*CH,6.0*CH,-3)
C
      CALL SWPPLT(NAX,NPOL,NA,CPOL, NAME  ,ICOL,
     &            NFX,NDAT,NF,XYREF,LABREF,IFCOL,
     &            ISX,NBL,XTR, IMATYP,IRETYP,
     &            TITLE,CODE,VERSION,
     &            AR, CH,CH2, 
     &            LGRID,LSYMB,LCDWAV,LLIST,LMRED,
     &            CPOLPLF )
      GO TO 1
C
C=============================================
C---- toggle hardcopy flag
 40   IF(LPLOT) CALL PLEND
      CALL REPLOT(IDEVRP)
      GO TO 1
C
C=============================================
C---- change settings
 50   CALL GETSET
      GO TO 1
C
C=============================================
C---- zoom
 60   IF(.NOT.LPLOT) THEN
       WRITE(*,*) 'No active plot'
       GO TO 1
      ENDIF
      CALL USETZOOM(.FALSE.,.TRUE.)
      CALL REPLOT(IDEV)
      GO TO 1
C
C=============================================
C---- unzoom
 70   IF(.NOT.LPLOT) THEN
       WRITE(*,*) 'No active plot'
       GO TO 1
      ENDIF
      CALL CLRZOOM
      CALL REPLOT(IDEV)
      GO TO 1
C
C=============================================
C---- annotate plot
 80   IF(.NOT.LPLOT) THEN
       WRITE(*,*) 'No plot to annotate'
       GO TO 1
      ENDIF
      CALL ANNOT(CH)
      GO TO 1
C=============================================
  900 CALL PLCLOSE
C
      END ! SPLOT
C
C
C***********************************************************************
C

      SUBROUTINE SWPPLT(NAX,NPOL,NA,CPOL, NAME  ,ICOL,
     &                  NFX,NDAT,NF,XYREF,LABREF,IFCOL,
     &                  ISX,NBL,XTR, IMATYP,IRETYP,
     &                  TITLE,CODE,VERSION,
     &                  AR, CH,CH2, 
     &                  LGRID,LSYMB,LCDWAV,LLIST,LMRED,
     &                  CPOLPLF )
      IMPLICIT REAL(M)
      INCLUDE 'PINDEX.INC'
      CHARACTER*(*) NAME(NPOL), LABREF(NDAT)
      CHARACTER*(*) CODE, TITLE
      LOGICAL LGRID, LSYMB, LCDWAV, LLIST, LMRED
C
      DIMENSION NA(NPOL), ICOL(NPOL), NBL(NPOL),
     &          NF(4,NDAT), IFCOL(NDAT), IMATYP(NPOL),IRETYP(NPOL)
      DIMENSION CPOL(NAX,IPTOT,NPOL), XYREF(NFX,2,4,NDAT),
     &          XTR(NAX,ISX,NPOL)
      DIMENSION CPOLPLF(3,*) 
C
      PARAMETER (NAXT=500)
      DIMENSION MATMP(NAXT), CDTMP(NAXT)
C
      LOGICAL NAMVAR,REYVAR,ACRVAR,CELVAR,ALFVAR,GRDVAR

C
      DIMENSION XLIN(3), YLIN(3)
C
      PARAMETER (NPX=100)
      DIMENSION REYN(NPX), ACRIT(NPX), CELL(NPX), ALFA(NPX)
      LOGICAL LCLCON(NPX), LALCON(NPX)
C
      DATA LMASK1, LMASK2, LMASK3 / -32640, -30584, -21846 /
C
      IF(NPOL.GT.NPX) THEN
        WRITE(*,*) 'POLPLT: Local array overflow. Increase NPX.'
        RETURN
      ENDIF
C
      DO IP=1, NPOL
        IF    (IRETYP(IP).EQ.1) THEN
         REYN(IP) = CPOL(1,IRE,IP)
        ELSEIF(IRETYP(IP).EQ.2) THEN
         REYN(IP) = CPOL(1,IRE,IP) * SQRT(ABS(CPOL(1,ICL,IP)))
        ELSE
         REYN(IP) = CPOL(1,IRE,IP) * ABS(CPOL(1,ICL,IP))
        ENDIF
C
        ACRIT(IP) = CPOL(1,INC,IP)
        CELL(IP)  = CPOL(1,ICL,IP)
        ALFA(IP)  = CPOL(1,IAL,IP)
C
        LCLCON(IP) = .TRUE.
        LALCON(IP) = .TRUE.
        DO IA=1, NA(IP)-1
          IF(CPOL(IA,ICL,IP).NE.CPOL(IA+1,ICL,IP)) THEN
           LCLCON(IP) = .FALSE.
          ENDIF
          IF(CPOL(IA,IAL,IP).NE.CPOL(IA+1,IAL,IP)) THEN
           LALCON(IP) = .FALSE.
          ENDIF
        ENDDO
      ENDDO
C
      CALL GETVAR(NAX,NPOL,NAME,CPOL,
     &            NAMVAR,REYVAR,ACRVAR,CELVAR,ALFVAR,GRDVAR)
C
C---- unpack plot limit array
      CDMIN = CPOLPLF(1,ICD)
      CDMAX = CPOLPLF(2,ICD)
      CDDEL = CPOLPLF(3,ICD)
C                 
      CMMIN = CPOLPLF(1,ICM)
      CMMAX = CPOLPLF(2,ICM)
      CMDEL = CPOLPLF(3,ICM)
C                 
      MAMIN = CPOLPLF(1,IMA)
      MAMAX = CPOLPLF(2,IMA)
      MADEL = CPOLPLF(3,IMA)
C
      MAWT = 1. / (MAMAX-MAMIN)
      CDWT = AR / (CDMAX-CDMIN)
C
      SH  = 0.7*CH2
      SHS = 0.5*CH2
C
C---- number of text lines to be plotted in left upper corner of CL-CD plot
      LINBOX = NDAT
      IF(NPOL.GT.1) LINBOX = LINBOX + NPOL + 1
      DYBOX = CH2*(2.0*FLOAT(LINBOX) + 1.0)
C
C---- set default color index
      CALL GETCOLOR(ICOL0)
C
      CALL PLOT(-MAWT*MAMIN,-CDWT*CDMIN,-3)
C
C---- plot sweep data - Title, airfoils: name, Mach, Re, and Ncrit
      XPLT0 = MAWT*MAMIN
      YPLT0 = CDWT*CDMAX
      CALL LABEL(NPOL, NAME ,ICOL,
     &           IRETYP,
     &           REYN, ACRIT,CELL,ALFA, LCLCON,LALCON,
     &           TITLE, LLIST,
     &           XPLT0,YPLT0, AR, CH,CH2 )
C
      CALL NEWCOLOR(ICOL0)
C
C---- CD axis for Ma-CD plot
      CALL NEWPEN(2)
      CALL YAXIS(MAWT*MAMIN,CDWT*CDMIN,AR,CDWT*CDDEL,CDMIN,CDDEL,CH2,3)
C
      CALL NEWPEN(3)
      XPLT = MAWT*MAMIN
      YPLT = CDWT*(CDMIN + CDDEL*FLOAT(INT((CDMAX-CDMIN)/CDDEL+0.01)/2)
     &             + 0.5*CDDEL) - 0.6*CH
      CALL PLCHAR(XPLT-4.0*CH,YPLT       ,1.4*CH,'C',0.0,1)
      CALL PLCHAR(XPLT-2.7*CH,YPLT-0.4*CH,0.9*CH,'D',0.0,1)
C
C---- Ma axis for Ma-CD plot
      CALL NEWPEN(2)
      CALL XAXIS(MAWT*MAMIN,CDWT*CDMIN,-1.,MAWT*MADEL,MAMIN,MADEL,CH2,2)
C
      CALL NEWPEN(3)
      XPLT = MAWT*(MAMIN + MADEL*FLOAT(INT((MAMAX-MAMIN)/MADEL+0.01)/2)
     &             + 0.5*MADEL)
      YPLT = CDWT*CDMIN
      IF(LMRED) THEN
        CALL PLCHAR(XPLT-2.0*CH,YPLT-4.0*CH,1.4*CH,'M',0.0,1)
        CALL PLMATH(XPLT-0.5*CH,YPLT-4.0*CH,1.4*CH,'R',0.0,1)
        CALL PLCHAR(XPLT+0.9*CH,YPLT-4.0*CH,1.4*CH,'C',0.0,1)
        CALL PLCHAR(XPLT+2.3*CH,YPLT-4.4*CH,1.0*CH,'L',0.0,1)
      ELSE
        CALL PLCHAR(XPLT-0.5*CH,YPLT-4.0*CH,1.4*CH,'M',0.0,1)
      ENDIF
C
      YLINE = CDWT*CDMAX - 2.0*CH2
C
      CALL NEWPEN(3)
C
      IF(NAMVAR) THEN
       XPLT = 6.0*CH2 + MAWT*MAMIN
       YPLT = YLINE
       CALL PLCHAR(XPLT,YPLT,0.8*CH2,'Airfoil',0.0,7)
       YLINE = YLINE - 2.25*CH2
       GO TO 5
      ENDIF
C
      IF(REYVAR) THEN
       XPLT = 7.5*CH2 + MAWT*MAMIN
       YPLT = YLINE
       ITYP = IRETYP(1)
       IF(ITYP.EQ.1) THEN
        CALL PLCHAR(XPLT,YPLT,    CH2,'Re' ,0.0,2)
       ELSE IF(ITYP.EQ.2) THEN
        CALL PLCHAR(XPLT-1.0*CH2,YPLT,    CH2,'Re CL',0.0,5)
        CALL PLMATH(XPLT+1.0*CH2,YPLT,    CH2,'  R  ',0.0,5)
       ELSE IF(ITYP.EQ.3) THEN
        CALL PLCHAR(XPLT-1.0*CH2,YPLT,    CH2,'Re CL',0.0,5)
        CALL PLMATH(XPLT+1.0*CH2,YPLT,    CH2,'  #  ',0.0,5)
       ENDIF
       YLINE = YLINE - 2.25*CH2
       GO TO 5
      ENDIF
C
      IF(ACRVAR) THEN
       XPLT = 8.0*CH2 + MAWT*MAMIN
       YPLT = YLINE
       CALL PLCHAR(XPLT    ,YPLT,    CH2,'N'   ,0.0,1)
       CALL PLCHAR(XPLT+CH2,YPLT,0.7*CH2,'crit',0.0,4)
       YLINE = YLINE - 2.25*CH2
       GO TO 5
      ENDIF
C
      IF(CELVAR) THEN
       XPLT = 9.0*CH2 + MAWT*MAMIN
       YPLT = YLINE
       CALL PLCHAR(XPLT    ,YPLT        ,    CH2,'C',0.0,1)
       CALL PLCHAR(XPLT+CH2,YPLT-0.2*CH2,0.7*CH2,'L',0.0,1)
       YLINE = YLINE - 2.25*CH2
       GO TO 5
      ENDIF
C
      IF(ALFVAR) THEN
       XPLT = 9.0*CH2 + MAWT*MAMIN
       YPLT = YLINE
       CALL PLMATH(XPLT    ,YPLT        ,1.2*CH2,'a',0.0,1)
       YLINE = YLINE - 2.25*CH2
       GO TO 5
      ENDIF
C
c
      IF(ALFVAR) THEN
       XPLT = 7.5*CH2 + MAWT*MAMIN
       YPLT = YLINE
       ITYP = IMATYP(1)
       IF(ITYP.EQ.1 .OR. ITYP.EQ.3) THEN
        CALL PLCHAR(XPLT    ,YPLT,    CH2,'Ma',0.0,2)
       ELSE IF(ITYP.EQ.2) THEN
        CALL PLCHAR(XPLT-CH2    ,YPLT,    CH2,'Ma CL',0.0,5)
        CALL PLMATH(XPLT+CH2    ,YPLT,    CH2,'  R  ',0.0,5)
       ENDIF
       YLINE = YLINE - 2.25*CH2
       GO TO 5
      ENDIF
C
      IF(GRDVAR) THEN
       XPLT = 7.5*CH2 + MAWT*MAMIN
       YPLT = YLINE
       CALL PLCHAR(XPLT    ,YPLT,    CH2,'Grid',0.0,4)
       GO TO 5
      ENDIF
c
 5    CONTINUE
C
C---- find which sweep has the rightmost point
      MPMAX = -1.0E9
      IPMAX = 1
      IAMAX = 1
      DO 8 IP=1, NPOL
        MAP = CPOL(1,IMA,IP)
        CLP = CPOL(1,ICL,IP)
        IF(LMRED) THEN
         MPTEST = MAP * SQRT(CLP)
        ELSE
         MPTEST = MAP
        ENDIF
        IF(MPTEST .GT. MPMAX) THEN
         MPMAX = MPTEST
         IPMAX = IP
         IAMAX = 1
        ENDIF
C
        MAP = CPOL(NA(IP),IMA,IP)
        CLP = CPOL(NA(IP),ICL,IP)
        IF(LMRED) THEN
         MPTEST = MAP * SQRT(CLP)
        ELSE
         MPTEST = MAP
        ENDIF
        IF(MPTEST .GT. MPMAX) THEN
         MPMAX = MPTEST
         IPMAX = IP
         IAMAX = NA(IP)
        ENDIF
 8    CONTINUE
C
C---- plot M-CD sweeps(s)
      DO 10 IP=1, NPOL
        CALL NEWCOLOR(ICOL(IP))
        CALL NEWPEN(4)
C
        IF(NA(IP).GT.NAXT) STOP 'SWPPLT: Array overflow. Increase NAXT.'
C
        IF(LMRED) THEN
         DO IA=1, NA(IP)
           MATMP(IA) = CPOL(IA,IMA,IP) * SQRT( ABS(CPOL(IA,ICL,IP)) )
         ENDDO
        ELSE
         DO IA=1, NA(IP)
           MATMP(IA) = CPOL(IA,IMA,IP)
         ENDDO
        ENDIF
C
        CALL XYLINE(NA(IP),MATMP(1),CPOL(1,ICD,IP),
     &              0.0,MAWT,0.0,CDWT,IP)
        IF(LSYMB) THEN
          CALL XYSYMB(NA(IP),MATMP(1),CPOL(1,ICD,IP),
     &                0.0,MAWT,0.0,CDWT,SHS,1)
        ENDIF
C
        IF(LCDWAV) THEN
         CALL NEWPEN(3)
         CALL XYLINE(NA(IP),MATMP(1),CPOL(1,ICW,IP),
     &               0.0,MAWT,0.0,CDWT,IP)
cc         CALL XYLINE(NA(IP),MATMP(1),CPOL(1,ICV,IP),
cc     &               0.0,MAWT,0.0,CDWT,IP)
        ENDIF
   10 CONTINUE
C
      IF(LCDWAV) THEN
       CALL NEWCOLOR(ICOL0)
       IP = IPMAX
       IA = IAMAX
       IF(LMRED) THEN
         XPLT = MAWT*CPOL(IA,IMA,IP) * SQRT( ABS(CPOL(IA,ICL,IP)) )
       ELSE
         XPLT = MAWT*CPOL(IA,IMA,IP)
       ENDIF
       XPLT = XPLT + 0.4*CH2
C
       YPLT = CPOL(IA,ICD,IP)*CDWT - 0.4*CH2
       CALL PLCHAR(XPLT,YPLT,0.8*CH2,'TOTAL',0.0,5)
       YPLT = CPOL(IA,ICW,IP)*CDWT - 0.4*CH2
       CALL PLCHAR(XPLT,YPLT,0.8*CH2,'WAVE',0.0,4)
cc       YPLT = CPOL(IA,ICV,IP)*CDWT - 0.4*CH2
cc       CALL PLCHAR(XPLT,YPLT,0.8*CH2,'VISC',0.0,4)
      ENDIF
C
C---- label each sweep with legend
      IF(NAMVAR .OR. REYVAR .OR. ACRVAR .OR. CELVAR .OR. ALFVAR) THEN
       DO 11 IP=1, NPOL
         CALL NEWCOLOR(ICOL(IP))
         XLIN(1) =     CH2 + MAWT*MAMIN
         XLIN(2) = 3.0*CH2 + MAWT*MAMIN
         XLIN(3) = 5.0*CH2 + MAWT*MAMIN
         YLIN(1) = YLINE + 0.5*CH2
         YLIN(2) = YLINE + 0.5*CH2
         YLIN(3) = YLINE + 0.5*CH2
         CALL NEWPEN(4)
         CALL XYLINE(3,XLIN,YLIN,0.0,1.0,0.0,1.0,IP)
         CALL NEWPEN(2)
         XPT = 6.5*CH2 + MAWT*MAMIN
         NN = LEN(NAME(IP))
         IF(NAMVAR) CALL PLCHAR(XPT,YLINE,.8*CH2,NAME(IP)      ,0.,NN)
         IF(REYVAR) CALL PLNUMB(XPT,YLINE,.8*CH2,REYN(IP)*1.E6 ,0.,-1)
         IF(ACRVAR) CALL PLNUMB(XPT,YLINE,.8*CH2,ACRIT(IP)     ,0., 3)
         IF(CELVAR) CALL PLNUMB(XPT,YLINE,.8*CH2,CELL(IP)      ,0., 4)
         IF(ALFVAR) CALL PLNUMB(XPT,YLINE,.8*CH2,ALFA(IP)      ,0., 4)
         YLINE = YLINE - 2.0*CH2
   11  CONTINUE
       YLINE = YLINE - 0.5*CH2
C
      ENDIF
C
C---- plot MA-CD reference data
      DO 13 ID=1, NDAT
        IF(NF(1,ID).EQ.0) GO TO 13
C
        CALL NEWCOLOR(IFCOL(ID))
C
        CALL NEWPEN(3)
        CALL XYSYMB(NF(1,ID),XYREF(1,1,1,ID),XYREF(1,2,1,ID),
     &              0.0,MAWT,0.0,CDWT,SH,ID)
        XPLT = 1.5*CH2 + MAWT*MAMIN
        YPLT = YLINE + 0.5*CH2
        CALL PLSYMB(XPLT,YPLT,SH,ID,0.0,0)
        XPLT = MAWT*MAMIN + 3.0*CH2
        CALL NEWPEN(2)
        LABLEN = LEN(LABREF(ID))
        CALL PLCHAR(XPLT,YLINE,0.8*CH2,LABREF(ID),0.0,LABLEN)
        YLINE = YLINE - 2.0*CH2
   13 CONTINUE
C
      CALL NEWCOLOR(ICOL0)
C
C----- coarse grid
       CALL NEWPEN(1)
       DXG = MAWT*MADEL
       DYG = CDWT*CDDEL
C
       NYGBOX = INT( DYBOX/(DYG/5.0) ) + 1
       IF (LINBOX.EQ.0) NYGBOX = 0
       DYGBOX = (DYG/5.0) * FLOAT(NYGBOX)
C
       Y0 = CDWT*CDMIN
       NXG = INT( (MAMAX-MAMIN)/MADEL + 0.01 )
       NYG = INT( (CDMAX-CDMIN)/CDDEL + 0.01 )
       DO 15 K=0, NXG
         XL = MAWT*(MAMIN + MADEL*FLOAT(K))
         CALL PLOT(XL,Y0,3)
         IF(K.GE.NXG/2) CALL PLOT(XL, Y0 + DYG*FLOAT(NYG)       , 2)
         IF(K.LT.NXG/2) CALL PLOT(XL, Y0 + DYG*FLOAT(NYG)-DYGBOX, 2)
   15  CONTINUE
C
       X0 = MAWT*MAMIN
       DO 16 K=0, NYG
         YL = Y0 + DYG*FLOAT(K)
         CALL PLOT(X0, YL, 3)
CCC         IF(K.NE.NYG) CALL PLOT(X0          , YL, 3)
CCC         IF(K.EQ.NYG) CALL PLOT(X0 + 2.0*DXG, YL, 3)
         CALL PLOT(MAWT*MAMAX, YL, 2)
   16  CONTINUE
C
      IF(LGRID) THEN
C
C----- fine grid
       CALL NEWPEN(1)
       DXG = MAWT*MADEL / 5.0
       DYG = CDWT*CDDEL / 5.0
C
CCC       IF(K.GE.NXG/2) CALL PLOT(XL, Y0 + DYG*FLOAT(NYG)       , 2)
CCC       IF(K.LT.NXG/2) CALL PLOT(XL, Y0 + DYG*FLOAT(NYG)-DYGBOX, 2)
       X0 = MAWT*MAMIN
       Y0 = CDWT*CDMIN
       NXGF = 5*(NXG/2)
       NYGF = 5* NYG   - NYGBOX
       CALL PLGRID(X0,Y0, NXGF,DXG, NYGF,DYG, LMASK2 )
C
       X0 = X0 + DXG*FLOAT(NXGF)
       NXGF = 5*NXG - NXGF
       NYGF = 5*NYG
       CALL PLGRID(X0,Y0, NXGF,DXG, NYGF,DYG, LMASK2 )
C
      ENDIF
C
C---- code and version identifier
      CHI = 0.7*CH2
      CALL NEWPEN(2)
      XPLT = MAWT*MAMAX - 11.0*CHI
      YPLT = CDWT*CDMAX + 0.5*CHI
      CALL PLCHAR(XPLT        ,YPLT,CHI,CODE   ,0.0,5)
      CALL PLCHAR(XPLT+6.0*CHI,YPLT,CHI,'V'    ,0.0,1)
      CALL PLNUMB(XPLT+8.0*CHI,YPLT,CHI,VERSION,0.0,1)
C
      CALL PLFLUSH
C
      RETURN
      END ! SWPPLT
 


      SUBROUTINE LABEL(NPOL, NAME ,ICOL,
     &                 IRETYP,
     &                 REYN, ACRIT, CELL, ALFA, LCLCON, LALCON,
     &                 TITLE, LLIST,
     &                 XPLT0,YPLT0, AR, CH,CH2 )
      IMPLICIT REAL (M)
      INCLUDE 'PINDEX.INC'
C
      CHARACTER*(*) NAME(NPOL)
      CHARACTER*(*) TITLE
      LOGICAL LCLCON(*), LALCON(*)
      LOGICAL LLIST
C
      DIMENSION ICOL(NPOL), IRETYP(NPOL)
      DIMENSION REYN(NPOL), ACRIT(NPOL), CELL(NPOL), ALFA(NPOL)
C
      CH3 = 0.90*CH2
      CH4 = 1.10*CH2
C
C---- y-spacing for label lines
      YSPC = 1.9*CH4
C
C...Put up title
C
      XPLT = XPLT0 - CH2
      YPLT = YPLT0 + 0.6*CH4
      IF(LLIST) YPLT = YPLT + YSPC*(NPOL+1)
      CALL NEWPEN(3)
      LENT = LEN(TITLE)
      CALL PLCHAR(XPLT,YPLT,1.2*CH4,TITLE,0.0,LENT)
C
      IF(.NOT.LLIST) RETURN
C
C...Put up polar identification data: name, flow conditions
      NMAX = 0
      DO 10 IP = 1, NPOL
        CALL STRIP(NAME(IP),NNAME)
        NMAX = MAX(NMAX,NNAME)
   10 CONTINUE
C
      DO 900 IP = 1, NPOL
       CALL NEWCOLOR(ICOL(IP))
C
       XPLT = XPLT0
       YPLT = YPLT0 + YSPC*(NPOL-IP+1)
C
       CALL NEWPEN(3)
       CALL PLCHAR(XPLT,YPLT,CH4,NAME(IP),0.0,NMAX)
       XPLT = XPLT + CH4*FLOAT(NMAX)
C
       CALL NEWPEN(2)
C
       ITYP = IRETYP(IP)
       IF(ITYP.EQ.1) THEN
        CALL PLCHAR(XPLT,YPLT,CH3,'   Re = '   ,0.0,  8)
        XPLT = XPLT + CH3*8.0
       ELSE IF(ITYP.EQ.2) THEN
        CALL PLCHAR(XPLT,YPLT,CH3,'   Re CL = ',0.0, 11)
        CALL PLMATH(XPLT,YPLT,CH3,'     R     ',0.0, 11)
        XPLT = XPLT + CH3*11.0
       ELSE IF(ITYP.EQ.3) THEN
        CALL PLCHAR(XPLT,YPLT,CH3,'   Re CL = ',0.0, 11)
        CALL PLMATH(XPLT,YPLT,CH3,'     #     ',0.0, 11)
        XPLT = XPLT + CH3*11.0
       ENDIF
       CALL PLNUMB(XPLT        ,YPLT,        CH3,REYN(IP),0.0,3)
       CALL PLMATH(XPLT+6.3*CH3,YPLT,        CH3,'#'     ,0.0,1)
       CALL PLCHAR(XPLT+7.2*CH3,YPLT,        CH3,  '10'    ,0.0,2)
       CALL PLMATH(XPLT+9.2*CH3,YPLT+0.4*CH3,CH3,     '6',0.0,1)
C
       XPLT = XPLT + 10.0*CH3
C
       IF(LCLCON(IP)) THEN
        CALL PLCHAR(XPLT,YPLT,CH3,'   CL = ',0.0,8)
        XPLT = XPLT + CH3*8.0
        CALL PLNUMB(XPLT,YPLT,CH3,CELL(IP)  ,0.0,3)
        XPLT = XPLT + CH3*5.0
       ENDIF
C
       IF(LALCON(IP)) THEN
        CALL PLMATH(XPLT,YPLT,CH3,'    a = ',0.0,8)
        XPLT = XPLT + CH3*8.0
        CALL PLNUMB(XPLT,YPLT,CH3,ALFA(IP)  ,0.0,3)
        XPLT = XPLT + CH3*5.0
       ENDIF
C
       CALL PLCHAR(XPLT,YPLT,    CH3,'   N',0.0,4)
       XPLT = XPLT + CH3*4.0
       CALL PLCHAR(XPLT,YPLT,0.7*CH3,'crit',0.0,4)
       XPLT = XPLT + CH3*2.8
       CALL PLCHAR(XPLT,YPLT,    CH3,' = ' ,0.0,3)
       XPLT = XPLT + CH3*3.0
       CALL PLNUMB(XPLT,YPLT,    CH3,ACRIT(IP) ,0.0,3)
       XPLT = XPLT + CH3*6.0
C
  900 CONTINUE
C
      RETURN
      END ! LABEL



      SUBROUTINE MINMAX(NAX,NPOL,NA,CPOL,CPOLPLF)
      INCLUDE 'PINDEX.INC'
      DIMENSION NA(NPOL)
      DIMENSION CPOL(NAX,IPTOT,NPOL), CPOLPLF(3,IPTOT)
C--------------------------------------------
C     Determines max and min limits of polar
C     quantities among all polars passed in.
C--------------------------------------------
C
      DO 1 IP=1, NPOL
        DO 10 K=1, 4
          CPOLPLF(1,K) = CPOL(1,K,IP)
          CPOLPLF(2,K) = CPOL(1,K,IP)
          DO 100 I=2, NA(IP)
            CPOLPLF(1,K) = MIN( CPOL(I,K,IP) , CPOLPLF(1,K) )
            CPOLPLF(2,K) = MAX( CPOL(I,K,IP) , CPOLPLF(2,K) )
 100      CONTINUE
 10     CONTINUE
 1    CONTINUE
C
      RETURN
      END ! MINMAX


 
      SUBROUTINE GETDEF
      INCLUDE 'PINDEX.INC'
      INCLUDE 'SPLOT.INC'
C
C---- Plotting flag
      IDEV = 1   ! X11 window only
C     IDEV = 2   ! B&W PostScript output file only (no color)
C     IDEV = 3   ! both X11 and B&W PostScript file
C     IDEV = 4   ! Color PostScript output file only 
C     IDEV = 5   ! both X11 and Color PostScript file 

C---- Re-plotting flag (for hardcopy)
      IDEVRP = 2   ! B&W PostScript
C     IDEVRP = 4   ! Color PostScript
C
C---- PostScript output logical unit and file specification
      IPSLU = 0  ! output to file  plot.ps   on LU 4    (default case)
C     IPSLU = ?  ! output to file  plot?.ps  on LU 10+?
C
C---- screen fraction taken up by plot window upon opening
      SCRNFR = 0.70
C
C---- Default plot size in inches
C-    (Default plot window is 11.0 x 8.5)
      SIZE = 8.0
C
C
C---- plot aspect ratio V/H
      AR = 0.60
C
C---- character height
      CH  = 0.016
      CH2 = 0.0135
C
C---- set default color table and get number of colors
      CALL COLORMAPDEFAULT
      CALL GETNUMCOLOR(NCOLOR)
C
      LGRID = .TRUE.
      LSYMB = .FALSE.
      LCDWAV = .FALSE.
      LLIST = .TRUE.
      LMRED = .FALSE.
C
      CPOLPLF(1,ICD) = 0.0   ! CDmax
      CPOLPLF(2,ICD) = 0.02  ! CDmin
      CPOLPLF(3,ICD) = 0.005 ! Axis CD increment
C         
      CPOLPLF(1,ICM) = 0.0   ! -CMmax
      CPOLPLF(2,ICM) = 0.2   ! -CMmin
      CPOLPLF(3,ICM) = 0.02  ! Axis -CM increment
C         
      CPOLPLF(1,IMA) = 0.65  ! MAmax
      CPOLPLF(2,IMA) = 0.75  ! MAmin
      CPOLPLF(3,IMA) = 0.05  ! Axis MA increment
C
      NTITLE = 0
      TITLE = '                                '
CCC            12345678901234567890123456789012
C
C...Try to read SPLOT.DEF file
      OPEN(UNIT=10,FILE='splot.def',STATUS='OLD',ERR=900)
      READ(10,*) CPOLPLF(1,ICD), CPOLPLF(2,ICD), CPOLPLF(3,ICD)
      READ(10,*) CPOLPLF(1,IMA), CPOLPLF(2,IMA), CPOLPLF(3,IMA)
      READ(10,*) IDEV, SIZE
      READ(10,*) AR, LGRID, LSYMB
      READ(10,*) CH, CH2
      CLOSE(UNIT=10)
      RETURN
C
  900 WRITE(*,*)
      WRITE(*,*) 'No  splot.def  file found'
      WRITE(*,*) 'Hard-wired defaults used'
      WRITE(*,*)
      RETURN
      END ! GETDEF
 

 
      SUBROUTINE WRTDEF(LU)
      INCLUDE 'PINDEX.INC'
      INCLUDE 'SPLOT.INC'
      CHARACTER*1 CGRID, CSYMB
C
      CGRID = 'F'
      CSYMB = 'F'
      IF(LGRID) CGRID = 'T'
      IF(LSYMB) CSYMB = 'T'
C
      WRITE(LU,1020) CPOLPLF(1,ICD), CPOLPLF(2,ICD), CPOLPLF(3,ICD)
      WRITE(LU,1030) CPOLPLF(1,IMA), CPOLPLF(2,IMA), CPOLPLF(3,IMA)
      WRITE(LU,1060) IDEV, SIZE
      WRITE(LU,1070) AR, CGRID, CSYMB
      WRITE(LU,1080) CH, CH2
      RETURN
C
C...............................................
 1020 FORMAT(1X, F9.4,F9.4,F9.4 ,' | CDmin   CDmax    dCD')
 1030 FORMAT(1X, F9.4,F9.4,F9.4 ,' | MAmin   MAmax    dMA')
 1060 FORMAT(1X,I3,6X,F9.4,9X   ,' | device  width(in)')
 1070 FORMAT(1X,F9.4,8X,A1,8X,A1,' | height/width     grid?     symb?')
 1080 FORMAT(1X,F9.4 ,F9.4,9X   ,' | char.height1  char.height2')
      END ! WRTDEF



      SUBROUTINE GETSET
      INCLUDE 'PINDEX.INC'
      INCLUDE 'SPLOT.INC'
      LOGICAL OK
      CHARACTER*2 OPTION

C---- Change plotting parameters
C
    1 WRITE(*,1000)
 1000 FORMAT(/ '  1   Change CD scaling'
     &       / '  2   Change CM scaling'
     &       / '  3   Change MACH scaling'
     &       / '  4   Plot Size'
     &       / '  5   Plot Title'
     &       / '  6   CDwave plot toggle'
     &       / '  7   M sqrt(CL) axis toggle'
     &       / '  8   Line+symbol plot toggle'
     &       / '  9   Label list toggle'
     &       / ' 10   Write settings to  splot.def  file'
     &      // 'Select option:  ',$)
C
      READ(*,1005) OPTION
 1005 FORMAT(A)
C
      IF(OPTION .EQ. '  ' .OR. OPTION.EQ.'0 ') THEN
C
        RETURN
C
      ELSE IF(OPTION.EQ.'1 ') THEN
C
        WRITE(*,1200) (CPOLPLF(K,ICD), K=1, 3)
        READ (*,*   ) (CPOLPLF(K,ICD), K=1, 3)
C
      ELSE IF(OPTION.EQ.'2 ') THEN
C
        WRITE(*,1300) (CPOLPLF(K,ICM), K=1, 3)
        READ (*,*   ) (CPOLPLF(K,ICM), K=1, 3)
C
      ELSE IF(OPTION.EQ.'3 ') THEN
C
        WRITE(*,1400) (CPOLPLF(K,IMA), K=1, 3)
        READ (*,*   ) (CPOLPLF(K,IMA), K=1, 3)
C
      ELSE IF(OPTION.EQ.'4 ') THEN
C
        WRITE(*,1500) SIZE
        READ(*,*) SIZE
C
      ELSE IF(OPTION.EQ.'5 ') THEN
C
        TITLE = '                                '
CCC              12345678901234567890123456789012
        CALL ASKS('Enter plot title (32 chars)^',TITLE)
        CALL STRIP(TITLE,NTITLE)
C
      ELSE IF(OPTION.EQ.'6 ') THEN
C
        LCDWAV = .NOT. LCDWAV
        IF(     LCDWAV) WRITE(*,*) 'CDwave will be plotted'
        IF(.NOT.LCDWAV) WRITE(*,*) 'CDwave will not be plotted'
C
      ELSE IF(OPTION.EQ.'7 ') THEN
C
        LMRED = .NOT. LMRED
        IF(     LMRED) WRITE(*,*) 'M sqrt(CL) will be used for x-axis'
        IF(.NOT.LMRED) WRITE(*,*) 'M will be used for x-axis'
C
      ELSE IF(OPTION.EQ.'8 ') THEN
C
        LSYMB = .NOT. LSYMB
        IF(     LSYMB) WRITE(*,*) 'Lines+symbols will be plotted'
        IF(.NOT.LSYMB) WRITE(*,*) 'Lines only will be plotted'
C
      ELSE IF(OPTION.EQ.'9 ') THEN
C
        LLIST = .NOT. LLIST
        IF(     LLIST) WRITE(*,*) 'List of sweeps will be plotted'
        IF(.NOT.LLIST) WRITE(*,*) 'List of sweeps will not be plotted'
C
      ELSE IF(OPTION.EQ.'10') THEN
C
        OPEN(10,FILE='splot.def',STATUS='OLD',ERR=903)
        CALL ASKL('File  splot.def  exists.  Overwrite ?^',OK)
        IF(OK) GO TO 906
        WRITE(*,*)
        WRITE(*,*) 'No action taken'
        CLOSE(10)
        GO TO 1
C
 903    OPEN(10,FILE='splot.def',STATUS='UNKNOWN')
 906    CALL WRTDEF(10)
        WRITE(*,*)
        WRITE(*,*) 'File splot.def written'
        CLOSE(10)
C
      ENDIF
      GO TO 1
C
 1200 FORMAT(/' Current   CDmin, CDmax, dCD = ',3F10.5
     &       /' Enter new CDmin, CDmax, dCD:  ',$)
 1300 FORMAT(/' Current   CMmin, CMmax, dCM = ',3F10.5
     &       /' Enter new CMmin, CMmax, dCM:  ',$)
 1400 FORMAT(/' Current   MAmin, MAmax, dMA = ',3F10.5
     &       /' Enter new MAmin, MAmax, dMA:  ',$)
 1500 FORMAT(/' Current   plot size = ', F10.5
     &       /' Enter new plot size:  ',$)
      END ! GETSET



      SUBROUTINE GETREF(IREAD, FNREF,
     &            NFX,NDX,NDAT,NF,XYREF,LABREF )
      INCLUDE 'PINDEX.INC'
      CHARACTER*(*) FNREF(NDX),LABREF(NDX)
      DIMENSION NF(4,NDX)
      DIMENSION XYREF(NFX,2,4,NDX)
C
      CHARACTER*80 LINE
C
      IF    (IREAD.LE.-1) THEN
C------ read new data sets
        ID1 = 1
        IDN = NDX
      ELSEIF(IREAD.EQ.0 ) THEN
C------ re-read old data sets
        ID1 = 1
        IDN = NDAT
      ELSE
C------ read additional data sets
        ID1 = NDAT+1
        IDN = NDX
      ENDIF
C
C
      DO 900 ID=ID1, IDN
C
      IF(IREAD.NE.0) THEN
       CALL ASKS('Enter reference data filename or <return>^',FNREF(ID))
      ENDIF
C
      OPEN(UNIT=9,FILE=FNREF(ID),STATUS='OLD',ERR=901)
C
C---- try to read data label
      READ(9,1000,END=901) LINE
 1000 FORMAT(A)
C
      IF(LINE(1:1).EQ.'#') THEN
C------ set data label
        LABREF(ID) = LINE(2:80)
      ELSE
C------ ask for data label
        IF(IREAD.NE.0) THEN
          CALL ASKS('Enter label for reference data^',LABREF(ID))
        ENDIF
C------ go read data
        REWIND(9)
      ENDIF
C
      DO 100 K=1, 4
C
        DO 10 I=1, NFX
          READ(9,*,END=11,ERR=901) XYREF(I,1,K,ID), XYREF(I,2,K,ID)
          IF(XYREF(I,1,K,ID).EQ.999.0) GO TO 11
   10   CONTINUE
   11   NF(K,ID) = I-1
C
  100 CONTINUE
      CLOSE(UNIT=9)
C
  900 CONTINUE
C
  901 NDAT = ID-1
      WRITE(*,*)
      WRITE(*,*) NDAT, ' reference data files read in'
C
      RETURN
      END ! GETREF




      SUBROUTINE GETSWP(IREAD,FNPOL,
     &            NAX,NPX,NPOL,NA,CPOL, NAME,
     &            ISX,NBL,XTR,
     &            TITLE,CODE,VERSION )
      INCLUDE 'PINDEX.INC'
      CHARACTER*(*) FNPOL(NPX), NAME(NPX)
      CHARACTER*(*) CODE, TITLE
C
      DIMENSION NA(NPX), NBL(NPX)
      DIMENSION CPOL(NAX,IPTOT,NPX),
     &          XTR(NAX,ISX,NPX)
C
      REAL MACH
C
      CHARACTER*80 LINE
      CHARACTER*1 DUMMY
C
      IF    (IREAD.LE.-1) THEN
C------ read new polars
        IP1 = 1
        IPN = NPX
      ELSEIF(IREAD.EQ.0 ) THEN
C------ re-read old polars
        IP1 = 1
        IPN = NPOL
      ELSE
C------ read additional polars
        IP1 = NPOL+1
        IPN = NPX
      ENDIF
C
C
      DO 900 IP=IP1, IPN
C
      IF(IREAD.NE.0) THEN
        CALL ASKS('Enter sweep data filename or <return>^',FNPOL(IP))
      ENDIF
C
      OPEN(UNIT=9,FILE=FNPOL(IP),STATUS='OLD',ERR=901)
C
      READ(9,1000,END=901,ERR=901) DUMMY
      IF(IP.EQ.1) THEN
       READ(9,1005,END=901) CODE, VERSION
       CALL STRIP(CODE,NCODE)
      ELSE
       READ(9,1000,END=901) DUMMY
      ENDIF
      READ(9,1000,END=901) DUMMY
      READ(9,1000,END=901) LINE
C
      READ(LINE,1010,END=901) NAME(IP)
      K = INDEX(LINE,'element')
      NBL(IP) = 1
      IF(K.NE.0) READ(LINE(K-3:K-1),*,ERR=901) NBL(IP)
C
      READ(9,1000,END=901) DUMMY
      READ(9,1015,END=901,ERR=29) IRETYP, IMATYP
      GO TO 30
C
C----- no CL-dependence flags (V 3.2 ISES polar).  Assume Re, Ma are fixed.
   29  IRETYP = 1
       IMATYP = 1
C
   30 IF(IRETYP .EQ. 0) IRETYP = 1
      IF(IMATYP .EQ. 0) IMATYP = 1
      READ(9,1000,END=901) DUMMY
      READ(9,1000,END=901) DUMMY
      XTRS1 = 1.0
      XTRP1 = 1.0
      READ(9,1030,END=901,ERR=901) REYN, ACRIT
      READ(9,1000,END=901) DUMMY
      READ(9,1000,END=901) DUMMY
      READ(9,1000,END=901) DUMMY
      DO 40 IA=1, NAX
        READ(9,*,ERR=901,END=42)
     &     CPOL(IA,IMA,IP),
     &     CPOL(IA,IAL,IP),
     &     CPOL(IA,ICL,IP),
     &     CPOL(IA,ICD,IP),
     &     CPOL(IA,ICW,IP),
     &     CPOL(IA,ICM,IP),
     &     XTR(IA,1,IP),
     &     XTR(IA,2,IP)
        CPOL(IA,IRE,IP) = REYN
        CPOL(IA,INC,IP) = ACRIT
        CPOL(IA,IXT,IP) = XTRS1
        CPOL(IA,IXB,IP) = XTRP1
C
        CPOL(IA,ICV,IP) = CPOL(IA,ICD,IP) - CPOL(IA,ICW,IP)
C
        ACL = MAX( ABS( CPOL(IA,ICL,IP) ) , 0.0001 )
        IF(IRETYP.EQ.2) CPOL(IA,IRE,IP) = REYN/SQRT(ACL)
        IF(IRETYP.EQ.3) CPOL(IA,IRE,IP) = REYN/ACL
C
   40 CONTINUE
   42 NA(IP) = IA - 1
C
      CLOSE(UNIT=9)
C
      WRITE(*,8000) NAME(IP)
      IF(IMATYP.EQ.1) WRITE(*,8011) MACH 
      IF(IMATYP.EQ.2) WRITE(*,8012) MACH
      IF(IMATYP.EQ.3) WRITE(*,8013) MACH
      IF(IRETYP.EQ.1) WRITE(*,8021) REYN 
      IF(IRETYP.EQ.2) WRITE(*,8022) REYN
      IF(IRETYP.EQ.3) WRITE(*,8023) REYN
      WRITE(*,8030) ACRIT
C
  900 CONTINUE
  901 NPOL = IP-1
C
      RETURN
C
C..........................................
 1000 FORMAT(A)
 1005 FORMAT(A16,12X,F10.0)
 1010 FORMAT(22X,A32)
 1015 FORMAT(2I2)
 1030 FORMAT( 6X,F9.3,17X,F7.3)
 8000 FORMAT(1X,A32)
 8011 FORMAT('             Ma =', F7.3,       $)
 8012 FORMAT('    sqrt(CL)*Ma =', F7.3,       $)
 8013 FORMAT('          CL*Ma =', F7.3,       $)
 8021 FORMAT('             Re =', F7.3,' e 6',$)
 8022 FORMAT('    sqrt(CL)*Re =', F7.3,' e 6',$)
 8023 FORMAT('          CL*Re =', F7.3,' e 6',$)
 8030 FORMAT('          Ncrit =', F6.2         )
      END ! GETSWP



      SUBROUTINE SORT(N,A,ISORT)
      DIMENSION A(N), ISORT(N)
C
      LOGICAL DONE
C
      DO 1 I=1, N
        ISORT(I) = I
 1    CONTINUE
C
      DO 2 IPASS=1, 12345
        DONE = .TRUE.
C
        DO 20 I=2, N
C
          IO = ISORT(I  )
          IM = ISORT(I-1)
C
          IF(A(IO) .GE. A(IM)) GO TO 20
C
           DONE = .FALSE.
C
           ISORT(I  ) = IM
           ISORT(I-1) = IO
C
 20     CONTINUE
C
        IF(DONE) RETURN
C
    2 CONTINUE
C
      END ! SORT
 

      SUBROUTINE GETTYP(NAX,NA,CPOL, IMATYP,IRETYP )
C
C---- Determines type of Ma(CL) and Re(CL) dependence
C
      INCLUDE 'PINDEX.INC'
C
      DIMENSION CPOL(NAX,IPTOT)
C
      IF(CPOL(NA,ICL)*CPOL(1,ICL) .LE. 0.0) THEN
        IMATYP = 1
        IRETYP = 1
        RETURN
      ENDIF
C
      IF(CPOL(NA,IMA)*CPOL(1,IMA) .LE. 0.0  .OR.
     &   CPOL(NA,ICL)/CPOL(1,ICL) .EQ. 1.0 ) THEN
        IMATYP = 1
      ELSE
        EX = LOG( CPOL(NA,IMA)/CPOL(1,IMA) )
     &     / LOG( CPOL(NA,ICL)/CPOL(1,ICL) )
        IF     (ABS(EX) .LT. 0.25) THEN
          IMATYP = 1
        ELSEIF (ABS(EX) .LT. 0.75) THEN
          IMATYP = 2
        ELSE
          IMATYP = 3
        ENDIF
      ENDIF
C
      IF(CPOL(NA,IRE)*CPOL(1,IRE) .LE. 0.0  .OR.
     &   CPOL(NA,ICL)/CPOL(1,ICL) .EQ. 1.0 ) THEN
        IRETYP = 1
      ELSE
        EX = LOG( CPOL(NA,IRE)/CPOL(1,IRE) )
     &     / LOG( CPOL(NA,ICL)/CPOL(1,ICL) )
        IF     (ABS(EX) .LT. 0.25) THEN
          IRETYP = 1
        ELSEIF (ABS(EX) .LT. 0.75) THEN
          IRETYP = 2
        ELSE
          IRETYP = 3
        ENDIF
      ENDIF
C
      RETURN
      END ! GETTYP


      SUBROUTINE GETVAR(NAX,NPOL,NAME,CPOL,
     &                  NAMVAR,REYVAR,ACRVAR,CELVAR,ALFVAR,GRDVAR)
      IMPLICIT REAL (M)
      INCLUDE 'PINDEX.INC'
      CHARACTER*(*) NAME
      LOGICAL NAMVAR,REYVAR,ACRVAR,CELVAR,ALFVAR,GRDVAR
C
      DIMENSION NAME(NPOL)
      DIMENSION CPOL(NAX,IPTOT,NPOL)
C
      NAMVAR = .FALSE.
      REYVAR = .FALSE.
      ACRVAR = .FALSE.
      CELVAR = .FALSE.
      ALFVAR = .FALSE.
      GRDVAR = .FALSE.
C
      DO 10 IP=1, NPOL-1
        NLO = LEN(NAME(IP)  )
        NLP = LEN(NAME(IP+1))
        IF(NAME(IP  )(1:NLO) .NE.
     &     NAME(IP+1)(1:NLP)      ) THEN
            NAMVAR = .TRUE.
            RETURN
        ENDIF
   10 CONTINUE      
C
      DO 20 IP=1, NPOL-1
        IF(CPOL(1,IRE,IP).NE.CPOL(1,IRE,IP+1)) THEN
         REYVAR = .TRUE.
         RETURN
        ENDIF
   20 CONTINUE      
C
      DO 30 IP=1, NPOL-1
        IF(CPOL(1,INC,IP).NE.CPOL(1,INC,IP+1)) THEN
         ACRVAR = .TRUE.
         RETURN
        ENDIF
   30 CONTINUE      
C
      DO 40 IP=1, NPOL-1
        IF(CPOL(1,ICL,IP).NE.CPOL(1,ICL,IP+1)) THEN
         CELVAR = .TRUE.
         RETURN
        ENDIF
   40 CONTINUE      
C
      DO 50 IP=1, NPOL-1
        IF(CPOL(1,IAL,IP).NE.CPOL(1,IAL,IP+1)) THEN
         ALFVAR = .TRUE.
         RETURN
        ENDIF
   50 CONTINUE      
C
c      DO 60 IP=1, NPOL-1
c         GRDVAR = .TRUE.
c         RETURN
c   60 CONTINUE      
C
      RETURN
      END ! GETVAR
