

      SUBROUTINE STRMPL
C---------------------------------------------------
C     Plots streamtube quantities versus arc length.
C---------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      LOGICAL BLANK, LAXES, LOFINI, LINPUT, ERROR
      DIMENSION XP(2),YP(2)
C
      DIMENSION JSTR(JX)
      CHARACTER*1 VAR, COPT
C
      DATA LMASK1, LMASK2, LMASK3 / -32640, -30584, -21846 /
C
      SMOD(SS) = (SS - SOFF)*SSF
      WMOD(WW) = (WW - WOFF)*WSF
C
C
      CH2 = 0.7*CH
      SH  = 0.2*CH2
C
C---- origin location / size
      XORG = 0.125
      YORG = 0.10
C
C---- set initial S-axis limits
      SMAX = MAX( SC(II-1,1) , SC(II-1,JJ-1) )
      SMIN = MIN( SC(   1,1) , SC(   1,JJ-1) )
C
      CALL SCALIT(1,SMAX,SMIN,SSCAL,ANN,NANN)
      SDEL = 1.0/(SSCAL*FLOAT(NANN))
      SMAX = SDEL * AINT(SMAX/SDEL + 0.49 + SIGN(0.50,SMAX))
      SMIN = SDEL * AINT(SMIN/SDEL - 0.49 + SIGN(0.50,SMIN))
C
C---- fraction of full plot size taken up by x-y plot
      SIZFAC = 0.8
C
C---- number of grid intervals per axis annotation interval
      NGR = 2
C
C---- default is lines plotted with symbols
      KSYMB = -1
C
C---- clear streamtube accumulator array
      NSTR = 0
      KSTR = 0
C
C---- streamtube numbers are to be requested from user
      LINPUT = .TRUE.
C
      LPLOT = .FALSE.
      BLANK = .TRUE.
C
      CALL GETCOLOR(ICOL0)
C
  990 WRITE(*,1990)
 1990 FORMAT(/1X,'-------------------------------------------'
     &      //1X,' 1  Streamtube quantity (M,P,R,Q,D,C,L,T,F) vs S'
     &       /1X,' 2  Clear current streamtube list'
     &       /1X,' 3  Blowup current plot'
     &       /1X,' 4  Reset S scaling'
     &       /1X,' 5  Options'
     &       /1X,' 6  Annotation menu'
     &       /1X,' 7  Hardcopy current plot'
     &       /1X,' 8  Toggle symbol plotting')
  995 WRITE(*,1995)
 1995 FORMAT(/1X,'Select streamtube plot option:  ',$)
      READ(*,1000) COPT
C
      IF(INDEX('0 ',COPT).NE.0) THEN
        IF(LPLOT) CALL PLEND
        LPLOT = .FALSE.
        RETURN
      ENDIF
C
      IF(INDEX('MPRQDCLTFmprqdcltf',COPT) .NE. 0) THEN
C------ one of the variable keyword letters was selected... go plot it
        NOPT = 1
        VAR = COPT
        LAXES = .FALSE.
        LOFINI = .FALSE.
        KSTR = 0
        IF(NSTR.EQ.0) LINPUT = .TRUE.
        WRITE(*,*)
        GO TO 12
      ELSE
        NOPT = 0
        READ(COPT,*,ERR=990) NOPT
      ENDIF
C
 1000 FORMAT(A)
C
      GOTO(10,20,30,40,50,60,70,80), NOPT
      GO TO 990
C
C======================================================
C---- Plot STATE.INC' variable vs s along streamtube
C
   10 CONTINUE
C
      LAXES = .FALSE.
      LOFINI = .FALSE.
      KSTR = 0
      IF(NSTR.EQ.0) LINPUT = .TRUE.
C
      WRITE(*,2000)
 2000 FORMAT(/'   M ach '
     &       /'   P ressure / Po'
     &       /'   R ho      / Ro'
     &       /'   Q         / Qinf'
     &       /'   D elta(Q) / Q     (speed change due to upwinding)'
     &       /'   C p                     ( dP  / q  )'
     &       /'   L oss coefficient       ( dPo / q  )'
     &       /'   T otal pressure change  ( dPo / Po )'
     &       /'   F  momentum-conservation trigger  0..1'
     &      //' Select streamtube flow quantity:  ', $)
      READ(*,1000) VAR
      IF (INDEX(' ',VAR).EQ.1) GO TO 990
C
      IF (INDEX('MPRQDCLTF',VAR).LE.0 .AND.
     &    INDEX('mprqdcltf',VAR).LE.0       ) GO TO 10
C
      WRITE(*,*)
C
C---- pick up here to plot new streamtube 
   12 CONTINUE
C
      IF(KSTR.LT.NSTR) THEN
C------ take number of to-be-plotted streamtube from accumulator array
C
        KSTR = KSTR + 1
        JO = JSTR(KSTR)
C
      ELSE IF(LINPUT) THEN
C------ get new streamtube number from user
C
        CALL GETSTR(NSTR,JO)
C
        IF(KSTR.EQ.NSTR .OR. JO.EQ.0) THEN
C-------- no new streamtube was input... 
C-          ...disable further input, prepare for new plot, return to menu
          LINPUT = .FALSE.
          KSTR = 0
          GO TO 990
        ENDIF
C
C------ set current-streamtube counter, add streamtube to accumulator array
        KSTR = NSTR
        JSTR(KSTR) = JO
C
      ELSE
C------ return to menu
        GO TO 990
      ENDIF
C
C
C---- fill flow variable array for selected streamtube
      IF    (INDEX('Mm',VAR).GT.0) THEN
C
        DO 131 I=1, II-1
          W(I) = Q(I,JO) / SQRT(GM1*(HINF-0.5*Q(I,JO)**2))
          S(I) = SC(I,JO)
 131    CONTINUE
C
      ELSEIF(INDEX('Pp',VAR).GT.0) THEN 
C
        DO 132 I=1, II-1
          W(I) = (P(I,JO)+PSTINF)/PSTINF
          S(I) = SC(I,JO)
 132    CONTINUE
C
      ELSEIF(INDEX('Rr',VAR).GT.0) THEN
C
        DO 133 I=1, II-1
          W(I) = R(I,JO)/RSTINF
          S(I) = SC(I,JO)
 133    CONTINUE
C
      ELSEIF(INDEX('Qq',VAR).GT.0) THEN
C
        DO 134 I=1, II-1
          W(I) = Q(I,JO)/QINF
          S(I) = SC(I,JO)
 134    CONTINUE
C
      ELSEIF(INDEX('Dd',VAR).GT.0) THEN
C
        DO 135 I=1, II-1
          W(I) = (QS(I,JO)-Q(I,JO))/Q(I,JO)
          S(I) = SC(I,JO)
 135    CONTINUE
C
      ELSEIF(INDEX('Cc',VAR).GT.0) THEN
C
        DPINF = PINF-PSTINF
        DO 136 I=1, II-1
          W(I) = -(P(I,JO)-DPINF)/QU
          S(I) = SC(I,JO)
 136    CONTINUE
C
      ELSEIF(INDEX('Ll',VAR).GT.0) THEN
C
        DO 137 I=1, II-1
          W(I) = (PST(I,JO) - PSTINF)/QU
          S(I) = SC(I,JO)
 137    CONTINUE
C
      ELSEIF(INDEX('Tt',VAR).GT.0) THEN
C
        DO 138 I=1, II-1
          W(I) = (PST(I,JO)-PSTINF)/PSTINF
          S(I) = SC(I,JO)
 138    CONTINUE
C
      ELSEIF(INDEX('Ff',VAR).GT.0) THEN
C
        QSTAR  =  SQRT(2.0*HINF/(2.0/GM1 + 1.0))
        W(1) = 0.0
        W(2) = 0.0
        W(3) = 0.0
        DO 139 I=4, II-1
          IK = I-3
          IL = I-2
          IM = I-1
          IO = I
C
          Q9 = Q(IK,JO)
          Q0 = Q(IL,JO)
C
          R1 = R(IM,JO)
          Q1 = Q(IM,JO)
          P1 = P(IM,JO) + PSTINF
          DQ1 = QS(IM,JO) - Q(IM,JO)
C
          R2 = R(IO,JO)
          Q2 = Q(IO,JO)
          P2 = P(IO,JO) + PSTINF
          DQ2 = QS(IO,JO) - Q(IO,JO)
C
          DQTL = MIN( (Q0 - Q9)/QSTAR , 0.0 )
          DQTM = MIN( (Q1 - Q0)/QSTAR , 0.0 )
          DQTO = MIN( (Q2 - Q1)/QSTAR , 0.0 )
          ARG = (DQTL/DQTEPS)**2 + (DQTM/DQTEPS)**2 + (DQTO/DQTEPS)**2
          EXQ = EXP(-ARG)
C
          DDQ = MIN( 0.5*(DQ1+DQ2)*(R2*Q2/P2 - R1*Q1/P1) , 0.0 )
          ARG = (DDQ/DPTEPS)**2
          EXT = EXP(-ARG)
C
          FSMOM = (1.0 - EXT)*(1.0 - EXQ)
          W(I) = FSMOM
          S(I) = 0.5*(SC(IM,JO) + SC(IO,JO))
 139    CONTINUE

      ENDIF
C
C
      IF(.NOT. LOFINI) THEN
C------ set initial scaling and offset parameters
C
        ILEFT = 1
        IRGHT = II-1
        DO 141 I=1, II-1
          IF(S(I) .LE. SMIN) ILEFT = I
          IF(S(I) .LE. SMAX) IRGHT = I
 141    CONTINUE

        WMAX = W(ILEFT)
        WMIN = W(ILEFT)
        DO 144 I=ILEFT, IRGHT
          WMAX = MAX( WMAX , W(I) )
          WMIN = MIN( WMIN , W(I) )
 144    CONTINUE
C
        CALL SCALIT(1,WMAX,WMIN,WSCAL,ANN,NANN)
        WDEL = 1.0/(WSCAL*FLOAT(NANN))
        WMAX = WDEL * AINT(WMAX/WDEL + 0.499 + SIGN(0.50,WMAX))
        WMIN = WDEL * AINT(WMIN/WDEL - 0.499 + SIGN(0.50,WMIN))
C
        WMAX = MAX( WMAX , WMIN+WDEL )
C
        IF(INDEX('Ff',VAR).GT.0) THEN
          WMIN = 0.0
          WMAX = 1.0
          WDEL = 0.2
        ENDIF
C
        LOFINI = .TRUE.
C
      ENDIF
C
C---- set plot offsets and scaling factors
      SOFF = SMIN
      WOFF = WMIN
      SSF = 1.0/(SMAX-SMIN)
      WSF = AR /(WMAX-WMIN)
C
      IF (.NOT. LAXES) THEN
C------ open window and plot axes for current scale/offset
C
        CALL PLTINI(SIZFAC)
        CALL PLOTABS(XORG*SIZE+XMARG,YORG*SIZE+YMARG,-3)
C
        CALL NEWPEN(2)
C
        XAXLEN = (SMAX-SMIN)*SSF
        DXANN = SDEL*SSF
        CALL XAXIS(SMOD(SMIN),WMOD(WMIN),XAXLEN,DXANN,SMIN,SDEL,CH2,-2)
        CALL PLCHAR(SMOD(SMAX)-0.5*DXANN-0.5*CH,WMOD(WMIN)-2.2*CH,
     &              1.1*CH,'s',0.0,1)
C
        YAXLEN = (WMAX-WMIN)*WSF
        DYANN = WDEL*WSF
        CALL YAXIS(SMOD(SMIN),WMOD(WMIN),YAXLEN,DYANN,WMIN,WDEL,CH2,-2)
C
        XPLT = SMOD(SMIN)
        YPLT = WMOD(WMAX)-0.5*DYANN-0.5*CH
C
        IF    (INDEX('Mm',VAR).GT.0) THEN
          CALL PLCHAR(XPLT-3.0*CH,YPLT,1.2*CH,'M'  ,0.0,1)
        ELSEIF(INDEX('Pp',VAR).GT.0) THEN 
          CALL PLCHAR(XPLT-4.5*CH,YPLT       ,    CH,'p/p ',0.0,4)
          CALL PLCHAR(XPLT-1.6*CH,YPLT-0.3*CH,0.6*CH,   'o',0.0,1)
        ELSEIF(INDEX('Rr',VAR).GT.0) THEN
          CALL PLMATH(XPLT-4.5*CH,YPLT       ,    CH,'r/r ',0.0,4)
          CALL PLCHAR(XPLT-1.6*CH,YPLT-0.3*CH,0.6*CH,   'o',0.0,1)
        ELSEIF(INDEX('Qq',VAR).GT.0) THEN
          CALL PLCHAR(XPLT-4.5*CH,YPLT,CH,'q/q ',0.0,4)
          CALL PLMATH(XPLT-4.5*CH,YPLT,CH,'   &',0.0,4)
        ELSEIF(INDEX('Dd',VAR).GT.0) THEN
          CALL PLMATH(XPLT-4.5*CH,YPLT,CH,'O   ',0.0,4)
          CALL PLCHAR(XPLT-4.5*CH,YPLT,CH,' q/q',0.0,4)
        ELSEIF(INDEX('Cc',VAR).GT.0) THEN
          CALL PLCHAR(XPLT-4.5*CH,YPLT       ,1.2*CH,'-C' ,0.0,2)
          CALL PLCHAR(XPLT-2.3*CH,YPLT-0.3*CH,0.9*CH,  'p',0.0,1)
        ELSEIF(INDEX('Ll',VAR).GT.0) THEN
          CALL PLMATH(XPLT-4.0*CH,YPLT       ,1.2*CH,'O '  ,0.0,2)
          CALL PLCHAR(XPLT-4.0*CH,YPLT       ,1.2*CH,' C'  ,0.0,2)
          CALL PLCHAR(XPLT-1.8*CH,YPLT-0.3*CH,0.9*CH,  'p' ,0.0,1)
          CALL PLCHAR(XPLT-1.1*CH,YPLT-0.6*CH,0.6*CH,   'o',0.0,1)
        ELSEIF(INDEX('Tt',VAR).GT.0) THEN
          CALL PLMATH(XPLT-6.0*CH,YPLT       ,    CH,'O     ',0.0,6)
          CALL PLCHAR(XPLT-6.0*CH,YPLT       ,    CH,' p /p ',0.0,6)
          CALL PLCHAR(XPLT-4.1*CH,YPLT-0.3*CH,0.6*CH,  'o'   ,0.0,1)
          CALL PLCHAR(XPLT-1.1*CH,YPLT-0.3*CH,0.6*CH,     'o',0.0,1)
        ELSEIF(INDEX('Ff',VAR).GT.0) THEN
          CALL PLCHAR(XPLT-2.5*CH,YPLT       ,1.2*CH,'f'  ,0.0,1)
        ENDIF
C
C
C------ initialize line number and label location
        ILIN = 0
        XLAB = SMOD(SMIN) + 2.5*CH2
        YLAB = WMOD(WMIN) - 0.5*CH2
C
        IF(LGRID) THEN
         NXGR = NGR * INT(XAXLEN/DXANN + 0.001)
         NYGR = NGR * INT(YAXLEN/DYANN + 0.001)
         DXG = DXANN / FLOAT(NGR)
         DYG = DYANN / FLOAT(NGR)
         CALL NEWPEN(1)
         CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
        ENDIF
C
        CALL PLFLUSH
        CALL NEWPEN(2)
C
        LAXES = .TRUE.
      ENDIF
C
C
C---- Do plotting for this streamtube
      ICOL = 3 + MOD(KSTR-1,8)
      IF(LCOLOR) CALL NEWCOLOR(ICOL)
C
      CH3 = 0.6*CH
      ILIN = ILIN + 1
      YLAB = YLAB + 1.9*CH3
      XP(1) = XLAB
      XP(2) = XP(1) + 5.0*CH3
      YP(1) = YLAB  + 0.5*CH3
      YP(2) = YP(1)
      RJO = FLOAT(JO)
      CALL XYPLOT(2,XP,YP,0.0,1.0,0.0,1.0,ILIN,SH,KSYMB)
      CALL PLCHAR(XLAB+5.5*CH3,YLAB,CH3,' STREAMTUBE ',0.0,12)
      CALL PLNUMB(999.0,999.0,CH3,RJO,0.0,-1)
      CALL XYPLOT(II-1,S,W,SOFF,SSF,WOFF,WSF, ILIN,SH,KSYMB)
C
      CALL NEWCOLOR(ICOL0)
      CALL PLFLUSH
C
      BLANK = .FALSE.
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
      GO TO 12
C
C======================================================
C---- set up for new streamtube list
C
 20   KSTR = 0
      NSTR = 0
      LINPUT = .TRUE.
      GO TO 990
C
C======================================================
C---- Zoom in on the plot
C
 30   IF ((.NOT.LCURS) .OR. (.NOT.BLANK)) THEN
        CALL OFFGET(SOFF,WOFF,SSF,WSF,1.0,AR,.FALSE.,LCURS)
        SMIN = SOFF
        WMIN = WOFF
        SMAX = SOFF + 1.0/SSF
        WMAX = WOFF + AR /WSF
C
        CALL SCALIT(1,SMAX,SMIN,SSCAL,ANN,NANN)
        SDEL = 1.0/(SSCAL*FLOAT(NANN))
        SMAX = SDEL * AINT(SMAX/SDEL + 0.49 + SIGN(0.50,SMAX))
        SMIN = SDEL * AINT(SMIN/SDEL - 0.49 + SIGN(0.50,SMIN))
C
        CALL SCALIT(1,WMAX,WMIN,WSCAL,ANN,NANN)
        WDEL = 1.0/(WSCAL*FLOAT(NANN))
        WMAX = WDEL * AINT(WMAX/WDEL + 0.49 + SIGN(0.50,WMAX))
        WMIN = WDEL * AINT(WMIN/WDEL - 0.49 + SIGN(0.50,WMIN))
C
        BLANK = .TRUE.
        LAXES = .FALSE.
C
C------ go replot all accumulated streamtubes
        KSTR = 0
        WRITE(*,*)
        GO TO 12
      ELSE
        WRITE(*,*) 'Select streamline plot first'
      ENDIF
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
      GOTO 990
C
C======================================================
C---- Reset S scaling
C
 40   SMAX = MAX( SC(II-1,1) , SC(II-1,JJ-1) )
      SMIN = MIN( SC(   1,1) , SC(   1,JJ-1) )
C
      CALL SCALIT(1,SMAX,SMIN,SSCAL,ANN,NANN)
      SDEL = 1.0/(SSCAL*FLOAT(NANN))
      SMAX = SDEL * AINT(SMAX/SDEL + 0.49 + SIGN(0.50,SMAX))
      SMIN = SDEL * AINT(SMIN/SDEL - 0.49 + SIGN(0.50,SMIN))
C
      GO TO 995
C
C======================================================
C---- Change settings
C
 50   CALL OPLSET(IDEVRP,IPSLU,
     &            SIZE,AR,
     &            XMARG,YMARG,XPAGE,YPAGE,
     &            CH,SCRNFR,LCURS,LLAND)
C
C---- if there is a plot on screen... go replot it
      IF(.NOT.BLANK) THEN
        LAXES = .FALSE.
        KSTR = 0
        WRITE(*,*)
        GO TO 12
      ENDIF
      GO TO 990
C
C======================================================
C---- annotate current plot
C
 60   CALL ANNOT(CH)
      GO TO 990
C
C======================================================
C---- make hardcopy
C
 70   IF(LPLOT) CALL PLEND
      LPLOT = .FALSE.
      CALL REPLOT(IDEVRP)
      GO TO 995
C
C======================================================
C---- Toggle symbol plotting
C
 80   IF(KSYMB.EQ.0) THEN
        KSYMB = -1
      ELSE
        KSYMB = 0
      ENDIF
C
C---- if there is a plot currently on screen... go replot it
      IF(.NOT.BLANK) THEN
       LAXES = .FALSE.
       KSTR = 0
       WRITE(*,*)
       GO TO 12
      ENDIF
C
      GO TO 990
C
      END ! STRMPL



      SUBROUTINE GETSTR(NSTR,JO)
C------------------------------------------
C     Gets new streamtube number from user
C------------------------------------------
C
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
C
      CHARACTER*32 CNUM
C
 1000 FORMAT(A)
C
      IF(NSTR.EQ.0) THEN
C
C------ display streamtube numbering to help selection
        WRITE(*,2010) JJ-1
        DO 10 N=1, NBL
          WRITE(*,2020) N, JBLD(N), JBLD(N)-2
 10     CONTINUE
        WRITE(*,2030) 1
C
 2010   FORMAT(/10X,    '       Grid top:',I5)
 2020   FORMAT(/10X,'Element',I2,' | top:',I5
     &         /10X,'       ',2X,' | bot:',I5)
 2030   FORMAT(/10X,    '       Grid bot:',I5 /)
C
      ENDIF
C
C---- assume first no streamtube will be input
      JO = 0
C
   50 WRITE(*,2050) 
 2050 FORMAT(1X,'    ... enter streamtube number (or <return>) :  ', $)
      READ(*,1000) CNUM
      IF(INDEX(CNUM(1:1),' ').EQ.1) RETURN
C
      READ(CNUM,*,ERR=50) JO
      IF (JO.EQ.0) RETURN
C
      IF(JO.LT.1 .OR. JO.GT.JJ-1) THEN
       WRITE(*,*) '*** Out of range.  Number of streamtubes = ',JJ-1
       GO TO 50
      ENDIF
      IF(JSTAG(JO).GT.0) THEN
       WRITE(*,*) '*** That is a dummy streamtube.'
       GO TO 50
      ENDIF
C
C---- set new number of streamtubes
      NSTR = NSTR + 1
C
      RETURN
      END ! GETSTR



      SUBROUTINE WAKEPL
C-------------------------------------------------
C     Plots exit wake plane profiles.
C-------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      LOGICAL BLANK, LAXES, LOFINI, LNUMST, ERROR
C
      DIMENSION YSTR(JX), YVAL(JX), REXIT(JX), QEXIT(JX)
      CHARACTER*1 VAR, COPT
C
      DATA LMASK1, LMASK2, LMASK3 / -32640, -30584, -21846 /
C
      ZMOD(ZZ) = (ZZ - ZOFF)*ZSF
      WMOD(WW) = (WW - WOFF)*WSF
C
C---- index of plane to be displayed
      I = II-1
C
      CH2 = 0.9*CH
      SH  = 0.25*CH2
C
C---- origin location (before plot scaling)
      XORG = 0.125
      YORG = 0.10
C
      SINA = SIN(ALFA)
      COSA = COS(ALFA)
C
C---- set exit-plane farfield rho,q, and streamline y arrays
      DO 3 J=1, JJ-1
        XA = 0.25*(X(I,J)+X(I+1,J)+X(I,J+1)+X(I+1,J+1))
        YA = 0.25*(Y(I,J)+Y(I+1,J)+Y(I,J+1)+Y(I+1,J+1))
        YVAL(J) = COSA*YA - SINA*XA
C
C------ set exit rho,q assuming isentropic relaxation to freestream pressure
        PRATX = (PINF/PST(I,J))**(GM1/GAM)
        RSTEX = PST(I,J)*GAM/(GM1*HINF)
        REXIT(J) = RSTEX * (PINF/PSTINF)**(1.0/GAM)
        QEXIT(J) = SQRT( ABS(2.0*HINF*(1.0 - PRATX)) )
 3    CONTINUE
C
C---- set exit-plane streamline Y array
      DO 4 J=1, JJ
        XA = 0.5*(X(I,J)+X(I+1,J))
        YA = 0.5*(Y(I,J)+Y(I+1,J))
        YSTR(J) = COSA*YA - SINA*XA
 4    CONTINUE
C
C---- set initial Y-axis limits
      ZMAX = YSTR(JJ)
      ZMIN = YSTR( 1)
C
      CALL SCALIT(1,ZMAX,ZMIN,ZSCAL,ANN,NANN)
      ZDEL = 1.0/(ZSCAL*FLOAT(NANN))
      ZMAX = ZDEL * AINT(ZMAX/ZDEL + 0.49 + SIGN(0.50,ZMAX))
      ZMIN = ZDEL * AINT(ZMIN/ZDEL - 0.49 + SIGN(0.50,ZMIN))
C
C---- fraction of full plot size taken up by x-y plot
      SIZFAC = 0.6
C
C---- number of grid intervals per axis annotation interval
      NGR = 2
C
C---- default is lines plotted with symbols
      KSYMB = -1
C
      LPLOT = .FALSE.
      BLANK = .TRUE.
      LNUMST = .FALSE.
C
  990 WRITE(*,*) '-------------------------------------------'
      WRITE(*,*)
      WRITE(*,*) ' 1  Profile quantity (M,R,Q,D,L,T) vs Y'
      WRITE(*,*) ' 2  Toggle streamtube number plotting'
      WRITE(*,*) ' 3  Blowup current plot'
      WRITE(*,*) ' 4  Reset plot scaling'
      WRITE(*,*) ' 5  Options'
      WRITE(*,*) ' 6  Annotation menu'
      WRITE(*,*) ' 7  Hardcopy current plot'
      WRITE(*,*) ' 8  Toggle symbol plotting'
  995 WRITE(*,1995)
 1995 FORMAT(/1X,'Select wake profile plot (-1=List):  ',$)
      READ(*,1000) COPT
C
      IF(INDEX('0 ',COPT).NE.0) THEN
        IF(LPLOT) CALL PLEND
        LPLOT = .FALSE.
        RETURN
      ENDIF
C
      IF(INDEX('MRQDLTmrqdlt',COPT) .NE. 0) THEN
C------ one of the variable keyword letters was selected... go plot it
        NOPT = 1
        VAR = COPT
        LAXES = .FALSE.
        LOFINI = .FALSE.
        WRITE(*,*)
        GO TO 12
      ELSE
        NOPT = 0
        READ(COPT,*,ERR=990) NOPT
      ENDIF
C
 1000 FORMAT(A)
C
      GOTO(10,20,30,40,50,60,70,80), NOPT
      GO TO 990
C
C======================================================
C---- Plot STATE.INC' farfield variable vs y at exit plane
C
   10 CONTINUE
C
      LAXES = .FALSE.
      LOFINI = .FALSE.
C
      WRITE(*,2000)
 2000 FORMAT(/'   M ach '
     &       /'   R ho      / Rhoinf'
     &       /'   Q         / Qinf'
     &       /'   D rag coefficient  ( rho U dU / q )'
     &       /'   L oss coefficient       ( dPo / q  )'
     &       /'   T otal pressure change  ( dPo / Po )'
     &      //' Select profile quantity:  ', $)
      READ(*,1000) VAR
      IF (INDEX('MRQDLT',VAR).LE.0 .AND.
     &    INDEX('mrqdlt',VAR).LE.0       ) GO TO 10
C
 12   CONTINUE
C
C---- fill selected flow variable array
      IF    (INDEX('Mm',VAR).GT.0) THEN
C
        DO 131 JO=1, JJ-1
          W(JO) = QEXIT(JO) / SQRT(GM1*(HINF-0.5*QEXIT(JO)**2))
          IF(JSTAG(JO).GT.0) W(JO) = MINF
 131    CONTINUE
C
      ELSEIF(INDEX('Rr',VAR).GT.0) THEN
C
        DO 133 JO=1, JJ-1
          W(JO) = REXIT(JO)/RHOINF
          IF(JSTAG(JO).GT.0) W(JO) = 1.0
 133    CONTINUE
C
      ELSEIF(INDEX('Qq',VAR).GT.0) THEN
C
        DO 134 JO=1, JJ-1
          W(JO) = QEXIT(JO)/QINF
          IF(JSTAG(JO).GT.0) W(JO) = 1.0
 134    CONTINUE
C
      ELSEIF(INDEX('Dd',VAR).GT.0) THEN
C
        DO 136 JO=1, JJ-1
          W(JO) = REXIT(JO)*QEXIT(JO) * (QEXIT(JO)-QINF) / QU
          IF(JSTAG(JO).GT.0) W(JO) = 0.0
 136    CONTINUE
C
      ELSEIF(INDEX('Ll',VAR).GT.0) THEN
C
        DO 137 JO=1, JJ-1
          W(JO) = (PST(I,JO) - PSTINF) / QU
          IF(JSTAG(JO).GT.0) W(JO) = 0.0
 137    CONTINUE
C
      ELSEIF(INDEX('Tt',VAR).GT.0) THEN
C
        DO 138 JO=1, JJ-1
          W(JO) = (PST(I,JO)-PSTINF)/PSTINF
          IF(JSTAG(JO).GT.0) W(JO) = 0.0
 138    CONTINUE
C
      ENDIF
C
C
      IF(.NOT. LOFINI) THEN
C------ set initial scaling and offset parameters
C
        WMAX = W(1)
        WMIN = W(1)
        DO 14 J=1, JJ-1
          WMIN = MIN( WMIN , W(J) )
          WMAX = MAX( WMAX , W(J) )
 14     CONTINUE
C
        CALL SCALIT(1,WMAX,WMIN,WSCAL,ANN,NANN)
        WDEL = 1.0/(WSCAL*FLOAT(NANN))
        WMAX = WDEL * AINT(WMAX/WDEL + 0.49 + SIGN(0.50,WMAX))
        WMIN = WDEL * AINT(WMIN/WDEL - 0.49 + SIGN(0.50,WMIN))
C
        LOFINI = .TRUE.
C
      ENDIF
C
C
C---- start here for replot
 15   CONTINUE
C
C
C---- set plot offsets and scaling factors
      ZOFF = ZMIN
      WOFF = WMIN
      ZSF = 1.0/(ZMAX-ZMIN)
      WSF = AR /(WMAX-WMIN)
C
      IF (.NOT. LAXES) THEN
C------ open window and plot axes for current scale/offset
C
        CALL PLTINI(SIZFAC)
        CALL PLOTABS(XORG*SIZE+XMARG,YORG*SIZE+YMARG,-3)
C
        CALL NEWPEN(2)
C
        YAXLEN = (ZMAX-ZMIN)*ZSF
        DYANN = ZDEL*ZSF
        CALL YAXIS(WMOD(WMIN),ZMOD(ZMIN),YAXLEN,DYANN,ZMIN,ZDEL,CH2,-2)
        CALL PLCHAR(WMOD(WMIN)-2.2*CH,ZMOD(ZMAX)-0.5*DYANN-0.5*CH,
     &              1.3*CH,'y',0.0,1)
C
        XAXLEN = (WMAX-WMIN)*WSF
        DXANN = WDEL*WSF
        CALL XAXIS(WMOD(WMIN),ZMOD(ZMIN),XAXLEN,DXANN,WMIN,WDEL,CH2,-2)
C
        XPLT = WMOD(WMAX)-0.5*DXANN
        YPLT = ZMOD(ZMIN)-3.8*CH
C
        IF    (INDEX('Mm',VAR).GT.0) THEN
          CALL PLCHAR(XPLT-1.0*CH,YPLT,1.2*CH,'M'  ,0.0,1)
        ELSEIF(INDEX('Rr',VAR).GT.0) THEN
          CALL PLMATH(XPLT-2.0*CH,YPLT,CH,'r/r ',0.0,4)
          CALL PLMATH(XPLT-2.0*CH,YPLT,CH,'   &',0.0,4)
        ELSEIF(INDEX('Qq',VAR).GT.0) THEN
          CALL PLCHAR(XPLT-2.0*CH,YPLT,CH,'q/q ',0.0,4)
          CALL PLMATH(XPLT-2.0*CH,YPLT,CH,'   &',0.0,4)
        ELSEIF(INDEX('Dd',VAR).GT.0) THEN
          CALL PLMATH(XPLT-4.0*CH,YPLT,CH,'        2',0.0,10)
          CALL PLCHAR(XPLT-4.0*CH,YPLT,CH,'2 q q/ q ',0.0,10)
          CALL PLMATH(XPLT-4.0*CH,YPLT,CH,' r O  r &',0.0,10)
        ELSEIF(INDEX('Ll',VAR).GT.0) THEN
          CALL PLMATH(XPLT-4.0*CH,YPLT       ,1.2*CH,'O '  ,0.0,2)
          CALL PLCHAR(XPLT-4.0*CH,YPLT       ,1.2*CH,' C'  ,0.0,2)
          CALL PLCHAR(XPLT-1.8*CH,YPLT-0.3*CH,0.9*CH,  'p' ,0.0,1)
          CALL PLCHAR(XPLT-1.1*CH,YPLT-0.6*CH,0.6*CH,   'o',0.0,1)
        ELSEIF(INDEX('Tt',VAR).GT.0) THEN
          CALL PLMATH(XPLT-6.0*CH,YPLT       ,    CH,'O     ',0.0,6)
          CALL PLCHAR(XPLT-6.0*CH,YPLT       ,    CH,' p /p ',0.0,6)
          CALL PLCHAR(XPLT-4.1*CH,YPLT-0.3*CH,0.6*CH,  'o'   ,0.0,1)
          CALL PLCHAR(XPLT-1.1*CH,YPLT-0.3*CH,0.6*CH,     'o',0.0,1)
        ENDIF
C
        IF(LGRID) THEN
         NXGR = NGR * INT(XAXLEN/DXANN + 0.001)
         NYGR = NGR * INT(YAXLEN/DYANN + 0.001)
         DXG = DXANN / FLOAT(NGR)
         DYG = DYANN / FLOAT(NGR)
         CALL NEWPEN(1)
         CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
        ENDIF
C
        CALL PLFLUSH
        CALL NEWPEN(2)
C
        LAXES = .TRUE.
      ENDIF
C
C
C
C---- plot profile
      CALL NEWPEN(3)
      NJ = JS2(NBL)-1
      J = 1
      CALL XYPLOT(NJ,W(J),YVAL(J),WOFF,WSF,ZOFF,ZSF, 1,SH,KSYMB)
      DO 16 N=NBL, 2, -1
        NJ = JS2(N-1) - JS1(N)
        J = JS1(N)
        CALL XYPLOT(NJ,W(J),YVAL(J),WOFF,WSF,ZOFF,ZSF, 1,SH,KSYMB)
 16   CONTINUE
      NJ = JJ - JS1(1)
      J = JS1(1)
      CALL XYPLOT(NJ,W(J),YVAL(J),WOFF,WSF,ZOFF,ZSF, 1,SH,KSYMB)
C
C
C---- plot profile in bar-chart form
c      CALL NEWPEN(2)
c      JO = 1
c      CALL PLOT(WMOD(W(JO)),ZMOD(YSTR(JO)),3)
c      DO 17 JO=1, JJ-1
c        JP = JO+1
c        IF(JSTAG(JO).GT.0) GO TO 17
c        IPEN = 2
c        IF(JSTAG(JO).LT.0) IPEN = 3
c        CALL PLOT(WMOD(W(JO)),ZMOD(YSTR(JO)),IPEN)
c        CALL PLOT(WMOD(W(JO)),ZMOD(YSTR(JP)),2)
c 17   CONTINUE
C
      IF(LNUMST) THEN
C------ plot streamtube number labels
        CH3 = 0.6*CH
        CALL NEWPEN(1)
        DO 18 JO=1, JJ-1
          IF(JSTAG(JO).GT.0) GO TO 18
          JP = JO+1
          XPLT = WMOD(W(JO)) + 1.2*CH3
          YPLT = 0.5*(ZMOD(YSTR(JO)) + ZMOD(YSTR(JP))) - 0.5*CH3
          RJO = FLOAT(JO)
          CALL PLNUMB(XPLT,YPLT,CH3,RJO,0.0,-1)
 18     CONTINUE
      ENDIF
C
C
      CALL PLFLUSH
C
      BLANK = .FALSE.
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
      GO TO 990
C
C
C======================================================
C---- Toggle streamtube number plotting
C
   20 LNUMST = .NOT. LNUMST
      IF(     LNUMST) WRITE(*,*) 'Streamtube numbers will  be plotted'
      IF(.NOT.LNUMST) WRITE(*,*) 'Streamtube numbers won`t be plotted'
C
C---- if there is a plot on screen... go replot it
      IF(.NOT.BLANK) THEN
       LAXES = .FALSE.
       GO TO 15
      ENDIF
      GO TO 990
C
C======================================================
C---- Zoom in on the plot
C
 30   IF ((.NOT.LCURS) .OR. (.NOT.BLANK)) THEN
        CALL OFFGET(WOFF,ZOFF,WSF,ZSF,AR,1.0,.FALSE.,LCURS)
        WMIN = WOFF
        ZMIN = ZOFF
        WMAX = WOFF + AR /WSF
        ZMAX = ZOFF + 1.0/ZSF 
C
        CALL SCALIT(1,WMAX,WMIN,WSCAL,ANN,NANN)
        WDEL = 1.0/(WSCAL*FLOAT(NANN)) 
        WMAX = WDEL * AINT(WMAX/WDEL + 0.49 + SIGN(0.50,WMAX))
        WMIN = WDEL * AINT(WMIN/WDEL - 0.49 + SIGN(0.50,WMIN))
C
        CALL SCALIT(1,ZMAX,ZMIN,ZSCAL,ANN,NANN)
        ZDEL = 1.0/(ZSCAL*FLOAT(NANN))
        ZMAX = ZDEL * AINT(ZMAX/ZDEL + 0.49 + SIGN(0.50,ZMAX))
        ZMIN = ZDEL * AINT(ZMIN/ZDEL - 0.49 + SIGN(0.50,ZMIN))
C
C------ go replot profile
        BLANK = .TRUE.
        LAXES = .FALSE.
        GO TO 12
C
      ELSE
        WRITE(*,*) 'Select profile plot first'
      ENDIF
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
      GOTO 990
C
C======================================================
C---- Reset scaling
C
 40   ZMAX = YSTR(JJ)
      ZMIN = YSTR( 1)
C
      CALL SCALIT(1,ZMAX,ZMIN,ZSCAL,ANN,NANN)
      ZDEL = 1.0/(ZSCAL*FLOAT(NANN))
      ZMAX = ZDEL * AINT(ZMAX/ZDEL + 0.49 + SIGN(0.50,ZMAX))
      ZMIN = ZDEL * AINT(ZMIN/ZDEL - 0.49 + SIGN(0.50,ZMIN))
C
      LOFINI = .FALSE.
C
      IF(.NOT.BLANK) THEN
C----- go replot profile
       LAXES = .FALSE.
       GO TO 12
      ENDIF
C
      GO TO 995
C
C======================================================
C---- Change settings
C
   50 WRITE(*,*) '...........................................'
      WRITE(*,*)
      WRITE(*,*) ' 1  Plot size'
      WRITE(*,*) ' 2  Toggle Cursor/Keyboard input for blowup'
   52 WRITE(*,5010) 
 5010 FORMAT(/1X,'Change what ?  ',$)
      READ (*,1000) COPT
C
      IF(INDEX('0 ',COPT).NE.0) THEN
C------ if there is a plot on screen... go replot it
        IF(.NOT.BLANK) THEN
         LAXES = .FALSE.
         GO TO 15
        ENDIF
        GO TO 990
      ELSE IF(INDEX('1',COPT).NE.0) THEN
   54  WRITE(*,*) 'Enter plot size:', SIZE
       CALL READR(1,SIZE,ERROR)
       IF(ERROR) GO TO 54
       BLANK = .TRUE.
      ELSE IF(INDEX('2',COPT).NE.0) THEN
        LCURS = .NOT. LCURS
        IF(     LCURS) WRITE(*,*) ' Cursor  coordinate input selected'
        IF(.NOT.LCURS) WRITE(*,*) 'Keyboard coordinate input selected'
      ENDIF
      GO TO 50
C
C======================================================
C---- annotate current plot
C
   60 CALL ANNOT(CH)
      GO TO 990
C
C======================================================
C---- make hardcopy
C
   70 IF(LPLOT) CALL PLEND
      LPLOT = .FALSE.
      CALL REPLOT(IDEVRP)
      GO TO 995
C
C======================================================
C---- Toggle symbol plotting
C
   80 IF(KSYMB.EQ.0) THEN
        KSYMB = -1
      ELSE
        KSYMB = 0
      ENDIF
C
C---- if there is a plot currently on screen... go replot it
      IF(.NOT.BLANK) THEN
       LAXES = .FALSE.
       KSTR = 0
       WRITE(*,*)
       GO TO 15
      ENDIF
      GO TO 990
C
      END ! WAKEPL


