
      SUBROUTINE SURFPL
C------------------------------------------------
C     Plots airfoil surface and wake quantities.
C------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      LOGICAL ERROR
      DIMENSION STE(3),DTE(3),TTE(3),HTE(3), XTT(2), CTT(2)
      DIMENSION AINPUT(3)
C
      CHARACTER*32 COLNAM
C
      CHARACTER*1 ANS
      CHARACTER*2 COPT
C
      DIMENSION DYGARR(10)
      DATA LMASK1, LMASK2, LMASK3 / -32640, -30584, -21846 /
C
C---- default flags
      LAIRFF = .TRUE.
      LFORCE = .TRUE.
      LFOREF = .FALSE.
      LREF   = .FALSE.
C
C---- fraction of full plot size taken up by x-y plot
      SIZFAC = 0.85
C
C---- local plot aspect ratio
      PAR = 0.90*AR
C
C---- number of grid intervals per axis annotation interval
      NGR = 2
C
C---- clear plot-type indicators
      KPLOT = 0
      NPLOT = 0
C
C---- origin location / SIZE
      XORG = 0.125
      YORG = 0.100
C
      KSYMB = 0
      SH  = 0.20*CH
      CHI = 0.65*CH
C
      SHS = 1.0*CH
C
      ISYMB = 0
C
C---- additional distance from bottom of plot to bottom of Mach,Cp axes
      YSPACE = 0.15
C
C---- plot all elements initially
      NBPLT = 0
C
C---- various scaling factors
C
      DTOR = ATAN(1.0)/45.0
C
      LPLOT = .FALSE.
C
  990 WRITE(*,*)
      WRITE(*,*) '-----------------------------------------------------'
      WRITE(*,*)
      WRITE(*,*) ' 1    Mach vs x'
      WRITE(*,*) ' 2      Cp vs x'
      WRITE(*,*) '                  ____________________'
      WRITE(*,*) ' 3       H vs x'
      WRITE(*,*) ' 4 top D,T vs x      BL data '
      WRITE(*,*) ' 5 bot D,T vs x            on'
      WRITE(*,*) ' 6      Cf vs x             airfoil'
      WRITE(*,*) ' 7      Ue vs x              and'
      WRITE(*,*) ' 8    A/Ao vs x               wake' 
      WRITE(*,*) ' 9      Ct vs x'
      WRITE(*,*) '10  Rtheta vs x'
      WRITE(*,*) '                  ____________________'
      WRITE(*,*) '11   List CL, CD ...'
      WRITE(*,*) '12   Change settings'
      IF (NBL.GT.1) 
     &WRITE(*,*) '13   Change element for plotting'
      WRITE(*,*) '14   Hardcopy current plot'
      WRITE(*,*) '15   Place symbol at specified grid location'
      WRITE(*,*) '16   Change x-axis limits for element BL plots'
      WRITE(*,*) '17   Change y-axis limits for current element BL plot'
      WRITE(*,*) '18   Cursor blowup for current BL plot'
      WRITE(*,*) '19   Reset x,y-axis limits for element BL plots'
      WRITE(*,*) '20   Annotation menu'
      WRITE(*,*) '21   Plot-page options'
C
  995 WRITE(*,1995)
 1995 FORMAT(/1X,'Select surface plot option:  ',$)
      READ(*,1000) COPT
C
      IF(INDEX('0 ',COPT(1:1)).NE.0) THEN
        IF(LPLOT) CALL PLEND
        LPLOT = .FALSE.
        RETURN
      ENDIF
C
      NOPT = 0
      READ(COPT,*,ERR=990) NOPT
C
C
 998  IF(NOPT.GE.1 .AND. NOPT.LE.10) THEN
       CALL PLTINI(SIZFAC)
       CALL PLOTABS(XORG*SIZE+XMARG,YORG*SIZE+YMARG,-3)
       CALL GETCOLOR(ICOL0)
      ENDIF
C
 1000 FORMAT(A)
C
      N = NBPLT
      IF(NBL.EQ.1) N = 1
C
      GOTO( 10, 20, 30, 40, 50, 60, 70, 80, 90,100,
     &     110,120,130,140,150,160,170,180,190,200,
     &     210   ),  NOPT
      GO TO 990
C
C===============================================
C**** Plot Mach vs x
C
  10  CONTINUE
      MAFAC = 0.65/(MAMAX-MAMIN)
C
C---- Offset for plotting airfoil outline at bottom
      CALL PLOT(0.0,YSPACE,-3)
C
      PAR = (MAMAX-MAMIN)*MAFAC
      CALL YAXIS(0.0,0.0,PAR,MADEL*MAFAC,0.0,0.2,CH,1)
C
      YDASH = MAFAC
      CALL DASH(0.0,1.0,YDASH)
C
      CALL NEWPEN(3)
      YLAB = (1.0+0.5*MADEL)*MAFAC - 0.7*CH
      CALL PLCHAR(-3.0*CH,YLAB,1.4*CH,'M',0.0,1)
C
C---- plot MSES identifier
      CALL NEWPEN(1)
      CALL PLCHAR(    CHI,MAMAX*MAFAC-1.1*CHI,CHI,'MSES' ,0.0,4)
      CALL PLCHAR(    CHI,MAMAX*MAFAC-3.1*CHI,CHI,'v'    ,0.0,1)
      CALL PLNUMB(2.5*CHI,MAMAX*MAFAC-3.1*CHI,CHI,VERSION,0.0,1)
C
CCC      IF (NBPLT.NE.0) THEN
CCC        CALL PLCHAR(CHI,MAMAX*MAFAC+2.*CHI,CHI,'Element ',0.0,8)
CCC        CALL PLNUMB(999.,999.,CHI,FLOAT(NBPLT),0.0,-1)
CCC      ENDIF
C
      IF(NBPLT.EQ.0 .OR. NBL.EQ.1) THEN
c       AXOFF = -.25
c       XSF = 0.60
c       XT0 = (0.0 - AXOFF)*XSF
c       XT1 = (1.0 - AXOFF)*XSF
c       AYOFF = (YSPACE/3.0)/XSF
       XX0 = 0.10
       XX1 = 0.90
       XSF = (XX1-XX0)/(XBMAX-XBMIN)
       AXOFF = XBMAX - XX1/XSF
       AYOFF = (YSPACE/3.0)/XSF + 0.5*(YBMIN+YBMAX)
       XT0 = (0.0 - AXOFF)*XSF
       XT1 = (1.0 - AXOFF)*XSF
      ELSE
       XT0 = 0.12
       XT1 = 0.72
       XSF = (XT1-XT0)/(XTAIL(NBPLT)-XNOSE(NBPLT))
       AXOFF = XTAIL(NBPLT) - XT1/XSF
       AYOFF = (YSPACE/3.0)/XSF + YNOSE(NBPLT)
      ENDIF
C
       DO 102 N=1, NBL
CCC      IF(NBPLT.EQ.N .OR. NBPLT.EQ.0) THEN
          ILE = ILEB(N)
          ITE = ITEB(N)
          J1 = JS1(N)
          J2 = JS2(N)
C
C-------- plot airfoil and displacement surfaces
          CALL NEWPEN(2)
          CALL AIRFPL(IIB(N),XB(1,N),YB(1,N),
     &                XPB(1,N),YPB(1,N),SB(1,N),AXOFF,AYOFF,XSF,
     &                0.0,0.0,0.0)
          CALL NEWPEN(1)
C
          CALL NEWCOLOR(ICOLS(IS1(N)))
          CALL AIRFOI(II,X(1,J1),Y(1,J1),AXOFF,AYOFF,XSF,0.0,0.0,0.0)
C
          CALL NEWCOLOR(ICOLS(IS2(N)))
          CALL AIRFOI(II,X(1,J2),Y(1,J2),AXOFF,AYOFF,XSF,0.0,0.0,0.0)
C
          CALL NEWCOLOR(ICOL0)
CCC      ENDIF
  102  CONTINUE
C
      YXAX = MAFAC*MINF
C
      CALL NEWPEN(1)
      CALL PLOT(0.0,YXAX,3)
      CALL PLOT(1.0,YXAX,2)
      DO 14 NT=0, 2
        XT = XT0 + (XT1-XT0)*FLOAT(NT)/2.0
        CALL PLOT(XT,YXAX-0.006,3)
        CALL PLOT(XT,YXAX+0.006,2)
   14 CONTINUE
      DO 15 NT=1, 9
        XT = XT0 + (XT1-XT0)*FLOAT(NT)/10.0
        CALL PLOT(XT,YXAX-0.003,3)
        CALL PLOT(XT,YXAX+0.003,2)
  15  CONTINUE
C
      CALL NEWPEN(2)
      DO 104 N=1, NBL
        IF(NBPLT.EQ.N .OR. NBPLT.EQ.0) THEN
         I1 = IS1(N)
         I2 = IS2(N)
C
         IBEG = ILEB(N)
         IEND = ITEB(N)
         IF(LPWAKE) IEND = II-1
         IDIF = IEND - IBEG + 1
C
         CALL NEWCOLOR(ICOLS(IS1(N)))
         CALL XYPLOT(IDIF,XI(IBEG,I1),MI(IBEG,I1),
     &               AXOFF,XSF,0.0,MAFAC,1,SH,KSYMB)
C
         CALL NEWCOLOR(ICOLS(IS2(N)))
         CALL XYPLOT(IDIF,XI(IBEG,I2),MI(IBEG,I2),
     &               AXOFF,XSF,0.0,MAFAC,1,SH,KSYMB)
C
         IF(ISYMB.NE.0 .AND. ISYMB.GE.IBEG .AND. ISYMB.LE.IEND) THEN
          CALL NEWCOLORNAME('red')
          CALL PLSYMB((XI(ISYMB,I1)-AXOFF)*XSF ,
     &                 MI(ISYMB,I1)       *MAFAC,SHS,1,0.0,0)
          CALL PLSYMB((XI(ISYMB,I2)-AXOFF)*XSF ,
     &                 MI(ISYMB,I2)       *MAFAC,SHS,1,0.0,0)
         ENDIF
        ENDIF
  104 CONTINUE
C
      CALL NEWCOLOR(ICOL0)
C
C---- plot reference data...
      IF(LREF) THEN
       NF = 0
       CALL GETREF(XF,MF,NF,NFX)
C
C----- check if distinction between elements has been made with a 999.0
       KF1 = 1
       ISYM = 1
       DO 106 KF=1, NF
         IF(XF(KF).EQ.999.0 .OR. KF.EQ.NF) THEN
          NFE = KF-KF1+1
          CALL XYPLOT(NFE,XF(KF1),MF(KF1),
     &                AXOFF,XSF,0.0,MAFAC,1,0.5*CH,ISYM)
          KF1 = KF + 1
          ISYM = ISYM + 1
         ENDIF
 106   CONTINUE
      ENDIF
C
      IF(LFORCE) CALL PLTFOR(MAMAX*MAFAC,NBPLT)
C
      KPLOT = 1
      NPLOT = N
      CALL PLFLUSH
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
ccc      CALL PLEND
      GO TO 995
C
C
C===============================================
C**** Plot Cp vs x
C
  20  CONTINUE
      CPFAC = 0.65/(CPMAX-CPMIN)
C
C---- Offset for plotting airfoil outline at bottom
      CALL PLOT(0.0,CPMAX*CPFAC+YSPACE,-3)
C
      PAR = (CPMAX-CPMIN)*CPFAC
      CALL YAXIS(0.0,-CPMAX*CPFAC,PAR,-CPDEL*CPFAC,CPMAX,CPDEL,CH,1)
C
      YDASH = -CPSTAR*CPFAC
      IF(YDASH .LE. -CPMIN*CPFAC) CALL DASH(0.0,1.0,YDASH)
C
      CALL NEWPEN(3)
      YLAB = (FLOAT(INT(CPMIN/CPDEL + 0.01)/2) + 0.5)
     &     * (-CPDEL)*CPFAC - 0.6*CH
      CALL PLCHAR(-4.0*CH,YLAB       ,1.30*CH,'C',0.0,1)
      CALL PLCHAR(-2.9*CH,YLAB-0.4*CH,1.00*CH,'p',0.0,1)
C
C---- plot ISES identifier
      CALL NEWPEN(1)
      CALL PLCHAR(    CHI,-CPMIN*CPFAC-1.0*CHI,CHI,'MSES' ,0.0,4)
      CALL PLCHAR(    CHI,-CPMIN*CPFAC-3.0*CHI,CHI,'v'    ,0.0,1)
      CALL PLNUMB(2.5*CHI,-CPMIN*CPFAC-3.0*CHI,CHI,VERSION,0.0,1)
C
C      IF (NBL.GT.1) THEN
C        CALL PLCHAR(CHI,-CPMIN*CPFAC+2.*CHI,CHI,'Element ',0.0,8)
C        CALL PLNUMB(999.,999.,CHI,FLOAT(NBP),0.0,-1)
C      ENDIF
C
      IF(NBPLT.EQ.0 .OR. NBL.EQ.1) THEN
c       AXOFF = -.25
c       XSF = 0.60
c       XT0 = (0.0 - AXOFF)*XSF
c       XT1 = (1.0 - AXOFF)*XSF
c       AYOFF = (YSPACE/2.0 + CPMAX*CPFAC)/XSF
       XX0 = 0.10
       XX1 = 0.90
       XSF = (XX1-XX0)/(XBMAX-XBMIN)
       AXOFF = XBMAX - XX1/XSF
       AYOFF = (YSPACE/2.0 + CPMAX*CPFAC)/XSF + 0.5*(YBMIN+YBMAX)
       XT0 = (0.0 - AXOFF)*XSF
       XT1 = (1.0 - AXOFF)*XSF
      ELSE
       XT0 = 0.12
       XT1 = 0.72
       XSF = (XT1-XT0)/(XTAIL(NBPLT)-XNOSE(NBPLT))
       AXOFF = XTAIL(NBPLT) - XT1/XSF
       AYOFF = (YSPACE/2.0 + CPMAX*CPFAC)/XSF + YNOSE(NBPLT)
      ENDIF
C
      CALL NEWPEN(1)
      YXAX = 0.0
      CALL PLOT(0.0,YXAX,3)
      CALL PLOT(1.0,YXAX,2)
      DO 24 NT=0, 2
        XT = XT0 + (XT1-XT0)*FLOAT(NT)/2.0
        CALL PLOT(XT,YXAX-0.006,3)
        CALL PLOT(XT,YXAX+0.006,2)
   24 CONTINUE
      DO 25 NT=1, 9
        XT = XT0 + (XT1-XT0)*FLOAT(NT)/10.0
        CALL PLOT(XT,YXAX-0.003,3)
        CALL PLOT(XT,YXAX+0.003,2)
  25  CONTINUE
C
       DO 202 N=1, NBL
CCC      IF(NBPLT.EQ.N .OR. NBPLT.EQ.0) THEN
          ILE = ILEB(N)
          ITE = ITEB(N)
          J1 = JS1(N)
          J2 = JS2(N)
C
C-------- plot airfoil and displacement surfaces
          CALL NEWPEN(2)
          CALL AIRFPL(IIB(N),XB(1,N),YB(1,N),
     &                XPB(1,N),YPB(1,N),SB(1,N),AXOFF,AYOFF,XSF,
     &                0.0,0.0,0.0)
          CALL NEWPEN(1)
C
          CALL NEWCOLOR(ICOLS(IS1(N)))
          CALL AIRFOI(II,X(1,J1),Y(1,J1),AXOFF,AYOFF,XSF,0.0,0.0,0.0)
C
          CALL NEWCOLOR(ICOLS(IS2(N)))
          CALL AIRFOI(II,X(1,J2),Y(1,J2),AXOFF,AYOFF,XSF,0.0,0.0,0.0)
C
          CALL NEWCOLOR(ICOL0)
CCC      ENDIF
  202  CONTINUE
C
      CALL NEWPEN(2)
      DO 204 N=1, NBL
        IF(NBPLT.EQ.N .OR. NBPLT.EQ.0) THEN
         I1 = IS1(N)
         I2 = IS2(N)
C
         IBEG = ILEB(N)
         IEND = ITEB(N)
         IF(LPWAKE) IEND = II-1
         IDIF = IEND - IBEG + 1
C
         CALL NEWCOLOR(ICOLS(IS1(N)))
         CALL XYPLOT(IDIF,XI(IBEG,I1),CPI(IBEG,I1),
     &               AXOFF,XSF,0.0,-CPFAC,1,SH,KSYMB)
C
         CALL NEWCOLOR(ICOLS(IS2(N)))
         CALL XYPLOT(IDIF,XI(IBEG,I2),CPI(IBEG,I2),
     &               AXOFF,XSF,0.0,-CPFAC,1,SH,KSYMB)
C
         IF(ISYMB.NE.0 .AND. ISYMB.GE.IBEG .AND. ISYMB.LE.IEND) THEN
          CALL NEWCOLORNAME('red')
          CALL PLSYMB((XI(ISYMB,I1)-AXOFF)*XSF ,
     &               -CPI(ISYMB,I1)       *CPFAC,SHS,1,0.0,0)
          CALL PLSYMB((XI(ISYMB,I2)-AXOFF)*XSF ,
     &               -CPI(ISYMB,I2)       *CPFAC,SHS,1,0.0,0)
         ENDIF
        ENDIF
  204 CONTINUE
C
      CALL NEWCOLOR(ICOL0)
C
C---- plot reference data...
      IF(LREF) THEN
       NF = 0
       CALL GETREF(XF,PF,NF,NFX)
C
       call newpen(1)

C----- check if distinction between elements has been made with a 999.0
       KF1 = 1
       ISYM = 1
       DO 206 KF=1, NF
         IF(XF(KF).EQ.999.0 .OR. KF.EQ.NF) THEN
          NFE = KF-KF1+1
          CALL XYPLOT(NFE,XF(KF1),PF(KF1),
     &                AXOFF,XSF,0.0,-CPFAC,1,0.5*CH,ISYM)
c          CALL XYPLOT(NFE,XF(KF1),PF(KF1),
c     &                AXOFF,XSF,0.0,-CPFAC,3,0.5*CH,KSYMB)
          KF1 = KF + 1
          ISYM = ISYM + 1
         ENDIF
 206   CONTINUE
      ENDIF
C
C
      IF(LFORCE) CALL PLTFOR(-CPMIN*CPFAC,NBPLT)
C
      KPLOT = 2
      NPLOT = N
      CALL PLFLUSH
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
ccc      CALL PLEND
      GO TO 995
C
C
C===============================================
C**** Plot H vs x
C
   30 CONTINUE
      CALL GETEL(NBPLT,NBL)
      N = NBPLT
      IF(NBL.EQ.1) N = 1
C
      ICOL1 = ICOLS(IS1(N))
      ICOL2 = ICOLS(IS2(N))
C
      XOFF = XIMIN(N)
      YOFF = HKMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(HKMAX(N)-HKMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(HKMAX(N)-HKMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*HKDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,HKMIN(N),HKDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.0*CH,1.4*CH,'x',0.0,1)
      CALL PLCHAR(-4.0*CH,YAXL-1.5*DYANN-0.7*CH,1.4*CH,'H',0.0,1)
      CALL PLCHAR(-2.7*CH,YAXL-1.5*DYANN-1.1*CH,0.9*CH,'k',0.0,1)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL NEWPEN(2)
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
      IF(LFORCE) THEN
       CLTOT = LIFT/QU
       CDTOT = (DRAGW + DRAGV)/QU
       CMTOT = MOMN/QU
       ADEG = ALFA * 180.0/3.1415926
       HSTAT = HINF / (1.0 + 0.5*GM1*MINF**2)
       MUINF = SQRT((HSTAT/HINF)**3) * (HINF+HVIS)/(HSTAT+HVIS)
       REINF = REYN * (2.0*QU/(QINF*MUINF))
C
       CALL VLABEL(0.0,YAXL,CH, NAME,
     &             REINF,MINF,ACRIT,ALFA,
     &             CLTOT,CDTOT,XTR(IS1(N)),XTR(IS2(N)),
     &             ICOL1,ICOL2,LCONV)
      ENDIF
C
      CALL GETCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
      CALL NEWCLIP(0.0,XAXL,0.0,YAXL)
C
C---- plot Hk over surface, litle bit from TE to first wake point, rest of wake
      ILE = ILEB(N)
      ITE = ITEB(N)
      I1 = IS1(N)
      I2 = IS2(N)
      NAIR = ITE-ILE
      NWAK = II-1 - ITE
      CALL NEWPEN(3)
C 
C---- top surface
      I = ILE+1
      CALL NEWCOLOR(ICOL1)
      CALL XYPLOT(NAIR,XI(I,I1),SHAP(I,I1),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      STE(1) = XI(ITE,I1)
      STE(2) = XI(ITE,I1)
      STE(3) = XI(ITE+1,I1)
      HTE(1) = SHAP(ITE,I1)
      HTE(2) = SHAP(ITE,I1)
      IF(THET(ITE,I1) .NE. 0.0)
     &HTE(2) = SHAP(ITE,I1) + 0.5*WGAP(ITE,N)/THET(ITE,I1)
      HTE(3) = SHAP(ITE+1,I1)
      CALL XYPLOT(3,STE,HTE,XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL PLSYMB((STE(2)-XOFF)*XSF,(HTE(2)-YOFF)*YSF,0.5*CH,3,0.0,0)
      I = ITE+1
      CALL XYPLOT(NWAK,XI(I,I1),SHAP(I,I1),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
C
C---- bottom surface
      I = ILE+1
      CALL NEWCOLOR(ICOL2)
      CALL XYPLOT(NAIR,XI(I,I2),SHAP(I,I2),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      STE(1) = XI(ITE,I2)
      STE(2) = XI(ITE,I2)
      STE(3) = XI(ITE+1,I2)
      HTE(1) = SHAP(ITE,I2)
      IF(THET(ITE,I2) .NE. 0.0)
     &HTE(2) = SHAP(ITE,I2) + 0.5*WGAP(ITE,N)/THET(ITE,I2)
      HTE(3) = SHAP(ITE+1,I2)
      CALL XYPLOT(3,STE,HTE,XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL PLSYMB((STE(2)-XOFF)*XSF,(HTE(2)-YOFF)*YSF,0.5*CH,3,0.0,0)
      I = ITE+1
      CALL XYPLOT(NWAK,XI(I,I2),SHAP(I,I2),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
C
      IF(ISYMB.NE.0 .AND. ISYMB.GT.ILE .AND. ISYMB.LT.II) THEN
       CALL NEWCOLORNAME('red')
       I = ISYMB
       CALL PLSYMB((XI(I,I1)-XOFF)*XSF,(SHAP(I,I1)-YOFF)*YSF,SHS,1,0.,0)
       CALL PLSYMB((XI(I,I2)-XOFF)*XSF,(SHAP(I,I2)-YOFF)*YSF,SHS,1,0.,0)
      ENDIF
C
      CALL NEWCOLOR(ICOL0)
C
C---- plot average wake Hk
      NW = II-ITE+1
      CALL XYPLOT(NW,XW(1,N),HWAK(ITE,N),XOFF,XSF,YOFF,YSF,4,SH,KSYMB)
C
      IF(LREF) THEN
        NF = 0
        CALL GETREF(XF,PF,NF,NFX)
        CALL XYPLOT(NF,XF,PF,XOFF,XSF,YOFF,YSF,1,0.8*CH,5)
      ENDIF
C
      CALL NEWCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 3
      NPLOT = N
      CALL PLFLUSH
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
ccc      CALL PLEND
      GO TO 995
C
C
C===============================================
C**** Plot top side   Ds and Th  vs  x
C
   40 CONTINUE
      CALL GETEL(NBPLT,NBL)
      N = NBPLT
      IF(NBL.EQ.1) N = 1
C
      ICOL = ICOLS(IS1(N))
C
      XOFF = XIMIN(N)
      YOFF = DSMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(DSMAX(N)-DSMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(DSMAX(N)-DSMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*DSDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,DSMIN(N),DSDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.0*CH,1.4*CH,'x',0.0,1)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
      IF(LFORCE) THEN
       CLTOT = LIFT/QU
       CDTOT = (DRAGW + DRAGV)/QU
       CMTOT = MOMN/QU
       ADEG = ALFA * 180.0/3.1415926
       HSTAT = HINF / (1.0 + 0.5*GM1*MINF**2)
       MUINF = SQRT((HSTAT/HINF)**3) * (HINF+HVIS)/(HSTAT+HVIS)
       REINF = REYN * (2.0*QU/(QINF*MUINF))
C
       CALL VLABEL(0.0,YAXL,CH, NAME,
     &             REINF,MINF,ACRIT,ALFA,
     &             CLTOT,CDTOT,XTR(IS1(N)),XTR(IS2(N)),
     &             ICOL1,ICOL2,LCONV)
      ENDIF
C
      CALL NEWCOLOR(ICOL)
      CALL PLCHAR(-4.5*CH,YAXL-0.5*DYANN-0.6*CH,1.2*CH,'Top',0.0,3)
      CALL PLMATH(-4.0*CH,YAXL-1.5*DYANN-0.6*CH,1.4*CH,'d'  ,0.0,1)
      CALL PLCHAR(-2.7*CH,YAXL-1.5*DYANN+0.8*CH,0.8*CH,'*'  ,0.0,1)
      CALL PLMATH(-3.5*CH,YAXL-2.5*DYANN-0.6*CH,1.4*CH,'q'  ,0.0,1)
C
      CALL GETCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
      CALL NEWCLIP(0.0,XAXL,0.0,YAXL)
C
C---- plot Dstar, Theta, Displacement,  over airfoil surface
      ILE = ILEB(N)
      ITE = ITEB(N)
      I1 = IS1(N)
      I2 = IS2(N)
      NAIR = ITE-ILE
      I = ILE+1
      CALL NEWPEN(2)
      CALL XYPLOT(NAIR,XI(I,I1),DSTR(I,I1),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL XYPLOT(NAIR,XI(I,I1),THET(I,I1),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL XYPLOT(NAIR,XI(I,I1),DISP(I,I1),XOFF,XSF,YOFF,YSF,2,SH,KSYMB)
C
C---- plot little bit from TE to first wake point
      STE(1) = XI(ITE,I1)
      STE(2) = XI(ITE,I1)
      STE(3) = XI(ITE+1,I1)
      DTE(1) = DSTR(ITE,I1)
      DTE(2) = DSTR(ITE,I1) + 0.5*WGAP(ITE,N)
      DTE(3) = DSTR(ITE+1,I1)
      TTE(1) = THET(ITE,I1)
      TTE(2) = THET(ITE,I1)
      TTE(3) = THET(ITE+1,I1)
      CALL NEWPEN(2)
      CALL XYPLOT(3,STE,DTE,XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL XYPLOT(3,STE,TTE,XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL PLSYMB((STE(2)-XOFF)*XSF,(DTE(2)-YOFF)*YSF,0.5*CH,3,0.0,0)
      CALL PLSYMB((STE(2)-XOFF)*XSF,(TTE(2)-YOFF)*YSF,0.5*CH,3,0.0,0)
C
C---- plot Dstar, Theta, Displacement,  over rest of wake
      NWAK = II-1 - ITE
      I = ITE+1
      CALL NEWPEN(2)
      CALL XYPLOT(NWAK,XI(I,I1),DSTR(I,I1),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL XYPLOT(NWAK,XI(I,I1),THET(I,I1),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL XYPLOT(NWAK,XI(I,I1),DISP(I,I1),XOFF,XSF,YOFF,YSF,2,SH,KSYMB)
C
      CALL NEWCOLOR(ICOL0)
C
C---- plot total wake Dstar and Theta
      NW = II-ITE+1
      I = ITE
      CALL XYPLOT(NW,XW(1,N),DWAK(I,N),XOFF,XSF,YOFF,YSF,4,SH,KSYMB)
      CALL XYPLOT(NW,XW(1,N),TWAK(I,N),XOFF,XSF,YOFF,YSF,4,SH,KSYMB)
C
      IF(LREF) THEN
        NF = 0
        CALL GETREF(XF,PF,NF,NFX)
        NF1 = 0
        NF2 = 0
C------ check for distinction between Dstar and Theta (with a 999.0)
        DO 41 IF=1, NF
          IF(XF(IF).EQ.999.0) THEN
           NF1 = IF-1
           NF2 = NF - NF1 - 1
           GO TO 42
          ENDIF
   41   CONTINUE
        NF1 = NF
   42   CONTINUE
C
        IF(NF2.EQ.0) THEN
         CALL XYPLOT(NF1,XF,PF,XOFF,XSF,YOFF,YSF,1,1.0*CH,5)
        ELSE
         CALL XYPLOT(NF1,XF,PF,XOFF,XSF,YOFF,YSF,1,1.3*CH,2)
         IF1 = NF1 + 2
         CALL XYPLOT(NF2,XF(IF1),PF(IF1),XOFF,XSF,YOFF,YSF,1,1.*CH,1)
        ENDIF
      ENDIF
C
      IF(ISYMB.NE.0 .AND. ISYMB.GT.ILE .AND. ISYMB.LT.II) THEN
       CALL NEWCOLORNAME('red')
       I = ISYMB
       CALL PLSYMB((XI(I,I1)-XOFF)*XSF,(DSTR(I,I1)-YOFF)*YSF,SHS,1,0.,0)
       CALL PLSYMB((XI(I,I1)-XOFF)*XSF,(THET(I,I1)-YOFF)*YSF,SHS,1,0.,0)
      ENDIF
C
      CALL NEWCOLOR(ICOL0)
C
      CALL NEWCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 4
      NPLOT = N
      CALL PLFLUSH
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
ccc      CALL PLEND
      GO TO 995
C
C
C===============================================
C**** Plot bottom side   Ds and Th  vs  x
C
   50 CONTINUE
      CALL GETEL(NBPLT,NBL)
      N = NBPLT
      IF(NBL.EQ.1) N = 1
C
      ICOL = ICOLS(IS2(N))
C
      XOFF = XIMIN(N)
      YOFF = DPMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(DPMAX(N)-DPMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(DPMAX(N)-DPMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*DPDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,DPMIN(N),DPDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.0*CH,1.4*CH,'x',0.0,1)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
      IF(LFORCE) THEN
       CLTOT = LIFT/QU
       CDTOT = (DRAGW + DRAGV)/QU
       CMTOT = MOMN/QU
       ADEG = ALFA * 180.0/3.1415926
       HSTAT = HINF / (1.0 + 0.5*GM1*MINF**2)
       MUINF = SQRT((HSTAT/HINF)**3) * (HINF+HVIS)/(HSTAT+HVIS)
       REINF = REYN * (2.0*QU/(QINF*MUINF))
C
       CALL VLABEL(0.0,YAXL,CH, NAME,
     &             REINF,MINF,ACRIT,ALFA,
     &             CLTOT,CDTOT,XTR(IS1(N)),XTR(IS2(N)),
     &             ICOL1,ICOL2,LCONV)
      ENDIF
C
      CALL NEWCOLOR(ICOL)
C
      CALL PLCHAR(-4.5*CH,YAXL-0.5*DYANN-0.6*CH,1.2*CH,'Bot',0.0,3)
      CALL PLMATH(-4.0*CH,YAXL-1.5*DYANN-0.6*CH,1.4*CH,'d'  ,0.0,1)
      CALL PLCHAR(-2.7*CH,YAXL-1.5*DYANN+0.8*CH,0.8*CH,'*'  ,0.0,1)
      CALL PLMATH(-3.5*CH,YAXL-2.5*DYANN-0.6*CH,1.4*CH,'q'  ,0.0,1)
C
      CALL GETCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
      CALL NEWCLIP(0.0,XAXL,0.0,YAXL)
C
C---- plot Dstar, Theta, Displacement,  over airfoil surface
      ILE = ILEB(N)
      ITE = ITEB(N)
      I1 = IS1(N)
      I2 = IS2(N)
      NAIR = ITE-ILE
      I = ILE+1
      CALL NEWPEN(2)
      CALL XYPLOT(NAIR,XI(I,I2),DSTR(I,I2),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL XYPLOT(NAIR,XI(I,I2),THET(I,I2),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL XYPLOT(NAIR,XI(I,I2),DISP(I,I2),XOFF,XSF,YOFF,YSF,2,SH,KSYMB)
C
C---- plot little bit from TE to first wake point
      STE(1) = XI(ITE,I2)
      STE(2) = XI(ITE,I2)
      STE(3) = XI(ITE+1,I2)
      DTE(1) = DSTR(ITE,I2)
      DTE(2) = DSTR(ITE,I2) + 0.5*WGAP(ITE,N)
      DTE(3) = DSTR(ITE+1,I2)
      TTE(1) = THET(ITE,I2)
      TTE(2) = THET(ITE,I2)
      TTE(3) = THET(ITE+1,I2)
      CALL NEWPEN(2)
      CALL XYPLOT(3,STE,DTE,XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL XYPLOT(3,STE,TTE,XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL PLSYMB((STE(2)-XOFF)*XSF,(DTE(2)-YOFF)*YSF,0.5*CH,3,0.0,0)
      CALL PLSYMB((STE(2)-XOFF)*XSF,(TTE(2)-YOFF)*YSF,0.5*CH,3,0.0,0)
C
C---- plot Dstar, Theta, Displacement,  over rest of wake
      NWAK = II-1 - ITE
      I = ITE+1
      CALL NEWPEN(2)
      CALL XYPLOT(NWAK,XI(I,I2),DSTR(I,I2),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL XYPLOT(NWAK,XI(I,I2),THET(I,I2),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL XYPLOT(NWAK,XI(I,I2),DISP(I,I2),XOFF,XSF,YOFF,YSF,2,SH,KSYMB)
C
      CALL NEWCOLOR(ICOL0)
C
C---- plot total wake Dstar and Theta
      NW = II-ITE+1
      I = ITE
      CALL XYPLOT(NW,XW(1,N),DWAK(I,N),XOFF,XSF,YOFF,YSF,4,SH,KSYMB)
      CALL XYPLOT(NW,XW(1,N),TWAK(I,N),XOFF,XSF,YOFF,YSF,4,SH,KSYMB)
C
      IF(LREF) THEN
        NF = 0
        CALL GETREF(XF,PF,NF,NFX)
        NF1 = 0
        NF2 = 0
C------ check for distinction between Dstar and Theta (with a 999.0)
        DO 51 IF=1, NF
          IF(XF(IF).EQ.999.0) THEN
           NF1 = IF-1
           NF2 = NF - NF1 - 1
           GO TO 52
          ENDIF
   51   CONTINUE
        NF1 = NF
   52   CONTINUE
C
        IF(NF2.EQ.0) THEN
         CALL XYPLOT(NF1,XF,PF,XOFF,XSF,YOFF,YSF,1,1.0*CH,5)
        ELSE
         CALL XYPLOT(NF1,XF,PF,XOFF,XSF,YOFF,YSF,1,1.3*CH,2)
         IF1 = NF1 + 2
         CALL XYPLOT(NF2,XF(IF1),PF(IF1),XOFF,XSF,YOFF,YSF,1,1.*CH,1)
        ENDIF
      ENDIF
C
      IF(ISYMB.NE.0 .AND. ISYMB.GT.ILE .AND. ISYMB.LT.II) THEN
       CALL NEWCOLORNAME('red')
       I = ISYMB
       CALL PLSYMB((XI(I,I2)-XOFF)*XSF,(DSTR(I,I2)-YOFF)*YSF,SHS,1,0.,0)
       CALL PLSYMB((XI(I,I2)-XOFF)*XSF,(THET(I,I2)-YOFF)*YSF,SHS,1,0.,0)
      ENDIF
C
      CALL NEWCOLOR(ICOL0)
C
      CALL NEWCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 5
      NPLOT = N
      CALL PLFLUSH
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
ccc      CALL PLEND
      GO TO 995
C
C
C===============================================
C**** Plot Cf vs x
C
   60 CONTINUE
      CALL GETEL(NBPLT,NBL)
      N = NBPLT
      IF(NBL.EQ.1) N = 1
C
      ICOL1 = ICOLS(IS1(N))
      ICOL2 = ICOLS(IS2(N))
C
      XOFF = XIMIN(N)
      YOFF = CFMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(CFMAX(N)-CFMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(CFMAX(N)-CFMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*CFDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,CFMIN(N),CFDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.0*CH,1.4*CH,'x',0.0,1)
C
      CALL PLCHAR(-4.0*CH,YAXL-1.5*DYANN-0.7*CH,1.4*CH,'C',0.0,1)
      CALL PLCHAR(-2.8*CH,YAXL-1.5*DYANN-1.1*CH,1.0*CH,'f',0.0,1)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL NEWPEN(2)
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
      IF(LFORCE) THEN
       CLTOT = LIFT/QU
       CDTOT = (DRAGW + DRAGV)/QU
       CMTOT = MOMN/QU
       ADEG = ALFA * 180.0/3.1415926
       HSTAT = HINF / (1.0 + 0.5*GM1*MINF**2)
       MUINF = SQRT((HSTAT/HINF)**3) * (HINF+HVIS)/(HSTAT+HVIS)
       REINF = REYN * (2.0*QU/(QINF*MUINF))
C
       CALL VLABEL(0.0,YAXL,CH, NAME,
     &             REINF,MINF,ACRIT,ALFA,
     &             CLTOT,CDTOT,XTR(IS1(N)),XTR(IS2(N)),
     &             ICOL1,ICOL2,LCONV)
      ENDIF
C
      CALL GETCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
      CALL NEWCLIP(0.0,XAXL,0.0,YAXL)
C
C---- plot Cf over airfoil surface
      ILE = ILEB(N)
      ITE = ITEB(N)
      I1 = IS1(N)
      I2 = IS2(N)
      NAIR = ITE-ILE
      I = ILE+1
      CALL NEWPEN(3)
C
      CALL NEWCOLOR(ICOL1)
      CALL XYPLOT(NAIR,XI(I,I1),TAU(I,I1),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
C
      CALL NEWCOLOR(ICOL2)
      CALL XYPLOT(NAIR,XI(I,I2),TAU(I,I2),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
C
      IF(ISYMB.NE.0 .AND. ISYMB.GT.ILE .AND. ISYMB.LE.ITE) THEN
       CALL NEWCOLORNAME('red')
       I = ISYMB
       CALL PLSYMB((XI(I,I1)-XOFF)*XSF,(TAU(I,I1)-YOFF)*YSF,SHS,1,0.,0)
       CALL PLSYMB((XI(I,I2)-XOFF)*XSF,(TAU(I,I2)-YOFF)*YSF,SHS,1,0.,0)
      ENDIF
C
      CALL NEWCOLOR(ICOL0)
C
      IF(LREF) THEN
        NF = 0
        CALL GETREF(XF,PF,NF,NFX)
        CALL XYPLOT(NF,XF,PF,XOFF,XSF,YOFF,YSF,1,1.0*CH,5)
      ENDIF
C
      CALL NEWCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 6
      NPLOT = N
      CALL PLFLUSH
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
ccc      CALL PLEND
      GO TO 995
C
C
C===============================================
C**** Plot Ue vs x
C
   70 CONTINUE
      CALL GETEL(NBPLT,NBL)
      N = NBPLT
      IF(NBL.EQ.1) N = 1
C
      ICOL1 = ICOLS(IS1(N))
      ICOL2 = ICOLS(IS2(N))
C
      XOFF = XIMIN(N)
      YOFF = UEMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(UEMAX(N)-UEMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(UEMAX(N)-UEMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*UEDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,UEMIN(N),UEDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.0*CH,1.4*CH,'x'   ,0.0,1)
      CALL PLCHAR(-3.3*CH,YAXL-1.5*DYANN-0.5*CH,1.0*CH, '/'  ,0.0,1)
      CALL PLCHAR(-5.0*CH,YAXL-1.5*DYANN-0.5*CH,1.2*CH,'u q' ,0.0,3)
      CALL PLMATH(999.0  ,999.0                ,1.2*CH,   '&',0.0,1)
      CALL PLCHAR(-4.1*CH,YAXL-1.5*DYANN-0.9*CH,0.8*CH, 'e'  ,0.0,1)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL NEWPEN(2)
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
      IF(LFORCE) THEN
       CLTOT = LIFT/QU
       CDTOT = (DRAGW + DRAGV)/QU
       CMTOT = MOMN/QU
       ADEG = ALFA * 180.0/3.1415926
       HSTAT = HINF / (1.0 + 0.5*GM1*MINF**2)
       MUINF = SQRT((HSTAT/HINF)**3) * (HINF+HVIS)/(HSTAT+HVIS)
       REINF = REYN * (2.0*QU/(QINF*MUINF))
C
       CALL VLABEL(0.0,YAXL,CH, NAME,
     &             REINF,MINF,ACRIT,ALFA,
     &             CLTOT,CDTOT,XTR(IS1(N)),XTR(IS2(N)),
     &             ICOL1,ICOL2,LCONV)
      ENDIF
C
      CALL GETCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
      CALL NEWCLIP(0.0,XAXL,0.0,YAXL)
C
C---- plot Ue over airfoil and wake
      ILE = ILEB(N)
      ITE = ITEB(N)
      I1 = IS1(N)
      I2 = IS2(N)
      NPTS = II-ILE-1
      I = ILE+1
      CALL NEWPEN(3)
C
C---- plot top surface, and small "+" at TE point
      CALL NEWCOLOR(ICOL1)
      CALL XYPLOT(NPTS,XI(I,I1),UEDG(I,I1),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL XYPLOT(NPTS,XI(I,I1),UINV(I,I1),XOFF,XSF,YOFF,YSF,2,SH,KSYMB)
      CALL PLSYMB((XI(ITE,I1)-XOFF)*XSF,(UEDG(ITE,I1)-YOFF)*YSF,
     &            0.5*CH,3,0.0,0)
C
C---- plot bottom surface, and small "+" at TE point
      CALL NEWCOLOR(ICOL2)
      CALL XYPLOT(NPTS,XI(I,I2),UEDG(I,I2),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL XYPLOT(NPTS,XI(I,I2),UINV(I,I2),XOFF,XSF,YOFF,YSF,2,SH,KSYMB)
      CALL PLSYMB((XI(ITE,I2)-XOFF)*XSF,(UEDG(ITE,I2)-YOFF)*YSF,
     &            0.5*CH,3,0.0,0)
C
      IF(ISYMB.NE.0 .AND. ISYMB.GT.ILE .AND. ISYMB.LT.II) THEN
       CALL NEWCOLORNAME('red')
       I = ISYMB
       CALL PLSYMB((XI(I,I1)-XOFF)*XSF,(UEDG(I,I1)-YOFF)*YSF,SHS,1,0.,0)
       CALL PLSYMB((XI(I,I2)-XOFF)*XSF,(UEDG(I,I2)-YOFF)*YSF,SHS,1,0.,0)
      ENDIF
C
      CALL NEWCOLOR(ICOL0)
C
      IF(LREF) THEN
        NF = 0
        CALL GETREF(XF,PF,NF,NFX)
        CALL XYPLOT(NF,XF,PF,XOFF,XSF,YOFF,YSF,1,1.0*CH,5)
      ENDIF
C
      CALL NEWCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 7
      NPLOT = N
      CALL PLFLUSH
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
ccc      CALL PLEND
      GO TO 995
C
C
C===============================================
C**** Plot A/Ao vs x
C
   80 CONTINUE
      CALL GETEL(NBPLT,NBL)
      N = NBPLT
      IF(NBL.EQ.1) N = 1
C
      ICOL1 = ICOLS(IS1(N))
      ICOL2 = ICOLS(IS2(N))
C
      XOFF = XIMIN(N)
      YOFF = ANMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(ANMAX(N)-ANMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(ANMAX(N)-ANMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*ANDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,ANMIN(N),ANDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.0*CH,1.4*CH,'x',0.0,1)
C
      CALL PLCHAR(-4.0*CH,YAXL-0.5*DYANN-0.6*CH,1.2*CH,'ln' ,0.0,2)
      CALL PLCHAR(-5.0*CH,YAXL-1.5*DYANN-0.6*CH,1.2*CH,'A/A',0.0,3)
      CALL PLCHAR(-1.4*CH,YAXL-1.5*DYANN-1.0*CH,0.8*CH,'0'  ,0.0,1)
C
      CALL DASH(0.0,XAXL,(ACRIT-YOFF)*YSF)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL NEWPEN(2)
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
      IF(LFORCE) THEN
       CLTOT = LIFT/QU
       CDTOT = (DRAGW + DRAGV)/QU
       CMTOT = MOMN/QU
       ADEG = ALFA * 180.0/3.1415926
       HSTAT = HINF / (1.0 + 0.5*GM1*MINF**2)
       MUINF = SQRT((HSTAT/HINF)**3) * (HINF+HVIS)/(HSTAT+HVIS)
       REINF = REYN * (2.0*QU/(QINF*MUINF))
C
       CALL VLABEL(0.0,YAXL,CH, NAME,
     &             REINF,MINF,ACRIT,ALFA,
     &             CLTOT,CDTOT,XTR(IS1(N)),XTR(IS2(N)),
     &             ICOL1,ICOL2,LCONV)
      ENDIF
C
      CALL GETCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
      CALL NEWCLIP(0.0,XAXL,0.0,YAXL)
C
C---- plot ln A/Ao upstream of transition points
      ILE = ILEB(N)
      ITE = ITEB(N)
      I1 = IS1(N)
      I2 = IS2(N)
      ITR1 = ITRAN(I1)-1
      ITR2 = ITRAN(I2)-1
      NBLS = ITR1-ILE
      NBLP = ITR2-ILE
      CALL NEWPEN(5)
C
      CALL NEWCOLOR(ICOL1)
      I = ILE+1
      CALL XYPLOT(NBLS,XI(I,I1),CTAU(I,I1),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      DCDX = (CTAU(ITR1,I1) - CTAU(ITR1-1,I1))
     &      /(  XI(ITR1,I1) -   XI(ITR1-1,I1))
      XTT(1) = XI(ITR1,I1)
      CTT(1) = CTAU(ITR1,I1)
      XTT(2) = XTR(I1)
      CTT(2) = CTAU(ITR1,I1) + (XTT(2)-XTT(1))*DCDX
      CTT(2) = MIN( CTT(2) , ACRIT )
      CALL XYPLOT(2,XTT,CTT, XOFF,XSF,YOFF,YSF, 1,SH,0)
      XLAB = XSF*(XTT(2)-XOFF) + 0.5*CH
      YLAB = YSF*(CTT(2)-YOFF)
      CALL PLCHAR(XLAB,YLAB,0.8*CH,'T',0.0,1)
C
      CALL NEWCOLOR(ICOL2)
      CALL XYPLOT(NBLP,XI(I,I2),CTAU(I,I2),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      DCDX = (CTAU(ITR2,I2) - CTAU(ITR2-1,I2))
     &      /(  XI(ITR2,I2) -   XI(ITR2-1,I2))
      XTT(1) = XI(ITR2,I2)
      CTT(1) = CTAU(ITR2,I2)
      XTT(2) = XTR(I2)
      CTT(2) = CTAU(ITR2,I2) + (XTT(2)-XTT(1))*DCDX
      CTT(2) = MIN( CTT(2) , ACRIT )
      CALL XYPLOT(2,XTT,CTT, XOFF,XSF,YOFF,YSF, 1,SH,0)
      XLAB = XSF*(XTT(2)-XOFF) + 0.5*CH
      YLAB = YSF*(CTT(2)-YOFF)
      CALL PLCHAR(XLAB,YLAB,0.8*CH,'B',0.0,1)
C
      IF(ISYMB.NE.0 .AND. ISYMB.GT.ILE .AND. ISYMB.LT.ITRAN(I1)) THEN
       CALL NEWCOLORNAME('red')
       I = ISYMB
       CALL PLSYMB((XI(I,I1)-XOFF)*XSF,(CTAU(I,I1)-YOFF)*YSF,SHS,1,0.,0)
      ENDIF
      IF(ISYMB.NE.0 .AND. ISYMB.GT.ILE .AND. ISYMB.LT.ITRAN(I2)) THEN
       CALL NEWCOLORNAME('red')
       I = ISYMB
       CALL PLSYMB((XI(I,I2)-XOFF)*XSF,(CTAU(I,I2)-YOFF)*YSF,SHS,1,0.,0)
      ENDIF
C
C---- plot amplitudes of individual frequencies
      FREF = 1.0
      CHF = 0.7*CH
C
      CALL NEWPEN(1)
      IO = ILE+1
      NBLS0 = NBLS
      NBLP0 = NBLP
C
      CALL GETCOLORRGB(ICOL1,IRED,IGRN,IBLU,COLNAM)
      CALL NEWCOLORRGB((IRED*2)/3,(IGRN*2)/3,(IBLU*2)/3)
      CALL FRPLOT(NBLS0,SI(IO,I1),XI(IO,I1),
     &            SHAP(IO,I1),THET(IO,I1),UEDG(IO,I1),VEDG(IO,I1),
     &            XTR(I1), FREF,
     &            XOFF,XSF, YOFF,YSF, CHF)
C
      CALL GETCOLORRGB(ICOL2,IRED,IGRN,IBLU,COLNAM)
      CALL NEWCOLORRGB((IRED*2)/3,(IGRN*2)/3,(IBLU*2)/3)
      CALL FRPLOT(NBLP0,SI(IO,I2),XI(IO,I2),
     &            SHAP(IO,I2),THET(IO,I2),UEDG(IO,I2),VEDG(IO,I2),
     &            XTR(I2), FREF,
     &            XOFF,XSF, YOFF,YSF, CHF)
C
      CALL NEWCOLOR(ICOL0)
C
      IF(NBLS0.NE.0 .OR. NBLP0.NE.0) THEN
C----- add label to plot if individual frequencies were plotted
       XLAB = XSF*(MAX(XI(ITRAN(I1),I1),XI(ITRAN(I2),I2))-XOFF) + 9.*CHF
       YLAB = 0.5*YAXL + 0.5*CH
       CALL NEWPEN(2)
       CALL PLMATH(XLAB,YLAB,1.2*CH,'w   &',0.0,5)
       CALL PLCHAR(XLAB,YLAB,1.2*CH,' L/q ',0.0,5)
      ENDIF
C
      CALL NEWCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 8
      NPLOT = N
      CALL PLFLUSH
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
ccc      CALL PLEND
      GO TO 995
C
C
C===============================================
C**** Plot Ctau vs sb
C
   90 CONTINUE
      CALL GETEL(NBPLT,NBL)
      N = NBPLT
      IF(NBL.EQ.1) N = 1
C
      ICOL1 = ICOLS(IS1(N))
      ICOL2 = ICOLS(IS2(N))
C
      XOFF = XIMIN(N)
      YOFF = CTMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(CTMAX(N)-CTMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(CTMAX(N)-CTMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*CTDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,CTMIN(N),CTDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.0*CH,1.4*CH,'x' ,0.0,1)
C
      CALL PLMATH(-3.7*CH,YAXL-1.5*DYANN-0.6*CH,1.4*CH,' H',0.0,2)
      CALL PLCHAR(-3.7*CH,YAXL-1.5*DYANN-0.6*CH,1.4*CH,'C ',0.0,2)
      CALL PLMATH(-3.7*CH,YAXL-1.5*DYANN-1.0*CH,1.1*CH,' t',0.0,2)
CCC   CALL PLCHAR(-1.8*CH,YAXL-1.5*DYANN-1.4*CH,0.7*CH,'eq',0.0,2)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL NEWPEN(2)
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
      IF(LFORCE) THEN
       CLTOT = LIFT/QU
       CDTOT = (DRAGW + DRAGV)/QU
       CMTOT = MOMN/QU
       ADEG = ALFA * 180.0/3.1415926
       HSTAT = HINF / (1.0 + 0.5*GM1*MINF**2)
       MUINF = SQRT((HSTAT/HINF)**3) * (HINF+HVIS)/(HSTAT+HVIS)
       REINF = REYN * (2.0*QU/(QINF*MUINF))
C
       CALL VLABEL(0.0,YAXL,CH, NAME,
     &             REINF,MINF,ACRIT,ALFA,
     &             CLTOT,CDTOT,XTR(IS1(N)),XTR(IS2(N)),
     &             ICOL1,ICOL2,LCONV)
      ENDIF
C
      CALL GETCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
      CALL NEWCLIP(0.0,XAXL,0.0,YAXL)
C
      ILE = ILEB(N)
      ITE = ITEB(N)
      I1 = IS1(N)
      I2 = IS2(N)
      NBLS = II-1-ITRAN(I1)
      NBLP = II-1-ITRAN(I2)
      ITR1 = ITRAN(I1)
      ITR2 = ITRAN(I2)
      CALL NEWPEN(2)
C
      CALL NEWCOLOR(ICOL1)
      I = ITR1
      CALL XYPLOT(NBLS,XI(I,I1),CTAU(I,I1),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL PLSYMB((XI(ITE,I1)-XOFF)*XSF,(CTAU(ITE,I1)-YOFF)*YSF,
     &            0.5*CH,3,0.0,0)
C
      CALL NEWCOLOR(ICOL2)
      I = ITR2
      CALL XYPLOT(NBLP,XI(I,I2),CTAU(I,I2),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL PLSYMB((XI(ITE,I2)-XOFF)*XSF,(CTAU(ITE,I2)-YOFF)*YSF,
     &            0.5*CH,3,0.0,0)
C
      IF(ISYMB.NE.0 .AND. ISYMB.GE.ITRAN(I1) .AND. ISYMB.LT.II) THEN
       CALL NEWCOLORNAME('red')
       I = ISYMB
       CALL PLSYMB((XI(I,I1)-XOFF)*XSF,(CTAU(I,I1)-YOFF)*YSF,SHS,1,0.,0)
      ENDIF
      IF(ISYMB.NE.0 .AND. ISYMB.GE.ITRAN(I2) .AND. ISYMB.LT.II) THEN
       CALL NEWCOLORNAME('red')
       I = ISYMB
       CALL PLSYMB((XI(I,I2)-XOFF)*XSF,(CTAU(I,I2)-YOFF)*YSF,SHS,1,0.,0)
      ENDIF
C
      CALL NEWCOLOR(ICOL0)
C
      IF(LREF) THEN
        NF = 0
        CALL GETREF(XF,PF,NF,NFX)
        CALL XYPLOT(NF,XF,PF,XOFF,XSF,YOFF,YSF,1,1.0*CH,5)
      ENDIF
C
      CALL NEWCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 9
      NPLOT = N
      CALL PLFLUSH
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
ccc      CALL PLEND
      GO TO 995
C
C
C===============================================
C**** Plot Rtheta vs x
C
  100 CONTINUE
      CALL GETEL(NBPLT,NBL)
      N = NBPLT
      IF(NBL.EQ.1) N = 1
C
      ICOL1 = ICOLS(IS1(N))
      ICOL2 = ICOLS(IS2(N))
C
      XOFF = XIMIN(N)
      YOFF = RTMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(RTMAX(N)-RTMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(RTMAX(N)-RTMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*RTDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,RTMIN(N),RTDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.0*CH,1.4*CH,'x',0.0,1)
C
      CALL PLCHAR(-5.5*CH,YAXL-0.5*DYANN-0.6*CH,1.1*CH,'log',0.0,3)
      CALL PLCHAR(-2.0*CH,YAXL-0.5*DYANN-1.2*CH,0.8*CH,'10' ,0.0,2)
      CALL PLCHAR(-4.4*CH,YAXL-1.5*DYANN-0.6*CH,1.4*CH,'Re' ,0.0,2)
      CALL PLMATH(999.0  ,YAXL-1.5*DYANN-1.3*CH,1.0*CH,'q'  ,0.0,1)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL NEWPEN(2)
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
      IF(LFORCE) THEN
       CLTOT = LIFT/QU
       CDTOT = (DRAGW + DRAGV)/QU
       CMTOT = MOMN/QU
       ADEG = ALFA * 180.0/3.1415926
       HSTAT = HINF / (1.0 + 0.5*GM1*MINF**2)
       MUINF = SQRT((HSTAT/HINF)**3) * (HINF+HVIS)/(HSTAT+HVIS)
       REINF = REYN * (2.0*QU/(QINF*MUINF))
C
       CALL VLABEL(0.0,YAXL,CH, NAME,
     &             REINF,MINF,ACRIT,ALFA,
     &             CLTOT,CDTOT,XTR(IS1(N)),XTR(IS2(N)),
     &             ICOL1,ICOL2,LCONV)
      ENDIF
C
      CALL GETCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
      CALL NEWCLIP(0.0,XAXL,0.0,YAXL)
C
C---- plot log(Rtheta) over airfoil and wake
      ILE = ILEB(N)
      ITE = ITEB(N)
      I1 = IS1(N)
      I2 = IS2(N)
      NPTS = II-ILE-1
      I = ILE+1
      CALL NEWPEN(3)
C
C---- top surface, with small "+" at TE point
      CALL NEWCOLOR(ICOL1)
      CALL XYPLOT(NPTS,XI(I,I1),ALRT(I,I1),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL PLSYMB((XI(ITE,I1)-XOFF)*XSF,(ALRT(ITE,I1)-YOFF)*YSF,
     &            0.5*CH,3,0.0,0)
C
C---- bottom surface, with small "+" at TE point
      CALL NEWCOLOR(ICOL2)
      CALL XYPLOT(NPTS,XI(I,I2),ALRT(I,I2),XOFF,XSF,YOFF,YSF,1,SH,KSYMB)
      CALL PLSYMB((XI(ITE,I2)-XOFF)*XSF,(ALRT(ITE,I2)-YOFF)*YSF,
     &            0.5*CH,3,0.0,0)
C
      IF(ISYMB.NE.0 .AND. ISYMB.GT.ILE .AND. ISYMB.LT.II) THEN
       CALL NEWCOLORNAME('red')
       I = ISYMB
       CALL PLSYMB((XI(I,I1)-XOFF)*XSF,(ALRT(I,I1)-YOFF)*YSF,SHS,1,0.,0)
       CALL PLSYMB((XI(I,I2)-XOFF)*XSF,(ALRT(I,I2)-YOFF)*YSF,SHS,1,0.,0)
      ENDIF
C
      CALL NEWCOLOR(ICOL0)
C
      IF(LREF) THEN
        NF = 0
        CALL GETREF(XF,PF,NF,NFX)
        CALL XYPLOT(NF,XF,PF,XOFF,XSF,YOFF,YSF,1,1.0*CH,5)
      ENDIF
C
      CALL NEWCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR =       INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN
C
       CALL NEWPEN(1)
C
       KK = 10
       DO 1005 K=1, KK
         FRAC = FLOAT(K+1)/FLOAT(K)
         DYGARR(K) = DYG * LOG10(FRAC)
 1005  CONTINUE
       DO 1008 IG=1, NYGR
         YG0 = DYG*FLOAT(IG-1)
         CALL PLGRID(0.0,YG0, NXGR,DXG, KK-1+1000,DYGARR, LMASK2)
 1008  CONTINUE
      ENDIF
C
C
      KPLOT = 10
      NPLOT = N
      CALL PLFLUSH
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
ccc      CALL PLEND
      GO TO 995
C
C
C===============================================
C**** Print out Lift and Drag
C
  110 CLI = LIFT/QU
      CDI = DRAG/QU
      CMI = MOMN/QU
C
      CDV = DRAGV/QU
      CDF = DRAGF/QU
      CDW = DRAGW/QU
      CDP = (CDV+CDW) - CDF
C
      CLTOT = CLI 
      CDTOT = CDV + CDW
      CMTOT = CMI 
C
      CD_ALFA = CDV_ALFA + CDW_ALFA
      CD_MINF = CDV_MINF + CDW_MINF
C
      ELOD = 0.0
      IF(CDTOT.NE.0.0) ELOD = CLTOT/CDTOT
C
      ADEG = ALFA / DTOR
C
      HSTAT = HINF / (1.0 + 0.5*GM1*MINF**2)
      MUINF = SQRT((HSTAT/HINF)**3) * (HINF+HVIS)/(HSTAT+HVIS)
      REINF = REYN * (2.0*QU/(QINF*MUINF))
      PEXAVG = 0.
      DO 1102 J=1, JJ-1
        IF(JSTAG(J).GT.0) GO TO 1102
        PEXAVG = PEXAVG + MFRACT(J)*P(II-1,J)
 1102 CONTINUE
C
      WRITE(*,8000) MINF, REINF*1.0E-6, ACRIT
      WRITE(*,8010) CLTOT, CDTOT, CMTOT, ELOD,
     &              CDV,   CDW,
     &              CDF,   CDP
      WRITE(*,8020) CIRC, ADEG, DOUX, DOUY, XCENT, YCENT
      WRITE(*,8420) CL_ALFA*DTOR, CD_ALFA*DTOR, CM_ALFA*DTOR
      WRITE(*,8440) CL_MINF, CD_MINF, CM_MINF
C
      IF(NBL.GT.1) THEN
C
       SINA = SIN(ALFA)
       COSA = COS(ALFA)
       DO 1104 N = 1, NBL
         BCL  = BLIFT(N)/QU
         BCD  = BDRAG(N)/QU
         BCM  = BMOMN(N)/QU
         BCDV = BDRAGV(N)/QU
         BCDF = BDRAGF(N)/QU
C
         BFX = BCD*COSA - BCL*SINA
         BFY = BCD*SINA + BCL*COSA
         BMO = BCM - 0.25*BFY
C
         WRITE(*,8030) N, BCL, BCDV, BFX, BFY, BCM, BCDF, BMO
         IF(REYN.NE.0.0) WRITE(*,8040) XTR(IS1(N)), XTR(IS2(N))
 1104  CONTINUE
C
      ELSE IF(REYN.NE.0.0) THEN
C
       WRITE(*,*)
       WRITE(*,8040) XTR(IS1(N)), XTR(IS2(N))
C
      ENDIF
C
C
 8000 FORMAT(/' Ma  =', F10.4,'     Re  =',F8.3,'e6',
     &                                        '   Ncrit =',F8.2)
 8010 FORMAT(/' CL  =', F10.5,'     CD  =',F10.6, '    CM  =',F10.5,
     &        ' L/D =', F10.3
     &      //'  CD breakdown'
     &       /' viscous ,wave    :  CDv =',F10.6, '    CDw =',F10.6
     &       /' friction,pressure:  CDf =',F10.6, '    CDp =',F10.6)
 8015 FORMAT(/' Sinl  =',F8.4,'    Sout  = ',F8.4)
 8020 FORMAT(/' Gamma =',F8.4,'    alpha = ',F8.4,' deg.'
     &       /' Doubx =',F8.4,'    Douby = ',F8.4,'    at x,y =',2F10.5)
C
 8420 FORMAT(/' dCL/da =',F8.4,'    dCD/da =',F10.6,'    dCM/da =',F9.5)
 8440 FORMAT( ' dCL/dM =',F8.4,'    dCD/dM =',F10.6,'    dCM/dM =',F9.5)
C
 8030 FORMAT(
     & /' Element :',I2
     & /'   CL  =',F10.5,'   CDv =',F10.6,
     &                  '        Cx =',F10.6,'    Cy =',F10.6,
     & /'   CM  =',F10.5,'   CDf =',F10.6,
     &                  '        Cm =',F10.6,' about origin') 
 8040 FORMAT(  ' top Xtr =', F8.4,'  bot Xtr = ',F8.4)
C
      WRITE(*,*)
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
      GO TO 995
C
C
C===============================================
C**** Change settings
C
  120 CALL SPLSET
      GO TO 995
C
C===============================================
C**** Change element to plot  (pass in -NBPLT to allow 0 as input)
C
  130 NBPLT = -NBPLT
      CALL GETEL(NBPLT,NBL)
      GO TO 995
C
C===============================================
C**** Make Hardcopy
C
  140 IF(LPLOT) CALL PLEND
      LPLOT = .FALSE.
      CALL REPLOT(IDEVRP)
      GO TO 995
C
C===============================================
C**** set index to place symbol on all line plots
C
 150  WRITE(*,1505) II, JJ
 1505 FORMAT(/' Grid size: I J = ', 2I6
     &       /'                     ______top______   ____bottom_____'
     &       /' Element  iLE  iTE   iTran iCorn   j   iTran iCorn   j')
CCC                 1     22  124    123   123   16    123   123   16
      WRITE(*,1510) (N,ILEB(N),ITEB(N),
     &               ITRAN(IS1(N)),IGCORN(IS1(N))+ILEB(N)-1,JS1(N), 
     &               ITRAN(IS2(N)),IGCORN(IS2(N))+ILEB(N)-1,JS2(N),
     &               N=1, NBL )
 1510 FORMAT(8(1X,I5,2X,2I5, 2(I7,I6,I5) / ) )
C
 151  WRITE(*,1520) ISYMB
 1520 FORMAT(1X,'Enter i index for symbol',I6)
      CALL READI(1,ISYMB,ERROR)
      IF(ERROR) GO TO 151
      GO TO 995
C
C==============================================
C**** change x-axis limits
C
 160  CONTINUE
      N = NPLOT
      IF(N.LT.1 .OR. N.GT.NBL .OR. KPLOT.EQ.0) THEN
       WRITE(*,*) 'No current BL plot'
       GO TO 995
      ENDIF
      WRITE(*,9101) N, XIMIN(N), XIMAX(N), XIDEL(N)
 9101 FORMAT(/' Element',I2,':  Currently, Xmin,Xmax,Xdel =', 3F10.4,
     &       /'        ',2X,'   Enter new  Xmin,Xmax,Xdel: ', $ )
      AINPUT(1) = XIMIN(N)
      AINPUT(2) = XIMAX(N)
      AINPUT(3) = XIDEL(N)
      CALL READR(3,AINPUT,ERROR)
      IF(ERROR) GO TO 160
      XIMIN(N) = AINPUT(1)
      XIMAX(N) = AINPUT(2)
      XIDEL(N) = AINPUT(3)
      NOPT = KPLOT
      GO TO 998
C
C===================================================
C**** change y-axis limits on current BL plot
C
 170  CONTINUE
      N = NPLOT
      IF(N.LT.1 .OR. N.GT.NBL .OR. KPLOT.EQ.0) THEN
       WRITE(*,*) 'No current BL plot'
       GO TO 995
      ENDIF
C
      CALL YLIMS(N,KPLOT)
C
      WRITE(*,9201) N, YIMIN(N), YIMAX(N), YIDEL(N)
 9201 FORMAT(/' Element',I2,':  Currently, Ymin,Ymax,Ydel =', 3F10.4,
     &       /'        ',2X,'   Enter new  Ymin,Ymax,Ydel: ', $ )
      AINPUT(1) = YIMIN(N)
      AINPUT(2) = YIMAX(N)
      AINPUT(3) = YIDEL(N)
      CALL READR(3,AINPUT,ERROR)
      IF(ERROR) GO TO 160
      YIMIN(N) = AINPUT(1)
      YIMAX(N) = AINPUT(2)
      YIDEL(N) = AINPUT(3)
C
      CALL VLIMS(N,KPLOT)
C
      NOPT = KPLOT
      GO TO 998
C
C===============================================
C**** cursor blowup
 180  CONTINUE
      N = NPLOT
      IF(N.LT.1 .OR. N.GT.NBL .OR. KPLOT.EQ.0) THEN
       WRITE(*,*) 'No current BL plot'
       GO TO 995
      ENDIF
C
      CALL OFFGET(XOFF,YOFF,XSF,YSF,1.0,AR,.FALSE.,.TRUE.)
C
      XIMIN(N) = XOFF
      YIMIN(N) = YOFF
      XIMAX(N) = 1.0/XSF + XIMIN(N)
      YIMAX(N) = PAR/YSF + YIMIN(N)
C
      CALL SCALIT(1,XIMAX(N),XIMIN(N),XFAC,ANN,NANN)
      XIDEL(N) = 1.0 / (FLOAT(NANN)*XFAC)
      XIMAX(N) = XIDEL(N)
     &         * AINT(XIMAX(N)/XIDEL(N) + 0.49+SIGN(0.50,XIMAX(N)))
      XIMIN(N) = XIDEL(N)
     &         * AINT(XIMIN(N)/XIDEL(N) - 0.49+SIGN(0.50,XIMIN(N)))
C
      CALL SCALIT(1,YIMAX(N),YIMIN(N),YFAC,ANN,NANN)
      YIDEL(N) = 1.0 / (FLOAT(NANN)*YFAC)
      YIMAX(N) = YIDEL(N)
     &         * AINT(YIMAX(N)/YIDEL(N) + 0.49+SIGN(0.50,YIMAX(N)))
      YIMIN(N) = YIDEL(N)
     &         * AINT(YIMIN(N)/YIDEL(N) - 0.49+SIGN(0.50,YIMIN(N)))
C
      CALL VLIMS(N,KPLOT)
C
      NOPT = KPLOT
      GO TO 998
C
C===============================================
C**** set default BL plot limits
 190  CONTINUE
      DO 191 N=1, NBL
        CALL DEFLIM(N)
 191  CONTINUE
      GO TO 995
C
C===============================================
C**** annotation menu
C
 200  CALL ANNOT(CH)
      GO TO 995
C
C===============================================
C**** plot-page options
C
 210  CALL OPLSET(IDEVRP,IPSLU,
     &            SIZE,AR,
     &            XMARG,YMARG,XPAGE,YPAGE,
     &            CH,SCRNFR,LCURS,LLAND)
      GO TO 995
C
      END ! SURFPL



      SUBROUTINE YLIMS(N,KPLOT)
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
C
      IF     (KPLOT.EQ.3) THEN
       YIMIN(N) = HKMIN(N)
       YIMAX(N) = HKMAX(N)
       YIDEL(N) = HKDEL(N)
      ELSE IF(KPLOT.EQ.4) THEN
       YIMIN(N) = DSMIN(N)
       YIMAX(N) = DSMAX(N)
       YIDEL(N) = DSDEL(N)
      ELSE IF(KPLOT.EQ.5) THEN
       YIMIN(N) = DPMIN(N)
       YIMAX(N) = DPMAX(N)
       YIDEL(N) = DPDEL(N)
      ELSE IF(KPLOT.EQ.6) THEN
       YIMIN(N) = CFMIN(N)
       YIMAX(N) = CFMAX(N)
       YIDEL(N) = CFDEL(N)
      ELSE IF(KPLOT.EQ.7) THEN
       YIMIN(N) = UEMIN(N)
       YIMAX(N) = UEMAX(N)
       YIDEL(N) = UEDEL(N)
      ELSE IF(KPLOT.EQ.8) THEN
       YIMIN(N) = ANMIN(N)
       YIMAX(N) = ANMAX(N)
       YIDEL(N) = ANDEL(N)
      ELSE IF(KPLOT.EQ.9) THEN
       YIMIN(N) = CTMIN(N)
       YIMAX(N) = CTMAX(N)
       YIDEL(N) = CTDEL(N)
      ELSE IF(KPLOT.EQ.10) THEN
       YIMIN(N) = RTMIN(N) 
       YIMAX(N) = RTMAX(N)
       YIDEL(N) = RTDEL(N)
      ENDIF
C
      RETURN
      END ! YLIMS



      SUBROUTINE VLIMS(N,KPLOT)
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
C
      IF     (KPLOT.EQ.3) THEN
       HKMIN(N) = YIMIN(N)
       HKMAX(N) = YIMAX(N)
       HKDEL(N) = YIDEL(N)
      ELSE IF(KPLOT.EQ.4) THEN
       DSMIN(N) = YIMIN(N)
       DSMAX(N) = YIMAX(N)
       DSDEL(N) = YIDEL(N)
      ELSE IF(KPLOT.EQ.5) THEN
       DPMIN(N) = YIMIN(N)
       DPMAX(N) = YIMAX(N)
       DPDEL(N) = YIDEL(N)
      ELSE IF(KPLOT.EQ.6) THEN
       CFMIN(N) = YIMIN(N)
       CFMAX(N) = YIMAX(N)
       CFDEL(N) = YIDEL(N)
      ELSE IF(KPLOT.EQ.7) THEN
       UEMIN(N) = YIMIN(N)
       UEMAX(N) = YIMAX(N)
       UEDEL(N) = YIDEL(N)
      ELSE IF(KPLOT.EQ.8) THEN
       ANMIN(N) = YIMIN(N)
       ANMAX(N) = YIMAX(N)
       ANDEL(N) = YIDEL(N)
      ELSE IF(KPLOT.EQ.9) THEN
       CTMIN(N) = YIMIN(N)
       CTMAX(N) = YIMAX(N)
       CTDEL(N) = YIDEL(N)
      ELSE IF(KPLOT.EQ.10) THEN
       RTMIN(N) = YIMIN(N)
       RTMAX(N) = YIMAX(N)
       RTDEL(N) = YIDEL(N)
      ENDIF
C
      RETURN
      END ! VLIMS



      SUBROUTINE GETEL(NBPLT,NBL)
C
      IF(NBPLT.GT.0 .OR. NBL.EQ.1) RETURN
C
 10   IF(NBPLT.EQ.0) THEN
        WRITE(*,1100) 1, NBL
      ELSE
        WRITE(*,1200) 1, NBL
      ENDIF
C
 1100 FORMAT(/' Enter element number (',I1,'..',I1,'):  ', $)
 1200 FORMAT(/' Enter element number (',I1,'..',I1,', 0=all):  ', $)
      READ(*,*,ERR=10) NUM
C
      IF(NUM.LT.0 .OR. NUM.GT.NBL) THEN
       WRITE(*,*) 'Element number out of range !'
       GO TO 10
      ELSE IF(NUM.EQ.0 .AND. NBPLT.EQ.0) THEN
       WRITE(*,*) 'Must specify an element'
       GO TO 10
      ELSE 
       NBPLT = NUM
       RETURN
      ENDIF
C
      END


      SUBROUTINE OSTRPL
C--------------------------------
C     Plots outer streamline Cp
C--------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      DIMENSION XX(IX,2), CX(IX,2), MX(IX,2)
C
      LOGICAL ERROR
C
      CHARACTER*1 ANS
      CHARACTER*2 COPT
C
C---- center of rotation for ALFA
      XROT = 0.25
      YROT = 0.0
C
C---- default flags
      LAIRFF = .TRUE.
      LFORCE = .TRUE.
      LFOREF = .FALSE.
      LREF   = .FALSE.
C
C---- fraction of full plot size taken up by x-y plot
      SIZFAC = 0.8                       !!! MD  added 10 Sept 96
C
C---- origin location / SIZE
      XORG = 0.125
      YORG = 0.10
C
      KSYMB = 0
      SH = 0.2*CH
      CHI = 0.6*CH
C
      SHS = 0.6*CH
C
      ISYMB = 0
C
C---- plot Cp axis limits and annotation increment
      CPMAX1 =  0.8
      CPMIN1 = -0.8
      CPDEL1 = -0.2
C
C---- plot Mach axis limit and annotation increment
      MAMIN1 = 0.0
      MAMAX1 = 1.2
      MADEL1 = 0.2
C
C---- additional distance from bottom of plot to bottom of Mach,Cp axes
      YSPACE = 0.15
C
      DTOR = ATAN(1.0)/45.0
C
      J1 = 1
      J2 = JJ
      SINA = SIN(ALFA)
      COSA = COS(ALFA)
C
      DPINF = PINF - PSTINF
      DO 5 I=1, II
        XX(I,1) = (X(I,J1)-XROT)*COSA + (Y(I,J1)-YROT)*SINA
        XX(I,2) = (X(I,J2)-XROT)*COSA + (Y(I,J2)-YROT)*SINA
C
C------ Cp
        CX(I,1) = (PI(I,J1)-DPINF)/QU
        CX(I,2) = (PI(I,J2)-DPINF)/QU
C
C------ isentropic Mach number
        PBAR1 = (PSTINF/(PI(I,J1)+PSTINF))**(GM1/GAM)
        PBAR2 = (PSTINF/(PI(I,J2)+PSTINF))**(GM1/GAM)
        PBAR1 = MAX(1.0,PBAR1)
        PBAR2 = MAX(1.0,PBAR2)
        MX(I,1) = SQRT(2.0/GM1*ABS(PBAR1-1.0))
        MX(I,2) = SQRT(2.0/GM1*ABS(PBAR2-1.0))
C
 5    CONTINUE
C
C
      LPLOT = .FALSE.
C
  990 WRITE(*,*)
      WRITE(*,*) '-----------------------------------------------------'
      WRITE(*,*)
      WRITE(*,*) ' 1   Mach vs x'
      WRITE(*,*) ' 2     Cp vs x'
      WRITE(*,*) '11   Hardcopy current plot'
      WRITE(*,*) '12   Change settings'
      WRITE(*,*) '14   Annotation menu'
      WRITE(*,*) '15   Place symbol at specified grid location'
  995 WRITE(*,1995)
 1995 FORMAT(/1X,'Select outer streamline plot:  ',$)
      READ(*,1000) COPT
C
      IF(INDEX('0 ',COPT(1:1)).NE.0) THEN
        IF(LPLOT) CALL PLEND
        LPLOT = .FALSE.
        RETURN
      ENDIF
C
      NOPT = 0
      READ(COPT,*,ERR=990) NOPT
C
C
      IF(NOPT.LT.10) THEN
       CALL PLTINI(SIZFAC)
       CALL PLOTABS(XORG*SIZE+XMARG,YORG*SIZE+YMARG,-3)
       CALL GETCOLOR(ICOL0)
      ENDIF
C
 1000 FORMAT(A)
C
      GOTO(10,20,990,990,990,990,990,990,990,990,110,120,990,140,150)
     &     , NOPT
      GO TO 990
C
C===============================================
C**** Plot Mach vs x
C
  10  CONTINUE
      MAFAC = 0.65/(MAMAX1-MAMIN1)
C
C---- Offset for plotting airfoil outline at bottom
      CALL PLOT(0.0,YSPACE,-3)
C
      PAR = MAMAX1*MAFAC
      CALL YAXIS(0.0,0.0,PAR,MADEL1*MAFAC,0.0,0.2,CH,1)
C
      YDASH = MAFAC
      CALL DASH(0.0,1.0,YDASH)
C
      CALL NEWPEN(3)
      YLAB = (1.0+0.5*MADEL1)*MAFAC - 0.7*CH
      CALL PLCHAR(-3.0*CH,YLAB,1.4*CH,'M',0.0,1)
C
C---- plot MSES identifier
      CALL NEWPEN(1)
      CALL PLCHAR(    CHI,MAMAX1*MAFAC-1.0*CHI,CHI,'MSES' ,0.0,4)
      CALL PLCHAR(    CHI,MAMAX1*MAFAC-3.0*CHI,CHI,'v'    ,0.0,1)
      CALL PLNUMB(2.5*CHI,MAMAX1*MAFAC-3.0*CHI,CHI,VERSION,0.0,1)
C
CCC      IF (NBPLT.NE.0) THEN
CCC        CALL PLCHAR(CHI,MAMAX1*MAFAC+2.*CHI,CHI,'Element ',0.0,8)
CCC        CALL PLNUMB(999.,999.,CHI,FLOAT(NBPLT),0.0,-1)
CCC      ENDIF
C
      XOFF = MIN(XX(1,1),XX(1,2))
      XSF = 1.0/MAX( (XX(II,1)-XX(1,1)), (XX(II,2)-XX(1,2)) )
      XT0 = (0.0-XROT - XOFF)*XSF
      XT1 = (1.0-XROT - XOFF)*XSF
      AYOFF = 0.0
C
       DO 102 N=1, NBL
          ILE = ILEB(N)
          ITE = ITEB(N)
          J1 = JS1(N)
          J2 = JS2(N)
C
C-------- plot airfoil and displacement surfaces
          CALL NEWPEN(2)
          CALL AIRFPL(IIB(N),XB(1,N),YB(1,N),
     &                XPB(1,N),YPB(1,N),SB(1,N),XOFF,AYOFF,XSF,
     &                XROT,YROT,-ALFA)
          CALL NEWPEN(1)
          CALL AIRFOI(II,X(1,J1),Y(1,J1),XOFF,AYOFF,XSF,XROT,YROT,-ALFA)
          CALL AIRFOI(II,X(1,J2),Y(1,J2),XOFF,AYOFF,XSF,XROT,YROT,-ALFA)
  102  CONTINUE
       CALL NEWPEN(3)
       J1 = 1
       J2 = JJ
       CALL AIRFOI(II,X(1,J1),Y(1,J1),XOFF,AYOFF,XSF,XROT,YROT,-ALFA)
       CALL AIRFOI(II,X(1,J2),Y(1,J2),XOFF,AYOFF,XSF,XROT,YROT,-ALFA)
C
      YXAX = MAFAC*MINF
C
      CALL NEWPEN(1)
      CALL PLOT(0.0,YXAX,3)
      CALL PLOT(1.0,YXAX,2)
      DO 14 NT=0, 2
        XT = XT0 + (XT1-XT0)*FLOAT(NT)/2.0
        CALL PLOT(XT,YXAX-0.006,3)
        CALL PLOT(XT,YXAX+0.006,2)
   14 CONTINUE
      DO 15 NT=1, 9
        XT = XT0 + (XT1-XT0)*FLOAT(NT)/10.0
        CALL PLOT(XT,YXAX-0.003,3)
        CALL PLOT(XT,YXAX+0.003,2)
  15  CONTINUE
C
      CALL NEWPEN(2)
         IBEG = 1
         IEND = II
         IDIF = IEND - IBEG + 1
         CALL XYPLOT(IDIF,XX(IBEG,1),MX(IBEG,1),
     &               XOFF,XSF,0.0,MAFAC,1,SH,KSYMB)
         CALL XYPLOT(IDIF,XX(IBEG,2),MX(IBEG,2),
     &               XOFF,XSF,0.0,MAFAC,1,SH,KSYMB)
         IF(ISYMB.NE.0 .AND. ISYMB.GE.IBEG .AND. ISYMB.LE.IEND) THEN
          CALL PLSYMB((XX(ISYMB,1)-XOFF)*XSF ,
     &                 MX(ISYMB,1)      *MAFAC,SHS,0.0,0)
          CALL PLSYMB((XX(ISYMB,2)-XOFF)*XSF ,
     &                 MX(ISYMB,2)      *MAFAC,SHS,0.0,0)
         ENDIF
C
C
C---- plot reference data...
      IF(LREF) THEN
       NF = 0
       CALL GETREF(XF,MF,NF,NFX)
C
C----- check if distinction between elements has been made with a 999.0
       IF1 = 1
       ISYM = 1
       DO 106 IF=1, NF
         IF(XF(IF).EQ.999.0 .OR. IF.EQ.NF) THEN
          NFE = IF-IF1+1
          CALL XYPLOT(NFE,XF(IF1),MF(IF1),
     &                XOFF,XSF,0.0,MAFAC,1,0.5*CH,ISYM)
          IF1 = IF + 1
          ISYM = ISYM + 1
         ENDIF
 106   CONTINUE
      ENDIF
C
C
      IF(LFORCE) CALL PLTFOR(MAMAX1*MAFAC,0)
C
      CALL PLFLUSH
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
ccc      CALL PLEND
      GO TO 995
C
C===============================================
C**** Plot Cp vs x
C
  20  CONTINUE
      CPFAC = 0.65/(CPMAX1-CPMIN1)
C
C---- Offset for plotting airfoil outline at bottom
      CALL PLOT(0.0,CPMAX1*CPFAC+YSPACE,-3)
C
      PAR = (CPMAX1-CPMIN1)*CPFAC
      CALL YAXIS(0.0,-CPMAX1*CPFAC,PAR,-CPDEL1*CPFAC,
     &             CPMAX1,CPDEL1,0.9*CH,1)
C
      YDASH = -CPSTAR*CPFAC
      IF(YDASH .LE. -CPMIN1*CPFAC) CALL DASH(0.0,1.0,YDASH)
C
      CALL NEWPEN(3)
      YLAB = (FLOAT(INT(CPMIN1/CPDEL1 + 0.01)/2) + 0.5)
     &     * (-CPDEL1)*CPFAC - 0.6*CH
      CALL PLCHAR(-4.0*CH,YLAB       ,1.20*CH,'C',0.0,1)
      CALL PLCHAR(-2.9*CH,YLAB-0.2*CH,0.90*CH,'p',0.0,1)
C
C---- plot ISES identifier
      CALL NEWPEN(1)
      CALL PLCHAR(    CHI,-CPMIN1*CPFAC-1.0*CHI,CHI,'MSES' ,0.0,4)
      CALL PLCHAR(    CHI,-CPMIN1*CPFAC-3.0*CHI,CHI,'v'    ,0.0,1)
      CALL PLNUMB(2.5*CHI,-CPMIN1*CPFAC-3.0*CHI,CHI,VERSION,0.0,1)
C
C      IF (NBL.GT.1) THEN
C        CALL PLCHAR(CHI,-CPMIN1*CPFAC+2.*CHI,CHI,'Element ',0.0,8)
C        CALL PLNUMB(999.,999.,CHI,FLOAT(NBP),0.0,-1)
C      ENDIF
C
      XOFF = MIN(XX(2,1),XX(2,2))
      XSF = 1.0/MAX( (XX(II-1,1)-XX(2,1)), (XX(II-1,2)-XX(2,2)) )
      XT0 = (0.0-XROT - XOFF)*XSF
      XT1 = (1.0-XROT - XOFF)*XSF
      AYOFF = (0.075 + CPMAX1*CPFAC)/XSF
C
      CALL NEWPEN(1)
      YXAX = 0.0
      CALL PLOT(0.0,YXAX,3)
      CALL PLOT(1.0,YXAX,2)
      DO 24 NT=0, 2
        XT = XT0 + (XT1-XT0)*FLOAT(NT)/2.0
        CALL PLOT(XT,YXAX-0.006,3)
        CALL PLOT(XT,YXAX+0.006,2)
   24 CONTINUE
      DO 25 NT=1, 9
        XT = XT0 + (XT1-XT0)*FLOAT(NT)/10.0
        CALL PLOT(XT,YXAX-0.003,3)
        CALL PLOT(XT,YXAX+0.003,2)
  25  CONTINUE
C
       DO 202 N=1, NBL
          ILE = ILEB(N)
          ITE = ITEB(N)
          J1 = JS1(N)
          J2 = JS2(N)
C
C-------- plot airfoil and displacement surfaces
          CALL NEWPEN(2)
          CALL AIRFPL(IIB(N),XB(1,N),YB(1,N),
     &                XPB(1,N),YPB(1,N),SB(1,N),XOFF,AYOFF,XSF,
     &                XROT,YROT,-ALFA)
          CALL NEWPEN(1)
          CALL AIRFOI(II,X(1,J1),Y(1,J1),XOFF,AYOFF,XSF,XROT,YROT,-ALFA)
          CALL AIRFOI(II,X(1,J2),Y(1,J2),XOFF,AYOFF,XSF,XROT,YROT,-ALFA)
  202  CONTINUE
       CALL NEWPEN(3)
       J1 = 1
       J2 = JJ
       CALL AIRFOI(II,X(1,J1),Y(1,J1),XOFF,AYOFF,XSF,XROT,YROT,-ALFA)
       CALL AIRFOI(II,X(1,J2),Y(1,J2),XOFF,AYOFF,XSF,XROT,YROT,-ALFA)
C
      CALL NEWPEN(2)
         IBEG = 1
         IEND = II
         IDIF = IEND - IBEG + 1
         CALL XYPLOT(IDIF,XX(IBEG,1),CX(IBEG,1),
     &               XOFF,XSF,0.0,-CPFAC,1,SH,KSYMB)
         CALL XYPLOT(IDIF,XX(IBEG,2),CX(IBEG,2),
     &               XOFF,XSF,0.0,-CPFAC,1,SH,KSYMB)
         IF(ISYMB.NE.0 .AND. ISYMB.GE.IBEG .AND. ISYMB.LE.IEND) THEN
          CALL PLSYMB((XX(ISYMB,1)-XOFF)*XSF ,
     &                -CX(ISYMB,1)      *CPFAC,SHS,0.0,0)
          CALL PLSYMB((XX(ISYMB,2)-XOFF)*XSF ,
     &                -CX(ISYMB,2)      *CPFAC,SHS,0.0,0)
         ENDIF
C
C---- plot reference data...
      IF(LREF) THEN
       NF = 0
       CALL GETREF(XF,PF,NF,NFX)
C
C----- check if distinction between elements has been made with a 999.0
       IF1 = 1
       ISYM = 1
       DO 206 IF=1, NF
         IF(XF(IF).EQ.999.0 .OR. IF.EQ.NF) THEN
          NFE = IF-IF1+1
          CALL XYPLOT(NFE,XF(IF1),PF(IF1),
     &                XOFF,XSF,0.0,-CPFAC,1,0.5*CH,ISYM)
          IF1 = IF + 1
          ISYM = ISYM + 1
         ENDIF
 206   CONTINUE
      ENDIF
C
C
      IF(LFORCE) CALL PLTFOR(-CPMIN1*CPFAC,0)
C
      CALL PLFLUSH
C
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ(*,1000) ANS
ccc      CALL PLEND
C
      GO TO 995
C
C===============================================
C**** Make Hardcopy
C
  110 IF(LPLOT) CALL PLEND
      LPLOT = .FALSE.
      CALL REPLOT(IDEVRP)
      GO TO 995
C
C===============================================
C**** Change settings
C
 120  CALL SPLSET
C
C
 140  CALL ANNOT(CH)
      GO TO 995
C
 150  WRITE(*,1505) II, JJ
 1505 FORMAT(/' Grid size: I J = ', 2I6
     &       /'                     ______top______   ____bottom_____'
     &       /' Element  iLE  iTE   iTran iCorn   j   iTran iCorn   j')
CCC                 1     22  124    123   123   16    123   123   16
      WRITE(*,1510) (N,ILEB(N),ITEB(N),
     &               ITRAN(IS1(N)),IGCORN(IS1(N))+ILEB(N)-1,JS1(N), 
     &               ITRAN(IS2(N)),IGCORN(IS2(N))+ILEB(N)-1,JS2(N),
     &               N=1, NBL )
 1510 FORMAT(8(1X,I5,2X,2I5, 2(I7,I6,I5) / ) )
C
 151  WRITE(*,1520) ISYMB
 1520 FORMAT(1X,'Enter i index for symbol',I6)
      CALL READI(1,ISYMB,ERROR)
      IF(ERROR) GO TO 151
      GO TO 995
C
      END ! OSTRPL
 
 
 
      SUBROUTINE PLTFOR(YTOP,N)
C-----------------------------------------------
C     Plots case name, flow conditions, forces
C-----------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      CHARACTER*32 LABEXP
C
C---- name, number character heights
      CHN = 1.1*CH
      CH2 = 0.9*CH
C
      CPFAC = 0.25
C
C---- x-location of left edge of plot block
      XLAB = 0.70
      IF(LFOREF) XLAB = 0.52
C
      IF(N.EQ.0) THEN
       CLTOT = LIFT/QU
       CDTOT = (DRAGW + DRAGV)/QU
       CMTOT = MOMN/QU
       ELOD = 0.0
       IF(CDTOT.NE.0.0) ELOD = CLTOT/CDTOT
      ELSE
       CLTOT = BLIFT(N)/QU
       CDTOT = BDRAGV(N)/QU
       CMTOT = BMOMN(N)/QU
       ELOD = 0.0
       IF(CDTOT.NE.0.0) ELOD = CLTOT/CDTOT
      ENDIF
C
      ADEG = ALFA * 180.0/3.1415926
      HSTAT = HINF / (1.0 + 0.5*GM1*MINF**2)
      MUINF = SQRT((HSTAT/HINF)**3) * (HINF+HVIS)/(HSTAT+HVIS)
      REINF = REYN * (2.0*QU/(QINF*MUINF))
C
      AINDEG = ATAN(SINL) * 180.0/3.1415926
      AOUDEG = ATAN(SOUT) * 180.0/3.1415926
C
C
C---- find index of last non-blank character in NAME array
      DO 10 LNB=32, 1, -1
        IF(NAME(LNB:LNB).NE.' ') GO TO 11
   10 CONTINUE
      LNB = 0
   11 CONTINUE
C
CCC      YLAB = YTOP - CH
      YLAB = YTOP
C
      IF(LNB.GT.0) THEN
       CALL NEWPEN(3)
       XNAME = XLAB + 0.08 - 0.45*CH*FLOAT(LNB)
       CALL PLCHAR(XNAME,YLAB,CHN,NAME,0.0,LNB)
       YLAB = YLAB - 0.2*CH2
      ENDIF
C
      CALL NEWPEN(2)
C
      YLAB = YLAB - 2.1*CH2
      CALL PLCHAR(XLAB,YLAB,CH2,'Mach = ',0.0,7)
      CALL PLNUMB(999.,999.,CH2, MINF    ,0.0,3)
C
      IF(REYN.NE.0.0) THEN
       YLAB = YLAB - 2.1*CH2
       CALL PLCHAR(XLAB,YLAB,CH2,'Re   = ',0.0,7)
       CALL PLNUMB(999.,999.,CH2, REINF*1.0E-6,0.0,3)
       CALL PLMATH(999.,YLAB+0.20*CH2,0.80*CH2,'#'  ,0.0,1)
       CALL PLCHAR(999.,YLAB         ,     CH2,'10' ,0.0,2)
       CALL PLMATH(999.,YLAB         ,1.20*CH2,  '6',0.0,1)
      ENDIF
C
      YLAB = YLAB - 2.1*CH2
      CALL PLCHAR(XLAB,YLAB,CH2,'Alfa = ',0.0,7)
      CALL PLNUMB(999.,999.,CH2, ADEG    ,0.0,3)
C
      YLAB = YLAB - 2.1*CH2
      CALL PLCHAR(XLAB,YLAB,CH2,'CL   = ',0.0,7)
      CALL PLNUMB(999.,999.,CH2, CLTOT   ,0.0,4)
C
      YLAB = YLAB - 2.1*CH2
      CALL PLCHAR(XLAB,YLAB,CH2,'CD   = ',0.0,7)
      CALL PLNUMB(999.,999.,CH2, CDTOT   ,0.0,5)
C
      YLAB = YLAB - 2.1*CH2
      CALL PLCHAR(XLAB,YLAB,CH2,'CM   = ',0.0,7)
      CALL PLNUMB(999.,999.,CH2, CMTOT   ,0.0,4)
C
      YLAB = YLAB - 2.1*CH2
      CALL PLCHAR(XLAB,YLAB,CH2,'L/D  = ',0.0,7)
      CALL PLNUMB(999.,999.,CH2, ELOD    ,0.0,2)
C
      IF(REYN.NE.0.0) THEN
       YLAB = YLAB - 2.1*CH2
       CALL PLCHAR(XLAB    ,YLAB,    CH2,'N    = ',0.0,7)
       CALL PLCHAR(XLAB+CH2,YLAB,0.8*CH2,'crit'   ,0.0,4)
       CALL PLCHAR(XLAB    ,YLAB,    CH2,'       ',0.0,7)
       CALL PLNUMB(999.,999.,CH2, ACRIT   ,0.0,2)
      ENDIF
C
      IF(.NOT.LFOREF) RETURN
C
      CALL NEWPEN(1)
      XLIN = XLAB + 16.0*CH2 + CH2
      DYLIN = (0.2 + 7.0*2.1)*CH2
      CALL PLOT(XLIN,YTOP+CH   ,3)
      CALL PLOT(XLIN,YTOP-DYLIN,2)
C
      CALL PLFLUSH
C
      WRITE(*,*) 'Enter experimental data label:'
      READ(*,1500) LABEXP
 1500 FORMAT(A)
C
C---- find index of last non-blank character in LABEXP array
      DO 20 LNB=32, 1, -1
        IF(LABEXP(LNB:LNB).NE.' ') GO TO 21
   20 CONTINUE
      LNB = 0
   21 CONTINUE
C
   30 WRITE(*,*) 'Enter experimental Mach, Re, Alpha, CL, CD, CM:'
      READ(*,*,ERR=30) AMEX, REEX, ALEX, CLEX, CDEX, CMEX
C
CCC      YLAB = YTOP - CH
      YLAB = YTOP
C
      XLAB = XLAB + 19.0*CH2
C
      CALL NEWPEN(2)
      CALL PLCHAR(XLAB,YLAB,CH,LABEXP,0.0,LNB)
      YLAB = YLAB - 0.2*CH2
C
      CALL NEWPEN(2)
C
      YLAB = YLAB - 2.1*CH2
      CALL PLNUMB(XLAB,YLAB,CH2,AMEX,0.0,3)
C
      IF(REEX.NE.0.0) THEN
       YLAB = YLAB - 2.1*CH2
       CALL PLNUMB(XLAB,YLAB,CH2,REEX*1.0E-6,0.0,3)
       CALL PLMATH(999.,YLAB+0.20*CH2,0.80*CH2,'#'  ,0.0,1)
       CALL PLCHAR(999.,YLAB         ,     CH2,'10' ,0.0,2)
       CALL PLMATH(999.,YLAB         ,1.20*CH2,  '6',0.0,1)
      ENDIF
C
      YLAB = YLAB - 2.1*CH2
      CALL PLNUMB(XLAB,YLAB,CH2,ALEX,0.0,3)
C
      YLAB = YLAB - 2.1*CH2
      CALL PLNUMB(XLAB,YLAB,CH2,CLEX,0.0,4)
C
      YLAB = YLAB - 2.1*CH2
      CALL PLNUMB(XLAB,YLAB,CH2,CDEX,0.0,5)
C
      YLAB = YLAB - 2.1*CH2
      CALL PLNUMB(XLAB,YLAB,CH2,CMEX,0.0,4)
C
      ELOD = CLEX/CDEX
      YLAB = YLAB - 2.1*CH2
      CALL PLNUMB(XLAB,YLAB,CH2,ELOD,0.0,2)
C
      RETURN
      END ! PLTFOR



      SUBROUTINE SPLSET
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      CHARACTER*1 ANS
      CHARACTER*20 CHLINE
      LOGICAL ERROR
C
 1000 FORMAT(A)
C
  120 CONTINUE
      IF    (KSYMB.EQ.0) THEN
        CHLINE = 'line'
      ELSEIF(KSYMB.GT.0) THEN
        CHLINE = 'symbols'
      ELSE
        CHLINE = 'symbols with line'
      ENDIF
      WRITE(*,1200) LPWAKE,LGRID,LREF,LFOREF,LFORCE,
     &              CPMIN,MAMAX,CHLINE,NAME
 1200 FORMAT(' ................................................'
     &     //'  W ake Cp, Mach plotting     ', L3
     &      /'  G rid overlay for BL plots  ', L3
     &      /'  D ata overlay for all plots ', L3
     &      /'  F orce data plotting        ', L3
     &      /'  P arameter plotting         ', L3
     &      /'  C p  minimum on Cp axis     ', F7.2
     &      /'  M ach maximum on M axis     ', F7.2
     &      /'  L ine plot style            ', A
     &      /'  N ame                       ', A )
C
  122 WRITE(*,1230)
 1230 FORMAT(/1X,'Change what ?  ',$)
      READ (*,1000) ANS
C
      IF    (ANS.EQ.'0' .OR. ANS.EQ.' ') THEN
       RETURN
C
      ELSEIF(INDEX('Ww',ANS).NE.0) THEN
       LPWAKE = .NOT.LPWAKE
C
      ELSEIF(INDEX('Gg',ANS).NE.0) THEN
       LGRID = .NOT.LGRID
C
      ELSEIF(INDEX('Dd',ANS).NE.0) THEN
       LREF = .NOT.LREF
C
      ELSEIF(INDEX('Ff',ANS).NE.0) THEN
       LFOREF = .NOT.LFOREF
C
      ELSEIF(INDEX('Pp',ANS).NE.0) THEN
       LFORCE = .NOT.LFORCE
C
ccc      ELSEIF(INDEX('Ww',ANS).NE.0) THEN
ccc       LAIRFF = .NOT.LAIRFF
C
      ELSEIF(INDEX('Cc',ANS).NE.0) THEN
 128   WRITE(*,*) 'Enter CPmin:', CPMIN
       CPMIN2 = CPMIN
       CALL READR(1,CPMIN2,ERROR)
       IF(ERROR) GO TO 128
       CPMIN = CPMIN2
       CPDEL = -0.5
       IF(CPMIN .LT. -4.01) CPDEL = -1.0
C
      ELSEIF(INDEX('Mm',ANS).NE.0) THEN
 129   WRITE(*,*) 'Enter MAmax:', MAMAX
       MAMAX2 = MAMAX
       CALL READR(1,MAMAX2,ERROR)
       IF(ERROR) GO TO 129
       MAMAX = MAMAX2
       MADEL = 0.2
C
      ELSEIF(INDEX('Ll',ANS).NE.0) THEN
       WRITE(*,*)
       WRITE(*,*) '  0  line'
       WRITE(*,*) ' +N  symbol N'
       WRITE(*,*) ' -N  symbol N with line'
       WRITE(*,*)
 140   WRITE(*,*) 'Enter plot style:', KSYMB
       CALL READI(1,KSYMB,ERROR)
       IF(ERROR) GO TO 140
C
      ELSEIF(INDEX('Nn',ANS).NE.0) THEN
       WRITE(*,*) 'Enter new name (32 characters max)'
       READ (*,1000) NAME
C
      ELSE
        WRITE(*,*) '*** Item not recognized ***'
      ENDIF
      GO TO 120
C
      END




      SUBROUTINE VLABEL(X0,Y0,CH,
     &                  NAME,
     &                  REINF,MINF,ACRIT,ALFA,
     &                  CL,CD,XTRT,XTRB,ICOL1,ICOL2,LVCONV)
      CHARACTER*(*) NAME
      REAL MINF
      LOGICAL LVCONV
C
      EXTERNAL PLCHAR
C
      ADEG = ALFA * 45.0/ATAN(1.0)
      CHN = 1.2*CH
C
      CALL GETCOLOR(ICOL0)
C
      X1 = X0
      X2 = X0 + 16.0*CH
      X3 = X0 + 30.0*CH
      X4 = X0 + 45.0*CH
C
      Y1 = Y0 + 1.5*CH
      Y2 = Y0 + 4.0*CH
      Y3 = Y0 + 6.8*CH
C
      CALL NEWPEN(3)
      CALL PLCHAR(X1,Y3,CHN,NAME,0.0,-1)
C
C
      CALL NEWPEN(2)
      CALL PLCHAR(X1       ,Y2,CH,'Ma = ',0.0,5)
      CALL PLNUMB(X1+5.0*CH,Y2,CH, MINF  ,0.0,4)
C
      CALL PLCHAR(X1        ,Y1        ,CH,'Re = '   ,0.0,5)
      NDIG = 3
      IF(REINF .GE. 9.9995E6) NDIG = 2
      IF(REINF .GE. 99.995E6) NDIG = 1
      IF(REINF .GE. 999.95E6) NDIG = 0
      CALL PLNUMB(X1+ 5.0*CH,Y1        ,CH, REINF*1.E-6,0.0,NDIG)
      CALL PLMATH(X1+10.1*CH,Y1+0.10*CH,0.80*CH,'#'  ,0.0,1)
      CALL PLCHAR(X1+10.9*CH,Y1        ,     CH,'10' ,0.0,2)
      CALL PLMATH(X1+12.9*CH,Y1        ,1.10*CH,  '6',0.0,1)
C
C
      CALL PLMATH(X2       ,Y2,1.2*CH,'a',0.0,1)
      CALL PLCHAR(X2       ,Y2,CH,'   = ',0.0,5)
      CALL PLNUMB(X2+5.0*CH,Y2,CH, ADEG  ,0.0,4)
      CALL PLMATH(999.0    ,Y2,CH,'"'    ,0.0,1)
C
      CALL PLCHAR(X2       ,Y1,CH,'N  = ',0.0,5)
      CALL PLSUBS(X2       ,Y1,CH,'cr'   ,0.0,2,PLCHAR)
      CALL PLNUMB(X2+5.0*CH,Y1,CH,ACRIT  ,0.0,2)
C
C
      CALL PLCHAR(X3       ,Y2,CH,'C  = ',0.0,5)
      CALL PLSUBS(X3       ,Y2,CH, 'L'   ,0.0,1,PLCHAR)
      CALL PLNUMB(X3+5.0*CH,Y2,CH, CL    ,0.0,4)
C
      CALL PLCHAR(X3       ,Y1,CH,'C  = ',0.0,5)
      CALL PLSUBS(X3       ,Y1,CH, 'D'   ,0.0,1,PLCHAR)
      CALL PLNUMB(X3+5.0*CH,Y1,CH, CD    ,0.0,5)
C
C
      CALL NEWCOLOR(ICOL1)
      CALL PLCHAR(X4       ,Y2,CH,'Top X  = ',0.0,9)
      CALL PLSUBS(X4+4.0*CH,Y2,CH,     'tr'  ,0.0,2,PLCHAR)
      CALL PLNUMB(X4+9.0*CH,Y2,CH, XTRT      ,0.0,4)
C
      CALL NEWCOLOR(ICOL2)
      CALL PLCHAR(X4       ,Y1,CH,'Bot X  = ',0.0,9)
      CALL PLSUBS(X4+4.0*CH,Y1,CH,     'tr'  ,0.0,2,PLCHAR)
      CALL PLNUMB(X4+9.0*CH,Y1,CH, XTRB      ,0.0,4)
C
C
cc      IF(.NOT.LVCONV) THEN
cc       CALL NEWCOLORNAME('red')
cc       XL = X1 + CHN*FLOAT(LEN(NAME)+1)
cc       CALL PLCHAR(XL,Y3,CHN,'* NOT CONVERGED *',0.0,17)
cc      ENDIF
C
      CALL NEWCOLOR(ICOL0)
C
      RETURN
      END

