
      PROGRAM UEWALL
C-----------------------------------------------------------
C     Writes out outer-streamline Ue(x) or Cp(x), typically
C     tunnel-wall speeds or pressures from mdat.xxx file.
C     Can be read into MPLOT in "Outer streamline plots" menu,
C     if the Mach, Re numbers are removed from the first line.
C
C     Use:
C
C      % uewall xxx
C
C     Output:  utop.xxx  ubot.xxx
C-----------------------------------------------------------
C
      INCLUDE 'STATE.INC'
      DIMENSION Q(IX), QS(IX), P(IX), PI(IX), PIDUM(IX)
C
      CHARACTER*80 ARGP1, FNAME
C
      CALL INPUT
C
C
C---- tunnel x,y reference coordinates  (x,y shifts for grid node locations)
      XREF = 0.25
      YREF = 0.0
C
C---- rotation applied to grid node locations
      COSA = COS(ALFA)
      SINA = SIN(ALFA)
ccc      COSA = 1.0
ccc      SINA = 0.0
C
C
      GM1 = GAM - 1.0
      REINF = REYN * RHOINF*QINF/MUINF
      QUE = 0.5*RHOINF*QINF**2
C
      CALL GETARG(1,ARGP1)
C
 1000 FORMAT(1X,2F10.6)
C
      DO 100 ISIDE=1, 2
C
      IF(ISIDE .EQ. 1) THEN
        FNAME = 'utop.' // ARGP1
        J = JJ
        CALL PICALC(J,Q,QS,P,PI,PIDUM )
      ELSE
        FNAME = 'ubot.' // ARGP1
        J = 1
        CALL PICALC(J,Q,QS,P,PIDUM,PI )
      ENDIF
C
C
      DPINF = PINF - PSTOUT
C
      OPEN(1,FILE=FNAME,STATUS='UNKNOWN')
      WRITE(1,*) MINF, REINF, '      !  Minf  REinf'
      S = 0.0
      DO 10 I=2, II-1
        DX = X(I,J) - X(I-1,J)
        DY = Y(I,J) - Y(I-1,J)
        DS = SQRT(DX**2 + DY**2)
        S = S + DS
C     
        PRAT = (PI(I)-PSTOUT)/PSTOUT
        UE = SQRT( 2.0*HINF*(1.0 - PRAT**(GM1/GAM)) ) / QINF
C
        CP = (PI(I) - DPINF)/QUE
C
C------ set tunnel x,y in freestream coordinates relative to XREF,YREF
        XBAR = (X(I,J)-XREF)*COSA + (Y(I,J)-YREF)*SINA
        YBAR = (Y(I,J)-YREF)*COSA - (X(I,J)-XREF)*SINA
C
C--------- Ue(s)/Uinf , intended as input for tunnel-wall BL calculation
ccc        IF(I.EQ.2) WRITE(1,1000) 0.0, UE
ccc        WRITE(1,1000) S, UE
C
C------ Cp(s) , intended for comparison with tunnel wall data
        WRITE(1,1000) XBAR, CP
C
 10   CONTINUE
      CLOSE(1)
C
 100  CONTINUE
C
      STOP
      END
      
