
      SUBROUTINE UPDATE(LRLX)
C----------------------------------------------------------
C     Adds on the Newton deltas for all the inviscid and
C     viscous variables, after checking for excessive
C     changes and under-relaxing if necessary.
C
C     If LRLX = F, then only the underrelaxation factor
C     (RLX) is determined, with no update being performed.
C     This option is only intended for checking forced
C     changes due to global DOFs.
C----------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      LOGICAL LRLX
      CHARACTER*1 VVAR, SVAR
C
C---- overlay temporary storage to save space
ccc      COMMON/WORK/ DX(IX,JX), DY(IX,JX)
      DIMENSION DX(IX,JX), DY(IX,JX)
C
      DATA DREPS / 1.0E-5 /
cccc      DATA DREPS / 1.0D-12 /
C
      RLXS = 1.0
      RLXR = 1.0
      RLXQ = 1.0
      RLXV = 1.0
      LSMOVE = .FALSE.
      SVAR = ' '
C
C---- calculate global variable system GLSYS and changes DGLOB
      CALL GLOBIT
C
C---- subtract off extra righthand sides of the global variables
C-    to get total local changes DR(. 0 .)
      DO 8 I=1, II
        DO 7 J=1, 2*JJ-1 + 6*NBL
          DR(J,0,I) = DR(J,1,I)
          DO 6 L=2, NRHS
            DR(J,0,I) = DR(J,0,I) - DGLOB(L-1)*DR(J,L,I)
   6      CONTINUE
   7    CONTINUE
   8  CONTINUE
C
C
C---- clamp DSBLE (LE movement) to  SBFAC  times the LE spacing
      SBFAC = 5.0
      DO 10 N = 1, NBL
        ILE = ILEB(N)
        J1 = JS1(N)
        J2 = JS2(N)
        DS1 = SQRT((X(ILE+1,J1)-X(ILE,J1))**2
     &           + (Y(ILE+1,J1)-Y(ILE,J1))**2)
        DS2 = SQRT((X(ILE+1,J2)-X(ILE,J2))**2
     &           + (Y(ILE+1,J2)-Y(ILE,J2))**2)
        DSBMAX = SBFAC * 0.5*(DS1+DS2)
        IF(RLXS*ABS(DSBLE(N)).GT.DSBMAX) RLXS = DSBMAX/ABS(DSBLE(N))
  10  CONTINUE
C
C---- find max and rms changes
      DNMAX = 0.
      DNRMS = 0.
      DRMAX = 0.
      DRRMS = 0.
      DVMAX = 0.
      DVRMS = 0.
      INMAX = 0
      JNMAX = 0
      IRMAX = 0
      JRMAX = 0
      IQMAX = 0
      JQMAX = 0
      VVAR = ' '
      IVMAX = 0
      ISMAX = 0
C
      NBJ = 2*JJ-1
C
C---- set large initial RLXV to ensure triggering max viscous change test
      RLXV = 1.0E12
C
      DO 20 I = 1, II
C
        DO 202 J = 1, JJ
          IF(ABS(DR(J,0,I)) .GT. ABS(DNMAX)) THEN
           DNMAX = DR(J,0,I)
           INMAX = I
           JNMAX = J
          ENDIF
          DNRMS = DNRMS + DR(J,0,I)**2
  202   CONTINUE
C
        IF(I.EQ.II) GO TO 20
C
C
        DO 204 J = 1, JJ-1
          IF(JSTAG(J).GT.0) GO TO 204
          RRAT = DR(J+JJ,0,I)/R(I,J)
          IF(RLXR*RRAT.GT.0.25) RLXR = 0.25/RRAT        !  clamp DR
          IF(RLXR*RRAT.LT.-.25) RLXR = -.25/RRAT
          IF(ABS(RRAT) .GT. ABS(DRMAX)) THEN
           DRMAX = RRAT
           IRMAX = I
           JRMAX = J
          ENDIF
          DRRMS = DRRMS + RRAT**2
 204    CONTINUE
C
C
        DHI = 1.7
        DLO = -.6
        ISTOT = 2*NBL
C
C----- Skip viscous update check for inviscid case
        IF(.NOT.LVISC) GO TO 20
C
         DO 206 IS=1, ISTOT
C
           N = (IS+1)/2
           ILE = ILEB(N)
           ITE = ITEB(N)
           IF(I.LE.ILE) GO TO 206
C
           IF(I.LT.ITRAN(IS)) THEN
            DCT = DR(NBJ-2+3*IS,0,I)/(5.0*ACRIT)
           ELSE
            DCT = DR(NBJ-2+3*IS,0,I)/(8.0*CTAU(I,IS))
           ENDIF
           DTH = DR(NBJ-1+3*IS,0,I)/THET(I,IS)
           DDS = DR(NBJ  +3*IS,0,I)/DSTR(I,IS)
C
           DVRMS = DVRMS  +  DCT**2 + DTH**2 + DDS**2
C
           IF(RLXV*DCT.GT.DHI .OR. RLXV*DCT.LT.DLO) THEN
            DVMAX = DCT
            IVMAX = I
            ISMAX = IS
            VVAR = 'C'
            IF(I.LT.ITRAN(IS)) VVAR = 'N'
           ENDIF
           IF(RLXV*DCT.GT.DHI) RLXV = DHI/DCT           !  clamp dDCTAU
           IF(RLXV*DCT.LT.DLO) RLXV = DLO/DCT
C
           IF(RLXV*DTH.GT.DHI .OR. RLXV*DTH.LT.DLO) THEN
            DVMAX = DTH
            IVMAX = I
            ISMAX = IS
            VVAR = 'T'
           ENDIF
           IF(RLXV*DTH.GT.DHI) RLXV = DHI/DTH           !  clamp dTHETA
           IF(RLXV*DTH.LT.DLO) RLXV = DLO/DTH
C
           IF(RLXV*DDS.GT.DHI .OR. RLXV*DDS.LT.DLO) THEN
            DVMAX = DDS
            IVMAX = I
            ISMAX = IS
            VVAR = 'D'
           ENDIF
           IF(RLXV*DDS.GT.DHI) RLXV = DHI/DDS           !  clamp dDSTAR
           IF(RLXV*DDS.LT.DLO) RLXV = DLO/DDS
C
C--------- don't do H clamp in wake
           IF(I.GT.ITE) GO TO 206
C
           SHAP = DSTR(I,IS)/THET(I,IS)
           HHI = 1.0 + 2.0*(1.0-1.0/SHAP)
           HLO = 1.0 - 0.6*(1.0-1.0/SHAP)
           HNEW = (1.0 + RLXV*DDS) / (1.0 + RLXV*DTH)
           IF(HNEW.GT.HHI .OR. HNEW.LT.HLO) THEN
            DVMAX = SHAP*(1.0 + DDS)/(1.0 + DTH) - SHAP
            IVMAX = I
            ISMAX = IS
            VVAR = 'H'
           ENDIF
           IF(HNEW.GT.HHI) RLXV = (HHI-1.0)/(DDS-HHI*DTH)   ! clamp dH
           IF(HNEW.LT.HLO) RLXV = (HLO-1.0)/(DDS-HLO*DTH)
C
  206    CONTINUE
C
   20 CONTINUE
C
      DRRMS = SQRT(DRRMS/FLOAT((II-1)*(JJ-1)))
      DNRMS = SQRT(DNRMS/FLOAT((II  )*(JJ  )))
C
      NVVAR = 0
      DO 22 N=1, NBL
        NVVAR = NVVAR + 6*(II-1-ILEB(N))
   22 CONTINUE
      DVRMS = SQRT(DVRMS/FLOAT(NVVAR))
C
C---- calculate viscous-Cd change from exit-plane d(theta)
      I = II-1
      DCDV = 0.
      DO 24 IS=1, ISTOT
        DCDV = DCDV + 2.0*DR(NBJ-1+3*IS,0,I)
 24   CONTINUE
C
C
CCC      SDA = SIN(DALFA)
CCC      CDA = COS(DALFA)
C
C---- set grid node x,y changes
      DO 30 J=1, JJ
        DO 305 I=1, II
          DX(I,J) = DR(J,0,I)*NX(I,J)
          DY(I,J) = DR(J,0,I)*NY(I,J)
          DO 3052 N = 1, NBL
            DX(I,J) = DX(I,J) + DSBLE(N)*NXG(I,J,N)
            DY(I,J) = DY(I,J) + DSBLE(N)*NYG(I,J,N)
 3052     CONTINUE
          DO 3054 N = 1, NPOSN
            K = KPOSN(N)
            DX(I,J) = DX(I,J) + DPOSN(K)*NXP(I,J,K)
            DY(I,J) = DY(I,J) + DPOSN(K)*NYP(I,J,K)
 3054     CONTINUE
CCC          XBAR = X(I,J) - XCENT
CCC          YBAR = Y(I,J) - YCENT
CCC          DX(I,J) = DX(I,J) + (XBAR*(CDA-1.0) - YBAR*SDA)
CCC          DY(I,J) = DY(I,J) + (YBAR*(CDA-1.0) + XBAR*SDA)
          DX(I,J) = DX(I,J) + DALFA*NXA(I,J)
          DY(I,J) = DY(I,J) + DALFA*NYA(I,J)
 305    CONTINUE
  30  CONTINUE
C
C
C---- set current overall underrelaxation factor
      RLX  = MIN( 1.0 , RLXS, RLXR , RLXV )
C
C---- check if Q needs to be clamped
      DO 400 ITQ=1, 32
C
C---- speed at vacuum
      QVAC = SQRT(2.0*HINF)
C
      RLXMIN = 1.0
      DO 40 J=1, JJ-1
        IF(JSTAG(J).GT.0) GO TO 40
C
C------ new streamtube mass flow
        MNEW = M(J) + RLX*(MF0(J)*DMASS)
        DO 402 N = 1, NBL
          MNEW = MNEW + RLX*(MF1(J,N)*DMAS1(N))
 402    CONTINUE
C
        DO 405 I=1, II-1
C
C-------- limits for new speed
          QMIN = 0.5* Q(I,J)
          QMAX = MIN( 0.5*(Q(I,J) + QVAC) , 2.0*Q(I,J) )
C
C-------- set new streamtube area
          XOO = X(I  ,J  ) + RLX*DX(I  ,J  )
          XPO = X(I+1,J  ) + RLX*DX(I+1,J  )
          XOP = X(I  ,J+1) + RLX*DX(I  ,J+1)
          XPP = X(I+1,J+1) + RLX*DX(I+1,J+1)
          YOO = Y(I  ,J  ) + RLX*DY(I  ,J  )
          YPO = Y(I+1,J  ) + RLX*DY(I+1,J  )
          YOP = Y(I  ,J+1) + RLX*DY(I  ,J+1)
          YPP = Y(I+1,J+1) + RLX*DY(I+1,J+1)
          DSX = 0.5*(XPP + XPO - XOP - XOO)
          DSY = 0.5*(YPP + YPO - YOP - YOO)
          DSS = SQRT(DSX**2 + DSY**2)
          ANEW = 0.5*(YPP+YOP - YPO-YOO) * DSX/DSS
     &         - 0.5*(XPP+XOP - XPO-XOO) * DSY/DSS
C
C-------- new density
          RNEW = R(I,J) + RLX*DR(J+JJ,0,I)
C
C-------- new speed
          QNEW = MNEW/(RNEW*ANEW)
C
          RLXNEW = 1.0
          IF(QNEW.GT.QMAX) RLXNEW = RLX * (QMAX-Q(I,J)) / (QNEW-Q(I,J))
          IF(QNEW.LT.QMIN) RLXNEW = RLX * (QMIN-Q(I,J)) / (QNEW-Q(I,J))
          IF(RLXNEW.LT.RLXMIN) THEN
           RLXMIN = RLXNEW
           IQMAX = I
           JQMAX = J
          ENDIF
  405   CONTINUE
   40 CONTINUE
C
C---- if Q clamping is unnecessary, go on
      IF(RLXMIN.GE.RLX) GO TO 42
C
C----- set new RLXQ to not less than half of current RLX
       RLXQ = MAX( RLXMIN , 0.5*RLX )
C
C----- set new overall under-relaxation factor and try it again
       RLX  = MIN( 1.0 , RLXS, RLXR , RLXV , RLXQ )
C
  400 CONTINUE
C
   42 CONTINUE
C
C
      RLXV = MIN( 1.0 , RLXV )
C
C---- exit if only the under-relaxation factor is needed
      IF(.NOT. LRLX) RETURN
C
C---- update density
      DO 50 I=1, II-1
        DO 505 J = 1, JJ-1
          R(I,J) = R(I,J) + RLX*DR(J+JJ,0,I)
 505    CONTINUE
 50   CONTINUE
C
C---- update grid
      DO 54 J=1, JJ
        DO 545 I=1, II
          X(I,J) = X(I,J) + RLX*DX(I,J)
          Y(I,J) = Y(I,J) + RLX*DY(I,J)
 545    CONTINUE
 54   CONTINUE
C
C
C---- update element-related variables
      DO 100 N = 1, NBL
       ILE = ILEB(N)
       ITE = ITEB(N)
       I1 = IS1(N)
       I2 = IS2(N)
       J1 = JS1(N)
       J2 = JS2(N)
C
       NBV = 2*JJ-1 + 6*(N-1)
C
C----- update displacement arrays
       DO 60 I=ILE+1, ITE
C
         IG = I - ILE + 1
C
C------- set displacement change for side 1
         DDISP = DR(J1,0,I)*(NX(I,J1)*BNX(I,I1) + NY(I,J1)*BNY(I,I1))
C
         IF(LMODI .OR. LMINV) THEN
C-------- subtract off modal wall movement 
          DO 601 NN=1, NMODN
            K = KMODN(NN)
            DDISP = DDISP - DMODN(K)*GN(K,IG,I1)
  601     CONTINUE
         ENDIF
C
C------- for mixed-inverse, displacement change is equal to d(Dstar)
         IF(LMIXI .AND. (I.GE.IX0 .AND. I.LE.IX1) .AND.
     &      NMIX.EQ.N .AND.
     &      (ISMOVE.EQ.1 .OR. ISMOVE.EQ.-1 .OR. ISMOVE.EQ.0)  )
     &    DDISP = DR(NBV+3,0,I) + DSTR(I,I1) - DISP(I,I1)
C
         DISP(I,I1) = DISP(I,I1) + RLX*DDISP
C
C
C------- set displacement change for side 2
         DDISP = DR(J2,0,I)*(NX(I,J2)*BNX(I,I2) + NY(I,J2)*BNY(I,I2))
C
c
c          if(i2.eq.2) then
c           write(*,6669) i,1000*dstr(i,i2),1000*disp(i,i2),
c     &                1000*dr(NBV+6,0,i),1000*dr(j2,0,i),1000*ddisp
c 6669      format(1x,i3,2f10.4,2x, 3f10.4)
c          endif
c
         IF(LMODI .OR. LMINV) THEN
C-------- subtract off modal wall movement 
          DO 602 NN=1, NMODN
            K = KMODN(NN)
            DDISP = DDISP - DMODN(K)*GN(K,IG,I2)
  602     CONTINUE
         ENDIF
C
C------- for mixed-inverse, displacement change is equal to d(Dstar)
         IF(LMIXI .AND. (I.GE.IX0 .AND. I.LE.IX1) .AND.
     &      NMIX.EQ.N .AND.
     &      (ISMOVE.EQ.2 .OR. ISMOVE.EQ.-1 .OR. ISMOVE.EQ.0)  )
     &    DDISP = DR(NBV+6,0,I) + DSTR(I,I2) - DISP(I,I2)
C
         DISP(I,I2) = DISP(I,I2) + RLX*DDISP
   60  CONTINUE
C
C
       ANTE = WGAP(ITE,N)
C
C----- set upper and lower wake displacement fractions at TE
       DISP1 = DISP(ITE,I1) + 0.5*ANTE
       DISP2 = DISP(ITE,I2) + 0.5*ANTE
       DSUM = DISP1 + DISP2
       IF(DSUM.EQ.0.0) THEN
        DFRAC1 = 0.5
        DFRAC2 = 0.5
       ELSE
        DFRAC1 = DISP1/DSUM
        DFRAC2 = DISP2/DSUM
       ENDIF
C

C----- update wake trajectory and displacement arrays
       DO 64 I=ITE+1, II
         IW = I-ITE+1
C
         DDS1 = RLX*DR(NBV+3,0,I)
         DDS2 = RLX*DR(NBV+6,0,I)
C
         DSUM = DSTR(I,I1) + DSTR(I,I2) + DDS1 + DDS2
         IF(DSUM.EQ.0.0) THEN
          DFRAC1 = 0.5
          DFRAC2 = 0.5
         ELSE
          DFRAC1 = (DSTR(I,I1)+DDS1)/DSUM
          DFRAC2 = (DSTR(I,I2)+DDS2)/DSUM
         ENDIF
C
C------- set unit vector for wake movement direction
ccc         XNW = -YPW(IW,N) / SQRT(XPW(IW,N)**2 + YPW(IW,N)**2)
ccc         YNW =  XPW(IW,N) / SQRT(XPW(IW,N)**2 + YPW(IW,N)**2)
         XNW = DFRAC2*NX(I,J1) + DFRAC1*NX(I,J2)
         YNW = DFRAC2*NY(I,J1) + DFRAC1*NY(I,J2)
         SNW = SQRT(XNW**2 + YNW**2)
         XNW = XNW/SNW
         YNW = YNW/SNW
C
         DOTW1 = XNW     *BNX(I,I1) + YNW     *BNY(I,I1)
         DOTW2 = XNW     *BNX(I,I2) + YNW     *BNY(I,I2)
C
         DOTB1 = NX(I,J1)*BNX(I,I1) + NY(I,J1)*BNY(I,I1)
         DOTB2 = NX(I,J2)*BNX(I,I2) + NY(I,J2)*BNY(I,I2)
C
C------- movement of wake trajectory point defined so that the upper
C-       and lower displacement fractions remain the same as Dstar
         DNW = ( (DISP(I,I2) + RLX*DR(J2,0,I)*DOTB2)*DFRAC1
     &          -(DISP(I,I1) + RLX*DR(J1,0,I)*DOTB1)*DFRAC2 )
     &       / ( DOTW2*DFRAC1 - DOTW1*DFRAC2 )
C
C------- wake movement contribution from element position DOFs and ALFA
         DXWPOS = 0.0
         DYWPOS = 0.0
         DO 642 NB=1, NPOSN
           K = KPOSN(NB)
           DXWPOS = DXWPOS
     &            + (DFRAC2*NXP(I,J1,K) + DFRAC1*NXP(I,J2,K))*DPOSN(K)
           DYWPOS = DYWPOS
     &            + (DFRAC2*NYP(I,J1,K) + DFRAC1*NYP(I,J2,K))*DPOSN(K)
 642     CONTINUE
         DXWPOS = DXWPOS + (DFRAC2*NXA(I,J1) + DFRAC1*NXA(I,J2))*DALFA
         DYWPOS = DYWPOS + (DFRAC2*NYA(I,J1) + DFRAC1*NYA(I,J2))*DALFA
C
         XW(IW,N) = XW(IW,N) + DNW*XNW + RLX*DXWPOS
         YW(IW,N) = YW(IW,N) + DNW*YNW + RLX*DYWPOS
C
C------- changes in displacements themselves
         DDISP1 = RLX*DR(J1,0,I)*DOTB1 - DNW*DOTW1
         DDISP2 = RLX*DR(J2,0,I)*DOTB2 - DNW*DOTW2
C
         DISP(I,I1) = DISP(I,I1) + DDISP1
         DISP(I,I2) = DISP(I,I2) + DDISP2
C
   64  CONTINUE
C
C
C----- update Ue arrays
       DO 65 IS=I1, I2
         IF(IS.EQ.I1) THEN
          JO = J1
          JP = J1+1
         ELSE
          JO = J2-1
          JP = J2
         ENDIF
C
         DO 655 I=ILE+1, II-1
C
C--------- set inviscid Ue Newton change using saved sensitivities
C
           DTH = DR(2*JJ-2+3*IS,0,I)
           DDS = DR(2*JJ-1+3*IS,0,I)
C
           DUI = DUIDMS(I,IS)*DMASS
     &         + DUIDR1(I,IS)*DR(JO+JJ,0,I-1)
     &         + DUIDR2(I,IS)*DR(JO+JJ,0,I  )
     &         + DUIN1M(I,IS)*DR(JO,0,I-1) + DUIN1P(I,IS)*DR(JP,0,I-1)
     &         + DUIN2M(I,IS)*DR(JO,0,I  ) + DUIN2P(I,IS)*DR(JP,0,I  )
     &         + DUIN3M(I,IS)*DR(JO,0,I+1) + DUIN3P(I,IS)*DR(JP,0,I+1)
           DRH = DRHDMS(I,IS)*DMASS
     &         + DRHDR1(I,IS)*DR(JO+JJ,0,I-1)
     &         + DRHDR2(I,IS)*DR(JO+JJ,0,I  )
     &         + DRHN1M(I,IS)*DR(JO,0,I-1) + DRHN1P(I,IS)*DR(JP,0,I-1)
     &         + DRHN2M(I,IS)*DR(JO,0,I  ) + DRHN2P(I,IS)*DR(JP,0,I  )
     &         + DRHN3M(I,IS)*DR(JO,0,I+1) + DRHN3P(I,IS)*DR(JP,0,I+1)
           DUN = DUNDMS(I,IS)*DMASS
     &         + DUNDR1(I,IS)*DR(JO+JJ,0,I-1)
     &         + DUNDR2(I,IS)*DR(JO+JJ,0,I  )
     &         + DUNN1M(I,IS)*DR(JO,0,I-1) + DUNN1P(I,IS)*DR(JP,0,I-1)
     &         + DUNN2M(I,IS)*DR(JO,0,I  ) + DUNN2P(I,IS)*DR(JP,0,I  )
     &         + DUNN3M(I,IS)*DR(JO,0,I+1) + DUNN3P(I,IS)*DR(JP,0,I+1)
           DO 6551 NB = 1, NBL
             DUI = DUI + DUIDNG(I,IS,NB)*DSBLE(NB)
     &                 + DUIDM1(I,IS,NB)*DMAS1(NB)
             DRH = DRH + DRHDNG(I,IS,NB)*DSBLE(NB)
     &                 + DRHDM1(I,IS,NB)*DMAS1(NB)
             DUN = DUN + DUNDNG(I,IS,NB)*DSBLE(NB)
     &                 + DUNDM1(I,IS,NB)*DMAS1(NB)
 6551      CONTINUE
           DO 6552 NB = 1, NPOSN
             K = KPOSN(NB)
             DUI = DUI + DUIDNP(I,IS,K)*DPOSN(K)
             DRH = DRH + DRHDNP(I,IS,K)*DPOSN(K)
             DUN = DUN + DUNDNP(I,IS,K)*DPOSN(K)
 6552      CONTINUE
           DUI = DUI + DUIDAL(I,IS)*DALFA
           DRH = DRH + DRHDAL(I,IS)*DALFA
           DUN = DUN + DUNDAL(I,IS)*DALFA
C
C--------- update inviscid and viscous Ue with clamp
           CALL UEF(UINV(I,IS)+DUI, DUDN(I,IS)+DUN,
     &              THET(I,IS)+DTH, DSTR(I,IS)+DDS,
     &              WXUT, WXUD,
     &              UENEW, UE_UI, UE_UN, UE_TH, UE_DS)
           DUE = UENEW - UEDG(I,IS)
C
           UINV(I,IS) = UINV(I,IS) + RLX*DUI
           RHOI(I,IS) = RHOI(I,IS) + RLX*DRH
           DUDN(I,IS) = DUDN(I,IS) + RLX*DUN
C
           RLXU = RLX
           IF(RLXU*DUE .LT. -0.8*UEDG(I,IS)) RLXU = -0.8*UEDG(I,IS)/DUE
           IF(RLXU*DUE .GT.  4.0*UEDG(I,IS)) RLXU =  4.0*UEDG(I,IS)/DUE
           UEDG(I,IS) = UEDG(I,IS) + RLXU*DUE
C
  655    CONTINUE
   65  CONTINUE
C
C
       IF(LVISC) THEN
C
C------- update BL parameters
         DO 67 I=ILE+1, II-1
           CTAU(I,I1) = CTAU(I,I1) + RLX*DR(NBV+1,0,I)
           CTAU(I,I2) = CTAU(I,I2) + RLX*DR(NBV+4,0,I)
           THET(I,I1) = THET(I,I1) + RLX*DR(NBV+2,0,I)
           THET(I,I2) = THET(I,I2) + RLX*DR(NBV+5,0,I)
           DSTR(I,I1) = DSTR(I,I1) + RLX*DR(NBV+3,0,I)
           DSTR(I,I2) = DSTR(I,I2) + RLX*DR(NBV+6,0,I)
C
C--------- limit Ctau, since it wasn't fully clamped 
           IF(I.GE.ITRAN(I1)) THEN
             CTAU(I,I1) = MIN( CTAU(I,I1) , 0.30   )
             CTAU(I,I1) = MAX( CTAU(I,I1) , 0.0001 )
           ENDIF
           IF(I.GE.ITRAN(I2)) THEN
             CTAU(I,I2) = MIN( CTAU(I,I2) , 0.30   )
             CTAU(I,I2) = MAX( CTAU(I,I2) , 0.0001 )
           ENDIF
C
C--------- limit wall Dstar to keep Hk > 1
           IF(I.LE.ITE) THEN
             HKLIM = 1.05
C
             MSQ = UEDG(I,I1)**2 / ((GAM-1.0)*(HINF-0.5*UEDG(I,I1)**2))
             CALL DSLIM(DSTR(I,I1),THET(I,I1),UEDG(I,I1),MSQ,GAM,HKLIM)
C
             MSQ = UEDG(I,I2)**2 / ((GAM-1.0)*(HINF-0.5*UEDG(I,I2)**2))
             CALL DSLIM(DSTR(I,I2),THET(I,I2),UEDG(I,I2),MSQ,GAM,HKLIM)
           ENDIF
C
C--------- MD 25 Aug 00
           IF(I.GT.ITE) THEN
            DS1LIM = 1.00001*THET(I,I1) + 0.5*WGAP(I,N)
            DS2LIM = 1.00001*THET(I,I2) + 0.5*WGAP(I,N)
            DSTR(I,I1) = MAX( DSTR(I,I1) , DS1LIM )
            DSTR(I,I2) = MAX( DSTR(I,I2) , DS2LIM )
           ENDIF
C
 67      CONTINUE
C
         DSTR(II,I1) = DSTR(II-1,I1)
         DSTR(II,I2) = DSTR(II-1,I2)
C
C------- smooth gross viscous variable transients
         DO 68 IS=I1, I2
           IF(RLX.GT.0.02 .OR. IS.NE.ISMAX) GO TO 68
C
           IF(VVAR.EQ.'D' .OR. VVAR.EQ.'T') THEN
            IF(IVMAX.LE.ITE) THEN
             CALL FILTER(DSTR(ILE+1,IS),1.0,(ITE-ILE))
             CALL FILTER(THET(ILE+1,IS),1.0,(ITE-ILE))
             DO 685 I=ILE+1, ITE
               MSQ = UEDG(I,IS)**2
     &             / ((GAM-1.0)*(HINF-0.5*UEDG(I,IS)**2))
               THET(I,IS) = MAX( THET(I,IS) , 1.0E-7*SBLE(N) )
               CALL DSLIM(DSTR(I,IS),THET(I,IS),UEDG(I,IS),MSQ,GAM,1.15)
 685         CONTINUE
            ELSE
             CALL FILTER(DSTR(ITE+1,IS),1.0,(II-ITE-1))
             CALL FILTER(THET(ITE+1,IS),1.0,(II-ITE-1))
             DO 688 I=ITE+1, II-1
               MSQ = UEDG(I,IS)**2
     &             / ((GAM-1.0)*(HINF-0.5*UEDG(I,IS)**2))
               THET(I,IS) = MAX( THET(I,IS) , 1.0E-7*SBLE(N) )
             CALL DSLIM(DSTR(I,IS),THET(I,IS),UEDG(I,IS),MSQ,GAM,1.0005)
  688        CONTINUE
            ENDIF
           ENDIF
   68    CONTINUE
C
       ENDIF
C
 100  CONTINUE    ! with next element
C
C
C---- set and spline new element geometry if inverse case
      IF(LMIXI .OR. LMINV .OR. LMODI) CALL NEWBLD
C
C---- re-position element(s) if translation/rotation case
      IF(LPOSI) CALL NEWPOS
C
C---- spline new inlet streamline and wake trajectories
      DO 105 N=1, NBL
        CALL SPWAKE(N)
 105  CONTINUE
C
C---- fix up any kinked wakes
      CALL WAKFIX
C
C---- fix up any displacement-surface streamlines
      CALL STRFIX
C
C---- adjust stagnation streamline nodes to match SGINL and SGOUT arrays
      CALL STGSET
C
C---- update global variables
      SINL = SINL + RLX*DSINL
      SOUT = SOUT + RLX*DSOUT
      CIRC = CIRC + RLX*DCIRC
      ALFA = ALFA + RLX*DALFA
      PDF0 = PDF0 + RLX*DPDF0
      PDF1 = PDF1 + RLX*DPDF1
      PDFL = PDFL + RLX*DPDFL
      PDX0 = PDX0 + RLX*DPDX0
      PDX1 = PDX1 + RLX*DPDX1
      PDD0 = PDD0 + RLX*DPDD0
      PDD1 = PDD1 + RLX*DPDD1
      REYN = REYN + RLX*DREYN
      PREX = PREX + RLX*DPREX
C
C**** Note:  SBLE's are now updated along with surface points in NEWDIS
c
ccc      DO 110 N = 1, NBL
ccc        SBLE(N) = SBLE(N) + RLX*DSBLE(N)
ccc  110 CONTINUE
C
C---- accumulate mode changes
      DO 111 N=1, NMODN
        K = KMODN(N)
        MODN(K) = MODN(K) + RLX*DMODN(K)
  111 CONTINUE
      DO 112 N=1, NPOSN
        K = KPOSN(N)
        POSN(K) = POSN(K) + RLX*DPOSN(K)
  112 CONTINUE
C
C
C---- decrement specified mode changes by current Newton deltas
      DO 121 N=1, NMODN
        K = KMODN(N)
        DMSPN(K) = DMSPN(K) - RLX*DMODN(K)
  121 CONTINUE
      DO 122 N=1, NPOSN
        K = KPOSN(N)
        DPSPN(K) = DPSPN(K) - RLX*DPOSN(K)
  122 CONTINUE
C
C
C---- update mass array
      MASS = 0.
      DO 135 J=1, JJ-1
        IF(JSTAG(J).GT.0) GO TO 135
        M(J) = M(J) + RLX*(MF0(J)*DMASS) 
        DO 1355 N = 1, NBL
          M(J) = M(J) + RLX*(MF1(J,N)*DMAS1(N))
 1355   CONTINUE
        MASS = MASS + M(J)
  135 CONTINUE
C
C---- normalize mass fraction array and set new mass vector
      DO 136 J=1, JJ-1
        MFRACT(J) = M(J)/MASS
  136 CONTINUE
C
C---- set new freestream mass flux ^2
      MOA = (MASS/AINF)**2
C
C---- initial guess for density ratio  Rho/Rhostag  using old Mach
      RB = (1.0 + 0.5*GM1*MINF**2)**(-1.0/GM1)
C
C---- Newton loop for exact new RB consistent with new mass flux
      HCON = 2.0*HINF*RSTOUT**2
      DO 138 IDUM=1, 20
        RG = RB**GAM
        RES = HCON*RB*(RB - RG) - MOA
        DELR = -RES / (HCON*(2.0*RB - GP1*RG))
        RB = RB + DELR
        IF(ABS(DELR).LT.DREPS) GO TO 140
  138 CONTINUE
      WRITE(*,*)
     &  'UPDATE: New freestream Mach iteration failed.  dR =', DELR
C
C---- set new freestream Mach and delta
  140 CONTINUE
      MOLD = MINF
      MINF = SQRT( 2.0/GM1 * (RB**(-GM1) - 1.0) )
      DMINF = MINF - MOLD
C
C---- set new freestream static conditions
      CALL FFCALC
C
C---- explicitly update Reynolds number if it's not a global DOF
      IF(LREYN.EQ.0) REYN = REYNIN/(RHOINF*QINF/MUINF)
C
C---- update SBLE's and displace stagnation streamlines
      CALL NEWDIS
C
      IF(RLXR .LT. 0.01) THEN
C----- very large density change occurred (most certainly from a shock)...
C-      smooth density over about 3 cells to speed up the shock
       SMLEN = 3.0
       DO 150 J=1, JJ-1
         IF(JSTAG(J).GT.0) GO TO 150
         CALL FILTER(R(1,J),SMLEN,II-1)
  150  CONTINUE
      ENDIF
C
C---- test for kinked grid
      CALL CHKINK(MAXDP)
C
C---- set SMOVE flag if necessary
      DO 160 N = 1, NBL
        ILE = ILEB(N)
        ITE = ITEB(N)
        J1 = JS1(N)
        J2 = JS2(N)
        DSLE = 0.50 * SQRT((X(ILE+1,J1)-X(ILE+1,J2))**2
     &                   + (Y(ILE+1,J1)-Y(ILE+1,J2))**2)
        IF(ABS(SBLE(N)-SBLOLD(N)) .GT. DSLE) THEN
         LSMOVE = .TRUE.
         SVAR = 'S'
        ENDIF
        IF(MAXDP .GT. -0.5) THEN
         LSMOVE = .TRUE.
         SVAR = 'G'
        ENDIF
 160  CONTINUE
C
      IF(LSMOVE) THEN
C----- save LE positions for next SMOVE test
       DO 165 N=1, NBL
         SBLOLD(N) = SBLE(N)
 165   CONTINUE
C
C----- SMOVE request was issued by one of the DISP/wake update routines
       IF(SVAR.EQ.' ') SVAR = 'D'
      ENDIF
C
      DRRAT = 0.
      IF(REYN.GT.0.0) DRRAT = DREYN/REYN
C
      IF(RLX .LT.1.0) WRITE(*,*)
      IF(RLXR.LT.1.0) WRITE(*,1200) RLXR
      IF(RLXS.LT.1.0) WRITE(*,1203) RLXS
      IF(RLXQ.LT.1.0) WRITE(*,1205) RLXQ,IQMAX,JQMAX
      IF(RLXV.LT.1.0) WRITE(*,1210) RLXV, VVAR,IVMAX,ISMAX
      WRITE(*,1230) ICOUNT, SVAR, DRRMS, DRMAX, IRMAX, JRMAX
      WRITE(*,1240)               DNRMS, DNMAX, INMAX, JNMAX
      IF(LVISC) WRITE(*,1250)     DVRMS, VVAR,  DVMAX, IVMAX, ISMAX
      DO 180 N = 1, NBL
        IF(LSBLE(N).GT.0) WRITE(*,1260) N,DSBLE(N)
  180 CONTINUE
      IF(LMAS1(NBL).EQ.0) THEN
       IF(.NOT.LVISC) WRITE(*,1262) DCIRC, DALFA*180.0/PIE
       IF(     LVISC) WRITE(*,1263) DCIRC, DALFA*180.0/PIE, DCDV
      ENDIF
      IF(LMAS1(NBL).NE.0) THEN
       DM1TOT = DMAS1(1)
       DO 182 N=2, NBL
         DM1TOT = DM1TOT + DMAS1(N)
 182   CONTINUE
       WRITE(*,1264) DM1TOT/MASS, DALFA*180.0/PIE
      ENDIF
      IF((LMASS.GT.0 .OR. LREYN.GT.0)) 
     &          WRITE(*,1268) DMASS/MASS,DMINF,DRRAT
      IF(LMIXI) WRITE(*,1280) DPDX0, DPDX1
      IF(LMIXI) WRITE(*,1290) DPDD0, DPDD1
      IF(LMODI .OR. LMINV)
     & WRITE(*,1295) (DMODN(KMODN(N)),N=1, NMODN)
      IF(LPOSI)
     & WRITE(*,1297) (DPOSN(KPOSN(N)),N=1, NPOSN)
 1200 FORMAT(1X,'RLXR:',F9.6)
 1203 FORMAT(1X,'RLXS:',F9.6)
 1205 FORMAT(1X,'RLXQ:',F9.6,4X,  'Q clamped at ',2I4)
 1210 FORMAT(1X,'RLXV:',F9.6,4X,A1,' clamped at I = ',I3,', side ',I3)
 1230 FORMAT(/
     &  1X,I4,1X,A,' rms(dR): ',E9.3,'  Max(dR): ',E9.3,'  at ',2I4)
 1240 FORMAT(1X,6X,' rms(dn): ',E9.3,'  Max(dn): ',E9.3,'  at ',2I4)
 1250 FORMAT(1X,6X,' rms(dV): ',E9.3,'  Max(d', A1, 
     &                                       '): ',E9.3,'  at ',2I4)
 1260 FORMAT(8X,'Element: ',I4,5X,'  (ds)LE : ',E9.3)
 1261 FORMAT(8X,'dSinl  : ',E9.3,'  dSout  : ',E9.3)
 1262 FORMAT(8X,'dGamma : ',E9.3,'  dAlpha : ',E9.3)
 1263 FORMAT(8X,'dGamma : ',E9.3,'  dAlpha : ',E9.3,'  dCDv:',F10.6)
 1264 FORMAT(8X,'dmfr/m : ',E9.3,'  dAlpha : ',E9.3)
 1268 FORMAT(8X,'dmass/m: ',E9.3,'  dMinf  : ',E9.3,' dReyn/R: ',E9.3)
 1280 FORMAT(8X,'dDOF0  : ',E9.3,'  dDOF1  : ',E9.3)
 1290 FORMAT(8X,'dDOFD0 : ',E9.3,'  dDOFD1 : ',E9.3)
 1295 FORMAT(8X,'dDMOD  : ',20(5E11.3 / 17X) )
 1297 FORMAT(8X,'dDPOS  : ',20(5E11.3 / 17X) )
C
C---- set actual max density change for SETUP's viscosity augmenting
      DRMAX = RLXR*DRMAX
C
      RETURN
      END ! UPDATE



      SUBROUTINE CHKINK(MAXDP)
C.......................................
C     Returns maximum dot-product
C     of two adjacent grid segments
C     as a measure of grid distortion.
C.......................................
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
CCC   MAXCP = 0.
      MAXDP = -1.0
C
      DO 10 JO=2, JJ-1
        IF(JSTAG(JO).NE.0) GO TO 10
        JP = JO+1
        JM = JO-1
        DO 110 IO=2, II-1
          IP = IO+1
          IM = IO-1
C
          DXIM = X(IO,JO) - X(IM,JO)
          DYIM = Y(IO,JO) - Y(IM,JO)
          DXIP = X(IO,JO) - X(IP,JO)
          DYIP = Y(IO,JO) - Y(IP,JO)
          DSIM = SQRT(DXIM**2 + DYIM**2)
          DSIP = SQRT(DXIP**2 + DYIP**2)
CCC       CPI = (DXIM*DYIP - DYIM*DXIP)/(DSIM*DSIP)
          DPI = (DXIM*DXIP + DYIM*DYIP)/(DSIM*DSIP)
C
          DXJM = X(IO,JO) - X(IO,JM)
          DYJM = Y(IO,JO) - Y(IO,JM)
          DXJP = X(IO,JO) - X(IO,JP)
          DYJP = Y(IO,JO) - Y(IO,JP)
          DSJM = SQRT(DXJM**2 + DYJM**2)
          DSJP = SQRT(DXJP**2 + DYJP**2)
CCC       CPJ = (DXJM*DYJP - DYJM*DXJP)/(DSJM*DSJP)
          DPJ = (DXJM*DXJP + DYJM*DYJP)/(DSJM*DSJP)
C
CCC       MAXCP = MAX( MAXCP , CPI , CPJ )
          MAXDP = MAX( MAXDP , DPI , DPJ )
  110   CONTINUE
   10 CONTINUE
C
      RETURN
      END ! CHKINK


      SUBROUTINE STGSET
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      LOGICAL OK
C
C---- overlay temporary storage to save space
ccc      COMMON/WORK/ XU(IX),XPU(IX),
ccc     &             YU(IX),YPU(IX),
ccc     &             SU(IX)
      DIMENSION XU(IX),XPU(IX),
     &          YU(IX),YPU(IX),
     &          SU(IX)
C
      DO 1000 N = 1, NBL
        ILE = ILEB(N)
        ITE = ITEB(N)
        J1 = JS1(N)
        J2 = JS2(N)
C
        DO 10 IG=1, NINL(N)
          I = IG
          XU(IG) = 0.5*(X(I,J1) + X(I,J2))
          YU(IG) = 0.5*(Y(I,J1) + Y(I,J2))
 10     CONTINUE
C
C------ calculate inlet streamline arc length and spline trajectory
        SU(1) = 0.
        DO 12 IG=2, NINL(N)
          SU(IG) = SU(IG-1)
     &             + SQRT(  (XU(IG)-XU(IG-1))**2
     &                    + (YU(IG)-YU(IG-1))**2 )
 12     CONTINUE
C
        CALL SPLINE(XU,XPU,SU,NINL(N))
        CALL SPLINE(YU,YPU,SU,NINL(N))
C
        SLEN = SU(NINL(N))
C
C------ set new grid points to match inlet spacing array SGINL
        DO 15 IG=1, NINL(N)-1
          I = IG
C
          SNEW = SLEN*SGINL(IG,N)
          XNEW = SEVAL(SNEW,XU,XPU,SU,NINL(N))
          YNEW = SEVAL(SNEW,YU,YPU,SU,NINL(N))
C
          X(I,J1) = XNEW
          Y(I,J1) = YNEW
          X(I,J2) = XNEW
          Y(I,J2) = YNEW
 15     CONTINUE
C
C
C------ locate intersections of wake N with all slide lines
        IS = IS1(N)
C
        DO 20 K=2, KBNFIX(IS)-1
          I = IBNFIX(K,IS)
          IG = I - ITEB(N) + 1
          IF(IG.LE.1) GO TO 20
C
C-------- find element index whose TE originates current slide line
          DO 202 NN=1, NBL
            IF(I.EQ.ITEB(NN)) GO TO 203
 202      CONTINUE
          WRITE(*,*) 'STGSET: TE not located. i = ', IBNFIX(K,IS)
          NN = 1
 203      CONTINUE
C
          IF(NN.GT.N) THEN
           KS = 2*NN - 1
          ELSE
           KS = 2*NN
          ENDIF
C
C-------- sign of displacement relative to slide-line arc length
          DSGN = 1.0
          IF(MOD(IS,2) .NE. MOD(KS,2)) DSGN = -1.0
C
C-------- set first intersection location guess
          KN = IABS(NN-N) + 1
          KN = MAX(KN,1)
          KN = MIN(KN,KNOR(KS))
          IG = I - ITEB(N) + 1
          SNI = SNOR(KN,KS)
          SU(IG) = SW(IG,N)
C
C-------- calculate actual intersection location
          CALL INTERS(OK,SNI,SU(IG),
     &       XNOR(1,KS),XSNOR(1,KS),
     &       YNOR(1,KS),YSNOR(1,KS),SNOR(1,KS),KNOR(KS),
     &       XW(1,N),XPW(1,N),
     &       YW(1,N),YPW(1,N),SW(1,N),NOUT(N) )
C
          IF(.NOT.OK) WRITE(*,*) 'n ite i:', N, ITEB(N), I
 20     CONTINUE
C
        SU(1)       = SW(1      ,N)
        SU(NOUT(N)) = SW(NOUT(N),N)
C
        DO 30 K=2, KBNFIX(IS)-1
          IG1 = IBNFIX(K  ,IS) - ITEB(N) + 1
          IG2 = IBNFIX(K+1,IS) - ITEB(N) + 1
          IF(IG1.LT.1) GO TO 30
C
          SW1 = SU(IG1)
          SW2 = SU(IG2)
C
          SWRAT = (SW2-SW1) / (SGOUT(IG2,N)-SGOUT(IG1,N))
          DO 302 IG=IG1, IG2
            SU(IG) = SW1 + (SGOUT(IG,N)-SGOUT(IG1,N))*SWRAT
            XU(IG) = SEVAL(SU(IG),XW(1,N),XPW(1,N),SW(1,N),NOUT(N))
            YU(IG) = SEVAL(SU(IG),YW(1,N),YPW(1,N),SW(1,N),NOUT(N))
 302      CONTINUE
 30     CONTINUE
C
C------ set total mass flow fraction in streamtubes above and below element
        MFPTOT = 0.0
        DO 40 J=JS1(N), JJ-1
          IF(JSTAG(J) .GT. 0) GO TO 41
           MFPTOT = MFPTOT + MFRACT(J)
 40     CONTINUE
 41     CONTINUE
C
        MFMTOT = 0.0
        DO 44 J=JS2(N), 2, -1
          IF(JSTAG(J-1) .LT. 0) GO TO 45
           MFMTOT = MFMTOT + MFRACT(J-1)
 44     CONTINUE
 45     CONTINUE
C
C------ set new fractional spacing array SGOUT and new wake coordinates
        SW1 = SU(1)
        SW2 = SU(NOUT(N))
        DO 50 IG=1, NOUT(N)
          SGOUT(IG,N) = (SU(IG)-SU(1))/(SU(NOUT(N))-SU(1))
          DXW = XU(IG) - XW(IG,N)
          DYW = YU(IG) - YW(IG,N)
C
          XW(IG,N) = XU(IG)
          YW(IG,N) = YU(IG)
C
          I = IG + ITEB(N) - 1
C
C======== move grid along with wake centerline movement DXW, DYW ...
C
C-------- move grid above wake, dropping off linearly towards next element
          MFP = 0.0
          DO 502 J=JS1(N), JJ-1
            IF(JSTAG(J) .GT. 0) GO TO 503
             X(I,J) = X(I,J) + DXW*(1.0 - MFP/MFPTOT)
             Y(I,J) = Y(I,J) + DYW*(1.0 - MFP/MFPTOT)
             MFP = MFP + MFRACT(J)
 502      CONTINUE
 503      CONTINUE
C
C-------- move grid below wake, dropping off linearly towards next element
          MFM = 0.0
          DO 504 J=JS2(N), 2, -1
            IF(JSTAG(J) .LT. 0) GO TO 505
             X(I,J) = X(I,J) + DXW*(1.0 - MFM/MFMTOT)
             Y(I,J) = Y(I,J) + DYW*(1.0 - MFM/MFMTOT)
             MFM = MFM + MFRACT(J-1)
 504      CONTINUE
 505      CONTINUE
C
 50     CONTINUE
C
C------ respline wake trajectory XW, YW
        CALL SPWAKE(N)
C
C------ reset SGOUT spacing arrays to match SW arrays exactly
        DO 60 IG=1, NOUT(N)
          SGOUT(IG,N) = (SW(IG     ,N)-SW(1,N))
     &                / (SW(NOUT(N),N)-SW(1,N))
 60     CONTINUE
C
 1000 CONTINUE
C
      RETURN
      END ! STGSET


      SUBROUTINE WAKFIX
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C---------------------------------------
C     Checks wake arrays for kinking
C---------------------------------------
      LOGICAL LOK(NBX)
C
C---- overlay temporary storage to save space
ccc      COMMON/WORK/ XNI(IX), YNI(IX), DSN(IX)
      DIMENSION XNI(IX), YNI(IX), DSN(IX)
C
      DATA CRSLIM / 0.5 /
C
C---- first assume all wakes are bad
      DO 1 N=1, NBL
        LOK(N) = .FALSE.
 1    CONTINUE
C
C---- do several passes to fix up wakes
      DO 1000 IPASS=1, 3
C
C---- go over wakes, skipping any which are OK
      DO 2 N=1, NBL
        IF(LOK(N)) GO TO 2
C
        ITE = ITEB(N)
C
C------ calculate max cross-product between wake segments
        CRSMAX = 0.0
        DO 22 IG=2, NOUT(N)-1
          IGP = IG+1
          IGM = IG-1
C
          DXM = XW(IG,N) - XW(IGM,N)
          DYM = YW(IG,N) - YW(IGM,N)
          DXP = XW(IG,N) - XW(IGP,N)
          DYP = YW(IG,N) - YW(IGP,N)
          DSM = SQRT(DXM**2 + DYM**2)
          DSP = SQRT(DXP**2 + DYP**2)
          CROSP = (DXM*DYP - DYM*DXP)/(DSM*DSP)
C
          CRSMAX = MAX(CRSMAX,ABS(CROSP))
C
          I = IG + ITE - 1
          XNI(IG) = BNX(I,IS1(N)) - BNX(I,IS2(N))
          YNI(IG) = BNY(I,IS1(N)) - BNY(I,IS2(N))
          SNI = SQRT(XNI(IG)**2 + YNI(IG)**2)
          XNI(IG) = XNI(IG)/SNI
          YNI(IG) = YNI(IG)/SNI
 22     CONTINUE
C
        IF(CRSMAX .LT. CRSLIM) THEN
         LOK(N) = .TRUE.
         GO TO 2
        ENDIF
C
        CALL FILTXY(XW(1,N),YW(1,N),1.0,NOUT(N),XNI(1),YNI(1),DSN(1))
C
C------ adjust displacements to reflect moved wake coordinates
        DO 25 IG=2, NOUT(N)-1
          I = ITEB(N) + IG - 1
          DISP(I,IS1(N)) = DISP(I,IS1(N)) - DSN(IG)
          DISP(I,IS2(N)) = DISP(I,IS2(N)) + DSN(IG)
 25     CONTINUE
C
C------ respline wake trajectory
        CALL SPWAKE(N)
C
C------ interior grid will need to be smoothed
        LSMOVE = .TRUE.
C
        WRITE(*,*) 'Wake smoothed for element ', N
C
 2    CONTINUE
C
C---- do another pass if any wake has been fixed up
      DO 5 N=1, NBL
        IF(.NOT.LOK(N)) GO TO 1000
 5    CONTINUE
      RETURN
C
 1000 CONTINUE
      RETURN
C
      END ! WAKFIX



      SUBROUTINE STRFIX
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C-----------------------------------------
C     Checks and fixes kinked displacement
C     (surface) streamlines
C-----------------------------------------
      LOGICAL LOKB(ISX), LOKW(ISX), LOKF(2)
      DIMENSION DSN(IX)
C
      DATA CRSLIM, DOTLIM / 0.9, 0.0 /
C
C---- first assume all streamlines over surfaces and wakes are bad
      DO 1 IS=1, 2*NBL
        LOKB(IS) = .FALSE.
        LOKW(IS) = .FALSE.
 1    CONTINUE
      LOKF(1) = .FALSE.
      LOKF(2) = .FALSE.
C
C---- do several passes to fix up streamlines
      DO 1000 IPASS=1, 3
C
C---- go over outermost streamlines
      DO 2 KS=1, 2
        IF(LOKF(KS)) GO TO 2
C
        J = 1
        IF(KS.EQ.2) J = JJ
C
        CRSMAX =  0.0
        DOTMAX = -1.0
        DO 22 IO=2, II-1
          IP = IO+1
          IM = IO-1
C
          DXM = X(IO,J) - X(IM,J)
          DYM = Y(IO,J) - Y(IM,J)
          DXP = X(IO,J) - X(IP,J)
          DYP = Y(IO,J) - Y(IP,J)
          DSM = SQRT(DXM**2 + DYM**2)
          DSP = SQRT(DXP**2 + DYP**2)
          CRSP = (DXM*DYP - DYM*DXP)/(DSM*DSP)
          DOTP = (DXM*DXP + DYM*DYP)/(DSM*DSP)
C
          CRSMAX = MAX(CRSMAX,ABS(CRSP))
          DOTMAX = MAX(DOTMAX,    DOTP )
 22     CONTINUE
C
        IF(CRSMAX.LT.CRSLIM .AND. DOTMAX.LT.DOTLIM) THEN
         LOKF(KS) = .TRUE.
         GO TO 2
        ENDIF
C
C------ kill sawtooth mode along streamline
        XM = X(1,J)
        YM = Y(1,J)
        DO 25 I=2, II-1
          XO = X(I  ,J)
          YO = Y(I  ,J)
          XP = X(I+1,J)
          YP = Y(I+1,J)
          X(I,J) = 0.25*XM + 0.5*XO + 0.25*XP
          Y(I,J) = 0.25*YM + 0.5*YO + 0.25*YP
          XM = XO
          YM = YO
 25     CONTINUE
C
C------ grid will need to be smoothed
        LSMOVE = .TRUE.
C
        WRITE(*,*) 'Outer grid streamline smoothed, j =', J
C
 2    CONTINUE
C
C
C---- go over streamline part covering airfoil surfaces
      DO 4 IS=1, 2*NBL
        IF(LOKB(IS)) GO TO 4
C
        N = (IS+1)/2
        ILE = ILEB(N)
        ITE = ITEB(N)
C
        J = JBLD(N)
        IF(MOD(IS,2).EQ.0) J = JBLD(N)-1
C
        ICN = IGCORN(IS) + ILE - 1
C
        CRSMAX = 0.0
        DOTMAX = -1.0
        ICRS = 0
        IDOT = 0
        DO 42 IO=ILE+1, ITE-1
          IF(IO.EQ.ICN) GO TO 42
C
          IP = IO+1
          IM = IO-1
C
          DXM = X(IO,J) - X(IM,J)
          DYM = Y(IO,J) - Y(IM,J)
          DXP = X(IO,J) - X(IP,J)
          DYP = Y(IO,J) - Y(IP,J)
          DSM = SQRT(DXM**2 + DYM**2)
          DSP = SQRT(DXP**2 + DYP**2)
          CRSP = (DXM*DYP - DYM*DXP)/(DSM*DSP)
          DOTP = (DXM*DXP + DYM*DYP)/(DSM*DSP)
C
          IF(ABS(CRSP) .GT. CRSMAX) THEN
           CRSMAX = ABS(CRSP)
           ICRS = IO
          ENDIF
          IF(DOTP .GT. DOTMAX) THEN
           DOTMAX = DOTP
           IDOT = IO
          ENDIF
C
 42     CONTINUE
C
        IF(CRSMAX.LT.CRSLIM .AND. DOTMAX.LT.DOTLIM) THEN
         LOKB(IS) = .TRUE.
         GO TO 4
        ENDIF
C
        IF(ICN.GT.ILE) THEN
          I = ILE
          NPTS = ICN - ILE + 1
          CALL FILTXY(X(I,J),Y(I,J),1.0,NPTS,
     &                BNX(I,IS),BNY(I,IS),DSN(I))
C
          I = ICN
          NPTS = ITE - ICN + 1
          CALL FILTXY(X(I,J),Y(I,J),1.0,NPTS,
     &                BNX(I,IS),BNY(I,IS),DSN(I))
        ELSE
          I = ILE
          NPTS = NBLD(N)
          CALL FILTXY(X(I,J),Y(I,J),1.0,NPTS,
     &                BNX(I,IS),BNY(I,IS),DSN(I))
        ENDIF
C
        DO 45 I=ILE+1, ITE-1
          DISP(I,IS) = DISP(I,IS) + DSN(I)
 45     CONTINUE
C
C------ grid will need to be smoothed
        LSMOVE = .TRUE.
C
        IKINK = 0
        IF(CRSMAX.GE.CRSLIM) IKINK = ICRS
        IF(DOTMAX.GE.DOTLIM) IKINK = IDOT
C
        WRITE(*,*) 'Grid streamline smoothed on surface side ', IS
        WRITE(*,*) 'Kink at i =', IKINK
C
 4    CONTINUE
C
C
C---- go over streamline part covering wakes
      DO 6 IS=1, 2*NBL
        IF(LOKW(IS)) GO TO 6
C
        N = (IS+1)/2
        ILE = ILEB(N)
        ITE = ITEB(N)
C
        J = JBLD(N)
        IF(MOD(IS,2).EQ.0) J = JBLD(N)-1
C
        CRSMAX =  0.0
        DOTMAX = -1.0
        ICRS = 0
        IDOT = 0
        DO 62 IO=ITE+1, II-1
          IP = IO+1
          IM = IO-1
C
          DXM = X(IO,J) - X(IM,J)
          DYM = Y(IO,J) - Y(IM,J)
          DXP = X(IO,J) - X(IP,J)
          DYP = Y(IO,J) - Y(IP,J)
          DSM = SQRT(DXM**2 + DYM**2)
          DSP = SQRT(DXP**2 + DYP**2)
          CRSP = (DXM*DYP - DYM*DXP)/(DSM*DSP)
          DOTP = (DXM*DXP + DYM*DYP)/(DSM*DSP)
C
          IF(ABS(CRSP) .GT. CRSMAX) THEN
           CRSMAX = ABS(CRSP)
           ICRS = IO
          ENDIF
          IF(DOTP .GT. DOTMAX) THEN
           DOTMAX = DOTP
           IDOT = IO
          ENDIF
C
 62     CONTINUE
C
        IF(CRSMAX.LT.CRSLIM .AND. DOTMAX.LT.DOTLIM) THEN
         LOKW(IS) = .TRUE.
         GO TO 6
        ENDIF
C
        IF(CRSMAX.GE.CRSLIM) IKINK = ICRS
        IF(DOTMAX.GE.DOTLIM) IKINK = IDOT
C
        I = ITE
        NPTS = NOUT(N)
        CALL FILTXY(X(I,J),Y(I,J),1.0,NPTS,
     &                BNX(I,IS),BNY(I,IS),DSN(I))
C
        DO 65 I=ITE+1, II-1
          DISP(I,IS) = DISP(I,IS) + DSN(I)
 65     CONTINUE
C
C------ grid will need to be smoothed
        LSMOVE = .TRUE.
C
        WRITE(*,*) 'Grid streamline smoothed on wake side ', IS
        WRITE(*,*) 'Kink at i =', IKINK
C
 6    CONTINUE
C
C---- do another pass if something was smoothed during this pass
      DO 9 IS=1, 2*NBL
        IF(.NOT.LOKB(IS) .OR. .NOT.LOKW(IS)) GO TO 1000
 9    CONTINUE
      IF(.NOT.LOKF(1) .OR. .NOT.LOKF(2)) GO TO 1000
      RETURN
C
 1000 CONTINUE
      RETURN
C
      END ! STRFIX


      SUBROUTINE FILTXY(X,Y,RLX,N,XN,YN,DS)
      IMPLICIT REAL (A-H,M,O-Z)
      PARAMETER (NMAX=500)
      DIMENSION X(N),Y(N), XN(N),YN(N), DS(N)
      DIMENSION DX(NMAX), DY(NMAX)
C
      IF(N.GT.NMAX) THEN
       WRITE(*,*) 'FILTXY:  Array overflow.  No action taken'
       RETURN
      ENDIF
C
      DO 10 I=2, N-1
        XM = 0.5*(X(I)+X(I-1))
        YM = 0.5*(Y(I)+Y(I-1))
        XP = 0.5*(X(I)+X(I+1))
        YP = 0.5*(Y(I)+Y(I+1))
C
        DXM = X(I) - X(I-1)
        DYM = Y(I) - Y(I-1)
        DXP = X(I+1) - X(I)
        DYP = Y(I+1) - Y(I)
C
        DSM = SQRT(DXM**2 + DYM**2)
        DSP = SQRT(DXP**2 + DYP**2)
C
        DX(I) = (DSP*XM + DSM*XP)/(DSM+DSP) - X(I)
        DY(I) = (DSP*YM + DSM*YP)/(DSM+DSP) - Y(I)
C
   10 CONTINUE
C
      DS(1) = 0.0
      DS(N) = 0.0
C
      DO 20 I=2, N-1
        SN = SQRT(XN(I)**2 + YN(I)**2)
        DS(I) = (DX(I)*XN(I) + DY(I)*YN(I))/SN
C
        X(I) = X(I) + RLX*DS(I)*XN(I)/SN
        Y(I) = Y(I) + RLX*DS(I)*YN(I)/SN
 20   CONTINUE
C
      RETURN
      END ! FILTXY

 
      SUBROUTINE NEWBLD
C-----------------------------------------------------------
C     Sets new blade coordinates by moving airfoil points
C     either with modal displacements (modal-inverse), or 
C     with Dstar and grid movement (mixed-inverse).
C-----------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
C---- overlay temporary storage to save space
ccc      COMMON/WORK/ XNEW(IBX), YNEW(IBX), SNEW(IBX)
      DIMENSION XNEW(IBX), YNEW(IBX), SNEW(IBX)
C
      DIMENSION IGNEW(IBX)
C
      DIMENSION SBSIDE(ISX)
      DIMENSION XTE1(NBX), YTE1(NBX), XTE2(NBX), YTE2(NBX)
C
C---- save current upper- and lower-surface TE points
      DO 5 N=1, NBL
        XTE1(N) = XB(1,N)
        YTE1(N) = YB(1,N)
        XTE2(N) = XB(IIB(N),N)
        YTE2(N) = YB(IIB(N),N)
 5    CONTINUE
C
C---- set element-side lengths for calculation of surface arc lengths SBI
      DO 7 N=1, NBL
        SBSIDE(IS1(N)) = SB(1     ,N) - SBLE(N)
        SBSIDE(IS2(N)) = SB(IIB(N),N) - SBLE(N)
 7    CONTINUE
C
C---- go over elements
      DO 1000 N=1, NBL
C
C---- for mixed-inverse, skip all but the modified element
      IF(LMIXI .AND. N.NE.NMIX) GO TO 1000
C
      ILE = ILEB(N)
      ITE = ITEB(N)
C
C---- set old location corresponding to SBCMAX
      XBCMAX = SEVAL(SBCMAX(N),XB(1,N),XPB(1,N),SB(1,N),IIB(N))
      YBCMAX = SEVAL(SBCMAX(N),YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
C---- set original element shape from spline, doubling corner point if any
      IB = 0
      IS = IS1(N)
      DO 21 IG=NBLD(N), 1, -1
        SBI = SBLE(N) + SBSIDE(IS)*SG(IG,IS)
        IB = IB+1
        XNEW(IB) = SEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
        YNEW(IB) = SEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
        IGNEW(IB) = IG
        IF(IG.EQ.IGCORN(IS)) THEN
         IB = IB+1
         XNEW(IB) = XNEW(IB-1)
         YNEW(IB) = YNEW(IB-1)
         IGNEW(IB) = IG
        ENDIF
 21   CONTINUE
C
      IBLENEW = IB
C
      IS = IS2(N)
      DO 22 IG=2, NBLD(N)
        SBI = SBLE(N) + SBSIDE(IS)*SG(IG,IS)
        IB = IB+1
        XNEW(IB) = SEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
        YNEW(IB) = SEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
        IGNEW(IB) = IG
        IF(IG.EQ.IGCORN(IS)) THEN
         IB = IB+1
         XNEW(IB) = XNEW(IB-1)
         YNEW(IB) = YNEW(IB-1)
         IGNEW(IB) = IG
        ENDIF
 22   CONTINUE
C
      IIBNEW = IB
C
C
C==== modify airfoil shape over inverse portion(s)
C
      NBJ = 2*JJ - 1
C
C---- go over both airfoil sides
      DO 100 IS=IS1(N), IS2(N)
C
C------ set surface-streamline index J, and geometry indices IB___
C-     (start side 2 at point ILE+1 so LE point is not moved twice)
C
        IF(IS.EQ.IS1(N)) THEN
         KS = 1
         J = JS1(N)
         IBFRST = 1
         IBLAST = IBLENEW
        ELSE
         KS = 2
         J = JS2(N)
         IBFRST = IBLENEW+1
         IBLAST = IIBNEW
        ENDIF
C
C
        IF(LMODI .OR. LMINV) THEN
C
C======= modal inverse update
C
         DO 30 IB=IBFRST, IBLAST
C
C--------- recall spacing-array index for this geometry point
           IG = IGNEW(IB)
C
C--------- set modal airfoil surface displacement
           DSURF = 0.0
           DO 301 NN=1, NMODN
             K = KMODN(NN)
             DSURF = DSURF + DMODN(K)*GN(K,IG,IS)
  301      CONTINUE
C
C--------- set normal unit vector components XNI,YNI
           SBI = SBLE(N) + SBSIDE(IS)*SG(IG,IS)
           XNI =  DEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
           YNI = -DEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
           SNI = SQRT(XNI**2 + YNI**2)
           XNI = XNI/SNI
           YNI = YNI/SNI
C
C--------- move surface point along normal vector
           XNEW(IB) = XNEW(IB) + RLX*DSURF*XNI
           YNEW(IB) = YNEW(IB) + RLX*DSURF*YNI
C
cccC--------- move surface point along Delta* vector
ccc           XNEW(IB) = XNEW(IB) + RLX*DSURF*BNX(I,IS)
ccc           YNEW(IB) = YNEW(IB) + RLX*DSURF*BNY(I,IS)
C
   30    CONTINUE
C
        ELSE IF(ISMOVE.EQ.KS .OR. ISMOVE.EQ.-1 .OR. ISMOVE.EQ.0) THEN
C
C======= mixed-inverse update
C
C------- go over inverse segment
         DO 40 IB=IBFRST, IBLAST
           IG = IGNEW(IB)
           I = ILE + IG - 1
C
C--------- modify only if inside inverse segment
           IF(I.GE.IX0 .AND. I.LE.IX1) THEN
C----------- set airfoil surface displacement, accounting for streamline 
C-           movement, Dstar change, and current (Disp-Dstar) mismatch
             DOTP = NX(I,J)*BNX(I,IS) + NY(I,J)*BNY(I,IS)
             DSURF = DR(J,0,I)*DOTP - DR(NBJ+3*IS,0,I)
     &             + (DISP(I,IS) - DSTR(I,IS))
             XNEW(IB) = XNEW(IB) + RLX*DSURF*BNX(I,IS)
             YNEW(IB) = YNEW(IB) + RLX*DSURF*BNY(I,IS)
           ENDIF
   40    CONTINUE
C
        ENDIF
C
  100 CONTINUE
C
C---- set new geometry
      IIB(N) = IIBNEW
      DO 50 IB=1, IIB(N)
        XB(IB,N) = XNEW(IB)
        YB(IB,N) = YNEW(IB)
   50 CONTINUE
C
C---- spline new blade geometry
      CALL SCALC(XB(1,N),YB(1,N),SB(1,N),IIB(N))
      CALL SEGSPL(XB(1,N),XPB(1,N),SB(1,N),IIB(N))
      CALL SEGSPL(YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
C---- reset stagnation point arc length value
      SBLE(N) = SB(IBLENEW,N)
C
C---- set new first wake point
      XW(1,N) = 0.5*(XB(1,N) + XB(IIB(N),N))   
      YW(1,N) = 0.5*(YB(1,N) + YB(IIB(N),N))
C
C---- set new arc length SBNOSE and SBCMAX so x,y locations stay put
      CALL NEARPT(XBNOSE(N),YBNOSE(N),SBNOSE(N),
     &            XB(1,N),XPB(1,N),YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
      CALL NEARPT(XBCMAX,YBCMAX,SBCMAX(N),
     &            XB(1,N),XPB(1,N),YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
C
C---- move slide lines attached to TE of this element
      IS = IS1(N)
      DO 62 K=1, KNOR(IS)
        XNOR(K,IS) = XNOR(K,IS) + (XB(1,N) - XTE1(N))
        YNOR(K,IS) = YNOR(K,IS) + (YB(1,N) - YTE1(N))
 62   CONTINUE
      IS = IS2(N)
      DO 65 K=1, KNOR(IS)
        XNOR(K,IS) = XNOR(K,IS) + (XB(IIB(N),N) - XTE2(N))
        YNOR(K,IS) = YNOR(K,IS) + (YB(IIB(N),N) - YTE2(N))
 65   CONTINUE
C
C---- set new spacing arrays to match new splined airfoil element
      IS = IS1(N)
      DO 71 IB=1, IBLENEW
        IG = IGNEW(IB)
        SG(IG,IS) = (SB(IB,N)-SBLE(N))/(SB(1,N)-SBLE(N))
 71   CONTINUE
C
      IS = IS2(N)
      DO 72 IB=IBLENEW, IIBNEW
        IG = IGNEW(IB)
        SG(IG,IS) = (SB(IB,N)-SBLE(N))/(SB(IIB(N),N)-SBLE(N))
 72   CONTINUE
C
 1000 CONTINUE
C
      RETURN
      END ! NEWBLD

 
      SUBROUTINE NEWDIS
C--------------------------------------------------------------
C     Updates surface point distribution arrays SG(..), 
C     updates stagnation point locations SBLE(.), and 
C     properly offsets grid points adjacent to airfoils by 
C     displacement arrays DISP(..) updated earlier in UPDATE.
C--------------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      LOGICAL LBNCRS
C
C---- overlay temporary storage to save space
ccc      COMMON/WORK/ SBNEW(3*IBX/2,2),
ccc     &             SBI(IX,2), XBI(IX,2), YBI(IX,2), 
ccc     &             XNI(IX,2), YNI(IX,2),
ccc     &             BNXOLD(IX,2), BNYOLD(IX,2)
      DIMENSION SBNEW(3*IBX/2,2),
     &          SBI(IX,2), XBI(IX,2), YBI(IX,2), 
     &          XNI(IX,2), YNI(IX,2),
     &          BNXOLD(IX,2), BNYOLD(IX,2)
C
C---- go over all elements
      DO 1000 N = 1, NBL
C
        ILE = ILEB(N)
        ITE = ITEB(N)
        I1 = IS1(N)
        I2 = IS2(N)
        J1 = JS1(N)
        J2 = JS2(N)
C
C------ set new surface node positions
        DO 10 IG=1, NBLD(N)
          I = ILE + IG - 1
C
C-------- old arc lengths
          SB1 = SBLE(N) + (SB(1     ,N)-SBLE(N))*SG(IG,I1)
          SB2 = SBLE(N) + (SB(IIB(N),N)-SBLE(N))*SG(IG,I2)
C
C-------- set new arc lengths using DSBLE global variable change ...
C-        (this assumes that DSBLE's of other elements have no influence,
C-        since their NXG,NYG on this element were defined to be zero.
          DNS1 = SQRT(NXG(I,J1,N)**2 + NYG(I,J1,N)**2)
          DNS2 = SQRT(NXG(I,J2,N)**2 + NYG(I,J2,N)**2)
          SBNEW(IG,1) = SB1 + RLX*DSBLE(N)*DNS1
          SBNEW(IG,2) = SB2 + RLX*DSBLE(N)*DNS2
C
C-------- set fixed node arc lengths exactly
          IF(IG.EQ.IGFIX(I1)) THEN
           DO 102 IB=2, IIB(N)-2
             IF(SB(IB,N) .EQ. SB(IB+1,N) .AND.
     &          SB1 .GT. SB(IB-1,N) .AND. SB1 .LT. SB(IB+2,N)) THEN
              SBNEW(IG,1) = SB(IB,N)
              GO TO 103
             ENDIF
  102      CONTINUE
  103      CONTINUE
          ENDIF
C
          IF(IG.EQ.IGFIX(I2)) THEN
           DO 106 IB=IIB(N)-2, 2, -1
             IF(SB(IB,N) .EQ. SB(IB+1,N) .AND.
     &          SB2 .GT. SB(IB-1,N) .AND. SB2 .LT. SB(IB+2,N)) THEN
              SBNEW(IG,2) = SB(IB,N)
              GO TO 107
             ENDIF
  106      CONTINUE
  107      CONTINUE
          ENDIF
C
   10   CONTINUE
C
C------ set new stagnation point position
        SBLE(N) = 0.5*(SBNEW(1,1) + SBNEW(1,2))
C
C------ set new normalized distribution arrays,
C-      and set surface points in temporary arrays
        SBTOT1 = SBNEW(NBLD(N),1) - SBNEW(1,1)
        SBTOT2 = SBNEW(NBLD(N),2) - SBNEW(1,2)
        DO 12 IG=NBLD(N), 1, -1
          SG(IG,I1) = (SBNEW(IG,1) - SBNEW(1,1))/SBTOT1
          SG(IG,I2) = (SBNEW(IG,2) - SBNEW(1,2))/SBTOT2
C
          I = ILE + IG-1
          SBI(I,1) = SBLE(N) + (SB(1     ,N)-SBLE(N))*SG(IG,I1)
          SBI(I,2) = SBLE(N) + (SB(IIB(N),N)-SBLE(N))*SG(IG,I2)
          XBI(I,1) = SEVAL(SBI(I,1),XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          YBI(I,1) = SEVAL(SBI(I,1),YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          XBI(I,2) = SEVAL(SBI(I,2),XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          YBI(I,2) = SEVAL(SBI(I,2),YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
   12   CONTINUE
C
C------ set wake points in temporary arrays
        DO 18 IG=2, NOUT(N)
          I = ITE + IG-1
          SBI(I,1) = SBI(ITE,1) - SWAK(N)*SGOUT(IG,N)
          SBI(I,2) = SBI(ITE,2) + SWAK(N)*SGOUT(IG,N)
          XBI(I,1) = XW(IG,N)
          YBI(I,1) = YW(IG,N)
          XBI(I,2) = XW(IG,N)
          YBI(I,2) = YW(IG,N)
   18   CONTINUE
C
C------ set normal vectors on airfoil
        DO 20 I=ILE, ITE
          DX1 =  DEVAL(SBI(I,1),YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          DY1 = -DEVAL(SBI(I,1),XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          DX2 =  DEVAL(SBI(I,2),YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          DY2 = -DEVAL(SBI(I,2),XB(1,N),XPB(1,N),SB(1,N),IIB(N))
C
          XNI(I,1) = DX1/SQRT(DX1**2 + DY1**2)
          YNI(I,1) = DY1/SQRT(DX1**2 + DY1**2)
          XNI(I,2) = DX2/SQRT(DX2**2 + DY2**2)
          YNI(I,2) = DY2/SQRT(DX2**2 + DY2**2)
   20   CONTINUE
C
C------ set normal vectors on wake
        DO 22 I=ITE+1, II-1
          IG = I - ITE + 1
          DX = -(YW(IG+1,N) - YW(IG-1,N))
          DY =  (XW(IG+1,N) - XW(IG-1,N))
          XNI(I,1) =  DX/SQRT(DX**2 + DY**2)
          YNI(I,1) =  DY/SQRT(DX**2 + DY**2)
          XNI(I,2) = -DX/SQRT(DX**2 + DY**2)
          YNI(I,2) = -DY/SQRT(DX**2 + DY**2)
   22   CONTINUE
C
        I = II
        IG = I - ITE + 1
        DX = -(YW(IG,N) - YW(IG-1,N))
        DY =  (XW(IG,N) - XW(IG-1,N))
        XNI(I,1) =  DX/SQRT(DX**2 + DY**2)
        YNI(I,1) =  DY/SQRT(DX**2 + DY**2)
        XNI(I,2) = -DX/SQRT(DX**2 + DY**2)
        YNI(I,2) = -DY/SQRT(DX**2 + DY**2)
C
        DO 30 I=ILE, II
          BNXOLD(I,1) = BNX(I,I1)
          BNYOLD(I,1) = BNY(I,I1)
          BNXOLD(I,2) = BNX(I,I2)
          BNYOLD(I,2) = BNY(I,I2)
 30     CONTINUE
C
C------ set normal vectors at corners, TE points differently
        CALL BLNCTE(N)
C
        DO 40 IS=I1, I2
          DO 405 K=2, KBNFIX(IS)
            I = IBNFIX(K,IS)
            IF(I.LT.ITE) GO TO 405
             XNI(I,1) = BNX(I,I1)
             YNI(I,1) = BNY(I,I1)
             XNI(I,2) = BNX(I,I2)
             YNI(I,2) = BNY(I,I2)
 405      CONTINUE
 40     CONTINUE
C
C
        DO 50 IS=I1, I2
          IF(IS.EQ.I1) THEN
            SGN = 1.0
            KS = 1
          ELSE
            SGN = -1.0
            KS = 2
          ENDIF
C
          DO 504 K=1, KBNFIX(IS)-1
            I    = IBNFIX(K,IS)
            INUM = IBNFIX(K+1,IS) - IBNFIX(K,IS) + 1
C
            CALL DSTELL(DISP(I,IS),
     &                  BNX(I,IS),BNY(I,IS),
     &                  XNI(I,KS),YNI(I,KS),
     &                  XBI(I,KS),YBI(I,KS),SBI(I,KS),
     &                  INUM,SGN,LBNCRS,IGCRS)
            IF(LBNCRS) LSMOVE = .TRUE.
C
            IF(IGCRS.NE.0) WRITE(*,*) 'Side, i =', IS, IGCRS+I-1
 504      CONTINUE
 50     CONTINUE
C
C------ correct displacement for change in displacement-vector angle
        DO 70 I=ILE+1, II-1
          DX1 = X(I+1,J1) - X(I-1,J1)
          DY1 = Y(I+1,J1) - Y(I-1,J1)
          DX2 = X(I+1,J2) - X(I-1,J2)
          DY2 = Y(I+1,J2) - Y(I-1,J2)
cc          DS1 = SQRT(DX1**2 + DY1**2)
cc          DS2 = SQRT(DX2**2 + DY2**2)
cc          DDISP1 = (DX1*   BNX(I,I1) + DY1*   BNY(I,I1))*DISP(I,I1)/DS1
cc     &           - (DX1*BNXOLD(I, 1) + DY1*BNYOLD(I, 1))*DISP(I,I1)/DS1
cc          DDISP2 = (DX2*   BNX(I,I2) + DY2*   BNY(I,I2))*DISP(I,I2)/DS2
cc     &           - (DX2*BNXOLD(I, 2) + DY2*BNYOLD(I, 2))*DISP(I,I2)/DS2
C
C-------- %%%  8/18/94   NEW
          DDISP1 = ( (DX1*BNYOLD(I, 1) - DY1*BNXOLD(I, 1))
     &              /(DX1*   BNY(I,I1) - DY1*   BNX(I,I1)) - 1.0)
     &           * DISP(I,I1)
          DDISP2 = ( (DX2*BNYOLD(I, 2) - DY2*BNXOLD(I, 2))
     &              /(DX2*   BNY(I,I2) - DY2*   BNX(I,I2)) - 1.0)
     &           * DISP(I,I2)
          DISP(I,I1) = DISP(I,I1) + DDISP1
          DISP(I,I2) = DISP(I,I2) + DDISP2
 70     CONTINUE
C
C
C------ set leading edge grid offset
        DISP(ILE,I1) = 0.5*(DISP(ILE+1,I1)+DISP(ILE+1,I2))
        DISP(ILE,I2) = DISP(ILE,I1)
C
C------ set LE Dstar just to be sanitary (it's not used in calculations)
        DSTR(ILE,I1) = DISP(ILE,I1)
        DSTR(ILE,I2) = DISP(ILE,I2)
C
C
C------ offset grid streamlines from surface and wake centerlines
        DO 80 I=ILE+1, II-1
C
C-------- set unit vectors normal to surface streamlines
          XS1 = X(I+1,J1) - X(I-1,J1)
          YS1 = Y(I+1,J1) - Y(I-1,J1)
          XS2 = X(I+1,J2) - X(I-1,J2)
          YS2 = Y(I+1,J2) - Y(I-1,J2)
C
          XN1 = -YS1 / SQRT(XS1**2 + YS1**2)
          YN1 =  XS1 / SQRT(XS1**2 + YS1**2)
          XN2 = -YS2 / SQRT(XS2**2 + YS2**2)
          YN2 =  XS2 / SQRT(XS2**2 + YS2**2)
C
C-------- set changes in X, Y of grid nodes
          DX1 = XBI(I,1) + DISP(I,I1)*BNX(I,I1) - X(I,J1)
          DY1 = YBI(I,1) + DISP(I,I1)*BNY(I,I1) - Y(I,J1)
          DX2 = XBI(I,2) + DISP(I,I2)*BNX(I,I2) - X(I,J2)
          DY2 = YBI(I,2) + DISP(I,I2)*BNY(I,I2) - Y(I,J2)
C
C-------- set change component perpendicular to grid streamline
          DOT1 = DX1*XN1 + DY1*YN1
          DOT2 = DX2*XN2 + DY2*YN2
C
C-------- kill it off near leading edge
          ARG1 = 15.0*(SBI(I,1)-SBI(ILE,1))/(SBI(ITE,1)-SBI(ILE,1))
          ARG2 = 15.0*(SBI(I,2)-SBI(ILE,2))/(SBI(ITE,2)-SBI(ILE,2))
          ARG1 = MIN( ARG1 , 4.0 )
          ARG2 = MIN( ARG2 , 4.0 )
          DOT1 = DOT1 * (1.0 - EXP(-ARG1**2))
          DOT2 = DOT2 * (1.0 - EXP(-ARG2**2))
C
C-------- kill it off on surface based on displacement/delta(s) ratio
c          IF(I.LT.ITE) THEN
c           ARG1 = 8.0 * ABS( DISP(I,I1)/(SBI(I+1,1)-SBI(I-1,1)) )
c           ARG2 = 8.0 * ABS( DISP(I,I2)/(SBI(I+1,2)-SBI(I-1,2)) )
c           ARG1 = MIN( ARG1 , 4.0 )
c           ARG2 = MIN( ARG2 , 4.0 )
c           DOT1 = DOT1 * (1.0 - EXP(-ARG1**2))
c           DOT2 = DOT2 * (1.0 - EXP(-ARG2**2))
c          ENDIF
C
C-------- subtract off component perpendicular to grid streamline
          DX1 = DX1 - XN1*DOT1
          DY1 = DY1 - YN1*DOT1
          DX2 = DX2 - XN2*DOT2
          DY2 = DY2 - YN2*DOT2
C
C-------- set new displacement distance for corrected X,Y change
          DISPX1 = (X(I,J1) + DX1) - XBI(I,1)
          DISPY1 = (Y(I,J1) + DY1) - YBI(I,1)
          DISPX2 = (X(I,J2) + DX2) - XBI(I,2)
          DISPY2 = (Y(I,J2) + DY2) - YBI(I,2)
C
          DISP(I,I1) = SIGN( SQRT(DISPX1**2 + DISPY1**2) , DISP(I,I1) )
          DISP(I,I2) = SIGN( SQRT(DISPX2**2 + DISPY2**2) , DISP(I,I2) )
C
C-------- set final streamline grid nodes
          X(I,J1) = XBI(I,1) + DISP(I,I1)*BNX(I,I1)
          Y(I,J1) = YBI(I,1) + DISP(I,I1)*BNY(I,I1)
          X(I,J2) = XBI(I,2) + DISP(I,I2)*BNX(I,I2)
          Y(I,J2) = YBI(I,2) + DISP(I,I2)*BNY(I,I2)
C
   80   CONTINUE
C
C------ set final stagnation point grid nodes
        I = ILE
        X(I,J1) = XBI(I,1) + DISP(I,I1)*BNX(I,I1)
        Y(I,J1) = YBI(I,1) + DISP(I,I1)*BNY(I,I1)
        X(I,J2) = XBI(I,2) + DISP(I,I2)*BNX(I,I2)
        Y(I,J2) = YBI(I,2) + DISP(I,I2)*BNY(I,I2)
C
 1000 CONTINUE
C
      RETURN
      END ! NEWDIS



      SUBROUTINE NEWPOS
C--------------------------------------------------------------
C     Moves element(s) in response to position DOFs.
C--------------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      LOGICAL OK
      DIMENSION XTE1(NBX), YTE1(NBX), XTE2(NBX), YTE2(NBX)
C
C---- save current upper- and lower-surface TE points
      DO 5 N=1, NBL
        XTE1(N) = XB(1,N)
        YTE1(N) = YB(1,N)
        XTE2(N) = XB(IIB(N),N)
        YTE2(N) = YB(IIB(N),N)
 5    CONTINUE
C
C---- go over position modes
      DO 1000 IPOS=1, NPOSN
        K = KPOSN(IPOS)
C
C------ go over all elements influenced by this position mode
        DO 100 NN=1, NPOSEL(K)
          N = NBPOS(NN,K)
C
          IF(ABPOS(NN,K).EQ.0.0) THEN
C--------- translate element
C
           DXB = RLX*DPOSN(K)*XBPOS(NN,K)
           DYB = RLX*DPOSN(K)*YBPOS(NN,K)
           DO 12 IB=1, IIB(N)
             XB(IB,N) = XB(IB,N) + DXB
             YB(IB,N) = YB(IB,N) + DYB
 12        CONTINUE
C
           XBNOSE(N) = XBNOSE(N) + DXB
           YBNOSE(N) = YBNOSE(N) + DYB
           XBTAIL(N) = XBTAIL(N) + DXB
           YBTAIL(N) = YBTAIL(N) + DYB
C
          ELSE
C--------- rotate element
C
           ANG = RLX*DPOSN(K)*ABPOS(NN,K)
           SINA = SIN(ANG)
           COSA = COS(ANG)
           DO 14 IB=1, IIB(N)
             XBAR = XB(IB,N) - XBPOS(NN,K)
             YBAR = YB(IB,N) - YBPOS(NN,K)
             XB(IB,N) = XBPOS(NN,K) + COSA*XBAR + SINA*YBAR
             YB(IB,N) = YBPOS(NN,K) + COSA*YBAR - SINA*XBAR
 14        CONTINUE
C
           XBAR = XBNOSE(N) - XBPOS(NN,K)
           YBAR = YBNOSE(N) - YBPOS(NN,K)
           XBNOSE(N) = XBPOS(NN,K) + COSA*XBAR + SINA*YBAR
           YBNOSE(N) = YBPOS(NN,K) + COSA*YBAR - SINA*XBAR
C
           XBAR = XBTAIL(N) - XBPOS(NN,K)
           YBAR = YBTAIL(N) - YBPOS(NN,K)
           XBTAIL(N) = XBPOS(NN,K) + COSA*XBAR + SINA*YBAR
           YBTAIL(N) = YBPOS(NN,K) + COSA*YBAR - SINA*XBAR
C
           CALL SEGSPL(XB(1,N),XPB(1,N),SB(1,N),IIB(N))
           CALL SEGSPL(YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
          ENDIF
C
C-------- set new first wake point
          XW(1,N) = 0.5*(XB(1,N) + XB(IIB(N),N))   
          YW(1,N) = 0.5*(YB(1,N) + YB(IIB(N),N))
C
C====================================
C-------- update spacing arrays
C
          I1 = IS1(N)
          I2 = IS2(N)
C
          DO 22 IG=1, NINL(N)
            SGINL(IG,N) = SGINL(IG,N) + RLX*SGINLP(IG,N,K)*DPOSN(K)
 22       CONTINUE
C
          DO 24 IG=1, NBLD(N)
            SG(IG,I1) = SG(IG,I1) + RLX*SGSRFP(IG,I1,K)*DPOSN(K)
            SG(IG,I2) = SG(IG,I2) + RLX*SGSRFP(IG,I2,K)*DPOSN(K)
 24       CONTINUE
C
          DO 26 IG=1, NOUT(N)
            SGOUT(IG,N) = SGOUT(IG,N) + RLX*SGOUTP(IG,N,K)*DPOSN(K)
 26       CONTINUE
C
          DO 30 IPASS=0, 50
C
            OK = .TRUE.
C
C---------- check if crossovers occurred
            DO 302 IG=2, NINL(N)-1
              IF(SGINL(IG,N) .LE. SGINL(IG-1,N) .OR.
     &           SGINL(IG,N) .GE. SGINL(IG+1,N)      ) THEN
               SGINL(IG,N) = 0.5*(SGINL(IG-1,N) + SGINL(IG+1,N))
               OK = .FALSE.
              ENDIF
 302        CONTINUE
C
            DO 304 IG=2, NBLD(N)-1
              IF(SG(IG,I1) .LE. SG(IG-1,I1) .OR.
     &           SG(IG,I1) .GE. SG(IG+1,I1)      ) THEN
               SG(IG,I1) = 0.5*(SG(IG-1,I1) + SG(IG+1,I1))
               OK = .FALSE.
              ENDIF
C
              IF(SG(IG,I2) .LE. SG(IG-1,I2) .OR.
     &           SG(IG,I2) .GE. SG(IG+1,I2)      ) THEN
               SG(IG,I2) = 0.5*(SG(IG-1,I2) + SG(IG+1,I2))
               OK = .FALSE.
              ENDIF
 304        CONTINUE
C
            DO 306 IG=2, NOUT(N)-1
              IF(SGOUT(IG,N) .LE. SGOUT(IG-1,N) .OR.
     &          SGOUT(IG,N) .GE. SGOUT(IG+1,N)      ) THEN
               SGOUT(IG,N) = 0.5*(SGOUT(IG-1,N) + SGOUT(IG+1,N))
               OK = .FALSE.
              ENDIF
 306        CONTINUE
C
            IF(OK) THEN
             IF(IPASS.GT.0) THEN
              WRITE(*,*) 'Spacing arrays crossed over.'
              WRITE(*,*) 'Fixed up on pass', IPASS
             ENDIF
             GO TO 100
            ENDIF
C
 30       CONTINUE
          WRITE(*,*) 'Spacing arrays crossed over.  Unable to fix up.'
C
 100    CONTINUE
C
 1000 CONTINUE
C
C
      DO 2000 N=1, NBL
C
C------ move slide lines attached to TE of this element
        IS = IS1(N)
        DO 17 K=1, KNOR(IS)
          XNOR(K,IS) = XNOR(K,IS) + (XB(1,N) - XTE1(N))
          YNOR(K,IS) = YNOR(K,IS) + (YB(1,N) - YTE1(N))
 17     CONTINUE
        IS = IS2(N)
        DO 18 K=1, KNOR(IS)
          XNOR(K,IS) = XNOR(K,IS) + (XB(IIB(N),N) - XTE2(N))
          YNOR(K,IS) = YNOR(K,IS) + (YB(IIB(N),N) - YTE2(N))
 18     CONTINUE
C
 2000 CONTINUE
C
      RETURN
      END ! NEWPOS



      SUBROUTINE DSTELL(DISP,BNX,BNY,GNX,GNY,XB,YB,SB,N,SGN,SMOOTH,ICRS)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION DISP(N),BNX(N),BNY(N),GNX(N),GNY(N),XB(N),YB(N),SB(N)
      LOGICAL SMOOTH
C-----------------------------------------------------------
C     Adjusts normal vectors with spring analogy
C     so they don't cross over.
C
C      DISP      displacement vector lengths
C      BNX,BNY   quasi-normal unit vectors to be leaned
C      GNX,GNY   true normal vectors used from which BNX,BNY are leaned
C      XB,YB     surface coordinates
C      SBI       surface arc length
C      N         number of points/vectors
C      SGN       (not used)
C      SMOOTH    returned as .TRUE. if grid will need to be smoothed
C      ICRS      node index of crossed vectors, if any
C----------------------------------------------------------
C
      PARAMETER (IDIM=400)
      DIMENSION C(IDIM),D(IDIM)
C
C---- set   CON     tension/torsion spring constant ratio, 
C-          COSMIN  minimum allowable lean cosine
C-          EPS     convergence tolerance on lean angle change (rad)
C
      DATA CON, COSMIN, EPS / 10.0 , 0.70 , 0.001 /
C
      SMOOTH = .FALSE.
C
      SINMIN = SQRT(1.0 - COSMIN**2)
C
      IF(N.GT.IDIM) STOP 'DSTELL: Array overflow.'
      ITMAX = 10
ccc      ITMAX = 1
C
C---- Newton iteration loop     
      DO 100 ITER=1, ITMAX
C
        ICRS = 0
C
C------- transient control: make sure quasi and true normals are close
         DO 10 IO=2, N-1
           COSTO = GNX(IO)*BNX(IO) + GNY(IO)*BNY(IO)
           IF(COSTO .LT. 0.0) THEN
            WRITE(*,*) 'DSTELL: Reversed normal vector.  k, cos = ',
     &                  IO, COSTO
            COSTO = COSMIN
            SINTO = SIGN( SINMIN , GNX(IO)*BNY(IO)-GNY(IO)*BNX(IO) )
            BNX(IO) = GNX(IO)*COSTO - GNY(IO)*SINTO
            BNY(IO) = GNY(IO)*COSTO + GNX(IO)*SINTO
           ENDIF
   10    CONTINUE
C
C
C------- set and linearize current normal wrt lean angle
C-           BNX(I) = GNX(I)*COST - GNY(I)*SINT
C-           BNY(I) = GNY(I)*COST + GNX(I)*SINT
C
         IM = 1
         COSTM = GNX(IM)*BNX(IM) + GNY(IM)*BNY(IM)
         SINTM = GNX(IM)*BNY(IM) - GNY(IM)*BNX(IM)
         BNX_TM = -GNX(IM)*SINTM - GNY(IM)*COSTM
         BNY_TM = -GNY(IM)*SINTM + GNX(IM)*COSTM
C
         IO = 2
         COSTO = GNX(IO)*BNX(IO) + GNY(IO)*BNY(IO)
         SINTO = GNX(IO)*BNY(IO) - GNY(IO)*BNX(IO)
         BNX_TO = -GNX(IO)*SINTO - GNY(IO)*COSTO
         BNY_TO = -GNY(IO)*SINTO + GNX(IO)*COSTO
C
C------- components of vector connecting adjacent vector heads
         DXSM = XB(IO)-XB(IM) + DISP(IO)*BNX(IO) - DISP(IM)*BNX(IM)
         DYSM = YB(IO)-YB(IM) + DISP(IO)*BNY(IO) - DISP(IM)*BNY(IM)
C
         DXSM_TM = -DISP(IM)*BNX_TM
         DYSM_TM = -DISP(IM)*BNY_TM
C
         DXSM_TO =  DISP(IO)*BNX_TO
         DYSM_TO =  DISP(IO)*BNY_TO
C
         D(1) = 0.0
         C(1) = 0.0
C
         DO 20 IO=2, N-1
C
           IP = IO+1
           IM = IO-1
C
           TO = ASIN(SINTO)
C
           DSBM = SB(IO) - SB(IM)
           DSBP = SB(IP) - SB(IO)
C
           COSTP = GNX(IP)*BNX(IP) + GNY(IP)*BNY(IP)
           SINTP = GNX(IP)*BNY(IP) - GNY(IP)*BNX(IP)
C
           COSTP = MAX( COSTP , -1.0 )
           COSTP = MIN( COSTP ,  1.0 )
           SINTP = MAX( SINTP , -1.0 )
           SINTP = MIN( SINTP ,  1.0 )
C
           BNX_TP = -GNX(IP)*SINTP - GNY(IP)*COSTP
           BNY_TP = -GNY(IP)*SINTP + GNX(IP)*COSTP
C
C--------- components of vector connecting adjacent vector heads
           DXSP = XB(IP)-XB(IO) + DISP(IP)*BNX(IP) - DISP(IO)*BNX(IO)
           DYSP = YB(IP)-YB(IO) + DISP(IP)*BNY(IP) - DISP(IO)*BNY(IO)
C
           DXSP_TO = -DISP(IO)*BNX_TO
           DYSP_TO = -DISP(IO)*BNY_TO
C
           DXSP_TP =  DISP(IP)*BNX_TP
           DYSP_TP =  DISP(IP)*BNY_TP
C
C--------- lengths of the two "springs" attached to IM and IP vector heads
C-         (connecting vectors crossed with quasi-normal unit vector)
           DSM = BNX(IO)*DYSM - BNY(IO)*DXSM
           DSP = BNX(IO)*DYSP - BNY(IO)*DXSP
C
           DSM_TM = BNX(IO)*DYSM_TM - BNY(IO)*DXSM_TM
           DSM_TO = BNX(IO)*DYSM_TO - BNY(IO)*DXSM_TO
     &          + BNX_TO *DYSM    - BNY_TO *DXSM
C
           DSP_TP = BNX(IO)*DYSP_TP - BNY(IO)*DXSP_TP
           DSP_TO = BNX(IO)*DYSP_TO - BNY(IO)*DXSP_TO
     &          + BNX_TO *DYSP    - BNY_TO *DXSP
C
C--------- check if springs have negative lengths
           IF( DSM*DSP .LE. 0.0 ) THEN
            WRITE(*,*) 
     &        'DSTELL: Crossed displacement vectors at ig = ', IO
             ICRS = IO
c
cc            write(*,*) 100.0*(xb(im)-xb(io)) , 100.0*(yb(im)-yb(io)),
cc     &                 100.0*disp(im)*bnx(im), 100.0*disp(im)*bny(im)
cc            write(*,*) 100.0*(xb(io)-xb(io)) , 100.0*(yb(io)-yb(io)),
cc     &                 100.0*disp(io)*bnx(io), 100.0*disp(io)*bny(io)
cc            write(*,*) 100.0*(xb(ip)-xb(io)) , 100.0*(yb(ip)-yb(io)),
cc     &                 100.0*disp(ip)*bnx(ip), 100.0*disp(ip)*bny(ip)
c
            BNX(IO) = DISP(IM)*BNX(IM) + DISP(IP)*BNX(IP)
            BNY(IO) = DISP(IM)*BNY(IM) + DISP(IP)*BNY(IP)
            BNS = SQRT(BNX(IO)**2 + BNY(IO)**2)
            IF(BNS.EQ.0.0) THEN
             BNX(IO) = 0.5*(BNX(IM) + BNX(IP))
             BNY(IO) = 0.5*(BNY(IM) + BNY(IP))
             BNS = SQRT(BNX(IO)**2 + BNY(IO)**2)
            ENDIF
            BNX(IO) = BNX(IO)/BNS
            BNY(IO) = BNY(IO)/BNS
            DISP(IO) = 0.5*(DISP(IM) + DISP(IP))
C
            COSTO = GNX(IO)*BNX(IO) + GNY(IO)*BNY(IO)
            SINTO = GNX(IO)*BNY(IO) - GNY(IO)*BNX(IO)
            BNX_TO = -GNX(IO)*SINTO - GNY(IO)*COSTO
            BNY_TO = -GNY(IO)*SINTO + GNX(IO)*COSTO
C
            DXSM = XB(IO)-XB(IM) + DISP(IO)*BNX(IO) - DISP(IM)*BNX(IM)
            DYSM = YB(IO)-YB(IM) + DISP(IO)*BNY(IO) - DISP(IM)*BNY(IM)
C
            DXSM_TM = -DISP(IM)*BNX_TM
            DYSM_TM = -DISP(IM)*BNY_TM
C
            DXSM_TO =  DISP(IO)*BNX_TO
            DYSM_TO =  DISP(IO)*BNY_TO
C
            SMOOTH = .TRUE.
           ENDIF
C
C--------- set and linearize residual 
C-         (moment balance of IO quasi-normal)
           DK = CON*DISP(IO)*0.5/(DSBM+DSBP)
C
           REZ = DK*(DSBP/DSP - DSBM/DSM) + TO
           Z_DSP = -DK * DSBP/DSP**2
           Z_DSM =  DK * DSBM/DSM**2
C
           D(IO) = REZ
           B     = Z_DSM*DSM_TM
           A     = Z_DSM*DSM_TO + Z_DSP*DSP_TO  +  1.0
           C(IO) =                Z_DSP*DSP_TP
C
c        write(*,*) io, 100.*dsbm,100.*dsm, 100.*dsbp,100.*dsp
c        write(*,*) io, b, a, c(io)
c        write(*,*) io, dsm_tm, dsm_to, dsp_to, dsp_tp 
C
C--------- eliminate lower diagonal entry and normalize current row
           AINV = 1.0/(A - B*C(IO-1))
           C(IO) = C(IO) * AINV
           D(IO) = ( D(IO) - B*D(IO-1) ) * AINV
C
C--------- define stuff for next loop pass
           DXSM = DXSP
           DYSM = DYSP
C
           DXSM_TM = DXSP_TO
           DYSM_TM = DYSP_TO
C
           DXSM_TO = DXSP_TP
           DYSM_TO = DYSP_TP
C
           BNX_TM = BNX_TO
           BNY_TM = BNX_TO
C
           BNX_TO = BNX_TP
           BNY_TO = BNY_TP
C
           SINTM = SINTO
           SINTO = SINTP
C
           COSTM = COSTO
           COSTO = COSTP
C
   20    CONTINUE
C
C
C------- back-substitute for Newton changes of lean angle
         DMAX = 0.0
C
         D(N) = 0.
         DO 30 I=N-1, 2, -1
           D(I) = D(I) - C(I)*D(I+1)
           DMAX = MAX( DMAX , ABS(D(I)) )
   30    CONTINUE
C
C
         RLX = 1.0
         IF(DMAX .GT. 0.15) RLX = 0.15/DMAX
C
C------- rotate normal vectors by Newton change of lean angle
         DO 40 I=2, N-1
           SINT = SIN(RLX*D(I))
           COST = COS(RLX*D(I))
C
           BNXT = BNX(I)
           BNYT = BNY(I)
C
           BNX(I) = BNXT*COST + BNYT*SINT
           BNY(I) = BNYT*COST - BNXT*SINT
   40    CONTINUE
C
ccc         WRITE(*,*) 'DSTELL:   Dmax = ',ITER,  DMAX, RLX
C
         IF(DMAX .LT. EPS) RETURN
C
  100 CONTINUE
C
      DDMAX = DMAX*180.0/3.14159
      WRITE(*,*) 'DSTELL: Convergence failed.  max Dtheta = ', DDMAX
C
      RETURN
      END ! DSTELL
