%{!?custom:%global custom 0}

%define archive nagios-plugins

%if %custom
%define name %{archive}-custom
%else
%define name %{archive}
%endif

%define version 1.4.0alpha1
%define release 1
%define source %{archive}-%{version}

Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Source: %{source}.tar.gz
BuildRoot: %{_tmppath}/%{name}-buildroot
Prefix: %{_prefix}/lib/nagios/plugins
Packager: Karl DeBisschop <kdebisschop@users.sourceforge.net>
Vendor: Nagios Plugin Development Group
Provides: nagios-plugins
%if %custom
Obsoletes: nagios-plugins nagios-plugins-extras
%else
Obsoletes: nagios-plugins-custom
%endif
AutoReqProv: no
Summary: Host/service/network monitoring program plugins for Nagios
Group: Applications/System

#BuildRequires: nagios-devel
#BuildRequires: postgresql-devel, openssl-devel, bind-devel, openldap-devel, mysql-devel
#BuildRequires: perl(Net::SNMP), %{?rh73:, ucd-snmp-devel} %{?rh80:, net-snmp-devel} %{?rh90:, net-snmp-devel}
#BuildRequires: fping, bind-utils, ntp, samba-client, openssh-clients, radiusclient-devel
#BuildRequires: qstat

#Requires: perl, perl(Net::SNMP), openssl

%description

Nagios is a program that will monitor hosts and services on your
network, and to email or page you when a problem arises or is
resolved. Nagios runs on a unix server as a background or daemon
process, intermittently running checks on various services that you
specify. The actual service checks are performed by separate "plugin"
programs which return the status of the checks to Nagios.

This package contains the basic plugins necessary for use with the
Nagios package.  This package should install cleanly on almost any
RPM-based system.


%package extras
Summary: Plugins which depend on the presence of other packages
Group: Applications/System

%description extras

Nagios is a program that will monitor hosts and services on your
network, and to email or page you when a problem arises or is
resolved. Nagios runs on a unix server as a background or daemon
process, intermittently running checks on various services that you
specify. The actual service checks are performed by separate "plugin"
programs which return the status of the checks to Nagios.

This package contains plugins which use additional libraries or system
calls that are not installed on all systems.  As a result, most users
will need to install the '--nodeps' option when invoking `rpm`

#Requires: fping, openldap, mysql, postgresql-libs


%prep
%setup -q -n %{source}


%build
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./configure \
--prefix=%{_prefix} \
--exec-prefix=%{_exec_prefix} \
--libexecdir=%{_exec_prefix}/lib/nagios/plugins \
--sysconfdir=%{_sysconfdir}/nagios \
--datadir=%{_datadir} \
--with-cgiurl=/nagios/cgi-bin
make 


%install
make AM_INSTALL_PROGRAM_FLAGS="" DESTDIR=${RPM_BUILD_ROOT} install
install -d ${RPM_BUILD_ROOT}/etc/nagios
install -m 664 command.cfg ${RPM_BUILD_ROOT}/etc/nagios

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
%config(missingok,noreplace) /etc/nagios/command.cfg
%doc CODING COPYING FAQ INSTALL LEGAL README REQUIREMENTS SUPPORT THANKS
%doc ChangeLog command.cfg
%defattr(775,root,root)
%dir %{_exec_prefix}/lib/nagios/plugins
%{_datadir}/locale/de/LC_MESSAGES/nagios-plugins.mo
%{_datadir}/locale/fr/LC_MESSAGES/nagios-plugins.mo
%if %custom
%{_exec_prefix}/lib/nagios/plugins/*
%else
%{_exec_prefix}/lib/nagios/plugins/check_by_ssh
%{_exec_prefix}/lib/nagios/plugins/check_breeze
%{_exec_prefix}/lib/nagios/plugins/check_dig
%{_exec_prefix}/lib/nagios/plugins/check_disk
%{_exec_prefix}/lib/nagios/plugins/check_disk_smb
%{_exec_prefix}/lib/nagios/plugins/check_dns
%{_exec_prefix}/lib/nagios/plugins/check_dummy
%{_exec_prefix}/lib/nagios/plugins/check_flexlm
%{_exec_prefix}/lib/nagios/plugins/check_ftp
%{_exec_prefix}/lib/nagios/plugins/check_http
%{_exec_prefix}/lib/nagios/plugins/check_ifoperstatus
%{_exec_prefix}/lib/nagios/plugins/check_ifstatus
%{_exec_prefix}/lib/nagios/plugins/check_imap
%{_exec_prefix}/lib/nagios/plugins/check_ircd
%{_exec_prefix}/lib/nagios/plugins/check_load
%{_exec_prefix}/lib/nagios/plugins/check_log
%{_exec_prefix}/lib/nagios/plugins/check_mailq
%{_exec_prefix}/lib/nagios/plugins/check_mrtg
%{_exec_prefix}/lib/nagios/plugins/check_mrtgtraf
%{_exec_prefix}/lib/nagios/plugins/check_nagios
%{_exec_prefix}/lib/nagios/plugins/check_nntp
%{_exec_prefix}/lib/nagios/plugins/check_nt
%{_exec_prefix}/lib/nagios/plugins/check_ntp
%{_exec_prefix}/lib/nagios/plugins/check_nwstat
%{_exec_prefix}/lib/nagios/plugins/check_oracle
%{_exec_prefix}/lib/nagios/plugins/check_overcr
%{_exec_prefix}/lib/nagios/plugins/check_ping
%{_exec_prefix}/lib/nagios/plugins/check_pop
%{_exec_prefix}/lib/nagios/plugins/check_procs
%{_exec_prefix}/lib/nagios/plugins/check_real
%{_exec_prefix}/lib/nagios/plugins/check_rpc
%{_exec_prefix}/lib/nagios/plugins/check_sensors
%{_exec_prefix}/lib/nagios/plugins/check_smtp
%{_exec_prefix}/lib/nagios/plugins/check_ssh
%{_exec_prefix}/lib/nagios/plugins/check_swap
%{_exec_prefix}/lib/nagios/plugins/check_tcp
%{_exec_prefix}/lib/nagios/plugins/check_time
%{_exec_prefix}/lib/nagios/plugins/check_udp
%{_exec_prefix}/lib/nagios/plugins/check_ups
%{_exec_prefix}/lib/nagios/plugins/check_users
%{_exec_prefix}/lib/nagios/plugins/check_wave
%{_exec_prefix}/lib/nagios/plugins/negate
%{_exec_prefix}/lib/nagios/plugins/utils.pm
%{_exec_prefix}/lib/nagios/plugins/utils.sh
%{_exec_prefix}/lib/nagios/plugins/urlize
%{_exec_prefix}/lib/nagios/plugins/check_file_age
%endif

%if ! %custom
%files extras
%defattr(775,root,root)
%{_exec_prefix}/lib/nagios/plugins/check_fping
%{_exec_prefix}/lib/nagios/plugins/check_game
%{_exec_prefix}/lib/nagios/plugins/check_ldap
%{_exec_prefix}/lib/nagios/plugins/check_mysql
%{_exec_prefix}/lib/nagios/plugins/check_pgsql
%{_exec_prefix}/lib/nagios/plugins/check_radius
%{_exec_prefix}/lib/nagios/plugins/check_snmp
%{_exec_prefix}/lib/nagios/plugins/check_hpjd

%endif

%changelog
* Wed Jan 17 2001 Karl DeBisschop <karl@debisschop.net> (1.2.9-1)
- switch from /usr/libexec to /usr/lib because FHS has no libexec
- use 'custom' macro define to merge with nagios-plugins-custom spec
- add check_game to extras

* Mon Jun 26 2000 Karl DeBisschop <karl@debisschop.net>
- Release 1.2.8-4 (check_ping bug fix)
- use bzip2 insted of gzip for mandrake compatibility

* Thu Jun 22 2000 Karl DeBisschop <karl@debisschop.net>
- Release 1.2.8-3 (bug fixes)
- Add macros to spec where possible

* Fri Jun 16 2000 Karl DeBisschop <karl@debisschop.net>
- Release 1.2.8-2 (bug fixes)

* Fri Jun 09 2000 Karl DeBisschop <karl@debisschop.net>
- Release to 1.2.8

* Wed Jun 07 2000 Karl DeBisschop <karl@debisschop.net>
- Upgrade to 1.2.8pre7

* Sat Jun 03 2000 Karl DeBisschop <karl@debisschop.net>
- Upgraded to 1.2.8pre5
- use RPM_OPT_FALGS to set compiler options
- cahneg group to Applications/System

* Fri May 19 2000 Karl DeBisschop <karl@debisschop.net>
- Upgraded to 1.2.8pre3 (release-3)

* Mon Mar 20 2000 Karl DeBisschop <karl@debisschop.net>
- Upgraded to 1.2.8b2

* Tue Dec 14 1999 Adam Jacob <adam@cybertrails.com> (1.2.7-1cvs)
- Upgraded package from 1.2.6 to 1.2.7 from the latest CVS code
- Modified SPEC file to contain the proper build_root stuff. :)

* Tue Oct 19 1999 Mike McHenry <mmchen@minn.net> (1.2.6)
- Upgraded package from 1.2.4 to 1.2.6
- Resolved dependancy issue with libpq.so
- Added support for check_fping

* Fri Sep 03 1999 Mike McHenry <mmchen@minn.net> (1.2.4)
- Upgraded package from 1.2.2 to 1.2.4

* Mon Aug 16 1999 Mike McHenry <mmchen@minn.net> (1.2.2)
- First RPM build (1.2.2)
