/*****************************************************************************
 *
 * EDATA.C - External extended object config data for NetSaint CGIs
 *
 * Copyright (c) 1999-2000 Ethan Galstad (netsaint@netsaint.org)
 * Last Modified:   08-15-2000
 *
 * License:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *****************************************************************************/

/*********** COMMON HEADER FILES ***********/

#include "../common/config.h"
#include "../common/common.h"
#include "../common/objects.h"
#include "cgiutils.h"
#include "edata.h"


/**** IMPLEMENTATION SPECIFIC HEADER FILES ****/

#ifdef USE_XEDDEFAULT
#include "../xdata/xeddefault.h"		/* default routines */
#endif
#ifdef USE_XEDMYSQL
#include "../xdata/xedmysql.h"			/* MySQL routines */
#endif




hostextinfo     *hostextinfo_list=NULL;




/******************************************************************/
/******************* TOP-LEVEL INPUT FUNCTIONS ********************/
/******************************************************************/


/* reads in all extended data */
int read_extended_object_config_data(char *config_file){
	int result;

	/**** IMPLEMENTATION-SPECIFIC CALLS ****/
#ifdef USE_XEDDEFAULT
	result=xeddefault_read_extended_object_config_data(config_file);
	if(result!=OK)
		return ERROR;
#endif
#ifdef USE_XEDMYSQL
	result=xedmysql_read_extended_object_config_data(config_file);
	if(result!=OK)
		return ERROR;
#endif

	return OK;
        }



/******************************************************************/
/********************** ADDITION FUNCTIONS ************************/
/******************************************************************/

int add_extended_host_info(char *host_name,char *notes_url, char *icon_image, char *vrml_image, char *gd2_icon_image, char *icon_image_alt, int x_2d, int y_2d, double x_3d, double y_3d, double z_3d){
	hostextinfo *new_hostextinfo;


	/* make sure we have what we need */
	if(host_name==NULL)
		return ERROR;
	if(!strcmp(host_name,""))
		return ERROR;


	/* allocate memory for a new data structure */
	new_hostextinfo=(hostextinfo *)malloc(sizeof(hostextinfo));
	if(new_hostextinfo==NULL)
		return ERROR;
				
	new_hostextinfo->host_name=(char *)malloc(strlen(host_name)+1);
	if(new_hostextinfo->host_name==NULL){
		free(new_hostextinfo);
		return ERROR;
	        }
	strcpy(new_hostextinfo->host_name,host_name);

	if(notes_url==NULL || !strcmp(notes_url,""))
		new_hostextinfo->notes_url=NULL;
	else{
		new_hostextinfo->notes_url=(char *)malloc(strlen(notes_url)+1);
		if(new_hostextinfo->notes_url==NULL){
			free(new_hostextinfo->host_name);
			free(new_hostextinfo);
			return ERROR;
		        }
		strcpy(new_hostextinfo->notes_url,notes_url);
	        }

	if(icon_image==NULL || !strcmp(icon_image,""))
		new_hostextinfo->icon_image=NULL;
	else{
		new_hostextinfo->icon_image=(char *)malloc(strlen(icon_image)+1);
		if(new_hostextinfo->icon_image==NULL){
			free(new_hostextinfo->notes_url);
			free(new_hostextinfo->host_name);
			free(new_hostextinfo);
			return ERROR;
	                }
		strcpy(new_hostextinfo->icon_image,icon_image);
	        }

	if(vrml_image==NULL || !strcmp(vrml_image,""))
		new_hostextinfo->vrml_image=NULL;
	else{
		new_hostextinfo->vrml_image=(char *)malloc(strlen(vrml_image)+1);
		if(new_hostextinfo->vrml_image==NULL){
			free(new_hostextinfo->icon_image);
			free(new_hostextinfo->notes_url);
			free(new_hostextinfo->host_name);
			free(new_hostextinfo);
			return ERROR;
	                }
		strcpy(new_hostextinfo->vrml_image,vrml_image);
	        }


	if(gd2_icon_image==NULL || !strcmp(gd2_icon_image,""))
		new_hostextinfo->gd2_icon_image=NULL;
	else{
		new_hostextinfo->gd2_icon_image=(char *)malloc(strlen(gd2_icon_image)+1);
		if(new_hostextinfo->gd2_icon_image==NULL){
			free(new_hostextinfo->vrml_image);
			free(new_hostextinfo->icon_image);
			free(new_hostextinfo->notes_url);
			free(new_hostextinfo->host_name);
			free(new_hostextinfo);
			return ERROR;
		        }
		strcpy(new_hostextinfo->gd2_icon_image,gd2_icon_image);
	        }


	if(icon_image_alt==NULL || !strcmp(icon_image_alt,""))
		new_hostextinfo->icon_image_alt=NULL;
	else{
		new_hostextinfo->icon_image_alt=(char *)malloc(strlen(icon_image_alt)+1);
		if(new_hostextinfo->icon_image_alt==NULL){
			free(new_hostextinfo->gd2_icon_image);
			free(new_hostextinfo->vrml_image);
			free(new_hostextinfo->icon_image);
			free(new_hostextinfo->notes_url);
			free(new_hostextinfo->host_name);
			free(new_hostextinfo);
			return ERROR;
		        }
		strcpy(new_hostextinfo->icon_image_alt,icon_image_alt);
	        }

	/* 2-D coordinates */
	new_hostextinfo->x_2d=x_2d;
	new_hostextinfo->y_2d=y_2d;
	if(x_2d==-1 && y_2d==-1)
		new_hostextinfo->have_2d_coords=FALSE;
	else
		new_hostextinfo->have_2d_coords=TRUE;

	/* 3-D coordinates */
	new_hostextinfo->x_3d=x_3d;
	new_hostextinfo->y_3d=y_3d;
	new_hostextinfo->z_3d=z_3d;
	if(x_3d==-1.0 && y_3d==-1.0 && z_3d==-1.0)
		new_hostextinfo->have_3d_coords=FALSE;
	else
		new_hostextinfo->have_3d_coords=TRUE;

	/* default is to not draw this item */
	new_hostextinfo->should_be_drawn=FALSE;

	/* add new host extended info entry to head of list */
	new_hostextinfo->next=hostextinfo_list;
	hostextinfo_list=new_hostextinfo;

	return OK;
        }
	


/******************************************************************/
/*********************** CLEANUP FUNCTIONS ************************/
/******************************************************************/

void free_extended_data(void){
	hostextinfo *this_hostextinfo;
	hostextinfo *next_hostextinfo;

	/* free memory for the extended host status list */
	for(this_hostextinfo=hostextinfo_list;this_hostextinfo!=NULL;this_hostextinfo=next_hostextinfo){
		next_hostextinfo=this_hostextinfo->next;
		free(this_hostextinfo->host_name);
		if(this_hostextinfo->notes_url!=NULL)
			free(this_hostextinfo->notes_url);
		if(this_hostextinfo->icon_image!=NULL)
			free(this_hostextinfo->icon_image);
		if(this_hostextinfo->vrml_image!=NULL)
			free(this_hostextinfo->vrml_image);
		if(this_hostextinfo->gd2_icon_image!=NULL)
			free(this_hostextinfo->gd2_icon_image);
		if(this_hostextinfo->icon_image_alt!=NULL)
			free(this_hostextinfo->icon_image_alt);
		free(this_hostextinfo);
	        }

	return;
        }




/******************************************************************/
/************************ SEARCH FUNCTIONS ************************/
/******************************************************************/

/* find the extended information for a given host */
hostextinfo * find_hostextinfo(char *host_name){
	hostextinfo *temp_hostextinfo;

	for(temp_hostextinfo=hostextinfo_list;temp_hostextinfo!=NULL;temp_hostextinfo=temp_hostextinfo->next){
		if(!strcmp(host_name,temp_hostextinfo->host_name))
			return temp_hostextinfo;
	        }
	
	return NULL;
        }
