/*****************************************************************************
 *
 * NS5TO6.C - Upgrade utility for NetSaint 0.0.5 host config files
 *
 * Program: NS5TO6
 * License: GPL
 * Copyright (c) 2000 Ethan Galstad (netsaint@netsaint.org)
 *
 * Last Modified:   04-02-2000
 *
 * Description:
 *
 * This utility will upgrade an existing version 0.0.5 host config file to
 * the format required for versioin 0.0.6.  Specifically, the service
 * definitions are modified to have a default value of 0 for the is_volatile
 * field.  Read the HTML documentation supplied with NetSaint for more info
 * on service definitions, the is_volatile field, and what volatile services
 * are.
 *
 * License:
 *
 * This program is free software; you can redistribute it and/or modify
 * it unde the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


int main(int argc, char **argv){
	FILE *fpin;
	FILE *fpout;
	char input_buffer[4096];
	char *temp_ptr="";
	int total_lines=0;
	int modified_lines=0;
	

	printf("\n");
	printf("NS5TO6 - NetSaint Configuration File Update Utility\n");
	printf("Copyright (c) 2000 Ethan Galstad (netsaint@netsaint.org)\n\n");

	if(argc!=3){

		printf("Usage: %s <version_5_host_file> <version_6_host_file>\n",argv[0]);
		printf("\n");
		printf("<version_5_host_file> is the hosts.cfg file that you\n");
		printf("previously used for version 0.0.5.  The modified file\n");
		printf("will be written out to the file specified by the\n");
		printf("<version_6_host_file> argument.\n\n");

		return -1;
	        }

	fpin=fopen(argv[1],"r");
	if(fpin==NULL){
		printf("Error: Cannot open file '%s' for reading!\n",argv[1]);
		return -1;
	        }

	fpout=fopen(argv[2],"w");
	if(fpout==NULL){
		printf("Error: Cannot open file '%s' for writing!\n",argv[2]);
		fclose(fpin);
		return -1;
	        }

	printf("Upgrading %s to work with version 0.0.6 service definition formats...\n",argv[1]);

	/* read in all lines for the original config file */
	while(fgets(input_buffer,sizeof(input_buffer)-1,fpin)){

		if(feof(fpin))
			break;

		total_lines++;

		/* this is not a service definition, so just write it out */
		if(strstr(input_buffer,"service[")!=input_buffer)
			fputs(input_buffer,fpout);

		/* this is a service definition, so modify it */
		else{

			modified_lines++;

			temp_ptr=strtok(input_buffer,";");
			fputs(temp_ptr,fpout);

			/* all service definitions default to be non-volatile */
			fputs(";0;",fpout);

			temp_ptr=strtok(NULL,"\n");
			fputs(temp_ptr,fpout);

			fputs("\n",fpout);
		        }
	        }


	fclose(fpin);
	fclose(fpout);

	printf("Copied a total of %d lines, of which %d (service definitions) were modified...\n",total_lines,modified_lines);
	printf("\n");
	printf("Done.\n");

	return 0;
        }
