%{!?custom:%global custom 0}

%define archive netsaint-plugins

%if %custom
%define name %{archive}-custom
%else
%define name %{archive}
%endif

%define version 1.2.9
%define release 3
%define source http://netsaintplug.sourceforge.net/src/%{archive}-%{version}-%{release}.tar.gz

Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Source: %{source}
BuildRoot: %{_tmppath}/%{name}-buildroot
Prefix: %{_prefix}/lib/netsaint/plugins
Vendor: Netsaint Plugin Development Group
Packager: Karl DeBisschop <karl@debisschop.net>
%if %custom
Obsoletes: netsaint-plugins netsaint-plugins-extras
%else
Obsoletes: netsaint-plugins-custom
%endif
AutoReqProv: no
Summary: Host/service/network monitoring program plugins for NetSaint
Group: Applications/System


%description

NetSaint is a program that will monitor hosts and services on your
network, and to email or page you when a problem arises or is
resolved. NetSaint runs on a unix server as a background or daemon
process, intermittently running checks on various services that you
specify. The actual service checks are performed by separate "plugin"
programs which return the status of the checks to NetSaint.

This package contains the basic plugins necessary for use with the
NetSaint package.  This package should install cleanly on almost any
RPM-based system.


%package extras
Summary: Plugins which depend on the presence of other packages
Group: Applications/System

%description extras

NetSaint is a program that will monitor hosts and services on your
network, and to email or page you when a problem arises or is
resolved. NetSaint runs on a unix server as a background or daemon
process, intermittently running checks on various services that you
specify. The actual service checks are performed by separate "plugin"
programs which return the status of the checks to NetSaint.

This package contains plugins which use additional libraries or system
calls that are not installed on all systems.  As a result, most users
will need to install the '--nodeps' option when invoking `rpm`


%prep
%setup -q -n %{archive}-%{version}-%{release}


%build
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./configure \
--prefix=%{_prefix}/lib/netsaint/plugins \
--libexecdir=%{_prefix}/lib/netsaint/plugins \
--with-cgiurl=/netsaint/cgi-bin
make


%install
make AM_INSTALL_PROGRAM_FLAGS="" DESTDIR=${RPM_BUILD_ROOT} install
install -d ${RPM_BUILD_ROOT}/etc/netsaint
install -m 664 command.cfg ${RPM_BUILD_ROOT}/etc/netsaint

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
%config(missingok,noreplace) /etc/netsaint/command.cfg
%doc AUTHORS COPYING ChangeLog FAQ INSTALL NEWS README REQUIREMENTS 
%doc command.cfg
%defattr(755,root,root)
%dir %{_prefix}/lib/netsaint/plugins
%if %custom
%{_prefix}/lib/netsaint/plugins/*
%else
%{_prefix}/lib/netsaint/plugins/check_by_ssh
%{_prefix}/lib/netsaint/plugins/check_breeze
%{_prefix}/lib/netsaint/plugins/check_disk
%{_prefix}/lib/netsaint/plugins/check_disk_smb
%{_prefix}/lib/netsaint/plugins/check_dns
%{_prefix}/lib/netsaint/plugins/check_dummy
%{_prefix}/lib/netsaint/plugins/check_flexlm
%{_prefix}/lib/netsaint/plugins/check_ftp
%{_prefix}/lib/netsaint/plugins/check_http
%{_prefix}/lib/netsaint/plugins/check_imap
%{_prefix}/lib/netsaint/plugins/check_ircd
%{_prefix}/lib/netsaint/plugins/check_load
%{_prefix}/lib/netsaint/plugins/check_log
%{_prefix}/lib/netsaint/plugins/check_mrtg
%{_prefix}/lib/netsaint/plugins/check_mrtgtraf
%{_prefix}/lib/netsaint/plugins/check_netsaint
%{_prefix}/lib/netsaint/plugins/check_nntp
%{_prefix}/lib/netsaint/plugins/check_ntp
%{_prefix}/lib/netsaint/plugins/check_nwstat
%{_prefix}/lib/netsaint/plugins/check_oracle
%{_prefix}/lib/netsaint/plugins/check_overcr
%{_prefix}/lib/netsaint/plugins/check_ping
%{_prefix}/lib/netsaint/plugins/check_pop
%{_prefix}/lib/netsaint/plugins/check_procs
%{_prefix}/lib/netsaint/plugins/check_real
%{_prefix}/lib/netsaint/plugins/check_rpc
%{_prefix}/lib/netsaint/plugins/check_sensors
%{_prefix}/lib/netsaint/plugins/check_smtp
%{_prefix}/lib/netsaint/plugins/check_ssh
%{_prefix}/lib/netsaint/plugins/check_swap
%{_prefix}/lib/netsaint/plugins/check_tcp
%{_prefix}/lib/netsaint/plugins/check_time
%{_prefix}/lib/netsaint/plugins/check_udp
%{_prefix}/lib/netsaint/plugins/check_ups
%{_prefix}/lib/netsaint/plugins/check_users
%{_prefix}/lib/netsaint/plugins/check_vsz
%{_prefix}/lib/netsaint/plugins/check_wave
%{_prefix}/lib/netsaint/plugins/utils.pm
%{_prefix}/lib/netsaint/plugins/utils.sh
%{_prefix}/lib/netsaint/plugins/urlize
%endif

%if ! %custom
%files extras
%defattr(755,root,root)
%{_prefix}/lib/netsaint/plugins/check_fping
%{_prefix}/lib/netsaint/plugins/check_game
%{_prefix}/lib/netsaint/plugins/check_ldap
%{_prefix}/lib/netsaint/plugins/check_mysql
%{_prefix}/lib/netsaint/plugins/check_pgsql
%{_prefix}/lib/netsaint/plugins/check_radius
%{_prefix}/lib/netsaint/plugins/check_snmp
%{_prefix}/lib/netsaint/plugins/check_hpjd

%endif

%changelog
* Wed Feb 07 2001 Karl DeBisschop <karl@debisschop.net> (1.2.9-2)
- Upstream release (bug fixes: check_dns, OpenBSD ps, debian packaging,
  SunOS ps and df, provide snprintf, --port for check_by_ssh).
- Sign RPMs
- Add AUTHORS, FAQ, and NEWS to documentation

* Wed Jan 17 2001 Karl DeBisschop <karl@debisschop.net> (1.2.9-1)
- switch from /usr/libexec to /usr/lib because FHS has no libexec
- use 'custom' macro define to merge with netsaint-plugins-custom spec
- add check_game to extras, move check_by_ssh out of extras

* Mon Jun 26 2000 Karl DeBisschop <karl@debisschop.net>
- Release 1.2.8-4 (check_ping bug fix)
- use bzip2 insted of gzip for mandrake compatibility

* Thu Jun 22 2000 Karl DeBisschop <karl@debisschop.net>
- Release 1.2.8-3 (bug fixes)
- Add macros to spec where possible

* Fri Jun 16 2000 Karl DeBisschop <karl@debisschop.net>
- Release 1.2.8-2 (bug fixes)

* Fri Jun 09 2000 Karl DeBisschop <karl@debisschop.net>
- Release to 1.2.8

* Wed Jun 07 2000 Karl DeBisschop <karl@debisschop.net>
- Upgrade to 1.2.8pre7

* Sat Jun 03 2000 Karl DeBisschop <karl@debisschop.net>
- Upgraded to 1.2.8pre5
- use RPM_OPT_FALGS to set compiler options
- cahneg group to Applications/System

* Fri May 19 2000 Karl DeBisschop <karl@debisschop.net>
- Upgraded to 1.2.8pre3 (release-3)

* Mon Mar 20 2000 Karl DeBisschop <karl@debisschop.net>
- Upgraded to 1.2.8b2

* Tue Dec 14 1999 Adam Jacob <adam@cybertrails.com> (1.2.7-1cvs)
- Upgraded package from 1.2.6 to 1.2.7 from the latest CVS code
- Modified SPEC file to contain the proper build_root stuff. :)

* Tue Oct 19 1999 Mike McHenry <mmchen@minn.net> (1.2.6)
- Upgraded package from 1.2.4 to 1.2.6
- Resolved dependancy issue with libpq.so
- Added support for check_fping

* Fri Sep 03 1999 Mike McHenry <mmchen@minn.net> (1.2.4)
- Upgraded package from 1.2.2 to 1.2.4

* Mon Aug 16 1999 Mike McHenry <mmchen@minn.net> (1.2.2)
- First RPM build (1.2.2)
