/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.IllegalComponentStateException;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.peer.TextComponentPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TextComponent
extends Component {
    String text;
    boolean editable = true;
    int selectionStart;
    int selectionEnd;
    protected transient TextListener textListener;
    private static final long serialVersionUID = -2214773872412987419L;
    private int textComponentSerializedDataVersion = 1;

    TextComponent(String string) {
        this.text = string;
        this.setCursor(Cursor.getPredefinedCursor(2));
    }

    public void removeNotify() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.text = textComponentPeer.getText();
            this.selectionStart = textComponentPeer.getSelectionStart();
            this.selectionEnd = textComponentPeer.getSelectionEnd();
        }
        super.removeNotify();
    }

    public synchronized void setText(String string) {
        this.text = string;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.setText(string);
        }
    }

    public synchronized String getText() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.text = textComponentPeer.getText();
        }
        return this.text;
    }

    public synchronized String getSelectedText() {
        return this.getText().substring(this.getSelectionStart(), this.getSelectionEnd());
    }

    public boolean isEditable() {
        return this.editable;
    }

    public synchronized void setEditable(boolean bl) {
        this.editable = bl;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.setEditable(bl);
        }
    }

    public synchronized int getSelectionStart() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.selectionStart = textComponentPeer.getSelectionStart();
        }
        return this.selectionStart;
    }

    public synchronized void setSelectionStart(int n) {
        this.select(n, this.getSelectionEnd());
    }

    public synchronized int getSelectionEnd() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.selectionEnd = textComponentPeer.getSelectionEnd();
        }
        return this.selectionEnd;
    }

    public synchronized void setSelectionEnd(int n) {
        this.select(this.getSelectionStart(), n);
    }

    public synchronized void select(int n, int n2) {
        String string = this.getText();
        if (n < 0) {
            n = 0;
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n2 < n) {
            n2 = n;
        }
        if (n > n2) {
            n = n2;
        }
        this.selectionStart = n;
        this.selectionEnd = n2;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.select(n, n2);
        }
    }

    public synchronized void selectAll() {
        this.getText();
        this.selectionStart = 0;
        this.selectionEnd = this.getText().length();
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.select(this.selectionStart, this.selectionEnd);
        }
    }

    public void setCaretPosition(int n) {
        TextComponentPeer textComponentPeer;
        if (n < 0) {
            throw new IllegalArgumentException("position less than zero.");
        }
        int n2 = this.getText().length();
        if (n > n2) {
            n = n2;
        }
        if ((textComponentPeer = (TextComponentPeer)this.peer) != null) {
            textComponentPeer.setCaretPosition(n);
            return;
        }
        throw new IllegalComponentStateException("Cannot set caret position until after the peer has been created");
    }

    public int getCaretPosition() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        int n = 0;
        if (textComponentPeer != null) {
            n = textComponentPeer.getCaretPosition();
        }
        return n;
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.add(this.textListener, textListener);
        this.newEventsOnly = true;
    }

    public void removeTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, textListener);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 900) {
            return (this.eventMask & 0x400L) != 0L || this.textListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TextEvent) {
            this.processTextEvent((TextEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processTextEvent(TextEvent textEvent) {
        if (this.textListener != null) {
            int n = textEvent.getID();
            switch (n) {
                case 900: {
                    this.textListener.textValueChanged(textEvent);
                    return;
                }
            }
        }
    }

    protected String paramString() {
        String string = String.valueOf(super.paramString()) + ",text=" + this.getText();
        if (this.editable) {
            string = String.valueOf(string) + ",editable";
        }
        return String.valueOf(string) + ",selection=" + this.getSelectionStart() + "-" + this.getSelectionEnd();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.text = textComponentPeer.getText();
            this.selectionStart = textComponentPeer.getSelectionStart();
            this.selectionEnd = textComponentPeer.getSelectionEnd();
        }
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "textL", this.textListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            if (string == "textL") {
                this.addTextListener((TextListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }
}

