/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import sun.awt.ScreenUpdater;
import sun.awt.UpdateClient;
import sun.awt.macos.MObjectPeer;
import sun.awt.macos.MToolkit;
import sun.awt.macos.MacFontMetrics;
import sun.awt.macos.MacGraphics;
import sun.awt.macos.MacImage;

public abstract class MComponentPeer
extends MObjectPeer
implements ComponentPeer,
UpdateClient {
    Component target;
    int pData;
    int pInternationalData;
    boolean repaintPending;
    Rectangle repaintRect;
    int mOwnerPane;
    int mFont;
    int mSize;
    int mStyle;
    Color mForeColor;
    Color mBackColor;
    boolean mRecalculateClip;
    boolean mIsContainer;
    boolean mIsButton;
    boolean mIsChoice;
    boolean mIsResizableFrame;
    int mObscuredRgn;
    int mClipRgn;

    MComponentPeer(Component component) {
        this.target = component;
        this.repaintRect = new Rectangle();
        this.repaintPending = false;
        Container container = component.getParent();
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        this.setup();
        this.create(mComponentPeer);
        this.initialize();
    }

    abstract void create(MComponentPeer var1);

    void create(MComponentPeer mComponentPeer, Object object) {
        this.create(mComponentPeer);
    }

    void setup() {
        this.mForeColor = new Color(0, 0, 0);
        this.mBackColor = new Color(192, 192, 192);
        this.pSetup();
    }

    void initialize() {
        Font font;
        Rectangle rectangle = this.target.bounds();
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.target.isVisible()) {
            this.show();
        } else {
            this.hide();
        }
        Color color = this.target.getForeground();
        if (color != null) {
            this.setForeground(color);
        }
        if ((color = this.target.getBackground()) != null) {
            this.setBackground(color);
        }
        if ((font = this.target.getFont()) != null) {
            this.setFont(font);
        }
    }

    public void dispose() {
        MToolkit.targetDisposedPeer(this.target, this);
        ScreenUpdater.updater.removeClient(this);
        this.pDispose();
    }

    public ColorModel getColorModel() {
        return MToolkit.getStaticColorModel();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public Graphics getGraphics() {
        MacGraphics macGraphics = new MacGraphics(this);
        ((Graphics)macGraphics).setColor(this.target.getForeground());
        ((Graphics)macGraphics).setFont(this.target.getFont());
        return macGraphics;
    }

    public FontMetrics getFontMetrics(Font font) {
        return MacFontMetrics.getFontMetrics(font);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.show();
            return;
        }
        this.hide();
    }

    public void show() {
        this.pShow();
    }

    public void hide() {
        this.pHide();
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.enable();
            return;
        }
        this.disable();
    }

    public void enable() {
        this.pEnable();
    }

    public void disable() {
        this.pDisable();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.target.getForeground());
        graphics.setFont(this.target.getFont());
        this.target.paint(graphics);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        this.addRepaintArea(n, n2, n3, n4);
        ScreenUpdater.updater.notify(this, l);
    }

    public void updateClient(Object object) {
        Rectangle rectangle = null;
        MComponentPeer mComponentPeer = this;
        synchronized (mComponentPeer) {
            if (this.repaintPending) {
                rectangle = this.repaintRect;
                this.repaintPending = false;
            }
        }
        if (rectangle != null) {
            MToolkit.postEvent(new PaintEvent(this.target, 801, rectangle));
        }
    }

    private synchronized void addRepaintArea(int n, int n2, int n3, int n4) {
        if (!this.repaintPending) {
            this.repaintPending = true;
            this.repaintRect = new Rectangle(n, n2, n3, n4);
            return;
        }
        this.repaintRect = this.repaintRect.union(new Rectangle(n, n2, n3, n4));
    }

    public void print(Graphics graphics) {
        Dimension dimension = this.target.size();
        graphics.setColor(this.target.getForeground());
        graphics.setFont(this.target.getFont());
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        this.target.print(graphics);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.pReshape(n, n2, n3, n4);
    }

    public native void pSetForeground(Color var1);

    public synchronized void setForeground(Color color) {
        if (color instanceof SystemColor) {
            color = new Color(color.getRGB());
        }
        this.pSetForeground(color);
    }

    public native void pSetBackground(Color var1);

    public synchronized void setBackground(Color color) {
        if (color instanceof SystemColor) {
            color = new Color(color.getRGB());
        }
        this.pSetBackground(color);
    }

    public native void setFont(Font var1);

    public native void setCursor(Cursor var1);

    public native void handleEvent(AWTEvent var1);

    public Image createImage(ImageProducer imageProducer) {
        return new MacImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        return new MacImage(this.target, n, n2);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public native Point getLocationOnScreen();

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        return this.target.size();
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public native void requestFocus();

    protected void gotFocus() {
        MToolkit.postEvent(new FocusEvent(this.target, 1004));
    }

    protected void lostFocus() {
        MToolkit.postEvent(new FocusEvent(this.target, 1005));
    }

    public boolean isFocusTraversable() {
        return false;
    }

    private native void pSetup();

    private native void pShow();

    private native void pHide();

    private native void pEnable();

    private native void pDisable();

    private native void pPrint(Graphics var1);

    private native void pReshape(int var1, int var2, int var3, int var4);

    private native void pRepaint(long var1, int var3, int var4, int var5, int var6);

    private native void pDispose();

    public void finalize() {
        this.dispose();
    }

    void handleExpose() {
        Graphics graphics = this.getGraphics();
        try {
            graphics.clearRect(0, 0, this.target.getSize().width, this.target.getSize().height);
        }
        catch (NullPointerException nullPointerException) {}
        MToolkit.postEvent(new PaintEvent(this.target, 800, new Rectangle(0, 0, this.target.getSize().width, this.target.getSize().height)));
    }

    void handleRepaint(int n, int n2, int n3, int n4) {
    }

    public static int modifiersToJavaFlags(int n) {
        int n2 = 0;
        if ((n & 0x100) != 0) {
            n2 |= 4;
        }
        if ((n & 0x200) != 0) {
            n2 |= 1;
        }
        if ((n & 0x800) != 0) {
            n2 |= 8;
        }
        if ((n & 0x1000) != 0) {
            n2 |= 2;
        }
        return n2;
    }

    protected void handleKeyEvent(int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        long l = 0L;
        int n7 = MComponentPeer.modifiersToJavaFlags(n5);
        int n8 = n3;
        char c = (char)n4;
        l = System.currentTimeMillis();
        int n9 = bl ? 401 : 402;
        KeyEvent keyEvent = new KeyEvent(this.target, n9, l, n7, n8, c);
        MToolkit.addNativeEventInfo(keyEvent, n6);
        MToolkit.postEvent(keyEvent);
        if (bl && c != '\u0000') {
            n9 = 400;
            keyEvent = new KeyEvent(this.target, n9, l, n7, 0, c);
            MToolkit.addNativeEventInfo(keyEvent, n6);
            MToolkit.postEvent(keyEvent);
        }
    }

    protected void handleMouseChanged(int n, int n2, int n3, int n4, boolean bl, int n5) {
        long l = System.currentTimeMillis();
        int n6 = MComponentPeer.modifiersToJavaFlags(n3);
        int n7 = bl ? 501 : 502;
        MouseEvent mouseEvent = new MouseEvent(this.target, n7, l, n6, n, n2, n4, true);
        MToolkit.addNativeEventInfo(mouseEvent, n5);
        MToolkit.postEvent(mouseEvent);
    }

    protected void handleMouseClicked(int n, int n2, int n3, int n4, int n5) {
        long l = System.currentTimeMillis();
        int n6 = MComponentPeer.modifiersToJavaFlags(n3);
        MouseEvent mouseEvent = new MouseEvent(this.target, 500, l, n6, n, n2, n4, false);
        MToolkit.addNativeEventInfo(mouseEvent, n5);
        MToolkit.postEvent(mouseEvent);
    }

    protected void handleMouseMoved(int n, int n2, int n3, boolean bl) {
        long l = System.currentTimeMillis();
        int n4 = MComponentPeer.modifiersToJavaFlags(n3);
        int n5 = bl ? 506 : 503;
        MouseEvent mouseEvent = new MouseEvent(this.target, n5, l, n4, n, n2, 0, false);
        MToolkit.postEvent(mouseEvent);
    }

    protected void handleMouseEnter(int n, int n2, int n3) {
        long l = System.currentTimeMillis();
        int n4 = MComponentPeer.modifiersToJavaFlags(n3);
        MouseEvent mouseEvent = new MouseEvent(this.target, 504, l, n4, n, n2, 0, false);
        MToolkit.postEvent(mouseEvent);
    }

    protected void handleMouseExit(int n, int n2, int n3) {
        long l = System.currentTimeMillis();
        int n4 = MComponentPeer.modifiersToJavaFlags(n3);
        MouseEvent mouseEvent = new MouseEvent(this.target, 505, l, n4, n, n2, 0, false);
        MToolkit.postEvent(mouseEvent);
    }
}

