.\"
.\" %nmhwarning%
.\" $Id: mark.man,v 1.1.1.1 1999/04/30 18:08:37 doug Exp $
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH MARK %manext1% MH.6.8 [%nmhversion%]
.SH NAME
mark \- manipulate message sequences
.SH SYNOPSIS
.in +.5i
.ti -.5i
mark
\%[+folder] \%[msgs]
\%[\-sequence\ name\ ...]
\%[\-add]
.br
\%[\-delete] \%[\-list] 
\%[\-public] \%[\-nopublic]
\%[\-zero]
.br
\%[\-nozero]
\%[\-version]
\%[\-help]
.in -.5i
.SH DESCRIPTION
The \fImark\fR command manipulates message sequences by adding or deleting
message numbers from folder\-specific message sequences, or by listing
those sequences and messages.

A message sequence is a keyword, just like one of the \*(lqreserved\*(rq
message names, such as \*(lqfirst\*(rq or \*(lqnext\*(rq.  Unlike the
\*(lqreserved\*(rq message names, which have a fixed semantics on
a per\-folder basis, the semantics of a message sequence may be
defined, modified, and removed by the user.  Message sequences are
folder\-specific, e.g., the sequence name \*(lqseen\*(rq in the context
of folder \*(lq+inbox\*(rq need not have any relation whatsoever to the
sequence of the same name in a folder of a different name.

Three action switches direct the operation of \fImark\fR.  These switches
are mutually exclusive: the last occurrence of any of them overrides
any previous occurrence of the other two.

The `\-add' switch tells \fImark\fR to add messages to sequences or to
create a new sequence.  For each sequence named via the `\-sequence\ name'
argument (which must occur at least once) the messages named via `msgs'
(which defaults to \*(lqcur\*(rq if no `msgs' are given), are added to the
sequence.  The messages to be added need not be absent from the sequence.
If the `\-zero' switch is specified, the sequence will be emptied prior
to adding the messages.  Hence, `\-add\ \-zero' means that each sequence
should be initialized to the indicated messages, while `\-add\ \-nozero'
means that each sequence should be appended to by the indicated messages.

The `\-delete' switch tells \fImark\fR to delete messages from sequences,
and is the dual of `\-add'.  For each of the named sequences, the
named messages are removed from the sequence.  These messages need
not be already present in the sequence.  If the `\-zero' switch is
specified, then all messages in the folder are added to the sequence
(first creating the sequence, if necessary) before removing the messages.
Hence, `\-delete\ \-zero' means that each sequence should contain
all messages except those indicated, while `\-delete\ \-nozero' means
that only the indicated messages should be removed from each sequence.
As expected, the command `mark\0\-sequence\0foo\0\-delete\0all' deletes
the sequence \*(lqfoo\*(rq from the current folder.

When creating or modifying sequences, you can specify the switches
`\-public' or `\-nopublic' to force the new or modified sequences to be
\*(lqpublic\*(rq or \*(lqprivate\*(rq.  The switch `\-public' indicates
that the sequences should be made \*(lqpublic\*(rq.  These sequences
will then be readable by all \fInmh\fR users with permission to read the
relevant folders.  In contrast, the `\-nopublic' switch indicates that the
sequences should be made \*(lqprivate\*(rq, and will only be accessible by
you.  If neither of these switches is specified, then existing sequences
will maintain their current status, and new sequences will default to
\*(lqpublic\*(rq if you have write permission for the relevant folder.
Check the mh\-sequence(5) man page for more details about the difference
between \*(lqpublic\*(rq and \*(lqprivate\*(rq sequences.

The `\-list' switch tells \fImark\fR to list both the sequences defined
for the folder and the messages associated with those sequences.
\fIMark\fR will list the name of each sequence given by
`\-sequence\ name' and the messages associated with that sequence.  If the
sequence is private, this will also be indicated.  If no sequence is
specified by the `\-sequence' switch, then all sequences for this folder
will be listed.  The `\-zero' switch does not affect the operation of
`\-list'.

The current restrictions on sequences are:

.in +.25i
The name used to denote a message sequence must consist of an alphabetic
character followed by zero or more alphanumeric characters, and cannot
be one of the (reserved) message names \*(lqnew\*(rq, \*(lqfirst\*(rq,
\*(lqlast\*(rq, \*(lqall\*(rq, \*(lqnext\*(rq, or \*(lqprev\*(rq.

Only a certain number of sequences may be defined for a given folder.
This number is usually limited to 26 (10 on small systems).

Message ranges with user\-defined sequence names are restricted to the
form \*(lqname:n\*(rq, \*(lqname:+n\*(rq, or \*(lqname:-n\*(rq, and refer
to the first or last `n' messages of the sequence `name', respectively.
Constructs of the form \*(lqname1\-name2\*(rq are forbidden for user
defined sequences.
.in -.25i
.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
.Pr
^Path:~^To determine the user's nmh directory
.Ps
^Current\-Folder:~^To find the default current folder
.Sa
flist(1), pick(1), mh-sequence(5)
.De
`+folder' defaults to the current folder
.Ds
`\-add' if `\-sequence' is specified, `\-list' otherwise
.Ds
`msgs' defaults to cur (or all if `\-list' is specified)
.Ds
`\-nozero'
.Co
If a folder is given, it will become the current folder.
.Hh
Use \*(lqflist\*(rq to find folders with a given sequence, and
\*(lqpick sequence \-list\*(rq to enumerate those messages in
the sequence (such as for use by a shell script).
.En
