/*
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 * intop.h - definitions for `intop'.
 *
 * Luca Deri     <deri@ntop.org>
 * Rocco Carbone <rocco@ntop.org>
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*
 * curses management
 */
#if defined(HAVE_NCURSES_H) || defined(HAVE_CURSES_H) || defined(HAVE_LIBCURSES)
# define HAVE_CURSES

#if defined(sun)
#define __lint
#endif

# if defined(HAVE_NCURSES_H)
#  include <ncurses.h>
# else
#  if defined(HAVE_CURSES_H)
#   include <curses.h>
#  endif
# endif

# ifndef A_NORMAL
#  define A_NORMAL     000000000000L
# endif

# ifndef A_REVERSE
#  define A_REVERSE    000040000000L
# endif
#endif /* ToBeRocked */

extern char * progname;
extern time_t boottime;
extern char * prompt;
extern char * pcolor;

extern int active;
extern int previous;

/*
 * ansi-colors for prompt management
 */

#define INTOP_NORMAL   "\x1B[0m"
#define INTOP_RED      "\x1B[31m"
#define INTOP_GREEN    "\x1B[32m"
#define INTOP_YELLOW   "\x1B[33m"
#define INTOP_BLUE     "\x1B[34m"
#define INTOP_MAGENTA  "\x1B[35m"
#define INTOP_CYAN     "\x1B[36m"



#define SECS_PER_DAY   86400
#define SECS_PER_HOUR   3600
#define SECS_PER_MIN      60

#define NOW ((time_t) time ((time_t *) 0))

/*
 * Function declarations.
 */

char * intop_banner (char * interface);
char * intop_report (char * interface);

void commandloop (int fromatty, char * name);
void userprompt (char * name);

char ** buildargv (char * input);
void    freeargv (char ** vector);

void intop_init (void);

char * cformatPkts (TrafficCounter pktNr);
char * cformatBytes (TrafficCounter numBytes);

/*
 * commands.
 */
int intop_prompt     (int argc, char * argv []);

int intop_open       (int argc, char * argv []);
int intop_close      (int argc, char * argv []);
int intop_set_filter (int argc, char * argv []);
int intop_sniff      (int argc, char * argv []);
int intop_uptime     (int argc, char * argv []);
int intop_hash       (int argc, char * argv []);
int intop_info       (int argc, char * argv []);
int intop_swap       (int argc, char * argv []);
int intop_top        (int argc, char * argv []);
int intop_lsdev      (int argc, char * argv []);
int intop_last       (int argc, char * argv []);
int intop_hosts      (int argc, char * argv []);
int intop_arp        (int argc, char * argv []);
int intop_nbt        (int argc, char * argv []);
int intop_dump       (int argc, char * argv []);



/*
 * Functions in pcapmore.c
 */
u_int32_t intop_lookupaddr (char * interface);
u_int32_t intop_lookupbroadcast (char * interface);


/*
 * Functions in nettable.c
 */
int      netno ();
int      intopmalloc (char * interface, int snaplen, pcap_t * ph, char * filter);
void     intopfree (int i);
int      intop_lookup_interface (char * name);

/*
 * Function in nettable.c to lookup by index in the table of managed network interfaces.
 */
char   * intop_interface (int i);
int      get_intop_flags (int i);
int      set_intop_flags (int i, int flags);
char   * intop_ipdot (int i);
char   * intop_iphuman (int i);
u_int32_t intop_netmask (int i);
pcap_t * intop_pcap (int i);
char   * intop_dltype (int i);
char   * get_intop_filter (int i);
int      set_intop_filter (int i, char * filter);


TrafficCounter ethpkts (int i);
TrafficCounter broadcastpkts (int i);
TrafficCounter multicastpkts (int i);
TrafficCounter droppedpkts (int i);
TrafficCounter icmpbytes (int i);
TrafficCounter receivedpkts (int i);
TrafficCounter kerneldroppedpkts (int i);
TrafficCounter receivedbytes (int i);
TrafficCounter ethbytes (int i);
TrafficCounter ipbytes (int i);
TrafficCounter tcpbytes (int i);
TrafficCounter udpbytes (int i);
TrafficCounter otheripbytes (int i);
TrafficCounter icmpbytes (int i);
TrafficCounter netbiosbytes (int i);
TrafficCounter arpbytes (int i);
TrafficCounter appletalkbytes (int i);
TrafficCounter ipxbytes (int i);
TrafficCounter decnetbytes (int i);
TrafficCounter dlcbytes (int i);
TrafficCounter ospfbytes (int i);
TrafficCounter egpbytes (int i);
TrafficCounter igmpbytes (int i);
TrafficCounter osibytes (int i);
TrafficCounter qnxbytes (int i);
TrafficCounter otherbytes (int i);

NtopInterface * nethandler (int i);
NtopInterface * netnext (void);
