/*
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 * uptime.c - Tell how long the program has been running.
 *
 * Luca Deri     <deri@ntop.org>
 * Rocco Carbone <rocco@ntop.org>
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*
 * ntop header file(s)
 */
#include "ntop.h"

#include "intop.h"


/*
 * Days In Seconds.
 */
static int days (time_t t1, time_t t2)
{
  return ((t2 - t1) / SECS_PER_DAY);
}


/*
 * Hours In Seconds.
 */
static int hours (time_t t1, time_t t2)
{
  return ((t2 - t1 - (days (t1, t2) * SECS_PER_DAY)) / SECS_PER_HOUR);
}


/*
 * Minutes In Seconds.
 */
static int mins (time_t t1, time_t t2)
{
  return ((t2 - t1 - (days (t1, t2) * SECS_PER_DAY) -
	   (hours (t1, t2) * SECS_PER_HOUR)) / SECS_PER_MIN);
}


/*
 * Tell how long the program has been running.
 */
int intop_uptime (int argc, char * argv [])
{
  /*
   * Notice the command name.
   */
  char * commandname = argv [0];

  int c;
#define USAGE(xxx) \
  printf ("Usage: %s [-h]\n\
           \n", xxx)
  char * optstring = "h";

  /*
   * Reserve here space for the local variables.
   */
  time_t now = NOW;
  struct tm * tm = localtime (& now);
  NtopInterface * n;

  optind = 0;
  optarg = NULL;

  /*
   * Parse command line options to the application via standard system calls.
   */
  while ((c = getopt (argc, argv, optstring)) != -1)
    {
      switch (c)
	{
	case 'h':
	  USAGE (commandname);
	  return (0);

	default:
	  USAGE (commandname);
	  return (-1);
	}
    }

  if (optind < argc)
    {
      printf ("\nWrong option(s): \" ");
      while (optind < argc)
	printf ("%s ", argv [optind ++]);
      printf ("\"\n");
      USAGE (commandname);
      printf ("\n");
      return (-1);
    }

  printf ("%2d:%02d%s   up %3d days, %2d:%02d:%02d,    %d interface%s\n\n",
	  tm -> tm_hour % 12,
	  tm -> tm_min,
	  tm -> tm_hour > 12 ? "pm" : "am",
	  days (boottime, now),
	  hours (boottime, now),
	  mins (boottime, now),
	  (int) (now - boottime) % 60,
	  netno (), netno () > 1 ? "s" : "");

  while ((n = netnext()))
    printf ("(%s) -- %s [%s],   %d hosts,   %s Pkts / %s\n",
	    n -> name, n -> fqdn, n -> ipdot,
	    n -> hostsno,
	    cformatPkts (n -> ethernetPkts),
	    cformatBytes (n -> ethernetBytes));

  fflush (stdout);

  return (0);
}
