#!/bin/sh
#
# (C) 2001-2002 by Luca Deri <deri@ntop.org>
#

# Are we in the "right" directory?
gdchart=`(pwd | grep gdchart0.94c)`
if test ".${gdchart}" = "."; then
    echo ""
    echo "Sorry, but this script needs to be run in the gdchart0.94c directory"
    echo ""
    exit 1
fi

#  If we're running RedHat with their "fixed" version of libpng, 1.0.14,
#  then we need to remove the version in this tree. 

echo ""
echo "Testing for libpng 1.0.14 v 1.2.4 conflict"
echo ""

if test -d /usr &&
   test -d /usr/include &&
   test -f /usr/include/png.h &&
   test -d /usr/lib &&
   test -f /usr/lib/libpng.so.2.1.0.14; then
    echo ""
    echo "Note:  You have libpng 1.0.14 installed (typical with RedHat 7.x)"
    echo "       Removing libpng 1.2.4 from the ntop source tree to prevent conflicts"
    echo ""
    echo ""
    remove_libpng124=yes
    rm -rf gd-1.8.3/libpng-1.2.4
else
    remove_libpng124=no
fi

echo ""
echo "Testing for gcc..."
which gcc > /dev/null
gccrc=$?
if test "${gccrc}" = "1"; then
    echo "    Note: no gcc, using cc!"
else
    echo "    OK!"
fi  
echo ""

echo ""
echo "Configuring gdchart..."
echo ""
./configure

echo ""
echo "Configuring and making zlib..."
echo ""
cd zlib-1.1.4/
./configure
make 

cd ../gd-1.8.3

if test ".${remove_libpng124}" != ".yes" &&
   test -d libpng-1.2.4; then
    echo ""
    echo "Configuring and making libpng..."
    echo ""
    cd libpng-1.2.4
    #
    # If you're using Mac OS X you
    # need to change makefile.gcc with
    # makefile.macosx
    #
    # Linux: use gcc not linux
    #
    
    mfn="gcc"
    
    if test -f /usr/bin/uname; then
    
        case `uname` in
          *solaris* )
             mfn="solaris"
             ;;
    
          *arwin* )
             mfn="macosx"
             ;;

          *OpenBSD* )
             mfn="openbsd"
             ;;
    
        esac
    fi
    
    ZLIBLIB=../../zlib-1.1.4
    ZLIBINC=../../zlib-1.1.4
    export ZLIBLIB ZLIBINC
    make -e -f scripts/makefile.${mfn}
    unset ZLIBLIB
    unset ZLIBINC
    
    cd ../
fi

if test "${gccrc}" = "1"; then
    echo ""
    echo "Making gd (with cc compiler)..."
    echo ""
    make COMPILER=cc
fi

cd ../
echo ""
echo "Making gdchart (and gd)..."
echo ""
make

#
# Just to be safe...
#
if test -f /usr/bin/uname; then
if /usr/bin/uname | grep Darwin > /dev/null; then
find . -name "*.a" -exec ranlib {} > /dev/null ';'
fi
fi

echo
echo "NOTE:"
echo "On some systems you need to do 'make install'"
echo "for each of the packages contained here."

