#
# fmthtml.pl - common subrotines to facilitate the dynamic creation
#              of html pages from PeP scripts.
#
# Copyright (C) 2003 Rocco Carbone <rocco@ntop.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING. If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#

#
# print HTML header and title
#
sub html_header {
  my $titlepage = shift;

  #
  # immediately start printing the magic line which tells to the world
  # we are playing with an HTML document
  #
  print "Content-type: text/html\n";
  print "Cache-Control: no-cache\n";
  print "Expires: 0\n\n";

  print
    "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n",
    "<html>\n",
    "<!-- ntop statistic page -->\n",
    "<!-- Rocco Carbone <rocco\@ntop.org> -->\n",
    "<head>\n",
    "<link rel=stylesheet href=/style.css type=\"text/css\">\n",
    "<meta http-equiv=Pragma content=no-cache>\n",
    "<meta http-equiv=Cache-Control content=no-cache>\n",
    "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">",
    "<meta name=\"robots\" content=\"ntop statistics\">\n",
    "<meta name=\"keywords\" content=\"ntop\">\n",
    "</head>\n",
    "<title>$titlepage</title>\n";
}


#
# start printing HTML body
#
sub html_start_body {
  my $title = shift;

  print "<body bgcolor=#ffffff text=#000000 link=#1111cc vlink=#cc0000 alink=#888888>\n";
  print "<center>\n";
  print "<table border=0 cellpadding=1 cellspacing=2>\n";
  print "<tr>\n";
  print "<td align=center>\n";
  print "<a href=\"/plugins/pep?available.pl\">all available scripts</a>\n";
  print "</td>\n";
  print "<td align=center>\n";
  print "<a href=\"/plugins/pep?$__progname__\">reload</a>\n";
  print "</td>\n";
  print "<td width=15></td>\n";
  print "<td align=center>\n";
  print "</td>\n";
  print "</tr>\n";
  print "</table>\n";
}


#
# finish printing HTML body (aka footer)
#
sub html_stop_body {
  print "<p>\n";
  print "Generated by $__progname__ version $__version__\n";
  print "</p>\n";
  print "<table border=0 cellpadding=1 cellspacing=2>\n";
  print "<tr>\n";
  print "<td align=left>\n";
  print "<font size=2>\n";
  print "Questions or comments: <a href=\"mailto:rocco\@ntop.org\"</a><br>\n";
  print "&copy; 2000-2003 by Rocco Carbone - Updated $__updated__\n";
  print "</font>\n";
  print "</td>\n";
  print "</tr>\n";
  print "</table>\n";
  print "</center>\n";
  print "</body>\n";
  print "</html>\n";
}

1;
