/*
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 * pep.c - Perl embedded Plugin - my first ntop plugin is here.
 *
 * Rocco Carbone <rocco@ntop.org>
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "ntop.h"

#include <EXTERN.h>   /* from the Perl distribution */
#include <perl.h>     /* from the Perl distribution */

static void byepep (void);
static void run_perl_script (char * url);


static PluginInfo plugininfo [] =
{
  {
    "Pep (Perl embedded Plugin)",             /* full name */
                                              /* its brief description */
    "Perl embedded Plugin for ntop - (c) 2000-2003 R. Carbone, released under GPL",
    "0.3",                                    /* version */
    "R. Carbone <rocco@ntop.org>",            /* author */
    "pep",                                    /* http://<host>:<port>/plugins/shortPluginName */
    0,                                        /* active */
    0,                                        /* inactive setup */
    NULL,                                     /* no special startup after initialization */
    byepep,                                   /* termination */
    NULL,                                     /* main */
    run_perl_script,                          /* handler for all the HTTP requests */
    NULL,                                     /* no BPF filter */
    NULL                                      /* no status */
  }
};



/*
 * a private instance of Perl
 */
static PerlInterpreter * pep_perl = NULL;


/*
 * called when Pep is being terminated
 */
static void byepep (void)
{
  /*
   * free the previously allocated perl instance
   */
  perl_destruct (pep_perl);
  perl_free (pep_perl);
  pep_perl = NULL;

  traceEvent (CONST_TRACE_INFO, "Thanks for having used PeP ...\n");
}


/*
 * handle HTTP requests
 */
static void run_perl_script (char * url)
{
  HV * traffic = NULL;  /* the %traffic hash */

  AV * ss = NULL;       /* the @sorttypes */
  AV * ff = NULL;       /* the @reporttypes */
  SV * val = NULL;

  static int pep_argc = 2;
  static char * pep_argv [] = { "", "" };

  static char script_dir [] = "plugins/pep/";

  char * pep_script = "available.pl";
  char filename [BUFSIZ];

  int i;
  int current = 0;
  HostTraffic * ht = NULL;

  char buf [BUFSIZ] = {0};
  char script [BUFSIZ] = {0};
  char sort [BUFSIZ] = {0};
  char field [BUFSIZ] = {0};

  pid_t childpid;

  pep_argv [1] = filename;

  memset (script, '\0', BUFSIZ);
  memset (sort, '\0', BUFSIZ);
  memset (field, '\0', BUFSIZ);

  if (url && * url)
    {
      traceEvent (CONST_TRACE_INFO, "PeP Request for url %s\n", url);

      strcpy (buf, url);

      /*
       * decode the parameters via the 'url' variable
       */
      if (sscanf (buf, "search=%[^&]%s", script, field) == 2)
	{
	  traceEvent (CONST_TRACE_INFO, "PeP Request for %s with params %s\n", script, field);

	  pep_script = script;
	  sprintf (sort, "PEP_QUERY_STRING=%s", field);
	  putenv (sort);
	}
      else if (sscanf (buf, "%[^&]&sort=%[^&]&field=%s", script, sort, field) == 3)
	{
	  pep_script = script;
	}
      else if (sscanf (buf, "%s", script) == 1)
	{
	  pep_script = script;
	}
      else
	{
	  pep_script = url;
	}
    }

  strcpy (filename, script_dir);
  strcat (filename, pep_script);

  childpid = fork ();
  switch (childpid)
    {
    case -1:
      /* error */
      return;

    default:
      /* parent */
      return;

    case 0:
      /* child */
      break;
    }

  close (0);
  close (1);
  close (2);

  dup (myGlobals . newSock);
  dup (myGlobals . newSock);
  dup (myGlobals . newSock);

  close (myGlobals . newSock);


  /*
   * compile the file
   */
  perl_parse (pep_perl, NULL, pep_argc, pep_argv, NULL);

  /*
   * create a new variable, the %traffic hash
   */
  traffic = perl_get_hv ("main::traffic", TRUE);

  /*
   * create two new variables, the @sorttypes and @reporttypes arrays
   */
  ss = perl_get_av ("main::sorttypes", TRUE);
  ff = perl_get_av ("main::reporttypes", TRUE);
  if (! strcmp (sort, "descending"))
    {
      val = newSVpv ("descending", strlen ("descending"));
      av_store (ss, 0, val);

      if (! * field)
	strcpy (field, "hwaddress");

      val = newSVpv (field, strlen (field));
      av_store (ff, 0, val);
    }
  else
    {
      val = newSVpv ("ascending", strlen ("ascending"));
      av_store (ss, 0, val);

      val = newSVpv (field, strlen (field));
      av_store (ff, 0, val);
    }

  /*
   * and populate the %traffic hash variable
   */
  for (i = 1; i < myGlobals . device [current] . actualHashSize; i ++)
    {
      char name [BUFSIZ] = {0};
      HV * unique = NULL;              /* an unique hash referenced by the %traffic value */

      /*
       * Skip unused entries.
       */
      if (! (ht = myGlobals . device [current] . hash_hostTraffic [i]))
	continue;

      /*
       * Skip broadcast entries.
       */
      if (broadcastHost (ht))
	continue;

      /*
       * Skip remote host entries.
       */
      if (! * ht -> ethAddressString || ! strcmp (ht -> ethAddressString, "0.0.0.0"))
	continue;


      /*
       * Good. I have the key to build an unique hash using 'ethAddressString' as its name.
       */

      /*
       * create a new variable, the %ht->ethAddressString unique hash
       */
      sprintf (name, "main::%s", ht -> ethAddressString);
      unique = perl_get_hv (name, TRUE);

      /*
       * populate the %traffic hash
       * key   = ethAddressString
       * value = the reference to the newly created hash
       */
      hv_store (traffic, ht -> ethAddressString, strlen (ht -> ethAddressString),
		newRV_inc ((SV *) unique), 0);

      /*
       * and now populate the %ht->ethAddressString unique hash
       */

      /* (1) hw address */
      val = newSVpv (ht -> ethAddressString, strlen (ht -> ethAddressString));
      hv_store (unique, "hwaddress", strlen ("hwaddress"), val, 0);

      /* (2) vendor */
      if (ht -> ethAddress && * ht -> ethAddress)
	val = newSVpv (getVendorInfo (ht -> ethAddress, 0),
		       strlen (getVendorInfo (ht -> ethAddress, 0)));
      else
	val = newSVpv (" ", strlen (" "));
      hv_store (unique, "vendor", strlen ("vendor"), val, 0);

      /* (3) ipaddress */
      if (! strcmp (intoa (ht -> hostIpAddress), "0.0.0.0"))
	val = newSVpv ("IP-less", strlen ("IP-less"));
      else
	val = newSVpv (intoa (ht -> hostIpAddress), strlen (intoa (ht -> hostIpAddress)));
      hv_store (unique, "ipaddress", strlen ("ipaddress"), val, 0);

      /* (4) hostname */
      if (ht -> hostSymIpAddress && * ht -> hostSymIpAddress)
	{
	  if (strcmp (ht -> hostSymIpAddress, intoa (ht -> hostIpAddress)))
	    val = newSVpv (ht -> hostSymIpAddress, strlen (ht -> hostSymIpAddress));
	  else
	    val = newSVpv (" unresolved", strlen (" unresolved"));
	}
      else
	val = newSVpv (" ", strlen (" "));
      hv_store (unique, "hostname", strlen ("hostname"), val, 0);

      /* (5) domain */
      if (ht -> dotDomainName && * ht -> dotDomainName)
	val = newSVpv (ht -> dotDomainName, strlen (ht -> dotDomainName));
      else
	val = newSVpv (" ", strlen (" "));
      hv_store (unique, "domain", strlen ("domain"), val, 0);

      /* (6) nbname */
      if (ht -> nonIPTraffic && ht -> nonIPTraffic -> nbHostName && * ht -> nonIPTraffic -> nbHostName)
	val = newSVpv (ht -> nonIPTraffic -> nbHostName, strlen (ht -> nonIPTraffic -> nbHostName));
      else
	val = newSVpv (" ", strlen (" "));
      hv_store (unique, "nbname", strlen ("nbname"), val, 0);

      /* (7) nbdomain */
      if (ht -> nonIPTraffic && ht -> nonIPTraffic -> nbDomainName && * ht -> nonIPTraffic -> nbDomainName)
	val = newSVpv (ht -> nonIPTraffic -> nbDomainName, strlen (ht -> nonIPTraffic -> nbDomainName));
      else
	val = newSVpv (" ", strlen (" "));
      hv_store (unique, "nbdomain", strlen ("nbdomain"), val, 0);

      /* (8) AppleTalk */
      if (ht -> nonIPTraffic && ht -> nonIPTraffic -> atNodeName && * ht -> nonIPTraffic -> atNodeName)
	val = newSVpv (ht -> nonIPTraffic -> atNodeName, strlen (ht -> nonIPTraffic -> atNodeName));
      else
	val = newSVpv (" ", strlen (" "));
      hv_store (unique, "atname", strlen ("atname"), val, 0);

      /* (9) IPX */
      if (ht -> nonIPTraffic && ht -> nonIPTraffic -> ipxHostName && * ht -> nonIPTraffic -> ipxHostName)
	val = newSVpv (ht -> nonIPTraffic -> ipxHostName, strlen (ht -> nonIPTraffic -> ipxHostName));
      else
	val = newSVpv (" ", strlen (" "));
      hv_store (unique, "ipxname", strlen ("ipxname"), val, 0);

      /* (10) first seen */
      val = newSVnv (ht -> firstSeen);
      hv_store (unique, "firstseen", strlen ("firstseen"), val, 0);

      /* (11) last seen */
      val = newSVnv (ht -> lastSeen);
      hv_store (unique, "lastseen", strlen ("lastseen"), val, 0);

      /* (12) packet sent */
      val = newSVnv (ht -> pktSent . value);
      hv_store (unique, "pktsent", strlen ("pktsent"), val, 0);

      /* (13) packet received */
      val = newSVnv (ht -> pktRcvd . value);
      hv_store (unique, "pktreceived", strlen ("pktreceived"), val, 0);

      /* (14) bytes sent */
      val = newSVnv (ht -> bytesSent . value);
      hv_store (unique, "bytessent", strlen ("bytessent"), val, 0);

      /* (15) bytes received */
      val = newSVnv (ht -> bytesRcvd . value);
      hv_store (unique, "bytesreceived", strlen ("bytesreceived"), val, 0);

      /* (16) broadcast packets sent */
      val = newSVnv (ht -> pktBroadcastSent . value);
      hv_store (unique, "pktbroadcastsent", strlen ("pktbroadcastsent"), val, 0);

      /* (17) broadcast bytes sent */
      val = newSVnv (ht -> bytesBroadcastSent . value);
      hv_store (unique, "bytesbroadcastsent", strlen ("bytesbroadcastsent"), val, 0);

      /* (18) multicast packets sent */
      val = newSVnv (ht -> pktMulticastSent . value);
      hv_store (unique, "pktmulticastsent", strlen ("pktmulticastsent"), val, 0);

      /* (19) multicast bytes sent */
      val = newSVnv (ht -> bytesMulticastSent . value);
      hv_store (unique, "bytesmulticastsent", strlen ("bytesmulticastsent"), val, 0);

      /* (20) multicast packets received */
      val = newSVnv (ht -> pktMulticastRcvd . value);
      hv_store (unique, "pktmulticastrcvd", strlen ("pktmulticastrcvd"), val, 0);

      /* (21) multicast bytes received */
      val = newSVnv (ht -> bytesMulticastRcvd . value);
      hv_store (unique, "bytesmulticastrcvd", strlen ("bytesmulticastrcvd"), val, 0);
    }

  /*
   * HTTP Protocol Header
   */
  printf ("HTTP/1.0 200 OK\n");
  printf ("Server: ntop/%s (%s)\n", version, osName);

  /*
   * and then execute the script
   */
  perl_run (pep_perl);

   if (traffic)
    hv_undef (traffic);
   if (ss)
    av_undef (ss);
  if (ff)
    av_undef (ff);

  /*
   * Done. See you on the CNN.
   */
  exit (0);
}


/*
 * PeP initialization function
 */
PluginInfo * PluginEntryFctn (void)
{
  traceEvent (CONST_TRACE_INFO, "\n");
  traceEvent (CONST_TRACE_INFO, "Welcome to %s (c) 2000-2003 %s.\n",
	      plugininfo -> pluginName, plugininfo -> pluginAuthor);
  traceEvent (CONST_TRACE_INFO, "\n");

  /*
   * initialization: allocate a private instance of the Perl Interpreter
   */
  pep_perl = perl_alloc ();
  perl_construct (pep_perl);

  return (plugininfo);
}
