#
# render.pl - a rudimental rendering engine to display PeP's tables.
#
# Copyright (C) 2003 Rocco Carbone <rocco@ntop.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING. If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#


#
# Print the table header
#
sub table_header {

  my ($color, $cols, $title, $subtitle) = @_;

  $title =~ s/ /\&nbsp;/g;         # replace blanks for html rendering
  $subtitle =~ s/ /\&nbsp;/g;      # replace blanks for html rendering

  print
    "<tr>
      <td bgcolor=$color->{colors}{forte} valign=top>
       <div align=left><img height=\"30\" src=$color->{images}{left} width=\"12\"></div>
      </td>
      <td align=center bgcolor=$color->{colors}{forte} ";
  if ($cols > 2) {
    my $colspan = $cols - 2;
    print "colspan=\"$colspan\"";
  }
  print ">
       <div align=center><font face=\"Arial, sans-serif\" size=-1>
        <b>$title<br></b>$subtitle</font>
       </div>
      </td>
      <td bgcolor=$color->{colors}{forte} valign=top>
        <div align=right><img height=30 src=$color->{images}{right} width=\"12\"></div>
      </td>
     </tr>";
}


#
# Print the description of row of a table.
#
# $fields is a reference to an array containing the keys of the columns.
#
sub table_row_description {

  my ($bg, $fields) = @_;

  my $face = "arial";

  print "<tr bgcolor=$bg>";

  print
    "<td height=12pt width=\"6%\" align=center>
      <font face=$face><b>&nbsp;#</b></font>
     </td>";

  my $kk = scalar @$fields;
  for ($jj = 0; $jj < $kk; $jj += 3) {
    print
      "<td height=12pt width=@$fields[$jj + 1] align=@$fields[$jj + 2]>
        <font face=$face size=-1>&nbsp;@$fields[$jj + 0]</font>
       </td>";
  }

  print "</tr>";
}

#
# Print a row of a table.
#
# $a is a reference to an array where:
#  the first element is always the "info"
#  the second element specifies the "width"
#  the third element specifies the "alignment"
#
sub table_row {

  my ($bg, $i, $a) = @_;

  my $face = "arial";

  print "<tr bgcolor=$bg>";

  print
    "<td height=12pt width=\"6%\" align=center>
      <font face=$face><b>&nbsp;$i.</b></font>
     </td>";

  foreach $e (@$a) {

    $e->[0] =~ s/ /\&nbsp;/g;      # replace blanks for html rendering

    print
      "<td height=12pt width=$e->[1] align=$e->[2]>
        <font face=$face size=-1>&nbsp;$e->[0]</font>
       </td>";
  }
    print "</tr>";
}


#
# Table footer
#
sub table_footer {

  my ($cols, $color) = @_;

  print
    "<tr>
      <td colspan=$cols><img valign=top height=\"9\" hspace=\"0\" src=$color width=100%></td>
     </tr>";
}


#
# Print a Table.
#
# $a is a reference to the array of the references to the hashes with the values
# $fields is a reference to the array of the keys to print
# $size is the size of the table in pixel
# $color is a reference to the hash with the specification of the colors and images to use
# $sorted is ...
#
sub table_print {

  my ($a, $fields, $size, $color, $title, $subtitle) = @_;

  if (! ref $a) {
    return;
  }

  print "<table bgcolor=$color->{colors}{bg} border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"$size\">";

  $cols = 1 + scalar @$fields / 3;

  #
  # this is the header of the table that is in turn another table
  # (1 row and 3 cols) with two small images at the left and right size
  # and a title and a subtitle in the middle (centered)
  #
  table_header($color, $cols, $title, $subtitle);

  my $i = 0;
  my $k = scalar @{$color->{rowcolors}};

  # the row for the description 
  table_row_description($color->{rowcolors}[1], $fields);

  # and now print a table with all the information
  foreach my $e (@$a) {

    # @rows is the array to the values to print in a row
    my @rows = ();

    my $kk = scalar @$fields;

    for ($jj = 0; $jj < $kk; $jj += 3) {

      my $info;
      #
      # special case to manage firstseen and lastseeen dates
      #
      if ($fields->[$jj + 0] eq "firstseen" || $fields->[$jj + 0] eq "lastseen") {
	$info = seen($e->{$fields->[$jj]});
      }
      else {
	$info = $e->{$fields->[$jj]};
      }

      my @specs = ($info, $fields->[$jj + 1], $fields->[$jj + 2]);

      @rows = (@rows, \@specs);
    }

    table_row($color->{rowcolors}[$i % $k], ++ $i, \@rows, $cols);
  }

  table_footer($cols, $color->{images}{bottom});

  print "</table>";
}


#
# Print a matrix of tables.
#
# $v is the reference to the array of all the tables to display
# $cols is the # of columns
# $size is the size of the table in pixel
#
sub print_matrix {

  my ($v, $cols, $size) = @_;

  #
  # what should be displayed
  #
  my @views = @$v;

  my ($i, $j);

  # how many rows in the matrix of tables?
  my $rows = int(($#views + 1) / $cols);
  if (($#views + 1) % $cols) {
    $rows++;
  }

  print "<table border=\"0\" cellpadding=\"6\" cellspacing=\"0\" width=\"100%\">";

  for ($i = 0; $i < $rows; $i ++) {
    print "<tr>";
    for ($j = 0; $j < $cols; $j ++) {
      print "<td valign=top>";
      table_print($views[$i * $cols + $j]->{vals},
		  $views[$i * $cols + $j]->{fields},
		  $size, $views[$i * $cols + $j]->{color},
		  $views[$i * $cols + $j]->{title},
		  $views[$i * $cols + $j]->{subtitle});
      print "</td>";
    }
    print "</tr>";
  }
  print "</table>";
}

1;
