/*
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 * dump.c - Enable/Disable verbosity flags.
 *
 * Luca Deri     <deri@ntop.org>
 * Rocco Carbone <rocco@ntop.org>
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*
 * ntop header file(s)
 */
#include "ntop.h"

#include "intop.h"



/*
 * Get/Set Packets dump.
 */
int intop_dump (int argc, char * argv [])
{
  /*
   * Notice the command name.
   */
  char * commandname = argv [0];

  int c;
#define USAGE(xxx) \
  printf ("Usage: %s [-h] [-i interface] [-f filename] [-A] [-R] [-H] [-E] [-I] [-T]\n", xxx)
  char * optstring = "hi:f:ARHEIT";

  /*
   * Reserve here space for the local variables.
   */
  char * interface = NULL;
  int current;
  NtopInterface * n;

  static int hflag = 0;
  static int eflag = 0;
  static int iflag = 0;
  static int tflag = 0;
  static FILE * fd = NULL;

  optind = 0;
  optarg = NULL;

  /*
   * Parse command line options to the application via standard system calls.
   */
  while ((c = getopt (argc, argv, optstring)) != -1)
    {
      switch (c)
	{
	case 'h':
	  USAGE (commandname);
	  return (0);

	default:
	  USAGE (commandname);
	  return (-1);

	case 'i':
	  interface = optarg;
	  break;

	case 'f':
	  if (! strcmp (optarg, "-"))
	    fd = stdout;
	  else
	    {
	      fd = fopen (optarg, "w");
	      if (! fd)
		fprintf (stdout, "Cannot open %s.\n", optarg);
	    }
	  break;

	case 'R':
	  fd = NULL;
	  hflag = 0;
	  eflag = 0;
	  iflag = 0;
	  tflag = 0;
	  break;

	case 'A':
	  if (! fd)
	    fd = stdout;
	  hflag = 1;
	  eflag = 1;
	  iflag = 1;
	  tflag = 1;
	  break;

	case 'H':
	  if (! fd)
	    fd = stdout;
	  hflag = ! hflag;
	  break;

	case 'E':
	  if (! fd)
	    fd = stdout;
	  eflag = ! eflag;
	  break;

	case 'I':
	  if (! fd)
	    fd = stdout;
	  iflag = ! iflag;
	  break;

	case 'T':
	  if (! fd)
	    fd = stdout;
	  tflag = ! tflag;
	  break;
	}
    }

  if (optind < argc)
    {
      printf ("\nWrong option(s): \" ");
      while (optind < argc)
	printf ("%s ", argv [optind ++]);
      printf ("\"\n");
      USAGE (commandname);
      printf ("\n");
      return (-1);
    }

  
  /*
   * Safe to play with the 'active' interface (if any)
   * in case no specific one was chosen by the user.
   */
  if (! interface && ! (interface = intop_interface (active)))
    {
      printf ("No interface is currently enabled for packet sniffing.\n");
      return (-1);
    }

  /*
   * Lookup for the given name in the table of enabled interfaces.
   */
  current = intop_lookup_interface (interface);
  if (current == -1)
    {
      printf ("%s: unknown interface %s.\n", commandname, interface);
      return (-1);
    }

  /*
   * Toogle the verbosity flags.
   */
  n = nethandler (current);


  n -> fdv     = fd;
  n -> hashing = hflag;
  n -> ethv    = eflag;
  n -> ipv     = iflag;
  n -> tcpv    = tflag;;

  return (0);
}
