/*
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 * init.c - perform all initialization steps for the ntop engine.
 *
 * Luca Deri     <deri@ntop.org>
 * Rocco Carbone <rocco@ntop.org>
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*
 * ntop header file(s)
 */
#include "ntop.h"
#include "intop.h"

/*
 * Initialize all variables used at run-time by the ntop engine.
 *
 * Shamelessly ripped from ntop's main.c source file
 * and adapted to do the job.
 */
void intop_init (int argc, char * argv [])
{
  static int initialized = 0;     /* true if the ntop engine has been initialized */

  if (initialized)
    return;

  printf ("Initializing intop engine.... Please wait.\n");
  fflush (stdout);

  /*
   * Initialize all global run-time parameters to reasonable values
   */
  initNtopGlobals (argc, argv);
  myGlobals.traceLevel = -2;

  /*
   * Initialize memory and data for the protocols being monitored trying to access
   */
  initIPServices ();
  initGlobalValues ();

  if (myGlobals . numIpProtosToMonitor == 0)
    addDefaultProtocols ();

  createPortHash ();

  initGdbm (".");     /* create DB files under the current directory */

  /*
   * initialize memory and data
   */
  initDevices (myGlobals . devices);

  initCounters ();

  initThreads ();

  /*
   * Done. Initialization done.
   */
  initialized = 1;
}
