#
# DaysInSecs
#
sub days {
  my ($t1, $t2) = @_;

  return int(($t2 - $t1) / 86400);
}


#
# HoursInSecs
#
sub hours {
  my ($t1, $t2) = @_;

  return int(($t2 - $t1 - (days($t1, $t2) * 86400)) / 3600);
}


#
# MinutesInSecs
#
sub mins {
  my ($t1, $t2) = @_;

  return int(($t2 - $t1 - (days($t1, $t2) * 86400) - (hours($t1, $t2) * 3600)) / 60);
}


sub prettydelta {
  my ($t1, $t2) = @_;

  my $d = days($t1, $t2);
  my $h = hours($t1, $t2);
  my $m = mins($t1, $t2);
  my $s = ($t2 - $t1) % 60;

  if ($d) {
    return sprintf("%3d %02d:%02d:%02d", $d, $h, $m, $s);
  }
  elsif ($h) {
    return sprintf("%2d:%02d:%02d", $h, $m, $s);
  }
  else {
    return sprintf("%02d:%02d", $m, $s);
  }
}


sub seen {

  my ($seen) = @_;

  my ($sec, $min, $hour, $day, $month, $year, $wday) = (localtime($seen)) [0, 1, 2, 3, 4, 5, 6];

  $year += 1900;
  $month = sprintf "%02d", $month + 1;
  $hour  = sprintf "%02d", $hour;
  $min   = sprintf "%02d", $min;
  $sec   = sprintf "%02d", $sec;

  return $year . "/" . $month . "/" . $day . "&nbsp;" . $hour . ":" . $min . ":" . $sec;
}

1;
