
#
# compare two entries based on the concept of "resolved vendor name"
#
sub known_vendors {
  my $v1 = $a->{vendor};
  my $v2 = $b->{vendor};

  # handle unresolved vendor names
  if (! $v1 || $v1 =~ /^\s/ || $v1 =~ /Multicast/) {
    return 1;
  }

  if (! $v2 || $v2 =~ /^\s/ || $v2 =~ /Multicast/) {
    return -1;
  }

  $v1 cmp $v2
}


#
# compare two entries for numerically IP address
#
sub ipnumerically {
  my $ip1 = $a->{ipaddress};
  my $ip2 = $b->{ipaddress};

  # handle unassigned IP-less
  if ($ip1 =~ /IP-less/) {
    return 1;
  }

  if ($ip2 =~ /IP-less/) {
    return -1;
  }

  my ($a1, $b1, $c1, $d1) = split (/\./, $ip1);
  my ($a2, $b2, $c2, $d2) = split (/\./, $ip2);

  $ip1 = sprintf ("%03d%03d%03d%03d", $a1, $b1, $c1, $d1);
  $ip2 = sprintf ("%03d%03d%03d%03d", $a2, $b2, $c2, $d2);

  $ip1 <=> $ip2;
}


#
# compare two entries based on the "aged" concept
#
sub aged {
  ($a->{lastseen} - $a->{firstseen}) <=> ($b->{lastseen} - $b->{firstseen})
}

1;
