#
# nbs.pl - html generator for ntop's NetBIOS Over IP Cache.
#
# Copyright (C) 2000-2003 Rocco Carbone <rocco@ntop.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING. If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#

#
# the %traffic hash keeps all information of interest
# for the purpose of reporting statistics access
#
# They include:
#     hwaddress   => unique ethernet address (MAC address)
#     vendor      => unique MAC address vendor name
#     ipaddress   => its IP address in dot notation
#     hostname    => its, locally resolved, hostname
#     domain      => its, locally resolved, DNS domain name
#     nbtname     => its NetBIOS name
#     nbtdomain   => its NetBIOS domain
#     first       => time the host was first seen
#     last        => time the host was last seen

#
# useful variables
#
$__progname__   = "nbs.pl";
$__version__    = "0.0.3";
$__updated__    = "2003 Mar 06";
$__boottime__   = time();
$__bootdate__   = localtime($__boottime__);

# Hey Netscape, this is for you
my $htmltitle   = "NTOP Statistics -- NetBIOS over IP Cache";
my $bodyname    = "NetBIOS over IP Cache Report";
my $title       = "NetBIOS over IP Cache Summary";
my $description = "Shows ntop's NetBIOS over IP Cache";


my $infobg      = "\"#cccccc\"";
my $headerbg    = "\"#ccccff\"";
my @bgcolors    = ("\"#ffffff\"", "\"#eeeeee\"");
my $j = 0;

#
# useful variables
#

# The unsorted hash of ntop traffic cache (global hash)
my @traffic = sort keys %traffic;

#
# other useful variables
#
@reporttypes = ("hwaddress") unless @reporttypes;
@sorttypes = ("ascending") unless @sorttypes;
my $reporttype;
my $sorttype;


#
# perform all needed ascending and descending sorting
#

#
# sort hw address alphabetically and ip address alphabetically
#
my @sorted_by_ipaddress     = sort ipnumerically values %traffic;
my @sorted_by_hostname      = sort { ${$a}{'hostname'}  cmp ${$b}{'hostname'} }  values %traffic;
my @sorted_by_nbname        = sort { ${$a}{'nbname'}    cmp ${$b}{'nbname'} }    values %traffic;
my @sorted_by_nbdomain      = sort { ${$a}{'nbdomain'}  cmp ${$b}{'nbdomain'} }  values %traffic;

my @sorted_by_rev_ipaddress = reverse @sorted_by_ipaddress;
my @sorted_by_rev_hostname  = reverse @sorted_by_hostname;
my @sorted_by_rev_nbname    = reverse @sorted_by_nbname;
my @sorted_by_rev_nbdomain  = reverse @sorted_by_nbdomain;

my $items_per_section = 25;
my $total_items       = $#sorted_by_hostname + 1;                  # items to display
my $sections          = int($total_items / $items_per_section);    # sections to create


if ($total_items % $items_per_section) {
  $sections++;
}

select STDOUT;

#
# print HTML header and title
#
html_header($htmltitle);

#
# start printing HTML body
#
html_start_body($bodyname);

#
# print report's title with its brief description
#
print "<center><font size=6><b>$description</b></font></table>\n";

foreach $reporttype (@reporttypes) {

  my $sorted_by     = "sorted_by_$reporttype";
  my $sorted_by_rev = "sorted_by_rev_$reporttype";

  my @sorted     = eval("\@$sorted_by");
  my @sorted_rev = eval("\@$sorted_by_rev");


  foreach $sorttype (@sorttypes) {
    my $current = 0;

    for ($section = 1; $section <= $sections; $section++) {
      # the sub array for this section
      my @sub_sorted;

      #
      # useful calculations before starting playing with sections
      #
      my $last = $current + $items_per_section - 1;

      if ($last >= $total_items) {
	$last = $total_items - 1;
      }
      my $itemno = $last - $current + 1;

      #
      # isolate the sub array
      #
      if ($sorttype eq "ascending") {
	$sort1 = "/plugins/pep?$__progname__&sort=descending&field=hostname";
	$sort4 = "/plugins/pep?$__progname__&sort=descending&field=ipaddress";
	$sort6 = "/plugins/pep?$__progname__&sort=descending&field=nbname";
	$sort7 = "/plugins/pep?$__progname__&sort=descending&field=nbdomain";

	@sub_sorted = @sorted[$current..$last];
      }
      else {
	$sort1 = "/plugins/pep?$__progname__&sort=ascending&field=hostname";
	$sort4 = "/plugins/pep?$__progname__&sort=ascending&field=ipaddress";
	$sort6 = "/plugins/pep?$__progname__&sort=ascending&field=nbname";
	$sort7 = "/plugins/pep?$__progname__&sort=ascending&field=nbdomain";

	@sub_sorted = @sorted_rev[$current..$last];
      }

      print "<p><table align=center cellpadding=1 cellspacing=0 border=0>\n";
      print "<b>$title section $section of $sections</b>\n";
      print "<tr><td>&nbsp;</td><tr bgcolor=$bgcolors[(++ $j) % 2]><td>&nbsp;</td>";
      print "<td colspan=15>Displaying ";
      print $itemno;
      print " items [";
      print $current + 1;
      print "-";
      print $last + 1;
      print "] of $total_items sorted by $sorttype $reporttype</td></tr>\n";
      print "<tr bgcolor=$bgcolors[(++ $j) % 2]>\n";
      print "</tr>\n";
      print "<tr><td>&nbsp;</td>\n";
      print "</table>\n";

      print "<table align=center cellpadding=1 cellspacing=0 border=0>\n";

      # table header (column's name separated by blanks)
      if ($itemno == 1) {
	print "<tr bgcolor=$headerbg>\n";
	# itemno
	print "<td width=10>&nbsp;</td>\n";
	print "<td align=left><font size=4><b>#</b></font></td>\n";
	# Hostname
	print "<td width=20>&nbsp;</td>\n";
	print "<td align=center><font size=4><b>Hostname</b></font></td>\n";
	# IP address
	print "<td width=20>&nbsp;</td>\n";
	print "<td align=center><font size=4><b>IP&nbsp;Address</b></font></td>\n";
	# NetBIOS Name
	print "<td width=20>&nbsp;</td>\n";
	print "<td align=center><font size=4><b>NetBIOSB&nbsp;Name</b></font></td>\n";
	# NetBIOS Domain
	print "<td width=20>&nbsp;</td>\n";
	print "<td align=center><font size=4><b>NetBIOS&nbsp;Domain</b></font></td>\n";
	print "<td width=10>&nbsp;</td></tr>";
      }
      else {
	print "<tr bgcolor=$headerbg>\n";
	# itemno
	print "<td width=10>&nbsp;</td>\n";
	print "<td align=left><font size=4><b>#</b></font></td>\n";
	# Hostname
	print "<td width=20>&nbsp;</td>\n";
	print "<td align=center><font size=4><b><a href=$sort1>Hostname</a></b></font></td>\n";
	# IP address
	print "<td width=20>&nbsp;</td>\n";
	print "<td align=center><font size=4><b><a href=$sort4>IP&nbsp;Address</a></b></font></td>\n";
	# NetBIOS Name
	print "<td width=20>&nbsp;</td>\n";
	print "<td align=center><font size=4><b><a href=$sort6>NetBIOS&nbsp;Name</a></b></font></td>\n";
	# NetBIOS Domain
	print "<td width=20>&nbsp;</td>\n";
	print "<td align=center><font size=4><b><a href=$sort7>NetBIOS&nbsp;Domain</a></b></font></td>\n";
	print "<td width=10>&nbsp;</td></tr>";
      }

      $no = $current + 1;
      foreach $key (@sub_sorted) {

	next unless ${$key}{'nbname'} ne " ";

	my $host = ${$key}{'hostname'};
           $host =~ s/ /\&nbsp;/g; # replace blanks for html rendering

	# bgcolor - separator - value(s) - separator
	print "<tr bgcolor=$bgcolors[(++ $j) % 2]>\n";
	print "<td width=10>&nbsp;</td>\n";
	print "<td align=center>$no</td>\n";                        # itemno
	print "<td width=20>&nbsp;</td>\n";
	print "<td align=left>$host&nbsp;</td>\n";                  # Hostname
	print "<td width=20>&nbsp;</td>\n";
	print "<td align=left>${$key}{'ipaddress'}&nbsp;</td>\n";   # IP Address
	print "<td width=20>&nbsp;</td>\n";
	print "<td align=left>${$key}{'nbname'}&nbsp;</td>\n";      # NetBIOS Name
	print "<td width=20>&nbsp;</td>\n";
	print "<td align=left>${$key}{'nbdomain'}&nbsp;</td>\n";    # NetBIOS Domain
	print "<td width=10>&nbsp;</td>\n";
	print "</tr>\n";

	$no++;
      } # next item on the same section

      # end table
      print
	"</table><p>";

      $current += $items_per_section;
    }   # next section
  }     # next sorting type
}       # next report type

#
# finish HTML output
#
html_stop_body();



#
# print HTML header and title
#
sub html_header {
  my $titlepage = shift;

  #
  # immediately start printing the magic line which tells to the world
  # we are playing with an HTML document
  #
  # print "Content-type: text/html\n\n";

  print "Content-type: text/html\n";
  print "Cache-Control: no-cache\n";
  print "Expires: 0\n\n";


  print
    "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n",
    "<html>\n",
    "<!-- ntop statistic page -->\n",
    "<!-- Rocco Carbone <rocco\@ntop.org> -->\n",
    "<head>\n",
#    "<meta http-equiv=refresh content=120>\n",
    "<link rel=stylesheet href=/style.css type=\"text/css\">\n",
    "<meta http-equiv=Pragma content=no-cache>\n",
    "<meta http-equiv=Cache-Control content=no-cache>\n",
    "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">",
    "<meta name=\"robots\" content=\"ntop statistics\">\n",
    "<meta name=\"keywords\" content=\"ntop\">\n",
    "</head>\n",
    "<title>$titlepage</title>\n";
}


#
# start printing HTML body
#
sub html_start_body {
  my $title = shift;

  print "<body bgcolor=#ffffff text=#000000 link=#1111cc vlink=#cc0000 alink=#888888>\n";
  print "<center>\n";
  print "<table border=0 cellpadding=1 cellspacing=2>\n";
  print "<tr>\n";
  print "<td align=center>\n";
  print "<a href=\"/plugins/pep?available.pl\">all available scripts</a>\n";
  print "</td>\n";
  print "<td width=15></td>\n";
  print "<td align=center>\n";
  print "</td>\n";
  print "</tr>\n";
  print "</table>\n";
}


#
# finish printing HTML body (aka footer)
#
sub html_stop_body {
  print "<p>\n";
  print "Generated by $__progname__ version $__version__\n";
  print "</p>\n";
  print "<table border=0 cellpadding=1 cellspacing=2>\n";
  print "<tr>\n";
  print "<td align=left>\n";
  print "<font size=2>\n";
  print "Questions or comments: <a href=\"mailto:rocco\@ntop.org\"</a><br>\n";
  print "&copy; 2000-2003 by Rocco Carbone - Updated $__updated__\n";
  print "</font>\n";
  print "</td>\n";
  print "</tr>\n";
  print "</table>\n";
  print "</center>\n";
  print "</body>\n";
  print "</html>\n";
}


sub ipnumerically {
  my $ip1 = ${$a}{'ipaddress'};
  my $ip2 = ${$b}{'ipaddress'};

  my ($a1, $b1, $c1, $d1) = split (/\./, $ip1);
  my ($a2, $b2, $c2, $d2) = split (/\./, $ip2);

  $ip1 = sprintf ("%03d%03d%03d%03d", $a1, $b1, $c1, $d1);
  $ip2 = sprintf ("%03d%03d%03d%03d", $a2, $b2, $c2, $d2);

  $ip1 <=> $ip2;
}


1;
