/* NTOP JDBC interface for mySQL
*
*     Command line invocation requires a text file parameter to store SQL commands into for debug:
*
*         java MySQLServer [ntopSQL.txt]
*
*  	  The SQL capture file write may be commented out.
*         SQL time stamps are generated for the SQL capture file only.
*
*         This routine checks for and corrects the invalid "DELETE *" command generated by NTOP
*         It does NOT generate the missing "FIRSTSEEN" values.
*         Both of the delete and firstseen problems should be fixed in the NTOP C-code.
*
*  Author Dave Moore <davem@mitre.org>  
*  (Based upon Java ODBC sample for MS Access) (Don't forget to set you userID & password.)
*  March 2001
*/
import java.util.*;
import java.text.*;
import java.io.*;
import java.net.*;
import java.sql.*;
import java.lang.System;

public class MySQLServer {
  private Connection connection;

  private boolean checkForWarning (SQLWarning warn) {
    boolean rc = false;

    // If an SQLWarning object was given, display the
    // warning messages.  Note that there could be
    // multiple warnings chained together
    try {
      if (warn != null) {
    	System.out.println ("\n *** Warning ***\n");
    	rc = true;
    	while (warn != null) {
    	  System.out.println ("SQLState: " +
    			      warn.getSQLState ());
    	  System.out.println ("Message:  " +
    			      warn.getMessage ());
    	  System.out.println ("");
    	  warn = warn.getNextWarning ();
    	}
      }
      return rc;
    } catch(Exception e) {
      return(true);
    }
  }

  public MySQLServer(String dbName) {
    try {
      Class.forName("org.gjt.mm.mysql.Driver");
      connection = DriverManager.getConnection("jdbc:mysql://localhost:3306/ntop?user=myid&password=mypass");
      checkForWarning(connection.getWarnings());
      //connection.setAutoCommit(true); // Automatic transaction commitment
      connection.setAutoCommit(true); // Automatic transaction commitment
    } catch (Exception e) {
      e.printStackTrace();
      System.exit(-1);
    }
  }


  public void executeStatement(String statement) {
       PreparedStatement stmt;
       int rc;

        try {
          stmt = connection.prepareStatement(statement); // Insert record in the HostInfo table
          rc = stmt.executeUpdate();
          stmt.close(); // Close the statement
        } catch(Exception ex) {
          ex.printStackTrace();
        }
  }

    private String replace_substring(String original, String delimiter, String replacement) {
    // Given an "original" input string, find all values of the "delimiter" string
    // and replace them with the "replacement" string.
    String result = "";
    int delimiter_length = delimiter.length();
    int replacement_length = replacement.length();
    int index_1 = 0;
    int index_2 = 0;
    if (original != null) {
      while (index_2 >= 0) {
        index_2 = original.indexOf(delimiter, index_1);  // next delimiter position from previous
        if (index_2 >= 0) {
          if (index_2 == index_1) {         //very next character ?
            result = result + replacement;
            }
            else {
              result = result + original.substring(index_1, index_2) + replacement;
             //log("found " + delimiter + " replacing with " + replacement + ".");
            }
          index_1 = index_2 + delimiter_length;  //skip over delimiter.
        }
      }
      result = result + original.substring(index_1, original.length());  //pick up tail end.
    }
    return result;
  }


// only argument is a text file to echo SQL commands to for debug.
  public static void main( String args[] ) throws IOException
  {
        byte buffer[];
        int bufLength = 1514;
        String cmndline;
        MySQLServer jdbcServer;
        DatagramSocket socket = null;
        DatagramPacket pkt;

//       SimpleDateFormat DateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss:SSS zzz");
        SimpleDateFormat DateFormatter = new SimpleDateFormat("EEE, HH:mm:ss.SSS");
        java.util.Date currentTime_1;

        System.out.println("Starting up...");

        try {
            socket = new DatagramSocket(4000);
        } catch (Exception e) {
          e.printStackTrace();
          System.exit(-1);
        }

        if (args.length != 1)
        {
          System.out.println("SQL capture file name parameter is required");
          System.exit(-1);
        }

//     debug SQL commands out to listout
       PrintWriter listout = new PrintWriter(new FileWriter(args[0]), true);  //autoflush set to true

        buffer = new byte[bufLength];
        pkt = new DatagramPacket(buffer, buffer.length);

//        comment out to stop database access
          jdbcServer = new MySQLServer("NTOP");

        while(true) {
            try {
               socket.receive(pkt);
               String statement = new String(buffer, 0, pkt.getLength());

               //Fix SQL syntax(1): Change "DELETE *" to just "DELETE".
               statement = jdbcServer.replace_substring(statement, "DELETE *", "DELETE");

               currentTime_1 = new java.util.Date();
               String dateString = DateFormatter.format(currentTime_1);
               cmndline = "["+pkt.getLength()+"] '"+statement+"'";

//	       comment out to eliminate debug dump file
              listout.println(dateString + " : " + cmndline);

//             comment out to block database access
               jdbcServer.executeStatement(statement);

               pkt.setLength(bufLength);
            } catch (Exception e) {
              e.printStackTrace();
            }
        }

        /*
        socket.close();
        System.out.println("Done.");
        */
  }

}
