/*
 *  Copyright (C) 2001 Vidar Hoel <vho@proseq.net>
 *
 *                     http://www.ntop.org/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/**************************************************
 * This file contains the code for NTOP to communicate direct to a
 * mySQL database. It is very messy atm, but hopefully I'll make it
 * cleaner..
**************************************************/

#include "ntop.h"
#include "globals-report.h"    

#ifdef HAVE_MYSQL
MYSQL  mysql, *mysql_sock;
MYSQL_RES     *mysql_res;
char qbuf[160], TraceInfoLine[200];
struct sockaddr_in dest;

static int enable_mySQL = 0;


static char ntop_mysql_user[100];
static char ntop_mysql_password[100];
static char ntop_mysql_database[100];
static char ntop_mysql_host[100];

static int * enableDBSupportPtr = NULL;
#ifdef MULTITHREADED
static pthread_mutex_t ntop_mysql_mutex;
#endif

#ifdef MULTITHREADED
int use_mutex;
#endif

/* forward */
void open_mySQLsocket(char *userName, char* password, char* dbName, char *dbHost);


/* *************************************** */
/*                                         */
/* Fixes courtesy of elmer@linking.ee      */
/*                                         */
/* *************************************** */

int MYSQL_QUERY_UL(MYSQL * sock, char * query) {
  int res;
  res = mysql_query(sock,query) ;
  return res;
};

/* *************************************** */

int MYSQL_QUERY (MYSQL * sock, char * query) {
  int res;
 
#ifdef MULTITHREADED
  if(use_mutex) pthread_mutex_lock(&ntop_mysql_mutex);
#endif
  res = MYSQL_QUERY_UL(sock,query) ;
#ifdef MULTITHREADED
  if(use_mutex) pthread_mutex_unlock(&ntop_mysql_mutex);
#endif
  return res;
};

/* *************************************** */

void handlemySQLSupport(char* param /* username:password:dbname:host */, int* enableDBsupport) {
  char *password, *strtokState;

  memset(ntop_mysql_user, 0, sizeof(ntop_mysql_user));
  memset(ntop_mysql_password, 0, sizeof(ntop_mysql_password));
  memset(ntop_mysql_database, 0, sizeof(ntop_mysql_database));
  memset(ntop_mysql_host, 0, sizeof(ntop_mysql_host));
  
  /**************************************************
   * Address is not set or in use atm. The user, passwd and name is
   * hardcore programmed in this file..
   **************************************************/

#ifdef DEBUG
  printf("Param: %s\n", param);
#endif

  if((param == NULL) || (param[0] == '\0'))
    return;

  myGlobals.mySQLuser = strtok_r(param, ":", &strtokState);
  password = strtok_r(NULL, ":", &strtokState);
  myGlobals.mySQLdatabase = strtok_r(NULL, ":", &strtokState);
  myGlobals.mySQLhostName = strtok_r(NULL, ":", &strtokState);
  
  if(myGlobals.mySQLuser) strncpy(ntop_mysql_user,myGlobals.mySQLuser,98);
  if(password) strncpy(ntop_mysql_password,password,98);
  if(myGlobals.mySQLdatabase)   strncpy(ntop_mysql_database,myGlobals.mySQLdatabase,98);
  if(myGlobals.mySQLhostName)     strncpy(ntop_mysql_host,myGlobals.mySQLhostName,98);

  if(myGlobals.mySQLdatabase == NULL) {
    myGlobals.mySQLdatabase = password;
    password = NULL;
  }

#ifdef DEBUG
  printf("User: %s\nPass: %s\ndb: %s\n", myGlobals.mySQLuser, password, myGlobals.mySQLdatabase);
#endif

  if((myGlobals.mySQLuser == NULL) || (myGlobals.mySQLdatabase == NULL)) {
    traceEvent(TRACE_INFO, "WARNING: invalid value specified for '-v' parameter. \n"
	       "         It should be username:password:dbName.\n");
    return;
  } else {    
#ifdef MULTITHREADED
      pthread_mutex_init(&ntop_mysql_mutex,NULL);
      use_mutex=1;
#endif
 
    (*enableDBsupport) = 1;
    enableDBSupportPtr = enableDBsupport;
    open_mySQLsocket(ntop_mysql_user, ntop_mysql_password, ntop_mysql_database,
		     ntop_mysql_host);
  }
}

/*-----------------------------------------------*/

void open_mySQLsocket(char *userName, char* password, char* dbName, char *dbHost) {
#ifdef MULTITHREADED
  if(use_mutex)  pthread_mutex_lock(&ntop_mysql_mutex);
#endif
  mysql_init(&mysql);
  mysql.reconnect = 1;

  if(!(mysql_sock = mysql_real_connect(&mysql, dbHost, userName, 
				       password, dbName, 0, NULL,0))) {
    traceEvent(TRACE_ERROR, "ERROR: Could not connect to the mySQL database!\n");
    goto end;
  }

  mysql_sock->reconnect = 1;
  enable_mySQL = 1;

 end:
#ifdef MULTITHREADED
  if(use_mutex)  pthread_mutex_unlock(&ntop_mysql_mutex);
#endif
  return;
}

/*-----------------------------------------------*/

void closemySQLsocket(void) {
#ifdef MULTITHREADED
  if(use_mutex)  pthread_mutex_lock(&ntop_mysql_mutex);
#endif
  mysql_close(mysql_sock);
#ifdef MULTITHREADED
  if(use_mutex)  pthread_mutex_unlock(&ntop_mysql_mutex);
#endif
  traceEvent(TRACE_INFO, "INFO: mySQL socket is down.\n");
}

/*-----------------------------------------------*/

void mySQLupdateHostNameInfo(unsigned long numeric, char* symbolic) {
  char *hostName;
  struct in_addr addr;
  char buf[32];

  if(!enable_mySQL)
    return;

  addr.s_addr = numeric;

  hostName = _intoa(addr, buf, sizeof(buf));

  /********************************************************************
   * The code here is taken from sql.c, just translated to the mySQL C
   * API interface.
   ********************************************************************/

  if(strcmp(hostName, symbolic) != 0) {  
    /* [1] Delete */
    if(sprintf(qbuf, "DELETE FROM NameMapper WHERE IPaddress = '%s'", hostName) < 0) 
      BufferTooShort();

    if(!MYSQL_QUERY(mysql_sock, qbuf)) {
      sprintf(TraceInfoLine, "In mySQLupdateHostNameInfo: %s\n", qbuf);
      traceEvent(TRACE_INFO, TraceInfoLine);
    }

    /* [2] Insert */ 
    if(sprintf(qbuf,"INSERT DELAYED INTO NameMapper (IPaddress, Name)"
	       " VALUES ('%s', '%s')", hostName, symbolic) < 0)
      BufferTooShort();
    if(!MYSQL_QUERY(mysql_sock, qbuf)) {
      sprintf(TraceInfoLine, "In mySQLupdateHostNameInfo: %s\n", qbuf);
      traceEvent(TRACE_INFO, TraceInfoLine);
    }
  } 
}

/*-----------------------------------------------*/

void mySQLupdateHostTraffic(HostTraffic *el) {
  char theDate[32], theDate2[32];
  struct tm t;

  if((!enable_mySQL) || (broadcastHost(el)) || (el->hostNumIpAddress[0] == '\0'))
    return;

  /* Fixes below courtesy of Andreas Pfaller <apfaller@yahoo.com.au> */
  strftime(theDate2, 32, "%Y-%m-%d %H:%M:%S", localtime_r(&el->firstSeen, &t));

  /* Added by David Moore <davem@mitre.org> */
  strftime(theDate, 32, "%Y-%m-%d %H:%M:%S", localtime_r(&el->lastSeen, &t));  


  /* ****************************** */

  if((strcmp(el->hostNumIpAddress, "")) == 0) {
    traceEvent(TRACE_INFO, "In mySQLupdateHostTraffic: Empty IP-address, gonna do nothing\n");
  } else {

    sprintf(qbuf, "SELECT IPaddress FROM Hosts WHERE IPaddress = \"%s\"", 
	    el->hostNumIpAddress);

#ifdef MULTITHREADED
    if(use_mutex)  pthread_mutex_lock(&ntop_mysql_mutex);
#endif

    if(MYSQL_QUERY_UL(mysql_sock,qbuf)) {
      sprintf(TraceInfoLine, "ERROR: In mySQLupdateHostTraffic: Query failed (%s)\n",
	      mysql_error(mysql_sock));
      traceEvent(TRACE_ERROR, TraceInfoLine);
    }

    if(!(mysql_res=mysql_store_result(mysql_sock))) {
      sprintf(TraceInfoLine, "In mySQLupdateHostTraffic: Couldn't get result from %s\n",
	      mysql_error(mysql_sock));
      traceEvent(TRACE_ERROR, TraceInfoLine);
    }

    /********************************************************************
     * Code here is also taken from sql.c, but I had to make some changes.
     * First of all, it is translated to the mySQL C API. Second, I
     * discoverd that mySQL can not do a update if a entry is not there,
     * so I had to check the if the given IP-adr. was already in the DB,
     * and then do a UPDATE or INSERT accordingly..
     ********************************************************************/
    
    if(mysql_num_rows(mysql_res) > 0) {
      if(sprintf(qbuf, "UPDATE Hosts SET "
		 "PktSent = %llu, "
		 "PktRcvd = %llu, "
		 "PktMulticastSent = %llu, "
		 "PktBroadcastSent = %llu, "
		 "DataSent = %llu, "
		 "DataRcvd = %llu, "
		 "DataMulticastSent = %llu, "
		 "DataBroadcastSent = %llu, "
		 "FirstSeen = '%s', "
		 "LastSeen = '%s' "
		 "WHERE IPaddress = '%s'",
		 (el->pktSent),
		 (el->pktRcvd),
		 (el->pktMulticastSent),
		 (el->pktBroadcastSent),
		 (el->bytesSent),
		 (el->bytesRcvd),
		 (el->bytesMulticastSent),
		 (el->bytesBroadcastSent),
		 theDate2, theDate,
		 el->hostNumIpAddress) < 0) BufferTooShort();

      if(!MYSQL_QUERY_UL(mysql_sock, qbuf)) {
	sprintf(TraceInfoLine, "In mySQLupdateHostTraffic: %s\n", qbuf);
	traceEvent(TRACE_INFO, TraceInfoLine);
      }
    } else {
      if(sprintf(qbuf, "INSERT Hosts SET "
		 "PktSent = %llu, "
		 "PktRcvd = %llu, "
		 "PktMulticastSent = %llu, "
		 "PktBroadcastSent = %llu, "
		 "DataSent = %llu, "
		 "DataRcvd = %llu, "
		 "DataMulticastSent = %llu, "
		 "DataBroadcastSent = %llu, "
		 "FirstSeen = '%s', "
		 "LastSeen = '%s', "
		 "IPaddress = '%s'",
		 (el->pktSent),
		 (el->pktRcvd),
		 (el->pktMulticastSent),
		 (el->pktBroadcastSent),
		 (el->bytesSent),
		 (el->bytesRcvd),
		 (el->bytesMulticastSent),
		 (el->bytesBroadcastSent),
		 theDate2, theDate,
		 el->hostNumIpAddress) < 0) BufferTooShort();

      if(!MYSQL_QUERY_UL(mysql_sock, qbuf)) {
	sprintf(TraceInfoLine, "In mySQLupdateHostTraffic: %s\n", qbuf);
	traceEvent(TRACE_INFO, TraceInfoLine);
      }

      /* --- */

      sprintf(qbuf, "SELECT IPaddress FROM IPtraffic WHERE IPaddress = \"%s\"", el->hostNumIpAddress);

      if(MYSQL_QUERY_UL(mysql_sock,qbuf)) {
	sprintf(TraceInfoLine, "Query failed (%s)\n", mysql_error(mysql_sock));
	traceEvent(TRACE_ERROR, TraceInfoLine);
      }

      if(!(mysql_res=mysql_store_result(mysql_sock))) {
	sprintf(TraceInfoLine, "Couldn't get result from %s\n", mysql_error(mysql_sock));
	traceEvent(TRACE_ERROR, TraceInfoLine);
      }

      if(mysql_num_rows(mysql_res) > 0) {
	if(sprintf(qbuf, "UPDATE IPtraffic SET "
                   "TCPSentLoc = %llu, "
                   "TCPSentRem = %llu, "
                   "TCPrcvdLoc = %llu, "
                   "TCPrcvdFromRem = %llu, "
                   "UDPSentLoc = %llu, "
                   "UDPSentRem = %llu, "
                   "UDPrcvdLoc = %llu, "
                   "UDPrcvdFromRem = %llu, "
                   "ICMPsent = %llu, "
                   "ICMPrcvd = %llu, "
                   "OSPFsent = %llu, "
                   "OSPFrcvd = %llu, "
                   "IGMPsent = %llu, "
                   "IGMPrcvd = %llu WHERE "
                   "IPaddress = '%s'",
                   (el->tcpSentLoc),
                   (el->tcpSentRem),
                   (el->tcpRcvdLoc),

                   (el->tcpRcvdFromRem),
                   (el->udpSentLoc),
                   (el->udpSentRem),
                   (el->udpRcvdLoc),
                   (el->udpRcvdFromRem),
                   (el->icmpSent),
                   (el->icmpRcvd),
                   (el->ospfSent),
                   (el->ospfRcvd),
                   (el->igmpSent),
                   (el->igmpRcvd),
                   el->hostNumIpAddress) < 0) BufferTooShort();


	if(!MYSQL_QUERY_UL(mysql_sock, qbuf)) {
	  sprintf(TraceInfoLine, "In mySQLupdateHostTraffic: %s\n", qbuf);
	  traceEvent(TRACE_INFO, TraceInfoLine);
	}

      } else {

	if(sprintf(qbuf, "INSERT IPtraffic SET "
                   "TCPSentLoc = %llu, "
                   "TCPSentRem = %llu, "
                   "TCPrcvdLoc = %llu, "
                   "TCPrcvdFromRem = %llu, "
                   "UDPSentLoc = %llu, "
                   "UDPSentRem = %llu, "
                   "UDPrcvdLoc = %llu, "
                   "UDPrcvdFromRem = %llu, "
                   "ICMPsent = %llu, "
                   "ICMPrcvd = %llu, "
                   "OSPFsent = %llu, "
                   "OSPFrcvd = %llu, "
                   "IGMPsent = %llu, "

                   "IGMPrcvd = %llu, "
                   "IPaddress = '%s'",
                   (el->tcpSentLoc),
                   (el->tcpSentRem),
                   (el->tcpRcvdLoc),
                   (el->tcpRcvdFromRem),
                   (el->udpSentLoc),
                   (el->udpSentRem),
                   (el->udpRcvdLoc),
                   (el->udpRcvdFromRem),
                   (el->icmpSent),
                   (el->icmpRcvd),
                   (el->ospfSent),
                   (el->ospfRcvd),
                   (el->igmpSent),
                   (el->igmpRcvd),
                   el->hostNumIpAddress) < 0) BufferTooShort();

#ifdef DEBUG
	printf ("DEBUG: INSERT IPtraffic SET.....\n");
#endif

	if(!MYSQL_QUERY_UL(mysql_sock, qbuf)) {
	  sprintf(TraceInfoLine, "In mySQLupdateHostTraffic: %s\n", qbuf);
	  traceEvent(TRACE_INFO, TraceInfoLine);
	}
      }

      /* --- */

      sprintf(qbuf, "SELECT IPaddress FROM NonIPTraffic WHERE IPaddress = \"%s\"", 
	      el->hostNumIpAddress);

      if(MYSQL_QUERY(mysql_sock,qbuf)) {
	sprintf(TraceInfoLine, "Query failed (%s)\n", mysql_error(mysql_sock));
	traceEvent(TRACE_ERROR, TraceInfoLine);
      }

      if(!(mysql_res=mysql_store_result(mysql_sock))) {
	sprintf(TraceInfoLine, "Couldn't get result from %s\n", mysql_error(mysql_sock));
	traceEvent(TRACE_ERROR, TraceInfoLine);
      }

      if(mysql_num_rows(mysql_res) > 0) {
	if(sprintf(qbuf, "UPDATE NonIPTraffic SET "
                   "IPXsent = %llu, "
                   "IPXrcvd = %llu, "
                   "OSIsent = %llu, "
                   "OSIrcvd = %llu, "
                   "DLCsent = %llu, "
                   "DLCrcvd = %llu, "
                   "ARPsent = %llu, "
                   "ARPrcvd = %llu, "
                   "DECNETsent = %llu, "
                   "DECNETrcvd = %llu, "
                   "ATALKsent = %llu, "
                   "ATALKrcvd = %llu, "
                   "NBIOSsent = %llu, "
                   "NBIOSrcvd = %llu, "
                   "OtherSent = %llu, "
                   "OtherRcvd = %llu WHERE "
                   "IPaddress = '%s'",
                   (el->ipxSent),
                   (el->ipxRcvd),
                   (el->osiSent),
                   (el->osiRcvd),
                   (el->dlcSent),
                   (el->dlcRcvd),
                   (el->arp_rarpSent),
                   (el->arp_rarpRcvd),
                   (el->decnetSent),
                   (el->decnetRcvd),
                   (el->appletalkSent),

                   (el->appletalkRcvd),
                   (el->netbiosSent),
                   (el->netbiosRcvd),
                   (el->otherSent),
                   (el->otherRcvd),
                   el->hostNumIpAddress) < 0) BufferTooShort();


	if(!MYSQL_QUERY_UL(mysql_sock, qbuf)) {
	  sprintf(TraceInfoLine, "In mySQLupdateHostTraffic: %s\n", qbuf);
	  traceEvent(TRACE_INFO, TraceInfoLine);
	}
                   
      } else {
             
	if(sprintf(qbuf, "INSERT NonIPTraffic SET "
                   "IPXsent = %llu, "
                   "IPXrcvd = %llu, "
                   "OSIsent = %llu, "
                   "OSIrcvd = %llu, "
                   "DLCsent = %llu, "
                   "DLCrcvd = %llu, "
                   "ARPsent = %llu, "
                   "ARPrcvd = %llu, "
                   "DECNETsent = %llu, "
                   "DECNETrcvd = %llu, "
                   "ATALKsent = %llu, "
                   "ATALKrcvd = %llu, "
                   "NBIOSsent = %llu, "
                   "NBIOSrcvd = %llu, "
                   "OtherSent = %llu, "
                   "OtherRcvd = %llu, "
                   "IPaddress = '%s'",
                   (el->ipxSent),
                   (el->ipxRcvd),
                   (el->osiSent),
                   (el->osiRcvd),
                   (el->dlcSent),
                   (el->dlcRcvd),
                   (el->arp_rarpSent),
                   (el->arp_rarpRcvd),
                   (el->decnetSent),
                   (el->decnetRcvd),
                   (el->appletalkSent),
                   (el->appletalkRcvd),
                   (el->netbiosSent),
                   (el->netbiosRcvd),
                   (el->otherSent),
                   (el->otherRcvd),
                   el->hostNumIpAddress) < 0) BufferTooShort();

	if(!MYSQL_QUERY_UL(mysql_sock, qbuf)) {
	  sprintf(TraceInfoLine, "In mySQLupdateHostTraffic: %s\n", qbuf);
	  traceEvent(TRACE_INFO, TraceInfoLine);
	}
      }
    }
    
#ifdef MULTITHREADED
    if(use_mutex)  pthread_mutex_unlock(&ntop_mysql_mutex);
#endif
  }
}

/*-----------------------------------------------------------------*/

void mySQLnotifyHostCreation(HostTraffic *el) {

  if((!enable_mySQL) || (broadcastHost(el)))
    return;

  /* [1] Delete */

  if(el->hostNumIpAddress[0] != '\0') {
    if(sprintf(qbuf, "DELETE FROM Hosts WHERE IPaddress = '%s'", 
	       el->hostNumIpAddress) < 0) 
      BufferTooShort();
  } else {
    if(sprintf(qbuf, "DELETE FROM Hosts WHERE MACaddress = '%s'", 
	       el->ethAddressString) < 0) 
      BufferTooShort();
  }

  if(!MYSQL_QUERY(mysql_sock, qbuf)) {
    sprintf(TraceInfoLine, "In mySQLnotifyHostCreation: %s\n", qbuf);
    traceEvent(TRACE_INFO, TraceInfoLine);
  }

  /* [2] Insert */
  if(sprintf(qbuf, "INSERT DELAYED INTO Hosts (IPaddress, MACaddress, NICvendor)"
	     " VALUES ('%s', '%s', '%s')",
	     el->hostNumIpAddress,
	     el->ethAddressString,
	     getVendorInfo(el->ethAddress, 0)) < 0) BufferTooShort();

  if(!MYSQL_QUERY(mysql_sock, qbuf)) {
    sprintf(TraceInfoLine, "In mySQLnotifyHostCreation: %s\n", qbuf);
    traceEvent(TRACE_INFO, TraceInfoLine);
  }

  if(el->hostNumIpAddress[0] != '\0') {
    if(sprintf(qbuf, "DELETE FROM NonIPTraffic WHERE IPaddress = '%s'",
               el->hostNumIpAddress) < 0) 
      BufferTooShort();
    if(!MYSQL_QUERY(mysql_sock, qbuf)) {
      sprintf(TraceInfoLine, "In mySQLnotifyHostCreation: %s\n", qbuf);
      traceEvent(TRACE_INFO, TraceInfoLine);
    }

    if(sprintf(qbuf, "INSERT DELAYED INTO NonIPTraffic (IPaddress) VALUES ('%s')", 
               el->hostNumIpAddress) < 0) 
      BufferTooShort();
    if(!MYSQL_QUERY(mysql_sock, qbuf)) {
      sprintf(TraceInfoLine, "In mySQLnotifyHostCreation: %s\n", qbuf);
      traceEvent(TRACE_INFO, TraceInfoLine);
    }

    if(sprintf(qbuf, "DELETE FROM IPtraffic WHERE IPaddress = '%s'", 
               el->hostNumIpAddress) < 0) 
      BufferTooShort();
    if(!MYSQL_QUERY(mysql_sock, qbuf)) {

      sprintf(TraceInfoLine, "In mySQLnotifyHostCreation: %s\n", qbuf);
      traceEvent(TRACE_INFO, TraceInfoLine);
    }

    if(sprintf(qbuf, "INSERT DELAYED INTO IPtraffic (IPaddress) VALUES ('%s')", 
               el->hostNumIpAddress) < 0) 
      BufferTooShort();
    if(!MYSQL_QUERY(mysql_sock, qbuf)) {
      sprintf(TraceInfoLine, "In mySQLnotifyHostCreation: %s\n", qbuf);
      traceEvent(TRACE_INFO, TraceInfoLine);
    }
  }

  /* traceEvent(TRACE_INFO, "%s\n", buf); */

}

/*-----------------------------------------------------------------*/

void mySQLnotifyTCPSession(IPSession *session, int actualDeviceId) {
  HostTraffic *server, *client;
  char dt1[32], dt2[32];
  struct tm t;

 
  if((!enable_mySQL) || (session->initiatorIdx == NO_PEER) || (session->remotePeerIdx == NO_PEER))
    return;
  
  client = myGlobals.device[actualDeviceId].hash_hostTraffic[checkSessionIdx(session->initiatorIdx)];
  server = myGlobals.device[actualDeviceId].hash_hostTraffic[checkSessionIdx(session->remotePeerIdx)];

  strftime(dt1, 32, "%Y-%m-%d %H:%M:%S", localtime_r(&session->firstSeen, &t));  
  strftime(dt2, 32, "%Y-%m-%d %H:%M:%S", localtime_r(&session->lastSeen, &t));  

  if(sprintf(qbuf, "INSERT DELAYED INTO TCPsessions (Client, Server, ClientPort, "
	     "ServerPort, DataSent, DataRcvd, FirstSeen, LastSeen)"
	     " VALUES ('%s', '%s', '%d', '%d', '%llu', '%llu', '%s', '%s')",
	     client->hostNumIpAddress,
	     server->hostNumIpAddress,
	     session->sport,
	     session->dport,
	     (session->bytesSent), 
	     (session->bytesRcvd),
	     dt1, dt2) < 0) 
    BufferTooShort();

  /* traceEvent(TRACE_INFO, "%s\n", sqlBuf); */

  if(!MYSQL_QUERY(mysql_sock, qbuf)) {
    sprintf(TraceInfoLine, "In mySQLnotifyTCPSession: %s\n", qbuf);
    traceEvent(TRACE_INFO, TraceInfoLine);
  }
}

/*-----------------------------------------------------------------*/

void mySQLupdateDBOSname(HostTraffic *el) {
  if((!enable_mySQL)|| (el->osName == NULL) || (el->osName[0] == '\0'))
    return;

  /* traceEvent(TRACE_INFO, "%s@%s\n", el->osName, el->hostNumIpAddress); */

  if(sprintf(qbuf, "UPDATE Hosts SET "
	     "OsName = '%s' WHERE IPaddress = '%s'",
	     el->osName, el->hostNumIpAddress) < 0) 
    BufferTooShort();
  
  if(!MYSQL_QUERY(mysql_sock, qbuf)) {
    sprintf(TraceInfoLine, "In mySQLupdateDBOSname: %s\n", qbuf);
    traceEvent(TRACE_INFO, TraceInfoLine);
  }
}

#endif /* HAVE_MYSQL */
