/*
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 * bind.c - bind a network port to look at incoming web requests.
 *
 * Luca Deri     <deri@ntop.org>
 * Rocco Carbone <rocco@ntop.org>
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*
 * ntop header file(s)
 */
#include "ntop.h"

#include "intop.h"


/*
 *
 */
int intop_bind (char * address)
{
  char * c;
  short port = NTOP_DEFAULT_WEB_PORT;                    /* default ntop mini-web port */
  struct hostent * host;
  struct sockaddr_in sockaddr = {0};
  int sockfd;
  int sockopt = 1;

  if (address)
    {
      /* try to decode address in the hostname:port syntax */
      c = strchr (address, ':');
      if (c)
	{
	  port = atoi (c + 1);
	  * c = '\0';
	}

      host = gethostbyname (address);
      if (host)
	memcpy (& sockaddr . sin_addr, host -> h_addr_list [0], host -> h_length);
      else
	sockaddr . sin_addr . s_addr = inet_addr (address);

      if (sockaddr . sin_addr . s_addr == -1)
	{
	  printf ("Warning: wrong address '%s'. continue to all available interfaces!\n", address);
	  sockaddr . sin_addr . s_addr = htonl (INADDR_ANY);
	}
    }
  else
    sockaddr . sin_addr . s_addr = htonl (INADDR_ANY);


  sockaddr . sin_family = AF_INET;
  sockaddr . sin_port = htons (port);


  /*
   * create a socket for the management of all the incoming HTTP calls
   */
  sockfd = socket (AF_INET, SOCK_STREAM, 0);
  if (sockfd == -1)
    {
      printf ("Cannot open socket: errno = %d\n", errno);
      return (-1);
    }

  /*
   * set option in order to reuse address if busy
   */
  if (setsockopt (sockfd, SOL_SOCKET, SO_REUSEADDR,
		  (const char *) & sockopt, sizeof (sockopt)))
    {
      printf ("Cannot set socket options: errno = %d\n", errno);
      close (sockfd);
      return (-1);
    }


  /*
   * bind to local address
   */
  if (bind (sockfd, (struct sockaddr *) & sockaddr, sizeof (sockaddr)))
    {
      printf ("Cannot bind at port %d: errno = %d\n", port, errno);
      close (sockfd);
      return (-1);
    }


  /*
   * Set queue limit for incoming calls.
   * The maximum length of the queue for pending connections is set to 256
   */
  if (listen (sockfd, 256))
    {
      printf ("Cannot listen: errno = %d\n", errno);
      close (sockfd);
      return (-1);
    }

  return (sockfd);
}
