/*
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 * hash.c - an attempt to emulate the ftp-hash command.
 *
 * Luca Deri     <deri@ntop.org>
 * Rocco Carbone <rocco@ntop.org>
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 *(at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*
 * ntop header file(s)
 */
#include "ntop.h"

#include "intop.h"


/* Patch courtesy of H. Morrow Long <morrow.long@yale.edu> */
#if defined(MULTITHREADED)
static pthread_t mytid;
#endif
static int done = 0;


static void stopThread(void)
{
  done = 1;
}


/*
 * Thread main loop
 */
static void * printhashloop(void * a)
{
  static char line [80];
  char hashmark [] = "#";

  int fd = pcap_fileno(myGlobals.device [0 /* actualDeviceId */] . pcapPtr);
  struct timeval timeOut;
  fd_set writemask;
  int nfound;

  int row = 0;
  int col = 0;

  memset(line, ' ', 80);

  /*
   * Initialize the curses.
   */
  initscr();
  cbreak();
  noecho();
#ifndef DARWIN
  nodelay(stdscr, TRUE);
#endif
  nonl();

#ifndef DARWIN
  intrflush(stdscr, FALSE);
  keypad(stdscr, TRUE);
  attrset(A_NORMAL);
#endif

#if(0)
  /*
   * Initial startup.
   */
  intop_printHeader(interface);
#endif

  col = 0;

  while(! done)
    {
      FD_ZERO(& writemask);
      FD_SET(fd, & writemask);

      timeOut . tv_sec  = 1;   /* wait max 1 second in the event hash has been disabled */
      timeOut . tv_usec = 0;

      nfound = select(fd + 1, NULL, & writemask, NULL, & timeOut);

      switch(nfound)
	{
	case -1:
	  done = 1;
	  break;

	case 0:                    /* timeOut elapsed */
	  break;

	default:                   /* a packet has arrived */
	  if(! col)
	    mvprintw(row, col, line);
	  mvprintw(row, col ++, hashmark);
	  refresh();
	  col = col % 80;
	}
    }

  /*
  * Terminate the curses.
  */
  clrscr();
  endwin();
#if defined(MULTITHREADED)
  killThread(& mytid);
#endif

  return(NULL); /* NOTREACHED */
}


/*
 * Enable/disable printing `#' for each packet captured.
 */
int intop_hash(int argc, char * argv [])
{
  /*
   * Notice the command name.
   */
  char * commandname = argv [0];

  int c;
#define USAGE(xxx) \
  printf("Usage: %s [-h] [-i interface] [-e] [-d]\n", xxx)
  char * optstring = "hi:ed";

  /*
   * Reserve here space for the local variables.
   */
  static int toggle = 0;
  char * interface = NULL;
  int current;

  optind = 0;
  optarg = NULL;

  /*
   * Parse command line options to the application via standard system calls.
   */
  while((c = getopt(argc, argv, optstring)) != -1)
    {
      switch(c)
	{
	case 'h':
	  USAGE(commandname);
	  return(0);

	default:
	  USAGE(commandname);
	  return(-1);

	case 'i':
	  interface = optarg;
	  break;
	}
    }

  if(optind < argc)
    {
      printf("\nWrong option(s): \" ");
      while(optind < argc)
	printf("%s ", argv [optind ++]);
      printf("\"\n");
      USAGE(commandname);
      printf("\n");
      return(-1);
    }

  /*
   * Safe to play with the 'active' interface(if any)
   * in case no specific one was chosen by the user.
   */
  if(! interface && !(interface = intop_interface(active)))
    {
      printf("No interface is currently enabled for packet sniffing.\n");
      return(-1);
    }

  /*
   * Lookup for the given name in the table of enabled interfaces.
   */
  current = intop_lookup_interface(interface);
  if(current == -1)
    {
      printf("%s: unknown interface %s.\n", commandname, interface);
      return(-1);
    }

  /*
   * Avoid to display no available information.
   */
  if(get_intop_flags(current) != INTERFACE_ENABLED)
    {
      printf("%s: no interface is currently enabled for packet sniffing.\n", 
	      commandname);
      return(-1);
    }

  toggle = ! toggle;

  /*
   * Create a thread to handle screen printing.
   */
  if(toggle)
    {
#ifdef MULTITHREADED
      createThread(&mytid, printhashloop, NULL);
#endif
      printf("Hash mark printing on.\n");
    }
  else
    {
#ifdef MULTITHREADED
      stopThread();
#endif
      printf("Hash mark printing off.\n");
    }

  fflush(stdout);
  return(0);
}
