/*
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 * intop.c - Mr. `intop', the first interactive ntop, is here.
 *
 * Luca Deri     <deri@ntop.org>
 * Rocco Carbone <rocco@ntop.org>
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


static char __version__ []   = "0.0.1";
static char __copyright__ [] = "(C) Copyright 2000";
static char __reserved__ []  = "All rights reserved.";
static char __authors__ []   = "L. Deri and R. Carbone";
static char __emails__ []    = "<deri@ntop.org> and <rocco@ntop.org>";
static char __id__ []        = "The first interactive ntop program.";
static char __what__ []      = "It allows you to control the power of ntop using fingers rather than mouse!";
static char __free__ []      =
"  This program is free software; you can redistribute it and/or modify\n\
  it under the terms of the GNU General Public License as published by\n\
  the Free Software Foundation; either version 2 of the License, or\n\
  (at your option) any later version.";
static char __notice__ []    =
"  This program is distributed in the hope that it will be useful,\n\
  but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
  GNU General Public License for more details.";



/*
 * operating system header file(s)
 */
#include <sys/utsname.h>

/*
 * ntop header file(s)
 */
#include "ntop.h"

#include "intop.h"


/*
 * I am sorry for these global variable here.
 */
char * progName;               /* the name of the game */
time_t boottime = 0;
char * prmpt = NULL;
char * pcolor = INTOP_GREEN;   /* default ansi-color for prompt */

int active = -1;               /* an index for the active interface (if any) */
int previous = -1;             /* an index for the previous interface (if any) */


/*
 * You are welcome!
 *
 * -- intop 0.0.1 (May 1, 2000) -- The first interactive ntop program.
 * Copyright (c) 2000 Luca Deri and Rocco Carbone. All rights reserved.
 *
 * It allows you to control the power of ntop using fingers rather than mouse!
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
static void welcome (char * program)
{
  static int once = 0;
  struct utsname name;

  if (! once)
    {
      uname (& name);
  
      printf ("\n");
      printf ("-- %s %s (%s) -- %s\n", program, __version__, __DATE__, __id__);
      printf ("%s %s. %s\n", __copyright__, __authors__, __reserved__);
      printf ("\n");
      printf ("%s\n", __what__);
      printf ("\n");
      printf ("%s\n", __free__);
      printf ("\n");
      printf ("%s\n", __notice__);
      printf ("\n");

      once = 1;
    }
}


/*
 * A well formatted banner should look like...
 */
char * intop_banner (char * interface)
{
  static char room [BUFSIZ] = {0};

  sprintf (room, "%s %s (%s) listening on [%s]",
	   progName, __version__, __DATE__, interface);

  return (room);
}


/*
 * A well formatted report should start with...
 */
char * intop_report (char * interface)
{
  static char room [BUFSIZ] = {0};
  time_t now = NOW;

  struct utsname osname;
  struct hostent * host;
  struct sockaddr_in myaddr;

  /*
   * Get name and information about the system.
   */
  uname (& osname);

  host = gethostbyname (osname . nodename);

  if (host)
    memcpy (& myaddr . sin_addr, host -> h_addr_list [0], host -> h_length);
  else
    myaddr . sin_addr . s_addr = inet_addr (osname . nodename);


  snprintf (room, sizeof(room), "Report created by %s %s (%s) on %s",
	    progName, __version__, __DATE__, ctime (& now));
  snprintf (room + strlen (room), sizeof(room)-strlen(room), "running on %s.%s [%s] %s with %s %s\n",
	    osname . nodename, myGlobals.domainName, inet_ntoa (myaddr . sin_addr),
	    osname . machine, osname . sysname, osname . release);
  snprintf (room + strlen (room), sizeof(room)-strlen(room), "%s %s. %s\n", 
	    __copyright__, __authors__, __emails__);

  return (room);
}



/*
 * Wrong. Please try again accordingly to ....
 */
static void intop_usage (char * program)
{
  welcome (program);
  printf ("Usage: %s [-h] [-i interface [-i interface]] [expression]\n", program);
  exit (-1);
}


static void showoptions (int argc, char * argv [])
{
  char ** targs;

  if (argc > 1)
    for (targs = argv; * targs != NULL; targs ++)
      printf ("\t\"%s\"\n", * targs);
}


/*
 * Parse the command line options. Return the program name.
 */
static char * parse_arguments (int argc, char * argv [])
{
  int done = 0;
  int c;
  char * optstring = "hi:";

  char * interface = NULL;
  int comargc = 0;
  char ** comargv = NULL;
  char * command = NULL;
  int rc = 0;

  /*
   * BPF filter.
   */
  int roomsize;
  char * fltr = NULL;

  /*
   * Notice the program name.
   */
  progName = * argv [0] == '-' ? (argv [0]) ++ : argv [0];
  progName = strrchr (progName, '/');
  progName = (! progName || ! * progName) ? (* argv) : (++ progName);

  /*
   * Parse command line options to the application via standard system calls.
   */
  while (! done && ((c = getopt (argc, argv, optstring)) != -1))
    {
      switch (c)
	{
	case 'h':
	default:
	  intop_usage (progName);
	  break;

	case 'i':
	  welcome (progName);

	  /*
	   * Initialize the ntop engine if not already done.
	   */
	  intop_init (argc, argv);

	  /*
	   * This only to allow multiple -i flags on the same command
	   */
	  if (optind == argc)
	    done = 1;

	  interface = optarg;
	  /*                    argv[0]      -i    interface      \0 */
	  command = malloc (strlen ("open") + 4 + strlen (interface) + 1);
	  sprintf (command, "open -i %s", interface);
	  comargv = buildargv (command);
	  comargc = 3;

	  rc = intop_open (comargc, comargv);

	  freeargv (comargv);
	  free (command);

	  if (rc == -1)
	    exit (0);

	  /*                    argv[0]      -i    interface      \0 */
	  command = malloc (strlen ("start") + 4 + strlen (interface) + 1);
	  sprintf (command, "start -i %s", interface);
	  comargv = buildargv (command);
	  comargc = 3;

	  rc = intop_sniff (comargc, comargv);

	  freeargv (comargv);
	  free (command);

	  if (rc == -1)
	    exit (0);

	  break;
	}
    }

  if (! done && argc > optind + 1)
    {
      /*
       * Build a filter from all remaining command line arguments.
       */
      roomsize = 0;
      fltr = NULL;
      while (optind < argc)
	{
	  roomsize += (strlen (argv [optind]) + 1 + 1);
	  if (fltr)
	    {
	      strcat (fltr, " ");
	      fltr = realloc (fltr, roomsize);
	      strcat (fltr, argv [optind ++]);
	    }
	  else
	    {
	      fltr = malloc (roomsize);
	      strcpy (fltr, argv [optind ++]);
	    }
	}

      set_intop_filter(intop_lookup_interface (interface), fltr);
      free (fltr);

#if (0)
      usage (progName);
#endif
    }

  return (progName);
}


/*
 * This program allows one to call all
 * the user visible routines defined in ntop library.
 * See the help command (?) for a list of all commands.
 */
int main (int argc, char * argv [])
{
  boottime = NOW;

  /*
   * Must run as root since opening a network interface
   * in promiscuous mode is a privileged operation.
   */
  if ((getuid () && geteuid ()) || setuid (0))
    {
      printf ("Sorry, you must be root in order to run this program.\n");
      exit (-1);
    }

  /*
   * Parse command line arguments, fill deteministic parameter values
   * and give welcome message.
   */
  welcome (progName = parse_arguments (argc, argv));

  /*
   * Perform here all the initialization steps required by the ntop engine.
   */
  intop_init (argc, argv);

  printf ("\nType ? for help.\n\n");

  /*
   * The main loop now.
   */
  commandloop (isatty (fileno (stdin)), progName);

  /*
   * Quit normally.
   */
  return (0);
}

#ifndef MULTITHREADED
/* NOTUSED */
void* handleWebConnections(void* notUsed) {
}
#endif
