
#define SIOCGIFCOUNT	0x8938		/* get number of devices */

/*
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 * pcapmore.c - common utilities I was not able to find in the LBNL library.
 *
 * Luca Deri     <deri@ntop.org>
 * Rocco Carbone <rocco@ntop.org>
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*
 * ntop header file(s)
 */
#include "ntop.h"

#include "intop.h"


/*
 * Return the Internet address for 'interface'.
 */
u_int32_t intop_lookupaddr (char * interface)
{
  int sockfd;
  struct ifreq req;
  struct sockaddr_in * addr;

  /*
   * Open a socket to query for network configuration parameters.
   */
  sockfd = socket (AF_INET, SOCK_DGRAM, 0);
  if (sockfd == -1)
    return (0);

  /*
   * All interface ioctl's must have parameter definitions which
   * begin with ifr_name.  The remainder may be interface specific.
   */
  memset(&req, 0, sizeof(req));
  strncpy (req . ifr_name, interface, sizeof (req . ifr_name));
  req . ifr_addr . sa_family = AF_INET;

  /*
   * Retrieve Internet address for this interface.
   */
  if (ioctl (sockfd, SIOCGIFADDR, & req) == -1)
    {
      close (sockfd);
      return (0);
    }

  close (sockfd);

  addr = (struct sockaddr_in *) & req . ifr_addr;
  return (addr -> sin_addr . s_addr);
}


/*
 * Return the broadcast address for 'interface'.
 */
u_int32_t intop_lookupbroadcast (char * interface)
{
  int sockfd;
  struct ifreq req;
  struct sockaddr_in * addr;

  /*
   * Open a socket to query for network configuration parameters.
   */
  sockfd = socket (AF_INET, SOCK_DGRAM, 0);
  if (sockfd == -1)
    return (0);

  /*
   * All interface ioctl's must have parameter definitions which
   * begin with ifr_name.  The remainder may be interface specific.
   */
  memset(&req, 0, sizeof(req));
  strncpy (req . ifr_name, interface, sizeof (req . ifr_name));
  req . ifr_addr . sa_family = AF_INET;

  /*
   * Retrieve Broadcast address for this interface.
   */
  if (ioctl (sockfd, SIOCGIFBRDADDR, & req) == -1)
    {
      close (sockfd);
      return (0);
    }

  close (sockfd);

  addr = (struct sockaddr_in *) & req . ifr_addr;

  return (addr -> sin_addr . s_addr);
}
