Summary: ntop shows the network usage
Name: ntop
Version: 2.0.99RC2
Release:  20020604
Source: http://luca.ntop.org/ntop-2.0.99-rc2.tgz
Source1: ntop.init
Source2: ntop.logrotate
Patch1: force-i386.patch
Copyright: GPL
Group: Applications/System
BuildPrereq: glibc, glibc-devel, gcc, cpp, gawk, autoconf, automake, openssl, openssl-devel, gdbm, gdbm-devel, libpcap, MySQL-shared
Requires: glibc, openssl, gdbm, ncurses, libpcap
Buildroot: %{_tmppath}/%{name}-root
Prereq: /sbin/chkconfig, /sbin/ldconfig

%description
ntop is a network and traffic analyzer that provides a wealth of information on
various networking hosts and protocols. ntop is primarily accessed via a built-in 
web interface. Optionally, data may be stored into a database for analysis or 
extracted from the web server in formats suitable for manipulation in perl or php.

Note that the command line version, intop, is largely unsupported.

See docs/1STRUN.txt for the 1st time startup procedure!

This is RELEASE CANDIDATE 2 for ntop 2.1, built from the source posted by Luca Deri
on 04Jun2002.
%prep
%setup -q -c ${NAME}${VERSION}
%patch 1 -P

%build
unset RPM_OPT_FLAGS
%undefine optflags 
# ntop craps out here with gcc2.96-98 and full optimization!
# First, build static libraries - use the new buildAll script
cd RC2/gdchart0.94c
./buildAll.sh
cd ../ntop
# Now, configure and build ntop
%configure --enable-optimize  --bindir=%{_sbindir} 
make

%install
cd RC2/ntop
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d \
         $RPM_BUILD_ROOT/%{_sbindir} \
         $RPM_BUILD_ROOT/etc/logrotate.d 

make install DESTDIR=$RPM_BUILD_ROOT

install -c -m0755 %{SOURCE1} $RPM_BUILD_ROOT/etc/rc.d/init.d/ntop
install -c -m0644 %{SOURCE2} $RPM_BUILD_ROOT/etc/logrotate.d/ntop

%post
/sbin/chkconfig --add  ntop
/sbin/ldconfig
/sbin/service ntop condrestart > /dev/null 2>&1


%preun
if [ "$1" = "0" ]; then
	/sbin/service ntop stop > /dev/null 2>&1
	/sbin/chkconfig --del ntop
fi

%postun
if [ "$1" -ge "1" ]; then
	/sbin/service ntop condrestart > /dev/null 2>&1
fi
/sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc ntop/AUTHORS
%doc ntop/CONTENTS
%doc ntop/MANIFESTO
%doc ntop/COPYING
%doc ntop/ChangeLog
%doc ntop/docs/FAQ
%doc ntop/docs/HACKING
%doc ntop/docs/KNOWN_BUGS
%doc ntop/docs/TODO
%doc ntop/docs/1STRUN.txt
%doc ntop/NEWS
%doc ntop/PORTING
%doc ntop/README
%doc ntop/SUPPORT_NTOP.txt
%doc ntop/THANKS
%config %{_sysconfdir}/rc.d/init.d/ntop
%config %{_sysconfdir}/logrotate.d/ntop
%{_sbindir}/ntop
%{_sbindir}/ntop-cert.pem
%{_sbindir}/intop
%{_datadir}/%{name}
%{_mandir}/man1/intop.1.gz
%{_mandir}/man8/ntop.8.gz

%{_libdir}/ntop
%{_libdir}/plugins
%{_libdir}/libntop*
%{_libdir}/libicmpPlugin*

%changelog
* Tue Jun 04 2002 Burton M. Strauss III <burton@ntopsupport.com>
- Updated to RC2

* Fri May 17 2002 Burton M. Strauss III <burton@ntopsupport.com>
- Updated to RC1

* Mon May 13 2002 Burton M. Strauss III <burton@ntopsupport.com>
- Updated for 2.0.99 - beta - from 13May2002 snapshot

* Fri Nov 23 2001 Hal Burgiss <hal@foobox.net>
- Updated for 2.0 beta.

* Thu Oct 11 2001 Hal Burgiss <hal@foobox.net>
- Updated for 2.0 pre-release snapshots. Many changes.

