/* This file is in the public domain */

#include <string>
#include <cstdlib>
#include <ctime>

#include <opencl/filters.h>

#include <opencl/square.h>
#include <opencl/randpool.h>
#include <opencl/x917.h>

using namespace OpenCL;

/* Not too useful generally; just dumps random bits */
template<typename R>
class RNG_Filter : public Filter
   {
   public:
      void write(const byte[], u32bit);
      RNG_Filter() : buffer(1024) { position = 0; }
   private:
      R rng;
      SecureVector<byte> buffer;
      u32bit position;
   };

template<typename B>
void RNG_Filter<B>::write(const byte input[], u32bit length)
   {
   buffer.copy(position, input, length);
   if(position + length >= buffer.size())
      {
      rng.randomize(buffer, buffer.size());
      send(buffer, buffer.size());
      input += (buffer.size() - position);
      length -= (buffer.size() - position);
      while(length >= buffer.size())
         {
         /* This actually totally ignores the input, but it doesn't matter,
            because this is only for benchmark purposes and we just want to
            test speed. Anyway, if the RNG is good you can't tell the diff */
         rng.randomize(buffer, buffer.size());
         send(buffer, buffer.size());
         input += buffer.size();
         length -= buffer.size();
         }
       buffer.copy(input, length);
      position = 0;
      }
   position += length;
   }

/* A wrappr class to convert an EntropySource into a pseudo-RNG */
template<typename E>
class ES_TO_RNG
   {
   public:
      void randomize(byte buf[], u32bit size)
         {
         u32bit need = size;
         while(need)
            need -= es.slow_poll(buf + size - need, need);
         }

   private:
      E es;
   };

Filter* lookup_rng(const std::string& algname)
   {
   if(algname == "X917<Square>")
      return new RNG_Filter< X917<Square> >;
   else if(algname == "Randpool")
      return new RNG_Filter<Randpool>;

   else return 0;
   }
