/*
An OpenCL example application which emulates a
poorly written version of "gpg --print-md"

Written by Jack Lloyd (lloyd@acm.jhu.edu), quite a while ago (as of June 2001)

This file is in the public domain
*/
#include <fstream>
#include <iostream>
#include <string>
#include <opencl/filters.h>
#include <opencl/encoder.h>
#include <opencl/md5.h>
#include <opencl/sha1.h>
#include <opencl/rmd160.h>

int main(int argc, char* argv[])
   {
   if(argc < 2)
      {
      std::cout << "Usage: hasher <filenames>" << std::endl;
      return 1;
      }

   OpenCL::LibraryInitializer init;

   const int COUNT = 3;
   std::string name[COUNT] = { "MD5", "SHA-1", "RIPEMD-160" };

   for(int j = 1; argv[j] != 0; j++)
      {
      OpenCL::Filter* hash[COUNT] = {
         new OpenCL::Chain(new OpenCL::HashFilter<OpenCL::MD5>,
                           new OpenCL::HexEncoder),
         new OpenCL::Chain(new OpenCL::HashFilter<OpenCL::SHA1>,
                           new OpenCL::HexEncoder),
         new OpenCL::Chain(new OpenCL::HashFilter<OpenCL::RIPEMD_160>,
                           new OpenCL::HexEncoder) };

      OpenCL::Pipe pipe(new OpenCL::Fork(hash, COUNT));

      std::ifstream file(argv[j]);
      if(!file)
         {
         std::cout << "ERROR: could not open " << argv[j] << std::endl;
         continue;
         }
      pipe.start_msg();
      file >> pipe;
      pipe.end_msg();
      file.close();
      for(int k = 0; k != COUNT; k++)
         {
         pipe.set_default_msg(k);
         std::cout << name[k] << "(" << argv[j] << ") = " << pipe << std::endl;
         }
      }
   return 0;
   }
