/*************************************************
* Barrett Reducer Header File                    *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_BARRETT_H__
#define OPENCL_BARRETT_H__

#include <opencl/reducer.h>

namespace OpenCL {

class BarrettReducer : public ModularReducer
   {
   public:
      BigInt reduce(const BigInt&) const;
      BarrettReducer(const BigInt&);
   private:
      u32bit max_bits, k;
      BigInt mu, b_to_k1;
      mutable BigInt q2, q3, r1, r2;
   };

}

#endif
