/*************************************************
* CTS Mode Header File                           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_CTS_H__
#define OPENCL_CTS_H__

#include <opencl/filter.h>
#include <opencl/modebase.h>

namespace OpenCL {

/*************************************************
* CTS Encryption                                 *
*************************************************/
template<class B>
class CTS_Encryption : public BlockCipherMode, public Filter
   {
   public:
      static std::string name() { return "CTS_Encryption<" + B::name() + ">"; }
      void write(const byte[], u32bit);
      void end_msg();
      CTS_Encryption(const BlockCipherKey&, const BlockCipherModeIV&);
   private:
      void encrypt(const byte[]);
   };

/*************************************************
* CTS Decryption                                 *
*************************************************/
template<class B>
class CTS_Decryption : public BlockCipherMode, public Filter
   {
   public:
      static std::string name() { return "CTS_Decryption<" + B::name() + ">"; }
      void write(const byte[], u32bit);
      void end_msg();
      CTS_Decryption(const BlockCipherKey&, const BlockCipherModeIV&);
   private:
      void decrypt(const byte[]);
      SecureBuffer<byte, B::BLOCKSIZE> temp;
   };

}

#endif

#ifndef OPENCL_CTS_ICC__
#define OPENCL_CTS_ICC__
#include <opencl/cts.icc>
#endif
