/*************************************************
* Default Allocator Source File                  *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_DEF_ALLOC_H__
#define OPENCL_DEF_ALLOC_H__

#include <opencl/manalloc.h>

namespace OpenCL {

/*************************************************
* Default Allocator                              *
*************************************************/
class Default_Allocator : public ManagedAllocator
   {
   public:
      SecureAllocator* clone() { return this; }
      Default_Allocator();
      ~Default_Allocator();
   private:
      static const u32bit PREF_SIZE = 32*1024, CACHE_SIZE = 8;
      void* alloc_block(u32bit) const;
      void dealloc_block(void*, u32bit) const;
      mutable void* cache[CACHE_SIZE];
   };

}

#endif
