/*************************************************
* EME1 Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_EME1_H__
#define OPENCL_EME1_H__

#include <opencl/pk_misc.h>
#include <opencl/mgf1.h>

namespace OpenCL {

/*************************************************
* EME1                                           *
*************************************************/
template<typename H, typename MGF = MGF1<H> >
class EME1 : public MessageEncodingMethod
   {
   public:
      SecureVector<byte> pad(const byte[], u32bit, u32bit) const;
      SecureVector<byte> unpad(const byte[], u32bit) const;

      EME1() { H hash; hash.final(Phash); }
      EME1(const byte P[], u32bit len) { H hash; hash.process(P, len, Phash); }
      EME1(const std::string& P) { H hash; hash.process(P, Phash); }
   private:
      static const u32bit HASHLENGTH = H::HASHLENGTH, SEEDLENGTH = HASHLENGTH;
      SecureBuffer<byte, HASHLENGTH> Phash;
   };

}

#endif

#ifndef OPENCL_EME1_ICC__
#define OPENCL_EME1_ICC__
#include <opencl/eme1.icc>
#endif
