/*************************************************
* File EntropySource Header File                 *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_ENTROPY_SRC_FILE_H__
#define OPENCL_ENTROPY_SRC_FILE_H__

#include <opencl/opencl.h>
#include <vector>
#include <string>

namespace OpenCL {

class File_EntropySource : public EntropySource
   {
   public:
      u32bit slow_poll(byte[], u32bit);
      u32bit fast_poll(byte buf[], u32bit len) { return slow_poll(buf, len); }

      void add_source(const std::string& dev) { sources.push_back(dev); }

      File_EntropySource(bool = true);
      File_EntropySource(const std::string&);
   private:
      std::vector<std::string> sources;
   };

}

#endif
