/*************************************************
* GOST Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_GOST_H__
#define OPENCL_GOST_H__

#include <opencl/opencl.h>

namespace OpenCL {

class GOST : public BlockCipher
   {
   public:
      static std::string name() { return "GOST"; }
      static const u32bit BLOCKSIZE = 8, KEYLENGTH = 32;
      BlockCipher* clone() const { return new GOST; }
      void set_key(const byte[], u32bit = KEYLENGTH) throw(Invalid_Key_Length);
      void clear() throw() { EK.clear(); }
      GOST() : BlockCipher(name(), BLOCKSIZE, KEYLENGTH) {}
   private:
      static const u32bit SBOX1[256], SBOX2[256], SBOX3[256], SBOX4[256];
      static void round(u32bit&, u32bit);
      void enc(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void dec(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      SecureBuffer<u32bit, 8> EK;
   };

}

#endif
