/*************************************************
* IDEA Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_IDEA_H__
#define OPENCL_IDEA_H__

#include <opencl/opencl.h>

namespace OpenCL {

class IDEA : public BlockCipher
   {
   public:
      static std::string name() { return "IDEA"; }
      static const u32bit BLOCKSIZE = 8, KEYLENGTH = 16;
      BlockCipher* clone() const { return new IDEA; }
      void set_key(const byte[], u32bit = KEYLENGTH) throw(Invalid_Key_Length);
      void clear() throw() { EK.clear(); DK.clear(); }
      IDEA() : BlockCipher(name(), BLOCKSIZE, KEYLENGTH) {}
   private:
      static void mul(u16bit&, u16bit);
      static u16bit mul_inv(u16bit);
      void enc(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void dec(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      SecureBuffer<u16bit, 52> EK, DK;
   };

}

#endif
