/*************************************************
* BigInt Algorithms Header File                  *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_MPCORE_H__
#define OPENCL_MPCORE_H__

#include <opencl/config.h>

extern "C" {

using OpenCL::u32bit;
using OpenCL::u64bit;
using OpenCL::s32bit;

void bigint_add(const u32bit*, u32bit, const u32bit*, u32bit, u32bit*);
void bigint_sub(const u32bit*, u32bit, const u32bit*, u32bit, u32bit*);
void bigint_mul(const u32bit*, u32bit, const u32bit*, u32bit, u32bit*);

void bigint_shl(u32bit*, const u32bit*, u32bit, u32bit, u32bit);
void bigint_shr(u32bit*, const u32bit*, u32bit, u32bit, u32bit);

bool bigint_divcore(u32bit, u32bit, u32bit, u32bit, u32bit, u32bit);

s32bit bigint_cmp(const u32bit*, u32bit, const u32bit*, u32bit);

}

#endif
