/*************************************************
* Mutex Factory Header File                      *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_MUTEX_H__
#define OPENCL_MUTEX_H__

#include <opencl/config.h>

namespace OpenCL {

/*************************************************
* Mutex Base Class                               *
*************************************************/
class Mutex
   {
   public:
      virtual void lock() = 0;
      virtual bool trylock() = 0;
      virtual void unlock() = 0;
      virtual Mutex* clone() const = 0;
      virtual ~Mutex() {}
   };

/*************************************************
* Default Mutex                                  *
*************************************************/
class Default_Mutex : public Mutex
   {
   public:
      void lock() {}
      bool trylock() { return true; }
      void unlock() {}
      Mutex* clone() const { return new Default_Mutex; }
   };

/*************************************************
* Get a mutex                                    *
*************************************************/
Mutex* get_mutex();

/*************************************************
* Release a mutex                                *
*************************************************/
void release_mutex(Mutex*);

/*************************************************
* Set the mutex type                             *
*************************************************/
void set_mutex_type(Mutex*);

}

#endif
