/*************************************************
* RC5 Header File                                *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_RC5_H__
#define OPENCL_RC5_H__

#include <opencl/opencl.h>

namespace OpenCL {

class RC5 : public BlockCipher
   {
   public:
      static std::string name() { return "RC5"; }
      static const u32bit BLOCKSIZE = 8, KEYLENGTH = 32, DEFAULT_ROUNDS = 16;
      BlockCipher* clone() const { return new RC5(ROUNDS); }
      void set_key(const byte[], u32bit = KEYLENGTH) throw(Invalid_Key_Length);
      void clear() throw() { S.clear(); }
      RC5(u32bit r = DEFAULT_ROUNDS);
   private:
      void enc(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void dec(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      SecureVector<u32bit> S;
      const u32bit ROUNDS;
   };

struct RC5_12 : public RC5
   {
   BlockCipher* clone() const { return new RC5_12; }
   RC5_12() : RC5(12) {}
   };

struct RC5_16 : public RC5
   {
   BlockCipher* clone() const { return new RC5_16; }
   RC5_16() : RC5(16) {}
   };

}

#endif
