/*************************************************
* RSA Header File                                *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_RSA_H__
#define OPENCL_RSA_H__

#include <opencl/bigint.h>

namespace OpenCL {

class RSA_PublicKey
   {
   public:
      SecureVector<byte> encrypt(const byte[], u32bit) const;
      SecureVector<byte> verify(const byte[], u32bit) const;

      u32bit max_input_bits() const { return (n.bits() - 1); }

      BigInt get_n() const { return n; }
      u32bit get_e() const { return e; }

      RSA_PublicKey(const BigInt& mod, u32bit exp) : n(mod), e(exp)
         { reducer_n = 0; }
      ~RSA_PublicKey();
   protected:
      RSA_PublicKey() { reducer_n = 0;}
      BigInt public_op(const BigInt&) const;
      BigInt n;
      u32bit e;
      mutable BigInt temp;
      mutable class ModularReducer* reducer_n;
   };

class RSA_PrivateKey : public RSA_PublicKey
   {
   public:
      SecureVector<byte> decrypt(const byte[], u32bit) const;
      SecureVector<byte> sign(const byte[], u32bit) const;

      void check_params() const;
      BigInt get_p() const { return p; }
      BigInt get_q() const { return q; }
      BigInt get_d() const { return d; }

      RSA_PrivateKey(const BigInt&, const BigInt&, u32bit,
                     const BigInt& = 0, const BigInt& = 0);
      RSA_PrivateKey(u32bit, u32bit = 3);
      ~RSA_PrivateKey();
   private:
      BigInt private_op(const BigInt&) const;
      void precompute();
      BigInt d, p, q, d1, d2, c;
      mutable BigInt j1, j2, h;
      mutable class ModularReducer* reducer_p;
      mutable class ModularReducer* reducer_q;
   };

}

#endif
